/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _GEDCOMPARSER_NOTE_STRUCTURE_HH_
#define _GEDCOMPARSER_NOTE_STRUCTURE_HH_

#include <string>
#include <vector>
#include "patterns/SmartPtr.hh"
#include "GEDCOMParser/Visitor/GEDCOMElement.hh"

///
namespace GEDCOMParser
{
  class GEDCOMVisitor;
  ///
  class NoteStructure;
  ///@name typedefs
  //@{
  /// @doc handling of many note structures
  typedef std::vector < SmartPtr < NoteStructure > >NoteStructures_t;
  //@}
};

#include "GEDCOMParser/AttachmentManager.hh"
#include "GEDCOMParser/Attachment.hh"

///
namespace GEDCOMParser
{
  /// @memo Implements the GEDCOM 5.5 NOTE_STRUCTURE structure   
  class NoteStructure:public GEDCOMElement,
    ///
    public Attachment, public AttachmentManager
  {
  protected:
    std::string _note_xref;
    std::string _submitter_text;
  public:
    virtual ~ NoteStructure (void);
    ///@name Accessors (set) 
    //@{    
    ///    
    void setNoteXref (std::string const &);
    ///    
    void concSubmitterText (std::string const &);
    ///    
    void contSubmitterText (std::string const &);
    //@}

    ///@name Accessors (get)
    //@{    
    ///    
    virtual std::string const &getNoteXref (void) const;
    ///    
    virtual std::string const &getSubmitterText (void) const;
    //@}   
    ///operator == used to find a note structure by its note record xref
    friend bool operator== (NoteStructure const &note_structure,
			    std::string const &note_xref)
    {
      return (note_structure._note_xref == note_xref);
    };
    ///operator == used to find a note structure by its note record xref
    friend bool operator== (NoteStructure * const note_structure,
			    std::string const &note_xref)
    {
      return (note_structure->_note_xref == note_xref);
    };
    ///
    virtual void Accept (GEDCOMParser::GEDCOMVisitor *);
  };
};
#endif
