/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _GEDCOMPARSER_PARSER_HH_
#define _GEDCOMPARSER_PARSER_HH_


#include "GEDCOMParser/GEDCOMFactory.hh"
#include "GEDCOMParser/LineageLinkageGedcom.hh"
#include "GEDCOMParser/ParseErrorManagement/ParseErrorManager.hh"

#include <string>

/// Package GEDCOMParser
namespace GEDCOMParser
{
  /// @memo Main class of the GEDCOM parser
  class Parser
  {
  public:
    /** @memo Constructor
	@param factory is the factory used to build the structure during the parsing
	@param lineage is the GEDCOM lineage transmission used to store the parsed structures ; if lineage is not initialized by the constructor, a new object will be created ; otherwise the passed object will be modified
    */
    Parser (GEDCOMParser::GEDCOMFactory const *factory,
	    GEDCOMParser::LineageLinkageGedcom * lineage = 0);
     ~Parser (void)
    {
      delete _parse_error_manager;
        _parse_error_manager = 0;
        return;
    };
    /** @memo execute the parsing
	@param filename identifies the file to parse
	@param debug : if set to 1, the execution will output its operations on stderr 
    */
      GEDCOMParser::ParseErrorManagement::
      ParseErrorManager const &Parse (std::string const &filename, int debug =
				      0);
    /** @memo get the lineage linkage GEDCOM structure after the parsing
	@return a LineageLinkageGedcom object
    */
      GEDCOMParser::LineageLinkageGedcom *
      getLineageLinkageGedcom (void) const;
  private:
      GEDCOMParser::GEDCOMFactory const *const _factory;
      GEDCOMParser::LineageLinkageGedcom * _lineage_linkage_gedcom;
      GEDCOMParser::ParseErrorManagement::ParseErrorManager *
      _parse_error_manager;
  };
};

#endif
