/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _GEDCOMPARSER_PERSONALNAME_HH_
#define _GEDCOMPARSER_PERSONALNAME_HH_

#include <vector>
#include <string>
#include "patterns/SmartPtr.hh"
#include "GEDCOMParser/AttachmentManager.hh"
#include "GEDCOMParser/Visitor/GEDCOMElement.hh"

///
namespace GEDCOMParser
{
  class GEDCOMVisitor;
  ///
  class PersonalName;
  ///@name typedefs
  //@{
  /// @doc handling of many personal names
  typedef std::vector < SmartPtr < PersonalName > >PersonalNames_t;
  //@}
}

///
namespace GEDCOMParser
{
  /// @memo Implements the GEDCOM 5.5 PERSONAL_NAME_STRUCTURE structure   
  class PersonalName:public GEDCOMElement, public AttachmentManager
  {
  protected:
    ///
    std::string _raw_name;
    ///
    std::string _name;
    ///
    std::string _npfx;
    ///
    std::string _raw_givn;
    ///
    std::string _givn;
    ///
    std::string _nick;
    ///
    std::string _spfx;
    ///
    std::string _raw_surn;
    ///
    std::string _surn;
    ///
    std::string _nsfx;
  public:
    ///
    virtual ~ PersonalName (void)
    {
    };
    ///@name Accessors (set) 
    //@{    
    /// setName runs the parsing of Given name and Surname ;
    void setName (std::string const &);
    ///
    void setNpfx (std::string const &);
    /// set the given name (for instance from a GEDCOM file)
    void setGivn (std::string const &);
    ///
    void setNick (std::string const &);
    ///
    void setSpfx (std::string const &);
    /// set the surname (for instance from a GEDCOM file)
    void setSurn (std::string const &);
    ///
    void setNsfx (std::string const &);
    //@}

    ///@name Accessors (get)
    //@{    
    /// Returns the Name as Givenname Surname
    virtual std::string const &getName (void) const;
    /// Returns the Name set by setName
    virtual std::string const &getRawName (void) const;
    ///
    virtual std::string const &getNpfx (void) const;
    /// Returns the Given name parsed by setName
    virtual std::string const &getGivn (void) const;
    /// Returns the Given name set by setGivn
    virtual std::string const &getRawGivn (void) const;
    ///
    virtual std::string const &getNick (void) const;
    ///
    virtual std::string const &getSpfx (void) const;
    /// Returns the Surname parsed by setName
    virtual std::string const &getSurn (void) const;
    /// Returns the Surname set by setSurn
    virtual std::string const &getRawSurn (void) const;
    ///
    virtual std::string const &getNsfx (void) const;
    //@}
    virtual void Accept (GEDCOMParser::GEDCOMVisitor *);
  };
};
#endif
