/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include "Place.hh"
#include <iostream>
#include "GEDCOMParser/Visitor/GEDCOMVisitor.hh"
#include "GEDCOMParser/GEDCOMFactory.hh"
#include "GEDCOMParser/GEDCOMFactoryAccessor.hh"

void
GEDCOMParser::Place::setPlaceValue (std::string const &pvalue)
{
  _value = pvalue;
  return;
}

void
GEDCOMParser::Place::setPlaceHierarchy (std::string const &value)
{
  _hierarchy = value;
  return;
}

std::string const &
GEDCOMParser::Place::getPlaceValue (void) const
{
  return _value;
}

std::string const &
GEDCOMParser::Place::getPlaceHierarchy (void) const
{
  return _hierarchy;
}

void
GEDCOMParser::Place::Accept (GEDCOMParser::GEDCOMVisitor * v)
{
  v->VisitPlace (this);
  return;
}
