#ifndef _GEDCOMPARSER_PREDICATES_HASPARENT_HH_
#define _GEDCOMPARSER_PREDICATES_HASPARENT_HH_

#include "GEDCOMParser/LineageLinkageGedcom.hh"
#include "GEDCOMParser/IndividualRecord.hh"
#include <functional>

namespace GEDCOMParser
{
  namespace Predicates
  {
    class HasParent:public std::binary_function <
      GEDCOMParser::LineageLinkageGedcom const *const,
      GEDCOMParser::IndividualRecords_elem_t, bool >
    {
    public:
      bool operator      () (GEDCOMParser::
			     LineageLinkageGedcom const *const lineage,
			     GEDCOMParser::
			     IndividualRecords_elem_t individu_elem) const
      {
	GEDCOMParser::IndividualRecord const *const individu =
	  individu_elem.second.getPtr ();
	bool res = (individu->getChildToFamilyLinks ().size () > 0);
	  return res;
      };
    };
  };
};
#endif
