#ifndef _GEDCOMPARSER_SERIALIZER_SERIALIZABLE_HH_
#define _GEDCOMPARSER_SERIALIZER_SERIALIZABLE_HH_

#include "GEDCOMParser/Serializer/Reader.hh"
#include "GEDCOMParser/Serializer/Writer.hh"

///
namespace GEDCOMParser
{
  class Serializable
  {
  public:
    ///
    Serializable (void):_reader (0), _writer (0)
    {
    };
      ///
      Serializable (Serializable const &s):_reader (s._reader),
      _writer (s._writer)
    {
    };
    ///
    ~Serializable (void)
    {
    };
    ///
    void setReader (GEDCOMParser::Reader * r)
    {
      _reader = r;
    };
    ///
    void setWriter (GEDCOMParser::Writer * w)
    {
      _writer = w;
    };
  protected:
    ///
    GEDCOMParser::Reader * _reader;
    ///
    GEDCOMParser::Writer * _writer;
  };
};

#endif
