/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include "SourceCitation.hh"
#include "GEDCOMParser/Visitor/GEDCOMVisitor.hh"
#include "GEDCOMParser/GEDCOMFactory.hh"
#include "GEDCOMParser/GEDCOMFactoryAccessor.hh"


void
GEDCOMParser::SourceCitation::setSourceXref (std::string const &value)
{
  _source_xref = value;
  return;
}

void
GEDCOMParser::SourceCitation::setPage (std::string const &value)
{
  _page = value;
  return;
}

void
GEDCOMParser::SourceCitation::setEvent (std::string const &value)
{
  _event = value;
  return;
}

void
GEDCOMParser::SourceCitation::setEventRole (std::string const &value)
{
  _event_role = value;
  return;
}

void
GEDCOMParser::SourceCitation::setDataDate (std::string const &value)
{
  if (_data_date != 0)
    {
      delete
	_data_date;
      _data_date = 0;
    }
  _data_date = new GEDCOMParser::DateManagement::DateValue (value);
  return;
}

void
GEDCOMParser::SourceCitation::concDataText (std::string const &value)
{
  _data_text = _data_text + value;
  return;
}

void
GEDCOMParser::SourceCitation::contDataText (std::string const &value)
{
  _data_text = _data_text + "\n" + value;
  return;
}

void
GEDCOMParser::SourceCitation::setQuay (std::string const &value)
{
  _quay = value;
  return;
}

void
GEDCOMParser::SourceCitation::concDescription (std::string const &value)
{
  _description = _description + value;
  return;
}

void
GEDCOMParser::SourceCitation::contDescription (std::string const &value)
{
  _description = _description + "\n" + value;
  return;
}


void
GEDCOMParser::SourceCitation::concText (std::string const &value)
{
  _text = _text + value;
  return;
}

void
GEDCOMParser::SourceCitation::contText (std::string const &value)
{
  _text = _text + "\n" + value;
  return;
}

std::string const &
GEDCOMParser::SourceCitation::getSourceXref (void) const
{
  return _source_xref;
}

std::string const &
GEDCOMParser::SourceCitation::getPage (void) const
{
  return _page;
}

std::string const &
GEDCOMParser::SourceCitation::getEvent (void) const
{
  return _event;
}

std::string const &
GEDCOMParser::SourceCitation::getEventRole (void) const
{
  return _event_role;
}

std::string const
GEDCOMParser::SourceCitation::getDataDate (void) const
{
  std::string res;
  if (_data_date != 0)
    {
      res = _data_date->getDisplayValue ();
    }
  return res;
}

GEDCOMParser::DateManagement::DateValue const * const 
GEDCOMParser::SourceCitation::getDataDateObject(void) const
{
  return _data_date;
}

std::string const &
GEDCOMParser::SourceCitation::getDataText (void) const
{
  return _data_text;
}

std::string const &
GEDCOMParser::SourceCitation::getQuay (void) const
{
  return _quay;
}

std::string const &
GEDCOMParser::SourceCitation::getDescription (void) const
{
  return _description;
}

std::string const &
GEDCOMParser::SourceCitation::getText (void) const
{
  return _text;
}

void
GEDCOMParser::SourceCitation::Accept (GEDCOMParser::GEDCOMVisitor * v)
{
  v->VisitSourceCitation (this);
  return;
}
