/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include "SourceRecord.hh"
#include "patterns/SmartPtr.hh"
#include "GEDCOMParser/Visitor/GEDCOMVisitor.hh"
#include "GEDCOMParser/GEDCOMFactory.hh"
#include "GEDCOMParser/GEDCOMFactoryAccessor.hh"

void
GEDCOMParser::SourceRecord::Data::Event::setEvent (std::string const &value)
{
  _event = value;
  return;
}

void
GEDCOMParser::SourceRecord::Data::Event::setDate (std::string const &value)
{
  if (_date != 0)
    {
      delete
	_date;
      _date = 0;
    }
  _date = new GEDCOMParser::DateManagement::DateValue (value);
  return;
}

void
GEDCOMParser::SourceRecord::Data::Event::setPlace (std::string const &value)
{
  _plac = value;
  return;
}

GEDCOMParser::SourceRecord::Data::Event *
  GEDCOMParser::SourceRecord::Data::addEvent (GEDCOMParser::SourceRecord::
					      Data::Event * const data = 0)
{

  GEDCOMParser::SourceRecord::Data::Event * tmp_data = data;
  if (data == 0)
    {
      GEDCOMParser::GEDCOMFactory * factory =
	GEDCOMParser::GEDCOMFactoryAccessor::getFactory ();
      tmp_data = factory->createSourceRecord_Data_Event ();
    }
  _events.push_back (SmartPtr < SourceRecord::Data::Event > (tmp_data));
  return _events.back ().getPtr ();
}

GEDCOMParser::SourceRecord::Data::Events_t const &
GEDCOMParser::SourceRecord::Data::getEvents (void) const
{
  return _events;
}

void
GEDCOMParser::SourceRecord::Data::setAgnc (std::string const &value)
{
  _agnc = value;
  return;
}

GEDCOMParser::SourceRecord::SourceRecord (std::string const &id = "")
{
  if (id != "")
    {
      setId (id);
    }
  return;
}

void
GEDCOMParser::SourceRecord::setId (std::string const &value)
{
  _id = value;
  return;
}

GEDCOMParser::SourceRecord::Data *
  GEDCOMParser::SourceRecord::setData (GEDCOMParser::SourceRecord::Data *
				       const data = 0)
{
  GEDCOMParser::SourceRecord::Data * tmp_data = data;
  if (data == 0)
    {
      GEDCOMParser::GEDCOMFactory * factory =
	GEDCOMParser::GEDCOMFactoryAccessor::getFactory ();
      tmp_data = factory->createSourceRecord_Data ();
    }
  _data = SmartPtr < SourceRecord::Data > (tmp_data);
  return _data.getPtr ();
}

void
GEDCOMParser::SourceRecord::contAuth (std::string const &value)
{
  _auth = _auth + "\n" + value;
  return;
}

void
GEDCOMParser::SourceRecord::concAuth (std::string const &value)
{
  _auth = _auth + value;
  return;
}

void
GEDCOMParser::SourceRecord::contTitle (std::string const &value)
{
  _titl = _titl + "\n" + value;
  return;
}

void
GEDCOMParser::SourceRecord::concTitle (std::string const &value)
{
  _titl = _titl + value;
  return;
}

void
GEDCOMParser::SourceRecord::setAbbr (std::string const &value)
{
  _abbr = value;
  return;
}

void
GEDCOMParser::SourceRecord::contPubl (std::string const &value)
{
  _publ = _publ + "\n" + value;
  return;
}

void
GEDCOMParser::SourceRecord::concPubl (std::string const &value)
{
  _publ = _publ + value;
  return;
}


void
GEDCOMParser::SourceRecord::contText (std::string const &value)
{
  _text = _text + "\n" + value;
  return;
}

void
GEDCOMParser::SourceRecord::concText (std::string const &value)
{
  _text = _text + value;
  return;
}


GEDCOMParser::SourceRepositoryCitation *
  GEDCOMParser::SourceRecord::setSourceRepositoryCitation (GEDCOMParser::
							   SourceRepositoryCitation
							   * const data = 0)
{
  GEDCOMParser::SourceRepositoryCitation * tmp_data = data;
  if (data == 0)
    {
      GEDCOMParser::GEDCOMFactory * factory =
	GEDCOMParser::GEDCOMFactoryAccessor::getFactory ();
      tmp_data = factory->createSourceRepositoryCitation ();
    }
  _src_rep_citation = SmartPtr < SourceRepositoryCitation > (tmp_data);
  return _src_rep_citation.getPtr ();
}

void
GEDCOMParser::SourceRecord::setRin (std::string const &value)
{
  _rin = value;
  return;
}

GEDCOMParser::SourceRecord::~SourceRecord (void)
{
}

SmartPtr < GEDCOMParser::SourceRecord::Data > const &
GEDCOMParser::SourceRecord::getData (void) const
{
  return _data;
}

SmartPtr < GEDCOMParser::SourceRepositoryCitation > const &
GEDCOMParser::SourceRecord::getSourceRepositoryCitation (void) const
{
  return _src_rep_citation;
}

std::string const &
GEDCOMParser::SourceRecord::Data::Event::getEvent (void) const
{
  return _event;
}

std::string const
GEDCOMParser::SourceRecord::Data::Event::getDate (void) const
{
  std::string res;
  if (_date != 0)
    {
      res = _date->getDisplayValue ();
    }
  return res;
}

GEDCOMParser::DateManagement::DateValue const *const
GEDCOMParser::SourceRecord::Data::Event::getDateObject (void) const
{
  return _date;
}


std::string const &
GEDCOMParser::SourceRecord::Data::Event::getPlace (void) const
{
  return _plac;
}

std::string const &
GEDCOMParser::SourceRecord::Data::getAgnc (void) const
{
  return _agnc;
}

std::string const &
GEDCOMParser::SourceRecord::getId (void) const
{
  return _id;
}

std::string const &
GEDCOMParser::SourceRecord::getAuth (void) const
{
  return _auth;
}

std::string const &
GEDCOMParser::SourceRecord::getTitle (void) const
{
  return _titl;
}

std::string const &
GEDCOMParser::SourceRecord::getAbbr (void) const
{
  return _abbr;
}

std::string const &
GEDCOMParser::SourceRecord::getPubl (void) const
{
  return _publ;
}

std::string const &
GEDCOMParser::SourceRecord::getText (void) const
{
  return _text;
}

std::string const &
GEDCOMParser::SourceRecord::getRin (void) const
{
  return _rin;
}

void
GEDCOMParser::SourceRecord::Accept (GEDCOMParser::GEDCOMVisitor * v)
{
  v->VisitSourceRecord (this);
  return;
}

void
GEDCOMParser::SourceRecord::Data::Accept (GEDCOMParser::GEDCOMVisitor * v)
{
  v->VisitSourceRecordData (this);
  return;
}

void
GEDCOMParser::SourceRecord::Data::Event::Accept (GEDCOMParser::GEDCOMVisitor *
						 v)
{
  v->VisitSourceRecordDataEvent (this);
  return;
}
