/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include "SourceRepositoryCitation.hh"
#include "patterns/SmartPtr.hh"
#include "GEDCOMParser/Visitor/GEDCOMVisitor.hh"
#include "GEDCOMParser/GEDCOMFactory.hh"
#include "GEDCOMParser/GEDCOMFactoryAccessor.hh"

void
GEDCOMParser::SourceRepositoryCitation::SourceCallNumber::setCallNumber (std::
									 string
									 const
									 &value)
{
  _caln = value;
  return;
}

void
GEDCOMParser::SourceRepositoryCitation::SourceCallNumber::setMedi (std::
								   string
								   const
								   &value)
{
  _medi = value;
  return;
}

void
GEDCOMParser::SourceRepositoryCitation::setRepoXref (std::string const &value)
{
  _repo_xref = value;
  return;
}

GEDCOMParser::SourceRepositoryCitation::SourceCallNumber *
  GEDCOMParser::SourceRepositoryCitation::addSourceCallNumber (GEDCOMParser::
							       SourceRepositoryCitation::
							       SourceCallNumber
							       * const data =
							       0)
{
  GEDCOMParser::SourceRepositoryCitation::SourceCallNumber * tmp_data = data;
  if (data == 0)
    {
      GEDCOMParser::GEDCOMFactory * factory =
	GEDCOMParser::GEDCOMFactoryAccessor::getFactory ();
      tmp_data = factory->createSourceRepositoryCitation_SourceCallNumber ();
    }
  _call_numbers.push_back (SmartPtr <
			   SourceRepositoryCitation::SourceCallNumber >
			   (tmp_data));
  return _call_numbers.back ().getPtr ();
}

GEDCOMParser::SourceRepositoryCitation::SourceCallNumbers_t const &
GEDCOMParser::SourceRepositoryCitation::getSourceCallNumbers (void) const
{
  return _call_numbers;
}

std::string const &
GEDCOMParser::SourceRepositoryCitation::SourceCallNumber::getCallNumber (void) const
{
  return _caln;
}

std::string const &
GEDCOMParser::SourceRepositoryCitation::SourceCallNumber::getMedi (void) const
{
  return _medi;
}


std::string const &
GEDCOMParser::SourceRepositoryCitation::getRepoXref (void) const
{
  return _repo_xref;
}

void
GEDCOMParser::SourceRepositoryCitation::Accept (GEDCOMParser::GEDCOMVisitor *
						v)
{
  v->VisitSourceRepositoryCitation (this);
  return;
}

void
GEDCOMParser::SourceRepositoryCitation::SourceCallNumber::
Accept (GEDCOMParser::GEDCOMVisitor * v)
{
  v->VisitSourceRepositoryCitationSourceCallNumber (this);
  return;
}
