/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _GEDCOMPARSER_SUBMITTER_RECORD_HH_
#define _GEDCOMPARSER_SUBMITTER_RECORD_HH_

#include <map>
#include <string>
#include <vector>

#include "GEDCOMParser/AddressManager.hh"
#include "GEDCOMParser/AttachmentManager.hh"
#include "GEDCOMParser/AutomatedRecordIdManager.hh"
#include "GEDCOMParser/ChangelogManager.hh"
#include "GEDCOMParser/Visitor/GEDCOMElement.hh"

///
namespace GEDCOMParser
{
  class GEDCOMVisitor;
  /// @memo Implements the GEDCOM 5.5 SUBMITTER_RECORD structure     
  class SubmitterRecord:public GEDCOMElement,
    ///
    public AttachmentManager,
    public AutomatedRecordIdManager,
    public AddressManager, public ChangelogManager
  {
  public:
    ///@name typedefs
    //@{
    /// @doc handling of many language preferences
    typedef std::vector < std::string > LanguagePreferences_t;
    //@}
      SubmitterRecord (std::string const &id = "");
      virtual ~ SubmitterRecord (void)
    {
    };
    ///@name Accessors (set) 
    //@{    
    ///
    void setId (std::string const &);
    ///
    void setName (std::string const &);
    ///
    void addLanguagePref (std::string const &);
    ///
    void setRfn (std::string const &);
    //@}

    ///@name Accessors (get)
    //@{    
    ///
    virtual std::string const &getId (void) const;
    ///
    virtual std::string const &getName (void) const;
    ///
    LanguagePreferences_t const &getLanguagePreferences (void) const;
    ///
    virtual std::string const &getRfn (void) const;
    //@}
    virtual void Accept (GEDCOMParser::GEDCOMVisitor *);
  protected:
      std::string _id;
      std::string _name;
    LanguagePreferences_t _language_preferences;
      std::string _rfn;
  };
  ///@name typedefs
  //@{
  /// @doc handling of many submitter records
  typedef std::map < std::string,
    SmartPtr < SubmitterRecord > >SubmitterRecords_t;
  //@}
};
#endif
