#ifndef _GEDCOMPARSER_VISITOR_GEDCOMVISITOR_HH_
#define _GEDCOMPARSER_VISITOR_GEDCOMVISITOR_HH_

///
class GEDCOMVisitor;

#include "GEDCOMParser/Address.hh"
#include "GEDCOMParser/Association.hh"
#include "GEDCOMParser/ChangeDate.hh"
#include "GEDCOMParser/ChildToFamilyLink.hh"
#include "GEDCOMParser/Data.hh"
#include "GEDCOMParser/Event.hh"
#include "GEDCOMParser/FamilyEvent.hh"
#include "GEDCOMParser/FamilyRecord.hh"
#include "GEDCOMParser/Header.hh"
#include "GEDCOMParser/IndividualAttribute.hh"
#include "GEDCOMParser/IndividualEvent.hh"
#include "GEDCOMParser/IndividualRecord.hh"
#include "GEDCOMParser/LdsIndividualOrdinance.hh"
#include "GEDCOMParser/LdsSpouseSealing.hh"
#include "GEDCOMParser/LineageLinkageGedcom.hh"
#include "GEDCOMParser/MultimediaLink.hh"
#include "GEDCOMParser/MultimediaRecord.hh"
#include "GEDCOMParser/NoteRecord.hh"
#include "GEDCOMParser/NoteStructure.hh"
#include "GEDCOMParser/PersonalName.hh"
#include "GEDCOMParser/Place.hh"
#include "GEDCOMParser/RepositoryRecord.hh"
#include "GEDCOMParser/SourceCitation.hh"
#include "GEDCOMParser/SourceRecord.hh"
#include "GEDCOMParser/SourceRepositoryCitation.hh"
#include "GEDCOMParser/SpouseToFamilyLink.hh"
#include "GEDCOMParser/Submission.hh"
#include "GEDCOMParser/SubmitterRecord.hh"
#include "GEDCOMParser/UserReference.hh"

///
class GEDCOMParser::LineageLinkageGedcom;
///
class GEDCOMParser::Header;

///
namespace GEDCOMParser
{
  class GEDCOMVisitor
  {
  public:
    ///
    virtual void
    VisitAddress (GEDCOMParser::Address *) =
      0;
    ///
    virtual void
    VisitAssociation (GEDCOMParser::Association *) =
      0;
    ///
    virtual void
    VisitChangeDate (GEDCOMParser::ChangeDate *) =
      0;
    ///
    virtual void
    VisitChildToFamilyLink (GEDCOMParser::ChildToFamilyLink *) =
      0;
    ///
    virtual void
    VisitData (GEDCOMParser::Data *) =
      0;
    ///
    virtual void
    VisitEvent (GEDCOMParser::Event *) =
      0;
    ///
    virtual void
    VisitFamilyEvent (GEDCOMParser::FamilyEvent *) =
      0;
    ///
    virtual void
    VisitFamilyRecord (GEDCOMParser::FamilyRecord *) =
      0;
    ///
    virtual void
    VisitHeader (GEDCOMParser::Header *) =
      0;
    ///
    virtual void
    VisitIndividualAttribute (GEDCOMParser::IndividualAttribute *) =
      0;
    ///
    virtual void
    VisitIndividualEvent (GEDCOMParser::IndividualEvent *) =
      0;
    ///
    virtual void
    VisitIndividualRecord (GEDCOMParser::IndividualRecord *) =
      0;
    ///
    virtual void
    VisitLdsIndividualOrdinance (GEDCOMParser::LdsIndividualOrdinance *) =
      0;
    ///
    virtual void
    VisitLdsSpouseSealing (GEDCOMParser::LdsSpouseSealing *) =
      0;
    ///
    virtual void
    VisitLineageLinkageGedcom (GEDCOMParser::LineageLinkageGedcom *) =
      0;
    ///
    virtual void
    VisitMultimediaLink (GEDCOMParser::MultimediaLink *) =
      0;
    ///
    virtual void
    VisitMultimediaRecord (GEDCOMParser::MultimediaRecord *) =
      0;
    ///
    virtual void
    VisitNoteRecord (GEDCOMParser::NoteRecord *) =
      0;
    ///
    virtual void
    VisitNoteStructure (GEDCOMParser::NoteStructure *) =
      0;
    ///
    virtual void
    VisitPersonalName (GEDCOMParser::PersonalName *) =
      0;
    ///
    virtual void
    VisitPlace (GEDCOMParser::Place *) =
      0;
    ///
    virtual void
    VisitRepositoryRecord (GEDCOMParser::RepositoryRecord *) =
      0;
    ///
    virtual void
    VisitSourceCitation (GEDCOMParser::SourceCitation *) =
      0;
    ///
    virtual void
    VisitSourceRecord (GEDCOMParser::SourceRecord *) =
      0;
    ///
    virtual void
    VisitSourceRecordData (GEDCOMParser::SourceRecord::Data *) =
      0;
    ///
    virtual void
    VisitSourceRecordDataEvent (GEDCOMParser::SourceRecord::Data::Event *) =
      0;

    ///
    virtual void
    VisitSourceRepositoryCitation (GEDCOMParser::SourceRepositoryCitation *) =
      0;
    ///
    virtual void
    VisitSourceRepositoryCitationSourceCallNumber (GEDCOMParser::
						   SourceRepositoryCitation::
						   SourceCallNumber *) =
      0;
    ///
    virtual void
    VisitSpouseToFamilyLink (GEDCOMParser::SpouseToFamilyLink *) =
      0;
    ///
    virtual void
    VisitSubmission (GEDCOMParser::Submission *) =
      0;
    ///
    virtual void
    VisitSubmitterRecord (GEDCOMParser::SubmitterRecord *) =
      0;
    ///
    virtual void
    VisitUserReference (GEDCOMParser::UserReference *) =
      0;

    ///
    virtual void
    VisitFamilyRecords (GEDCOMParser::FamilyRecords_t *) =
      0;
    ///
    virtual void
    VisitIndividualRecords (GEDCOMParser::IndividualRecords_t *) =
      0;
    ///
    virtual void
    VisitMultimediaRecords (GEDCOMParser::MultimediaRecords_t *) =
      0;
    ///
    virtual void
    VisitNoteRecords (GEDCOMParser::NoteRecords_t *) =
      0;
    ///
    virtual void
    VisitRepositoryRecords (GEDCOMParser::RepositoryRecords_t *) =
      0;
    ///
    virtual void
    VisitSourceRecords (GEDCOMParser::SourceRecords_t *) =
      0;
    ///
    virtual void
    VisitSourceRecordDataEvents (GEDCOMParser::SourceRecord::Data::
				 Events_t *) =
      0;
    ///
    virtual void
    VisitSubmitterRecords (GEDCOMParser::SubmitterRecords_t *) =
      0;

    ///
    virtual void
    VisitAssociations (GEDCOMParser::Associations_t *) =
      0;
    ///
    virtual void
    VisitChildToFamilyLinks (GEDCOMParser::ChildToFamilyLinks_t *) =
      0;
    ///
    virtual void
    VisitFamilyEvents (GEDCOMParser::FamilyEvents_t *) =
      0;
    ///
    virtual void
    VisitIndividualAttributes (GEDCOMParser::IndividualAttributes_t *) =
      0;
    ///
    virtual void
    VisitIndividualEvents (GEDCOMParser::IndividualEvents_t *) =
      0;
    ///
    virtual void
    VisitLdsIndividualOrdinances (GEDCOMParser::LdsIndividualOrdinances_t *) =
      0;
    ///
    virtual void
    VisitLdsSpouseSealings (GEDCOMParser::LdsSpouseSealings_t *) =
      0;
    ///
    virtual void
    VisitMultimediaLinks (GEDCOMParser::AttachmentManager::
			  MultimediaLinks_t *) =
      0;
    ///
    virtual void
    VisitNoteStructures (GEDCOMParser::AttachmentManager::
			 NoteStructures_t *) =
      0;
    ///
    virtual void
    VisitPersonalNames (GEDCOMParser::PersonalNames_t *) =
      0;
    ///
    virtual void
    VisitSourceCitations (GEDCOMParser::AttachmentManager::
			  SourceCitations_t *) =
      0;
    ///
    virtual void
    VisitEvents (GEDCOMParser::SourceRecord::Data::Events_t *) =
      0;
    ///
    virtual void
    VisitSourceCallNumbers (GEDCOMParser::SourceRepositoryCitation::
			    SourceCallNumbers_t *) =
      0;
    ///
    virtual void
    VisitSpouseToFamilyLinks (GEDCOMParser::SpouseToFamilyLinks_t *) =
      0;
    ///
    virtual void
    VisitUserReferences (GEDCOMParser::UserReferences_t *) =
      0;
  };
};
#endif
