/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "GEDCOMParser/Parser.hh"
#include "GEDCOMParser/GEDCOMFactory.hh"
#include "GEDCOMParser/GEDCOMFactoryAccessor.hh"
#include "GEDCOMParser/ParseErrorManagement/ParseErrorManager.hh"
#include <iostream>

#include "gettext.h"
#define _(String) gettext(String)

void print_event(SmartPtr<GEDCOMParser::Event> const &event)
{
  if (! event.Null())
    {
      std::cout << " (" << event->getType() << ") " << event->getDate();
    }
  std::cout << std::endl;
  return;
}

int main(int argc, char **argv)
{
  int res;
  res = 0;
  setlocale (LC_ALL, "");
  bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
  textdomain (PACKAGE);

  GEDCOMParser::GEDCOMFactoryAccessor::Init();
  GEDCOMParser::GEDCOMFactory * factory = GEDCOMParser::GEDCOMFactoryAccessor::getFactory();
  GEDCOMParser::Parser viewparser(factory);
  if (argc == 2)
    {

      char * gedcom_filename = argv[1];

      GEDCOMParser::ParseErrorManagement::ParseErrorManager parse_error_manager = viewparser.Parse(gedcom_filename);
      if (parse_error_manager.ErrorCount() == 0)
	{
	  res = 0;
	  GEDCOMParser::LineageLinkageGedcom * const lineage = viewparser.getLineageLinkageGedcom();
	  GEDCOMParser::IndividualRecords_t const &individuals=lineage->getIndividualRecords();
	  for (GEDCOMParser::IndividualRecords_t::const_iterator individual_iter=individuals.begin();
	       individual_iter!=individuals.end();individual_iter++)
	    {
	      // getting individual events
	      GEDCOMParser::IndividualEvents_t const &individual_events=(individual_iter->second)->getIndividualEvents();
	      for (GEDCOMParser::IndividualEvents_t::const_iterator event_iter=individual_events.begin();
	       event_iter!=individual_events.end();event_iter++)
		{
		  SmartPtr<GEDCOMParser::Event> const &event = (*event_iter)->getEvent();
		  std::cout << (*event_iter)->getType();
		  print_event(event);
		}
	      // getting individual attributes
	      GEDCOMParser::IndividualAttributes_t const &individual_attributes=(individual_iter->second)->getIndividualAttributes();
	      for (GEDCOMParser::IndividualAttributes_t::const_iterator attribute_iter=individual_attributes.begin();
	       attribute_iter!=individual_attributes.end();attribute_iter++)
		{
		  SmartPtr<GEDCOMParser::Event> const &event = (*attribute_iter)->getEvent();
		  std::cout << (*attribute_iter)->getType();
		  print_event(event);
		}
	    }
	  
	  GEDCOMParser::FamilyRecords_t const &families=lineage->getFamilyRecords();
	  for (GEDCOMParser::FamilyRecords_t::const_iterator family_iter=families.begin();
	       family_iter!=families.end();family_iter++)
	    {
	      // getting family events
	      GEDCOMParser::FamilyEvents_t const &family_events=(family_iter->second)->getFamilyEvents();
	      for (GEDCOMParser::FamilyEvents_t::const_iterator family_event_iter=family_events.begin();
		   family_event_iter!=family_events.end();family_event_iter++)
		{
		  SmartPtr<GEDCOMParser::Event> const &event = (*family_event_iter)->getEvent();
		  std::cout << (*family_event_iter)->getType();
		  print_event(event);
		}
	    }
	}
      else
	{
	  std::cout << std::endl << _("Parsing finished with errors : ") << std::endl;
	  res = 1;
	  for (std::vector < GEDCOMParser::ParseErrorManagement::ParseError >::const_iterator err_iter = parse_error_manager.getErrors().begin(); err_iter != parse_error_manager.getErrors().end(); err_iter++)
	    {
	      std::cerr << err_iter->getDescription() << std::endl;
	    }
	}
    }
  return res;
}
