<?
// GiftWeb: PHP/PostgreSQL online Gift Registry System 
// Matthew T. Jachimstal
// Copyright (C) 2000-2003  Matthew T. Jachimstal
//
// email: matthew@jachimstal.com
//
// Snail mail: Matthew Jachimstal
//			   460 Washington Blvd.
//			   Hoffman Estates, IL 60194
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//

require "./main.inc";
require "./util.php";

$s = $_GET["s"];
$uid = validatesession($s);

$conn = ADONewConnection($dbtype);
$conn->PConnect($dbhost, $dbuser, $dbpass, $dbname);


$itemlist = $_POST["itemlist"];

$cnt = count($itemlist);
if ($_POST["type"]	!= "edit" && $_POST["type"] != "notes"
    && $_POST["type"] != "images" )
{
	if ( $cnt == 0 )
	{
		header("Location: editlist.php?s=$s");
		exit(0);
	}
}



if (isset($_POST["submit_delete"]))
{	
	$stage = 1;
	$text = "Delete Items";
}

if (isset($_POST["submit_edit"]))
{
	$stage = 2;
	$text = "Edit Items";
}

if (isset($_POST["submit_notes"]))
{
	$stage = 3;
	$text = "Edit Item Notes";
}

if (isset($_POST["submit_images"]))
{
	$stage = 4;
	$text = "Edit Item Images";
}

if (isset($_POST["cancel"]))
{
	header("Location: editlist.php?s=$s");
	exit(0);
}

if ($_POST["type"] == "delete")
{
	$stage = -1;
	$text = "Deleting Items";
}

if ($_POST["type"] == "edit")
{
	$stage = -2;
	$text = "Updating Items";
}

if ($_POST["type"] == "notes")
{
	$stage = -3;
	$text = "Updating Notes";
}

if ($_POST["type"] == "images")
{
	$stage = -4;
	$text = "Updating Images";
}


startpage($text, 0);

if ($stage == 1)   // confirmation of deletion
{
	?>
	<h2>Delete Items</h2>
	Please <b>confirm</b> that you wish to <b>delete</b> these items.<p>

	<form method=post action="edit.php?s=<?echo $s?>">
	<input type=hidden name=type value="delete">
	<table cellspacing=0 cellpadding=2 border=1><tr><th>Item Description</th><th>Confirm<br>Delete</th></tr>
	<?

	for ($i=0; $i < $cnt; $i++)
	{
		$itnum = $itemlist[$i];
		
		$sql = "SELECT * FROM items WHERE item_num='$itnum'";
		$result = $conn->Execute($sql);
		$desc = chop($result->fields["description"]);

		?>
		<tr><td><?echo $desc?></td>
			<td><input type=checkbox name=itemlist[] value=<?echo $itnum?> 
				 checked="checked"></td></tr>

		<?
	}
	?>

	<center>
	<tr><td>
		<table><tr>
		<td><input type=submit name=confirm value="Delete items"></td>
		<td width=5%>&nbsp;</td>
		<td><input type=submit name=cancel value="Cancel and return to my list"></td>
		</tr></table>
	<td>&nbsp;</td>
	</tr></table>
	
	<?
}

if ($stage == -1)    //deletion
{
	?>
	<h2>Deleting Selected Items</h2>
	<?


	$error = 0;

	for ($i=0; $i < $cnt; $i++)
	{
		$itnum = $itemlist[$i];

		$sql = "SELECT * FROM items WHERE item_num='$itnum' and uid='$uid'";
		$result = $conn->Execute($sql);
		$desc = chop($result->fields["description"]);
		$pid = $result->fields["purchased"];

		if ( $pid != -1 )
		{
			notify_purchaser($uid, $itnum, $pid);
		}

		$sql = "DELETE FROM items WHERE item_num='$itnum'";
		$result = $conn->Execute($sql);

		$sql = "DELETE FROM notes WHERE item_num='$itnum'";
		$result = $conn->Execute($sql);

		if ($result->RecordCount() != 0)
		{
			$error = 1;
		}
	}

	if ($error != 0)
	{
		?>
		<h2>An error occurred deleting an item. Please try again. If the
		problem persists, contact the registry administrator.</h2>
		<meta HTTP-EQUIV="Refresh" 
			CONTENT="5; URL=./editlist.php?s=<?echo $s?>">
		<?
	}
	else
	{
		?>
		<h2>Your items have been successfully deleted.</h2>
		<meta HTTP-EQUIV="Refresh" 
			CONTENT="3; URL=./editlist.php?s=<?echo $s?>">
		<?
	}
}



if ($stage == 2)   // Editing items
{
	?>
	<h2>Edit Items</h2>
	Please make all your changes to the items below and press submit.<p>

	<form method=post action="edit.php?s=<?echo $s?>">
	<input type=hidden name=type value="edit">
	<input type=hidden name=count value="<?echo $cnt?>">
	<table cellspacing=0 cellpadding=2 border=1>
	<tr><th>Item Description</th>
	    <th>Store/URL</th>
	    <th>Avg Price</th>
	</tr>
	   
	<?

	for ($i=0; $i < $cnt; $i++)
	{
		$itnum = $itemlist[$i];
		
		$sql = "SELECT * FROM items WHERE item_num='$itnum'";
		$result = $conn->Execute($sql);
		$desc = chop($result->fields["description"]);
		$url = chop($result->fields["url"]);
		$price = chop($result->fields["price"]);

		$indesc = "idesc".$i;
		$inurl = "iurl".$i;
		$inprice = "iprice".$i;
		$inum  = "inum".$i;

		?>
		<tr><td><input type=text name=<?echo $indesc?>
				 size=50 value="<?echo $desc?>"></td>
			<td><input type=text name=<?echo $inurl?>
				 size=60 value="<?echo $url?>"></td>
			<td><input type=text name=<?echo $inprice?>
				 size=8 value="<?echo $price?>"></td></tr>
			<input type=hidden name=<?echo $inum?>
				value="<?echo $itnum?>">
		<?
	}
	?>
	</tr></td>

	<center>
	<tr><td>
		<table><tr>
		<td><input type=submit name=confirm value="Update items"></td>
		<td width=5%>&nbsp;</td>
		<td><input type=submit name=cancel value="Cancel"></td>
		</tr></table>
	</tr></table>
	
	<?
}

if ($stage == -2)   // updating items
{
  // phpinfo(32);
	//exit();

	$error = 0;
	
	for ($i = 0; $i < $_POST["count"]; $i++)
	{
		$idesc = "idesc".$i;
		$iurl = "iurl".$i;
		$iprice = "iprice".$i;
		$inum = "inum".$i;

		$desc = $_POST["$idesc"];
		$url = $_POST["$iurl"];
		$price = $_POST["$iprice"];
		$num = $_POST["$inum"];

		$sql = "UPDATE items set description='$desc', url='$url' ";
		$sql .= ", price='$price' ";
		$sql .= "WHERE item_num='$num'";

		$result = $conn->Execute($sql);

		if ($result->RecordCount() != 0)
		{
			$error = 1;
		}
	}

	if ($error == 1)
	{
        ?>
        <h2>An error occured updating your item(s). Please try again.</h2
        If the problem persists, please contact the site administrator.
        <meta HTTP-EQUIV="Refresh"
            CONTENT="5; URL=./editlist.php?s=<?echo $s?>">
        <?
	}
	else
	{
	    ?>
    	<h2>Item(s) successfuly updated.</h2>
        <meta HTTP-EQUIV="Refresh"
            CONTENT="3; URL=./editlist.php?s=<?echo $s?>">
		<?
	}
}

if ($stage == 3)
{
	?>
	<h2>Edit Item Notes</h2>
	Please make your changes to the Item Notes below, or select those
	you wish to delete, and press the appropriate button below.<p>

	<form method=post action="edit.php?s=<?echo $s?>">
	<input type=hidden name=type value="notes">
	<input type=hidden name=count value="<?echo $cnt?>">
	<table cellspacing=0 cellpadding=2 border=1>
	<?

	for ($i=0; $i < $cnt; $i++)
	{
		$itnum = $itemlist[$i];

		$sql = "SELECT * FROM items WHERE item_num='$itnum'";
		$result = $conn->Execute($sql);
		$desc = chop($result->fields["description"]);

		$sql = "SELECT * FROM notes WHERE item_num='$itnum'";
		$result = $conn->Execute($sql);

		if ($result->RecordCount() == 1)
		{
			$note = $result->fields["notes"];
		}
		else
		{
			$note = "";
		}

		$note = chop($note);

		$inum = "inum".$i;
		$inote = "inote".$i;

		?>
		<tr><td><font size=+1><b><?echo $desc?></b></font><br>
				<textarea name="<?echo $inote?>" cols=40 rows=5
				 wrap=physical><?echo $note?></textarea><br>

				Delete: <input type=checkbox name=dellist[] 
				 value="<?echo $itnum?>"><p></td>

			<input type=hidden name="<?echo $inum?>" value="<?echo $itnum?>">
		</tr>
		<?

		if ( $i < ($cnt - 1))
		{
			echo "<tr><td> </td></tr>\n";
			echo "<tr><td> </td></tr>\n";
		}
	}
	?>
	
	</table>

	<table>
	<tr><td>
		<table><tr>
		<td><input type=submit name=upd_note value="Update Notes">
		<td width=5%>&nbsp;</td>
		<td><input type=submit name=cancel value="Cancel"></td>
		</tr></table>
	</tr></table>

	<?
}


if ($stage == -3)
{

	$error = 0;
	$error2 = 0;

	for ($i = 0; $i < $_POST["count"]; $i++)
	{
		$inote = "inote".$i;
		$inum = "inum".$i;

		$note = $_POST["$inote"];
                $num = $_POST["$inum"];           

		$note = chop($note);

		if ($note != "")
		{
			$sql = "DELETE FROM notes where item_num='$num'";
			$result = $conn->Execute($sql);

			$sql = "INSERT INTO notes VALUES('$num', '$note')";
			$result = $conn->Execute($sql);
	
			if ($result->RecordCount() != 0)
			{
				$error = 1;
			}
		}
	}

	if (isset($_POST["dellist"]))
	{
		$count2 = count($_POST["dellist"]);
		for ($i = 0; $i < $count2; $i++)
		{
			$itnum = chop($_POST["dellist"][$i]);
			$sql = "DELETE FROM notes WHERE item_num='$itnum'";

			$result =$conn->Execute($sql);

			if ($result->RecordCount() != 0)
			{
				$error2 = 1;
			}
		}
	}

	if ($error == 1 || $error2 == 1)
	{
		?>
		<h2>An error occured updating your item note(s). Please try again.</h2>
		If the problem persists, please contact the site administrator.
		<meta HTTP-EQUIV="Refresh"
			CONTENT=5; URL="./editlist.php?s=<?echo $s?>">
		<?
	}
	else
	{
		?>
		<h2>Item Note(s) updated.</h2>
		<meta HTTP-EQUIV="Refresh"
			CONTENT=3; "URL=./editlist.php?s=<?echo $s?>">
		<?
	}
}

if ($stage == 4)   // Editing item images
{

	?>
	<h2>Edit Item Images</h2>
	Please make all your changes to the items below and press submit.
	   <p><i>Note: Images need to be 60x60 pixels (like Amazon uses) or smaller</i></p>
	

	<form method=post action="edit.php?s=<?echo $s?>">
	<input type=hidden name=type value="images">
	<input type=hidden name=count value="<?echo $cnt?>">
	<table cellspacing=0 cellpadding=2 border=1>
	<tr><th width=45%>Item Description</th>
	    <th width=55%>Image URL </th>
	</tr>
	   
	<?

	for ($i=0; $i < $cnt; $i++)
	{
		$itnum = $itemlist[$i];
		
		$sql = "SELECT * FROM items WHERE item_num='$itnum'";
		$result = $conn->Execute($sql);
		$desc = chop($result->fields["description"]);
		$image = chop($result->fields["image"]);

		$inimage = "iimage".$i;
		$inum  = "inum".$i;
	  
		?>
		<tr><td><?echo $desc?></td>
			<td><input type=text name=<?echo $inimage?>
				 size=60 value="<?echo $image?>"></td>
			<input type=hidden name=<?echo $inum?>
				value="<?echo $itnum?>">
		<?
	}
	?>
	</tr></td>

	<center>
	<tr><td>
		<table><tr>
		<td><input type=submit name=confirm value="Update items"></td>
		<td width=5%>&nbsp;</td>
		<td><input type=submit name=cancel value="Cancel"></td>
		</tr></table>
	</tr></table>
	
	<?
}


if ($stage == -4)   // updating items
{
  //phpinfo(32);
  //exit();

	$error = 0;
	
	for ($i = 0; $i < $_POST["count"]; $i++)
	{
		$image = "iimage".$i;
		$inum = "inum".$i;

		$image = $_POST["$image"];
		$num = $_POST["$inum"];

	
		$sql = "UPDATE items set image='$image' ";
		$sql .= "WHERE item_num='$num'";

		$result = $conn->Execute($sql);

		if ($result->RecordCount() != 0)
		{
			$error = 1;
		}
	}

	if ($error == 1)
	{
        ?>
        <h2>An error occured updating your item(s). Please try again.</h2
        If the problem persists, please contact the site administrator.
        <meta HTTP-EQUIV="Refresh"
            CONTENT="5; URL=./editlist.php?s=<?echo $s?>">
        <?
	}
	else
	{
	    ?>
    	<h2>Item(s) successfuly updated.</h2>
        <meta HTTP-EQUIV="Refresh"
            CONTENT="3; URL=./editlist.php?s=<?echo $s?>">
		<?
	}
}
		


endpage(0);
?>
