/*
 * `gnetic' is a program to use and enjoy by all alive being
 * Jesús Burgos <jburmac@gmail.com>
 * Joan Lledó <joanlluislledo@gmail.com>
 *
 *  Copyright (C) 2005 Jesús Burgos
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef _IMAGE_H
#define _IMAGE_H

#define nlogicals 59

#define _FILE_OFFSET_BITS 64
#include <sys/types.h>

#include "util.h"
#include "net.h"

bool no_data;

#define set_no_data(mode) \
	no_data = mode

/* params_dev_fd allows dev2fd and fd2dev to be called in a thread */
struct params_dev_fd
{
	struct socks_link sockets;
	const char *devicepath;
};

enum fs_types
{ none, nodes, fat };

/* There is space for only 32 filesystems (look in struct part_info) */
enum fs_codes
{ empty, ext2, ext3, ext4, jfs, xfs, reiserfs, swap, hfs, hfsp, fat16, fat32,
	ntfs
};

enum partition_types
{ primary, logical, extended };

/* This structure can save all the needed data to copy a partition without its
 * data */
struct part_info
{
	off_t min_size;				// Min size of the partition for the dest disk
	float used_part;			// Percentaje of disk used by the partition
	unsigned int bootable:1;
	unsigned int lba:1;
	enum fs_codes fs_code:5;
	enum partition_types type:2;
	unsigned char label[28];
	unsigned char bs[8193];
	char uuid[37];
	unsigned char dummy[512];
};

//All the image information. Very important
struct image_header
{
	struct part_info partitions[4 + nlogicals];
	off_t image_size;			/* Estimated Total size of the resultant image,
								 * in kbytes */
	enum
	{ disk, part } image_type:1;	// 0->full disk; 1->single partition
	unsigned char mbr[447];
	bool no_data;
	unsigned char dummy[511];
};

struct nodes_file
{
	char name[256];
	mode_t mode;				// Permissions and file type
	uid_t uid;					// Owner
	gid_t gid;					// Group
	off_t size;					// Size in bytes
	time_t atime;
	time_t mtime;
	char se_xattr[128];			// SeLinux extended attributtes
	unsigned int did;			/* Has the uniqueid of the parent directory */
	unsigned long long other;	/* When is a block device file:
								 * this variable saves the major & minor
								 * When is a directory:
								 * saves his own uniqueid */
	unsigned char dummy[384];
};

/* a file in FAT filesystems does not need uid or gid */
struct fat_file
{
	char name[256];
	mode_t mode;				// File permissions
	off_t size;					// Size in bytes
	time_t atime;
	time_t mtime;
	unsigned int did;
	unsigned long long other;
	unsigned char dummy[512];
};

int dna_check (const char *);
int dev2fd (const struct params_dev_fd *);
int fd2dev (const struct params_dev_fd *);

#endif /* _IMAGE_H */
