/* $Id: phoneview.c,v 1.5 2004/02/20 19:26:23 thrulliq Exp $ */

#include <gtk/gtk.h>
#include <glade/glade.h>
#include <gnokii.h>

#include "gnocky.h"
#include "utils.h"

static GladeXML *phone_xml;

GtkWidget *gnocky_phone_view_create()
{
	GtkWidget *pv;

	phone_xml = create_gladexml("gnocky-phone-view.glade", "phone_view");

	if (!phone_xml) {
		g_error("Cannot create phone view!\n");
		gtk_main_quit();
	}

	pv = glade_xml_get_widget(phone_xml, "phone_view");

	if (pv == NULL) {
		g_error("uhm... pv == NULL!!!\n");
	}
	return pv;
}

void gnocky_phone_view_update(GnockyPhoneMonitor pm)
{
	GtkWidget *widget;
	gchar *tmp;
	
	/* rf level */
	widget = glade_xml_get_widget(phone_xml, "rf_progress");
	gtk_progress_set_value(GTK_PROGRESS(widget), (gdouble)pm.rf_level);

	if (pm.rf_level == -1)
		tmp = g_strdup_printf(_("N/A"));
	else
		tmp = g_strdup_printf("%d%%", (int)pm.rf_level);

	gtk_progress_bar_set_text(GTK_PROGRESS_BAR(widget), tmp);
	g_free(tmp);

	/* battery level */
	widget = glade_xml_get_widget(phone_xml, "battery_progress");
	gtk_progress_set_value(GTK_PROGRESS(widget), (gdouble)pm.battery_level);

	if (pm.battery_level == -1)
		tmp = g_strdup_printf(_("N/A"));
	else
		tmp = g_strdup_printf("%d%%", (int)pm.battery_level);

	gtk_progress_bar_set_text(GTK_PROGRESS_BAR(widget), tmp);
	g_free(tmp);

	if (pm.model) {
		widget = glade_xml_get_widget(phone_xml, "model_entry");
		gtk_label_set_text(GTK_LABEL(widget), pm.model);
		//gtk_entry_set_text(GTK_ENTRY(widget), pm.model);
	}
	
	if (pm.manufacturer) {
		widget = glade_xml_get_widget(phone_xml, "manufacturer_entry");
		gtk_label_set_text(GTK_LABEL(widget), pm.manufacturer);
		//gtk_entry_set_text(GTK_ENTRY(widget), pm.manufacturer);
	}
	
	if (pm.revision) {
		widget = glade_xml_get_widget(phone_xml, "rev_entry");
		gtk_label_set_text(GTK_LABEL(widget), pm.revision);
		//gtk_entry_set_text(GTK_ENTRY(widget), pm.revision);
	}	

	if (pm.imei) {
		widget = glade_xml_get_widget(phone_xml, "imei_entry");
		tmp = g_strdup_printf("<b>%s</b>", pm.imei);
		gtk_label_set_markup(GTK_LABEL(widget), tmp);
		//gtk_entry_set_text(GTK_ENTRY(widget), pm.imei);
	}	
	
	widget = glade_xml_get_widget(phone_xml, "network_info_label");
	if (pm.network_name && pm.network_country) {
		tmp = g_strdup_printf("<b>%s</b> (%s)", pm.network_name, pm.network_country);
		gtk_label_set_markup(GTK_LABEL(widget), tmp);
		g_free(tmp);
	} else {
		gtk_label_set_text(GTK_LABEL(widget), _("N/A"));
	}
	
	if (pm.model_updated) {
		GdkPixbuf *pixbuf;
		widget = glade_xml_get_widget(phone_xml, "phone_image");
		pixbuf = gtk_image_get_pixbuf(GTK_IMAGE(widget));
		if (!pixbuf) {
			gchar *model = g_ascii_strdown(pm.model, -1);

			tmp = g_strconcat("/phones/", model, ".png", NULL);
			pixbuf = create_pixbuf(tmp);
			g_free(model);
			g_free(tmp);
		
			if (!pixbuf) {
				model = gn_model_get(pm.model);
				tmp = g_strconcat("/phones/", model, ".png", NULL);
				pixbuf = create_pixbuf(tmp);
				g_free(tmp);
			}
		
			if (!pixbuf) {
				pixbuf = create_pixbuf("/phones/unknown.png");
			}

			gtk_image_set_from_pixbuf(GTK_IMAGE(widget), pixbuf);
		}

		//if (pixbuf)
		//	gdk_pixbuf_unref(pixbuf);
	}
}



