/* $Id: smsview.c,v 1.2 2004/03/09 17:17:38 thrulliq Exp $ */

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <glade/glade.h>
#include <gnokii.h>
#include <string.h>

#include "gnocky.h"
#include "utils.h"
#include "phonebookview.h"

extern GSList *sms_list;
extern GMutex *sms_mutex;
extern gboolean sms_updated;
static GladeXML *sms_xml;
static GladeXML *new_sms_xml = NULL;
static GtkListStore *store;
static GtkTreeIter iter;

enum {
	COL_SENDER,
	COL_DATE,
	COL_MEMORY,
	COL_POINTER
};
  
static GtkTreeModel *gnocky_sms_create_model()
{
  /* create list store */
  store = gtk_list_store_new (4, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_POINTER);

  return GTK_TREE_MODEL (store);
}

static void gnocky_sms_add_columns(GtkTreeView *treeview)
{
	GtkCellRenderer *renderer;
	GtkTreeViewColumn *column;
	
	renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes (_("Sender"),
						     renderer,
						     "text",
						     COL_SENDER,
						     NULL);
	gtk_tree_view_column_set_sort_column_id (column, COL_SENDER);
	gtk_tree_view_append_column (treeview, column);

	renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes (_("Date"),
						     renderer,
						     "text",
						     COL_DATE,
						     NULL);
	gtk_tree_view_column_set_sort_column_id (column, COL_DATE);
	gtk_tree_view_append_column (treeview, column);
	
	renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes (_("Memory"),
						     renderer,
						     "text",
						     COL_MEMORY,
						     NULL);
	gtk_tree_view_column_set_sort_column_id (column, COL_MEMORY);
	gtk_tree_view_append_column (treeview, column);
	
}

gboolean gnocky_new_sms_count_characters(GtkWidget *widget, GdkEventKey *event, gpointer user_data)
{
	GtkTextBuffer *buffer;
	GtkWidget *w;
	gint char_count;
	gchar *tmp;
	
	buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(widget));
	char_count = gtk_text_buffer_get_char_count (buffer);
	
	if (char_count > GN_SMS_MAX_LENGTH) {
		GtkTextIter start, end;
		gchar *text;
		
		gtk_text_buffer_get_start_iter(buffer, &start);
		gtk_text_buffer_get_end_iter(buffer, &end);
		
		text = gtk_text_buffer_get_text(buffer, &start, &end, FALSE);
		gtk_text_buffer_set_text(buffer, text, GN_SMS_MAX_LENGTH);
		g_free(text);
		char_count = GN_SMS_MAX_LENGTH;
	}
	w = glade_xml_get_widget(new_sms_xml, "chars_label");
	tmp = g_strdup_printf(_("%d left"), GN_SMS_MAX_LENGTH - char_count);
	gtk_label_set_markup(GTK_LABEL(w), tmp);
	g_free(tmp);
	
	return FALSE;
}

void gnocky_new_sms_clicked(GtkWidget *widget, gpointer data)
{
	GtkWidget *new_sms;
	int res;
	
	new_sms_xml = create_gladexml("gnocky-new-sms.glade", "new_sms_dialog");
	
	if (!new_sms_xml)
		g_error("Cannot create new sms view!\n");
	
	new_sms = glade_xml_get_widget(new_sms_xml, "new_sms_dialog");
	glade_xml_signal_autoconnect(new_sms_xml);
	res = gtk_dialog_run(GTK_DIALOG(new_sms));
	
	gnocky_new_sms_count_characters(glade_xml_get_widget(new_sms_xml, "sms_text"), NULL, NULL);
	
	if (res == GTK_RESPONSE_OK) {
		GtkWidget *entry;
		gchar *number, *text, *sms_text;
		GtkTextBuffer *buffer;
		GtkTextIter start, end;
		gn_sms *sms;
		
		entry = glade_xml_get_widget(new_sms_xml, "sms_number");
		number = g_convert(gtk_entry_get_text(GTK_ENTRY(entry)), -1, "ISO-8859-2", "UTF-8", NULL, NULL, NULL);
		
		entry = glade_xml_get_widget(new_sms_xml, "sms_text");
		buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(entry));
		
		gtk_text_buffer_get_start_iter(buffer, &start);
		gtk_text_buffer_get_iter_at_offset(buffer, &end, GN_SMS_MAX_LENGTH);
		
		text = gtk_text_buffer_get_text(buffer, &start, &end, FALSE);
		sms_text = g_convert(text, -1, "ISO-8859-2", "UTF-8", NULL, NULL, NULL);
		g_free(text);
		
		sms = g_new0(gn_sms, 1);
		gn_sms_default_submit(sms);
		strncpy(sms->remote.number, number, sizeof(sms->remote.number) - 1);
		if (number[0] == '+') {
			sms->remote.type = GN_GSM_NUMBER_International;
		} else {
			sms->remote.type = GN_GSM_NUMBER_Unknown;
		}
		strncpy(sms->user_data[0].u.text, sms_text, strlen(sms_text));
		sms->user_data[0].length = strlen(sms_text);
		
		sms->user_data[0].type = GN_SMS_DATA_Text;
		if (!gn_char_def_alphabet(sms->user_data[0].u.text)) 
			sms->dcs.u.general.alphabet = GN_SMS_DCS_UCS2;
		sms->user_data[1].type = GN_SMS_DATA_None;
		g_free(sms_text);
		
		gnocky_event_push(GNOCKY_EVENT_SEND_SMS, sms);
	}
	
	gtk_widget_destroy(new_sms);
	g_object_unref(new_sms_xml);
	new_sms_xml = NULL;
}

void gnocky_sms_load_from_phone_clicked(GtkWidget *widget, gpointer data)
{
	gnocky_event_push(GNOCKY_EVENT_READ_SMS_LIST, NULL);
}

static gboolean sms_pressed(GtkWidget *widget, GdkEventKey *ev, gpointer user_data)
{
	if (ev->keyval == GDK_Delete) {
		GtkTreeModel *model = gtk_tree_view_get_model(GTK_TREE_VIEW(widget));
		GtkTreePath *treepath = NULL;
		GtkTreeIter iter;
		GtkWidget *dialog;
		gint res;
		gn_sms *sms;
		
		gtk_tree_view_get_cursor (GTK_TREE_VIEW(widget), &treepath, NULL);
		gtk_tree_model_get_iter(model, &iter, treepath);
		gtk_tree_model_get(model, &iter, COL_POINTER, &sms, -1);
		
		dialog = gtk_message_dialog_new(NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, 
                                             GTK_BUTTONS_OK_CANCEL,
					     _("Do you want to delete this SMS?"));

		res = gtk_dialog_run(GTK_DIALOG(dialog));
		if (res == GTK_RESPONSE_OK) {
			gnocky_event_push(GNOCKY_EVENT_DELETE_SMS, sms);
		}
		
		gtk_widget_destroy(dialog);
	}
	return FALSE;
}

static gboolean sms_clicked(GtkWidget *treeview, GdkEventButton *ev, gpointer user_data)
{
	GtkTreeModel *model = gtk_tree_view_get_model(GTK_TREE_VIEW(treeview));
	GtkTreeViewColumn *treevc = NULL;
	GtkTreePath *treepath = NULL;
	GtkTreeIter iter;
	GtkWidget *widget;
	GtkTextBuffer *buffer;
	gn_sms *sms;
	gchar *tmp, *sender;
		
	if (!gtk_tree_view_get_path_at_pos(GTK_TREE_VIEW(treeview), ev->x, ev->y, &treepath, &treevc, NULL, NULL))
		return FALSE;
	gtk_tree_model_get_iter(model, &iter, treepath);
	gtk_tree_model_get(model, &iter, COL_POINTER, &sms, -1);
	
	widget = glade_xml_get_widget(sms_xml, "sms_body");
	buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (widget));
	gtk_text_buffer_set_text (buffer, sms->user_data[0].u.text, -1);

	widget = glade_xml_get_widget(sms_xml, "from_label");

	sender = gnocky_pb_get_name(sms->remote.number);

	if (!sender)
		tmp = g_strdup(sms->remote.number);
	else
		tmp = g_strdup_printf("<b>%s</b> (%s)", sender, sms->remote.number);

	gtk_label_set_markup(GTK_LABEL(widget), tmp);
	g_free(tmp);
	
	widget = glade_xml_get_widget(sms_xml, "date_label");
	tmp = g_strdup_printf(_("<b>%02d:%02d %02d/%02d/%04d</b>"), sms->smsc_time.hour, sms->smsc_time.minute,
				sms->smsc_time.day, sms->smsc_time.month, sms->smsc_time.year);
	gtk_label_set_markup(GTK_LABEL(widget), tmp);
	g_free(tmp);

	return FALSE;
}

GtkWidget *gnocky_sms_view_create()
{
	GtkTreeModel *model;
	GtkWidget *sms_tree;
	GtkWidget *sv;

	sms_xml = create_gladexml("gnocky-sms-view.glade", "sms_view");

	if (!sms_xml) {
		g_error("Cannot create sms view!\n");
		gtk_main_quit();
	}
	
	glade_xml_signal_autoconnect(sms_xml);
	
	sv = glade_xml_get_widget(sms_xml, "sms_view");

	if (sv == NULL) {
		g_error("uhm... sv == NULL!!!\n");
	}
	
	model = gnocky_sms_create_model();
	sms_tree = glade_xml_get_widget(sms_xml, "sms_tree");
	gtk_tree_view_set_model(GTK_TREE_VIEW(sms_tree), model);
	g_object_unref (model);
	
	g_signal_connect(G_OBJECT(sms_tree), "button-press-event", G_CALLBACK(sms_clicked), NULL);
	g_signal_connect(G_OBJECT(sms_tree), "key-press-event", G_CALLBACK(sms_pressed), NULL);
	
	gnocky_sms_add_columns(GTK_TREE_VIEW(sms_tree));
	
	return sv;
}

void gnocky_sms_view_update(GnockyPhoneMonitor pm)
{
	if (g_mutex_trylock(sms_mutex)) {
		GSList *tmp = sms_list;
		if (sms_updated) {
			gtk_list_store_clear(store);
			while (tmp) {
				gn_sms *sms = tmp->data;
				gchar *sender;
				gchar *date;
				
				sender = gnocky_pb_get_name(sms->remote.number);
				if (!sender)
					sender = g_strdup(sms->remote.number);
				
				date = g_strdup_printf(_("%02d:%02d %02d/%02d/%04d"), sms->smsc_time.hour, sms->smsc_time.minute,
				sms->smsc_time.day, sms->smsc_time.month, sms->smsc_time.year);
				
				gtk_list_store_append (store, &iter);
				gtk_list_store_set (store, &iter, COL_SENDER, sender, COL_DATE, date, COL_MEMORY, gn_memory_type2str(sms->memory_type), COL_POINTER, sms, -1);
				
				g_free(sender);
				g_free(date);
				tmp = tmp->next;
			}
			sms_updated = FALSE;
		}
		g_mutex_unlock(sms_mutex);
	}
}
