# -*- coding: utf-8 -*-

#    This file is part of Gnomolicious.
#
#    Gnomolicious is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    Gnomolicious is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with Gnomolicious; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    (C) 2006 Nicolas Évrard <nicoe@nutellux.be>

__revision__ = "$Id$"

from gettext import gettext as _

import dbus
import gnomevfs
import deskbar, deskbar.indexer, deskbar.locale_utils, deskbar.handler_utils
import deskbar.handler

HANDLERS = {"DeliciousHandler" : 
            {'name' : _('del.icio.us Bookmarks'),
             'description' : _('Search your del.icio.us account'),}}


class DeliciousMatch(deskbar.handler.Match):

    def __init__(self, backend, url, description):
        self.url = url
        self.description = description
        deskbar.handler.Match.__init__(self, backend, url)

    def action(self, text=None):
        gnomevfs.url_show(self.url)

    def get_verb(self):
        return _('Open <b>%s</b>' % self.description)


class DeliciousHandler(deskbar.handler.AsyncHandler):

    def __init__(self):
        super(DeliciousHandler,
              self).__init__('/usr/local/share/gnomolicious/gnomolicious.png')

    def initialize(self):
        bus = dbus.SessionBus()
        proxy = bus.get_object('org.gnome.gnomolicious',
                               '/org/gnome/Gnomolicious')
        self.dbus = dbus.Interface(proxy, 'org.gnome.GetUrlsIFace')

    def query(self, qstring, qmax=5):
        urls = self.dbus.getUrls(qstring)
        self.check_query_changed()
        if urls:
            return [DeliciousMatch(self, *x) for x in urls[:qmax-1]]
        else:
            return []
