# -*- coding: utf-8 -*-

#    This file is part of Gnomolicious.
#
#    Gnomolicious is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    Gnomolicious is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with Gnomolicious; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    (C) 2006 Nicolas Évrard <nicoe@nutellux.be>

__revision__ = "$Id: epiphany.py,v 1.1 2006/03/20 00:23:56 nicoe Exp $"

import os
import lxml

if sys.version_info < (2, 4):
    from sets import Set as set

import delicious

logger = logging.getLogger('gnomolicious')
EPIBOOKMARKS = os.path.expanduser('~/.gnome2/epiphany/bookmarks.rdf')

class EpiphanyBookmarks(delicious.Singleton):

    def __init__(self):
        self.bookmarks, self.delicioused = self.parse(EPIBOOKMARKS)

    def parse(self, path):
        bookmarks, delicioused = {}, set()
        bmtree = lxml.etree.parse(file(path, 'r'))
        for bookmark in bmtree.xpath('/rdf:RDF/rss:item',
                                     delicious.NAMESPACES):
            post = delicious.Post(bookmark)
            tags = set([subj.text for subj in bookmark.xpath('./dc:subject')])
            bookmarks[post] = tags
            if 'delicioused' in tags:
                delicioused.add(post.href.url)

        return bookmarks, delicioused


