//  Gnomoradio - roboradio/init.cc
//  Copyright (C) 2003  Jim Garrison
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version)
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "init.h"

namespace Roboradio
{
	int Init::refcnt = 0;
	Rainbow::Init *Init::rainbow = 0;
	State *Init::session = 0;
	Recommendation *Init::recommend = 0;
	Player Init::default_player;
}

using namespace std;
using namespace SigC;
using namespace Roboradio;

Roboradio::Init::Init ()
{
	if (++refcnt != 1)
		return;

	srand(time(0));

	session = new State;
	session->load_preferences();

	if (session->get_rainbow_enabled())
		rainbow = new Rainbow::Init(session->get_rainbow_hub());
	session->signal_rainbow_enabled_changed.connect(slot(&Init::on_rainbow_enabled_changed));
	session->signal_rainbow_hub_changed.connect(slot(&Init::on_rainbow_hub_changed));
	session->signal_rainbow_cache_size_changed.connect(slot(&Init::on_rainbow_cache_size_changed));

	recommend = session->load_recommendation();

	session->load_songs();
	session->load_song_paths();
	session->load_song_lists();
	session->done_loading();
}

Roboradio::Init::~Init ()
{
	if (--refcnt != 0)
		return;

	delete session; // automatic save
	if (rainbow)
		delete rainbow;
	if (recommend)
		delete recommend;
}

void Roboradio::Init::on_rainbow_enabled_changed (bool enabled)
{
	if (enabled && !rainbow)
		rainbow = new Rainbow::Init(session->get_rainbow_hub());
	if (!enabled && rainbow) {
		delete rainbow;
		rainbow = 0;
	}
}

void Roboradio::Init::on_rainbow_hub_changed (Glib::ustring hub)
{
	if (rainbow) {
		rainbow->hub().set_hub(hub);
	}
}

void Roboradio::Init::on_rainbow_cache_size_changed (unsigned int megabytes)
{
	if (rainbow) {
		rainbow->hub().set_cache_size(megabytes);
	}
}
