//  Gnomoradio - gnomoradio/song-paths.cc
//  Copyright (C) 2003  Matt Gerginski, Jim Garrison
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <iostream>
#include "song-paths.h"

using namespace Gtk;
using namespace Wraporadio;
using namespace Glib;
using namespace std;

Gnomoradio::SongPaths::SongPaths ()
	: remove_path_button(_("Remove")),
	  add_path_button(_("Add"))
{
	add_path_button.signal_clicked().connect(SigC::slot(*this, &Gnomoradio::SongPaths::add_path_button_clicked));
	remove_path_button.signal_clicked().connect(SigC::slot(*this, &Gnomoradio::SongPaths::remove_path_button_clicked));

	resize(2, 2);
	set_homogeneous(false);
	set_spacings(8);

	attach(song_path_treeview, 0, 2, 0, 1);
	attach(remove_path_button, 0, 1, 1, 2, EXPAND | FILL, SHRINK);
	attach(add_path_button, 1, 2, 1, 2, EXPAND | FILL, SHRINK);

	State state = wr.get_state();

	set<ustring> song_path = state.get_song_path ();

	/* set up song paths tree view */
	ref_tree_model = Gtk::ListStore::create(m_columns);
	song_path_treeview.set_model(ref_tree_model);

	song_path_treeview.append_column(_("Song Paths"), m_columns.path_col);

	for (set<ustring>::iterator i = song_path.begin(); i != song_path.end(); ++i) {
		Gtk::TreeModel::Row row = *(ref_tree_model->append());
		row[m_columns.path_col] = *i;	
	}
}

void Gnomoradio::SongPaths::add_path_button_clicked ()
{
	FileSelection dialog(_("Select Directory"));
 
	Widget *toplevel = song_path_treeview.get_toplevel();

	if (toplevel->get_flags() & TOPLEVEL)
	{
		cout << "called it" << endl;
		dialog.set_transient_for(static_cast<Gtk::Window&>(*toplevel));
	}

	dialog.get_file_list()->get_parent()->hide(); // disable selecting files

	int response = dialog.run();

	if (response == RESPONSE_OK) {
		ustring new_path = dialog.get_filename();
		Gtk::TreeModel::Row row = *(ref_tree_model->append());
		row[m_columns.path_col] = new_path;
		
		wr.get_state().add_song_path(new_path);
	}
}

void Gnomoradio::SongPaths::remove_path_button_clicked ()
{
	TreeModel::iterator iter = song_path_treeview.get_selection()->get_selected();

	if (iter) //If anything is selected
	{
		TreeModel::Row row = *iter;
		
		ustring path;

		row.get_value(0, path);

		ref_tree_model->erase(*iter);

		wr.get_state().remove_song_path(path);
	}
}
