//  Gnomoradio - roboradio/audio/prober.cc
//  Copyright (C) 2003  Jim Garrison
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version)
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "roboradio/audio/prober.h"

extern "C" {
#include "../mp3/esd-audio.h"
}

Roboradio::Audio::Prober::Prober ()
	: activated(false)
{
}

Roboradio::Audio::Prober::~Prober ()
{
	stop_prober();
}

gboolean Roboradio::Audio::probe (gpointer s)
{
	Prober *sng = static_cast<Prober*>(s);
	if (esdout_playing()) {
		int pos = sng->get_position();
		if (pos >= 0)
			sng->signal_position_changed(pos);
		return true;
	} else if (sng->get_position() >= 0) {
		return true;
	} else {
		sng->stop();
		sng->signal_done();
		sng->activated = false;
		return false;
	}
}

void Roboradio::Audio::Prober::start_prober ()
{
	if (activated)
		return;
	prober_timeout = g_timeout_add(1000, &probe, this);
	activated = true;
}

void Roboradio::Audio::Prober::stop_prober ()
{
	if (!activated)
		return;
	g_source_remove(prober_timeout);
	activated = false;
}
