// -*- c++ -*-

//  Gnomoradio - roboradio/sort-songs.h
//  Copyright (C) 2003  Jim Garrison
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version)
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __ROBORADIO_SORT_SONGS_H
#define __ROBORADIO_SORT_SONGS_H

#include "roboradio/song.h"

#include <list>
#include <memory>

namespace Roboradio
{
	class SortSongs
	{
	public:
		typedef std::list<SongRef> ContainerType;

		typedef ContainerType::iterator iterator;
		typedef ContainerType::reverse_iterator reverse_iterator;

		enum SortType
		{
			Artist,
			Rating,
			LastListen,
			Length,
			Types
		};

		SortSongs (SortType type);

		iterator begin () { return l[t]->begin(); }
		iterator end () { return l[t]->end(); }
		reverse_iterator rbegin () { return l[t]->rbegin(); }
		reverse_iterator rend () { return l[t]->rend(); }

	private:
		static void on_new_song (SongRef song);
		static void on_song_changed (SongRef song);

		SortType t;

		static std::auto_ptr<ContainerType> l[];
		static bool initialized;
	};
}

#endif
