// -*- c++ -*-

//  Gnomoradio - rainbow/util.h
//  Copyright (C) 2003  Jim Garrison
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __RAINBOW_UTIL_H
#define __RAINBOW_UTIL_H

// unix-specific network and select stuff
#ifdef WIN32
#include <winsock2.h>
#else
#include <fcntl.h>
#include <sys/socket.h>
#include <sys/select.h>
#include <sys/types.h>
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#endif

#include <string>
#include <cstdlib>

#include <iostream>
#define logmsg std::cerr

namespace Rainbow
{
	bool send_data_on_socket (int socket, const char *data, ssize_t size, int timeout = 0);
	bool send_data_on_socket (int socket, const std::string &data, int timeout = 0);
}

#endif
