#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the 
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
#  Boston, MA 02111-1307 USA.
#
######################################################################


from Globals import Persistent
from OFS.ObjectManager import ObjectManager
from OFS.SimpleItem import Item
from OFS.PropertyManager import PropertyManager
from OFS.FindSupport import FindSupport
from AccessControl.Role import RoleManager
from AccessControl import ClassSecurityInfo
from Globals import InitializeClass, DTMLFile
from Globals import HTMLFile
import Products.PythonScripts, Globals
from Products.PythonScripts.PythonScript import *
from Products.MailHost.MailHost import manage_addMailHost
from Products.ZCatalog.ZCatalog import manage_addZCatalog
from Products.TransparentFolders.TransparentFolder import manage_addTransparentFolder			
from AccessControl.User import manage_addUserFolder
import os
from Products.GNOWSYS.gno import gno,manage_addgnoFolder
from Products.GNOWSYS.ObjectType import ObjectType
from Products.GNOWSYS.OccurrenceType import occurrencetype
from Products.GNOWSYS.AssociationType import AssocT
from Products.GNOWSYS.Object import Object
from Products.GNOWSYS.FacetType import facettype
from time import time
from string import split, find

file_path = Globals.package_home(globals())

class GNOWSYS(ObjectManager,
                  PropertyManager,
                  RoleManager,
                  Item,
                  FindSupport):
    """
    GNOWSYS implementation.
    This class will be used for creating an instance of the product
    """

    meta_type = "GNOWSYS"
     
    _properties = (
        {'id':'title', 'type': 'string', 'mode': 'w'},
        {'id':'image', 'type': 'selection', 'mode': 'wd', 'select_variable': 'image_select'},
        ) 

    manage_options = (
        {'label': 'Contents', 'action': 'manage_main'},
        {'label': 'View', 'action': 'index_html'},
        {'label': 'Properties', 'action':'_properties'}, 
        ) 


allowedmetatypes = ('DTML Method')

def all_meta_types(self):

            if hasattr(self, 'allowedmetatypes'):
                result = []
		import Products
                for metaType in Products.meta_types:
                    if metaType['name'] in self.allowedmetatypes:
                        result.append(metaType)
                return result

def __init__(self, id, title):
        self.__version__ = '1.0'
        self.id = id
        self.title = title

#constructors

ncallclone = DTMLFile('dtml/ncallclone',globals())
RuleForm = DTMLFile('CF/RuleForm',globals())

def ncl(self,id,title,REQUEST=None):

    """replicate FOLDER from the file system to ZODB """
    import string

    if hasattr(self,id):
       return ''' <p> <h4>Id %s already in use </h4>
                  <p> <p> please , select some other Id ''' %(id)
    surl = self.absolute_url()
    surl = surl + '/' + id
   
    self.manage_addgnoFolder(id,title)
    curr_folder = get_attr(self,id,'Attribute Err')

   
    """
    Below code adds Data, Objects,... folders to store the instances created by     a user and the System Objects and Object Types
    """
    addImage(curr_folder,'GnowsysLogo','www/Gnowsys.png')
    curr_folder.manage_addProperty('SiteTitle',title,'string')
    curr_folder._setObject('Data', gno('Data','Data'))
    curr_folder.Data._setObject('Objects', gno('Objects','Objects'))
    curr_folder.Data._setObject('ObjectType', gno('ObjectType','ObjectType'))
    curr_folder.Data._setObject('Associations', gno('Associations','Associations'))
    curr_folder.Data._setObject('AssociationTypes', gno('AssociationTypes','AssociationTypes'))
    curr_folder.Data._setObject('FacetTypes', gno('FacetTypes','FacetTypes'))
    curr_folder.Data._setObject('OccurrenceTypes', gno('OccurrenceTypes','OccurrenceTypes'))
    curr_folder.Data._setObject('Rules', gno('Rules','Rule Base'))
    curr_folder.Data._setObject('Views', gno('Views','Stored Views'))
    curr_folder.manage_addProperty('surl', surl, 'string')
    idt = self.absolute_url()+'/'+id+'/Data/'
    u = self.absolute_url()+'/'+id+'/Data/ObjectType/'
    u2 = self.absolute_url()+'/'+id+'/Data/Object/'

    curr_folder.Data.FacetTypes._setObject('Status',facettype('Status','Status','Status','lines','Status','Status','Status','Status'))

    curr_folder.Data.ObjectType._setObject('SystemObject',ObjectType('SystemObject','SystemObject',idt+'SystemObject','SystemObject','SystemObject','SystemObject',['Object'],['Object'],['SystemObject'],'This is a default ObjectType.',u+'SystemObject'))
    curr_folder.Data.ObjectType.SystemObject._updateProperty('Status','Private')
    curr_folder.Data.Objects._setObject('Default',Object('Default','Default Object','','Default Object','Default Object','',['SystemObject'],'','This Object is requred by the system please do not delete or add any data to this Object.',[],u2+'Default',u2+'Default'))

# check's File Is Working Or Not

#    file = 'C:\Program Files\Zope\lib\python\Products\Gnowsys\FoxDat\MEDIAR1.TXT'
#    text = ifdata(file)

#    dat = []
    
#    for er in text:        
#        if er!='ER':
#            dat.append(er)
#        else:
#            curr_folder.Data.Objects._setObject(dat[0],Object(dat[0],dat[1],'',dat[1],'','',['Role'],'',dat[2],[],u2+dat[0],u2+dat[0]))
#            dat = []
            
#    curr_folder.Data.Objects._setObject(dat[0],Object(dat[0],dat[1],'','','','',['Role'],'',dat[2],[],u2+dat[0],u2+dat[0]))         
    
    curr_folder.Data.ObjectType._setObject('Role',ObjectType('Role','Role',idt+'Role','Role','Role','Role',['Object'],['Object'],['Role'],'This is a default ObjectType.',u+'Role')) 
    curr_folder.Data.ObjectType.Role._updateProperty('Status','Private') 
    curr_folder.Data.ObjectType._setObject('Theme',ObjectType('Theme','Theme','','Theme','Theme','Theme',['Object'],['Object'],['Theme'],'This is a default ObjectType.',u+'Theme')) 
    curr_folder.Data.ObjectType.Theme._updateProperty('Status','Private')
    id1 = int(time())
    id2 = repr(id1)

    # for adding a Transparent Folder

    manage_addTransparentFolder(curr_folder,'Programs','Programs')
    curr_folder.manage_addUserFolder()    
    ex = curr_folder    
    curr_folder = curr_folder.Programs

    # for adding ZCatalog with apropriate Indexes and Metadata
    
    ex.manage_addProduct['ZCatalog'].manage_addZCatalog(id='Catalog',title='Catalog for the Product')

    zopeVersion = self.REQUEST['SERVER_SOFTWARE']
    zopeVersion = string.split(zopeVersion,'(').pop(1)

    if string.find(zopeVersion,'Zope 2.5') >= 0:
       ex.Catalog.manage_delIndex('id','FieldIndex')
       ex.Catalog.manage_delIndex('title','FieldIndex')
       ex.Catalog.manage_delIndex('meta_type','FieldIndex')
       ex.Catalog.manage_delIndex('bobobase_modification_time','FieldIndex')
       ex.Catalog.manage_delIndex('PrincipiaSearchSource','FieldIndex')
       ex.Catalog.manage_delIndex('path','TextIndex')
       ex.Catalog.manage_delColumn('id')
       ex.Catalog.manage_delColumn('title') 
       ex.Catalog.manage_delColumn('meta_type')
       ex.Catalog.manage_delColumn('bobobase_modification_time')
       ex.Catalog.manage_delColumn('summary')

    ex.Catalog.manage_addIndex('BaseName','TextIndex')
    ex.Catalog.manage_addIndex('TTList','TextIndex')
    ex.Catalog.manage_addIndex('DisplayName','TextIndex')
    ex.Catalog.manage_addIndex('SortName','TextIndex')
    ex.Catalog.manage_addIndex('ObjectTypes','TextIndex')
    ex.Catalog.manage_addIndex('AssociationType','TextIndex')
    ex.Catalog.manage_addIndex('FacetValue','TextIndex')
    ex.Catalog.manage_addIndex('Occurences','TextIndex')
    ex.Catalog.manage_addIndex('Scope','TextIndex')
    ex.Catalog.manage_addIndex('Path','TextIndex')
    
    ex.Catalog.manage_addColumn('BaseName') 
    ex.Catalog.manage_addColumn('Identity') 
    ex.Catalog.manage_addColumn('DisplayName') 
    ex.Catalog.manage_addColumn('SortName') 
    ex.Catalog.manage_addColumn('ObjectTypes')
    ex.Catalog.manage_addColumn('Description') 
    ex.Catalog.manage_addColumn('LObjects') 
    ex.Catalog.manage_addColumn('AssociationType') 
    ex.Catalog.manage_addColumn('RObjects') 
    ex.Catalog.manage_addColumn('Scope') 
    ex.Catalog.manage_addColumn('Path') 
    

    #end of ZCatalog
    
    #add a mailhost
    ex.manage_addProduct['MailHost'].manage_addMailHost(id='mailhost',title='Mail Host',smtp_host=REQUEST['SMTP_Host'],localhost='localhost',smtp_port=REQUEST['Port'],timeout=1.0,REQUEST=None) 

    #cloning all files from CF folder to the newinstance.
    #This method checks if the file is a DTML or a PythonScript and calls the
    #appropriate clone functions.

    tdir = Globals.package_home(globals())
    tdir = tdir + '/CF'
    t = os.listdir(tdir)
    for temp in t:
	tp = os.path.splitext(os.path.basename(temp))
        fp = os.path.join('CF',tp[0])
	if tp[1] == '.dtml':
		addDTML(curr_folder,tp[0],"Method",fp)
                
	if tp[1] == '.py':
		addPythonScript(curr_folder,tp[0],fp) 
    
    curr_folder.dtmlholder.manage_addProperty('list',[],'tokens') 
    return self.manage_main(self,REQUEST,update_menu=1)

def get_attr(base_obj,curr_obj,err):
    try:
        curr_folder = getattr(base_obj,curr_obj)
    except:
        return err
    return curr_folder

def addPythonScript(obj,id,file):
    f=open(file_path+'/'+file+'.py')     
    file=f.read()     
    f.close()     
    manage_addPythonScript(obj,id)
    obj._getOb(id).write(file)
    return getattr(obj,id)


def addDTML(obj,id,title,file):     
    f=open(file_path+'/'+file+'.dtml')     
    file=f.read()     
    f.close()     
    obj.manage_addDTMLMethod(id,title,file)     
    return getattr(obj,id)     
     
def addImage(obj,id,file):     
    f=open(file_path+'/'+file,'rb')     
    contents=f.read()     
    f.close()     
    title=''     
    tlen = len(contents)     
    new_id = obj.manage_addImage(id,contents,title=title)   
    img_obj = obj.__getitem__(new_id)  
    img_obj.content_type = 'image/gif'

def addZCatalog(obj,id,file):
    f=open(file_path+'/'+file)     
    file=f.read()     
    f.close()     
    manage_addZCatalog(obj,id)
    obj._getOb(id).write(file)
    return getattr(obj,id)     

def addParamToScript(self,ScriptName,Params):
    self.ZPythonScript_edit(Params)

InitializeClass(GNOWSYS)
