
#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the 
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
#  Boston, MA 02111-1307 USA.
#
######################################################################

#---------------------------------------------------------------------------------------------------
# This file defines class ObjectType, functions defines in this class are as follows.
# __init__( self, id, title, Identity, BaseName, DisplayName, SortName, Category, Scope, keywords, Description, ls ) - Constructor.
# appOT( self, REQUEST ) - Script used for updating occurences of a particular instance, this script is calles from DTML method occuredit
# intermedOT( self, RESPONSE, URL1, URL2, REQUEST=None) - ?????
# facetadd( self, REQUEST ) - Adds facets, is called from DTML method manage_Facetmainform.
# removefacet( self, REQUEST ) - ????
# facetscript( self, REQUEST ) - This script is used for updating a facet, this script is called from DTML method facetedit.
# ocadd( self, REQUEST=None) - Adds Occurences ( most probabely )
# remoccur( self, REQUEST=None) - This script removes specified occurence of a topic.
# OTremovelist( self, ul, objTT, REQUEST=None ) - ????
# ttdel( self, REQUEST, RESPONSE, URL1, URL2 ) - ???
# OTupdateunsel( self, REQUEST ) - ???????
# ---------Factory methods------------------
# manage_addnewObjecttypeForm = DTMLFile( 'dtml/addnewObjecttypeform', globals())
# manage_ addnewObjecttype( dispatcher, id, REQUEST=None ) - Add new object type objects
# addDTML( obj, id, title, file ) - Adds a file in systempath with .dtml extension.
#---------------------------------------------------------------------------------------------------

from Globals import Persistent
from OFS.ObjectManager import ObjectManager
from OFS.SimpleItem import Item
from OFS.PropertyManager import PropertyManager
from OFS.PropertySheets import PropertySheet
from OFS.FindSupport import FindSupport
from AccessControl.Role import RoleManager
from AccessControl import ClassSecurityInfo
from Globals import InitializeClass, DTMLFile
from Products.ZCatalog.CatalogAwareness import CatalogAware

import string, Globals

#   View_Sample = DTMLFile('dtml/sampleView',globals())
#   manage_occurencesPropertiesForms = DTMLFile('dtml/occurencespropertiesform',globals())

file_path = Globals.package_home(globals())

class ObjectType(ObjectManager,
                  PropertyManager,
                  RoleManager,
                  Item,
                  FindSupport,
                  CatalogAware):
    """Object type object implementation.

    Object Type objects are folders that can contain Object TYpe objects
    and other supporting objects.  They provide properties to all
    Objects and Object types in them.  They also provide
    support methods for displaying Object Types.
    """

    meta_type = "Object Type"

    # added a new property title, and set its value of BaseName (by Nagarjuna)
    _properties = (
        {'id':'Identity', 'type': 'string', 'mode': 'w'}, 
        {'id':'title', 'type': 'string', 'mode': 'w'},
        {'id':'BaseName', 'type': 'string', 'mode': 'w'},
        {'id':'DisplayName', 'type': 'string', 'mode': 'w'}, 
        {'id':'SortName', 'type': 'string', 'mode': 'w'}, 
        {'id':'Category', 'type': 'lines', 'mode': 'w'},
        {'id':'Scope', 'type': 'lines', 'mode': 'w'},
        {'id':'Description', 'type': 'text', 'mode': 'w'}, 
        {'id':'keywords','type':'lines','mode':'w'},
        #{'id':'Status','type':'boolean','mode':'w'}, 
 #Not needed
        #{'id':'Occurrences','type':'lines','mode':'w'},
#To be added as seperate Tab
        #{'id':'FacetValue','type':'lines','mode':'w'},
#To be added as seperate Tab
        {'id':'Path','type':'string','mode':'w'},
     )


    manage_options = (
        {'label': 'Contents', 'action': 'manage_main',},
	{'label': 'Facets','action': 'manage_FacetForm',},
#	{'label':'Occurences','action':'manage_occurencesPropertiesForms',}
        ) + PropertyManager.manage_options \

	
    def __init__(self,id,title,Identity,BaseName,DisplayName,SortName,Category,Scope,keywords,Description,ls):
        self.id=id
        self.title=title
        self.Identity=Identity
        self.BaseName=BaseName
        self.DisplayName=DisplayName
        self.SortName=SortName
        self.Category=Category
        self.Scope=Scope
        self.keywords=keywords
        self.Path=[]
        self.Path.append(ls)
        self.Description=Description
        #self.Status=1
        #self.Occurrences=[]
        #self.Occurrences.append(ls)
        #self.FacetValue=[]
        self.manage_addDTMLMethod('index_html',BaseName)
        self.manage_addDocument('content_dtml',BaseName)          
        self.content_dtml.manage_edit('<dtml-var BaseName>',BaseName,'content_dtml')
        self.index_html.manage_edit(' ',BaseName,'index_html')
	
	# add new property sheet called facets
	
	self.propertysheets.manage_addPropertySheet('Facets', 'Facets')
	Facets  = self.propertysheets.get('Facets')
        
	#photoconf.manage_addProperty('store', store, 'string')
        #photoconf.manage_addProperty('engine', engine, 'string')
	#photoconf.manage_addProperty('quality', quality, 'int')
        #photoconf.manage_addProperty('pregen', pregen, 'boolean')
        #photoconf.manage_addProperty('timeout', timeout, 'int')

#  manage_editPhoto = DTMLFile('dtml/editPhotoPropertiesForm',globals())
# manage_occurencesPropertiesForms = DTMLFile('dtml/occurencespropertiesform',globals())


    def appOT(self,REQUEST):
      """ 
         This script is used for updating the Occurrences
	 of a particular instance with the edited values
	 This script is called from the DTML Method occuredit
      """
      t=[]
      t=self.Occurrences
      tr4=[]
      tz=[]
      # tz stores the list that will finally be updated as Occurrences
      # property in the instance
      tz.append(t[0])
      tr=REQUEST['Occur']
      tr1=repr(tr)
      # repr function converts tr to a string format.
      # This is necessary because the first entry in Occurrences i.e.Local:..
      # should not be edited as it stores the path of the instance.Only other
      # occurrences should be allowed to be edited.Converting to a string 
      # helps in parsing.
      tr2=string.replace(tr1,"['","")
      tr3=string.replace(tr2,"\\r\\n']","")
      tr4=string.split(tr3,"\\r\\n")
      # Each line in occurrences usually ends in a \r\n which need to be 
      # removed before being passed to a list
      tz=tz+tr4
      # Add the Local element to the rest of the edited list
      self._updateProperty('Occurrences',tz)
      self.REQUEST.RESPONSE.redirect('OToccuredit')  
       
    def intermedOT(self,RESPONSE,URL1,URL2,REQUEST=None):
        """ """ 
        temp=REQUEST['BaseName']
        self.manage_changeProperties(REQUEST)
        self.Catalog.manage_catalogFoundItems(REQUEST,RESPONSE,URL1,URL2,['Object Type'])
        nm="ObjectType"
        REQUEST.set('newnm',nm)
	REQUEST.set('newid',temp)
	ur=self.absolute_url()
	REQUEST.RESPONSE.redirect(ur+'/replyedit?newid=%s&newnm=%s' % (temp,nm))
        return


    def facetadd(self,REQUEST):
        """
        This script is used for adding Facets
        to a particular instance. 
        This script is called from the DTML Method manage_Facetmainform
        """

        ft1=REQUEST['ft']
        facetval1=REQUEST['facetval']
        facet=ft1+':'+facetval1
        f1=[]
        f1=self.FacetValue
        f1.append(facet)
        self._updateProperty('FacetValue',f1)
        temp=REQUEST['facetval']
        nm="Facet"
        REQUEST.set('newnm',nm)
        REQUEST.set('newid',temp)
        self.REQUEST.RESPONSE.redirect('manage_Facetmainform')
        #ur=container.absolute_url()
        #self.REQUEST.RESPONSE.redirect(ur+'/replyadd?newid='+temp+'&newnm='+nm)
    
    def removefacet(self,REQUEST):
        """ """
        a=REQUEST['facetlist']
        b=self.FacetValue
        fac1=filter(lambda x,a=REQUEST['facetlist']: x not in a,b)
        self._updateProperty('FacetValue',fac1)
        REQUEST.RESPONSE.redirect('delfacets')

    def facetscript(self,REQUEST):
        """
        This script is used for updating the Facets
        of a particular instance with the edited values
        This script is called from the DTML Method facetedit
        """
        t=[]
        t=self.FacetValue
        tr4=[]
        tz=[]
        # tz stores the list that will  finally be updated as FacetValue property
        # in the instance
        tz.append(t[0])
        tr=REQUEST['fact']
        tr1=repr(tr)
        # repr function converts tr to a string format.
        tr2=string.replace(tr1,"['","")
        tr3=string.replace(tr2,"']","")
        tr4=string.split(tr3,"\\r\\n")
        # Each line in facets usually ends in a \r\n which need to be removed 
        # before being passed to a list
        tz=tr4
        # Add the Local element to the rest of the edited list
        self._updateProperty('FacetValue',tz)
        self.REQUEST.RESPONSE.redirect('manage_facetedit')


    def ocadd(self,REQUEST=None):
        """ """
        ot1=REQUEST['ot']
        oval1=REQUEST['oval']
	occ=ot1+':'+oval1
	l1=[]
	l1=self.Occurrences
	l1.append(occ)
	self._updateProperty('Occurrences',l1)
	REQUEST.RESPONSE.redirect('OToccurmain')
 
   
    def remoccur(self,REQUEST=None):
        """
        This script removes the specified occurrences of a topic.
        occlist contains the list of Occurrences to be deleted
        """
        a=REQUEST['occlist']
        b=self.Occurrences
        occ=filter(lambda x,a=REQUEST['occlist']: x not in a,b)
        #After subtracting the selected values of Occurrences to be deleted fro#m the original list, update the values in the Propertysheet
        self._updateProperty('Occurrences',occ)
        REQUEST.RESPONSE.redirect('occurdel')
       

    def OTremovelist(self,ul,objTT,REQUEST=None):
        """ """
        itbinit=ul
	itb2=string.replace(itbinit,"['","")
	itb3=string.replace(itb2,"']","")
	itb4=string.replace(itb3,"', '"," ")
	itbfin=[]
	itbfin=string.split(itb4," ")
	itafin=objTT
	nTT=filter(lambda x,itafin=objTT: x not in itafin,itbfin)
	self._updateProperty('Category',nTT)
	self.REQUEST.RESPONSE.redirect('OTmembership')

    def ttdel(self,REQUEST,RESPONSE,URL1,URL2):
        """Deletes the requested object """
	
        temp=REQUEST['BaseName']
	self.Data.ObjectType.manage_delObjects(REQUEST['id2'])
        self.Catalog.manage_catalogFoundItems(REQUEST,RESPONSE,URL1,URL2,['Object Type'])
        nm="ObjectType"
 	REQUEST.set('newnm',nm)
	REQUEST.set('newid',temp)
        REQUEST.RESPONSE.redirect(URL2+'/replydelete?newid='+temp+'&newnm='+nm)
 
    def OTupdateunsel(self,REQUEST):

         """ """
         list_of_ids=[]
         list_of_ids = self.Data.ObjectType.objectIds()
         b=[]
         b=self.Category
         a=list_of_ids
         oTT=filter(lambda x,b=self.Category: x not in b,a)
         return oTT 
    
#
# Factory methods
#
# 12/11/2002 Edited
#manage_facetsPropertiesForms = DTMLFile('file_path/dtml/facetspropertiesform',globals())
#manage_occurencesPropertiesForms  = DTMLFile('file_path/dtml/occurencespropertiesform',globals())
manage_addnewObjecttypeForm = DTMLFile('dtml/addnewObjecttypeform', globals())

def manage_addnewObjecttype(dispatcher, id, REQUEST=None):
    """Add New Object type object"""
    dest = dispatcher.Destination()
    title=REQUEST['BaseName']
    idt=dest.absolute_url() 
    u=idt+'/Data/ObjectType/'+REQUEST['id']
    idt=idt+'/Data/ObjectType/'+id
    Path=u
    ls='Local:'+idt
    dest.Data.ObjectType._setObject(id, ObjectType(id,title,REQUEST['Identity'],REQUEST['BaseName'],REQUEST['DisplayName'],REQUEST['SortName'],REQUEST['Category'],REQUEST['Scope'],REQUEST['keywords'],REQUEST['Description'],Path))
   
    dest.Data.ObjectType[id].reindex_object()

    temp=REQUEST['BaseName']
    nm="Object Type"
    REQUEST.set('newnm',nm)
    REQUEST.set('newid',temp)        

    if REQUEST is not None:
        try:    url=dispatcher.DestinationURL()
        except: url=REQUEST['URL1']
        REQUEST.RESPONSE.redirect(url+'/replyadd?newid=%s&newnm=%s' % (temp,nm))

    return id

def addDTML(obj,id,title,file):
    f=open(file_path+'/'+file+'.dtml')
InitializeClass(ObjectType)

