from Globals import Persistent
from OFS.ObjectManager import ObjectManager
from OFS.SimpleItem import Item
from OFS.PropertyManager import PropertyManager
from OFS.FindSupport import FindSupport
from AccessControl.Role import RoleManager
from AccessControl import ClassSecurityInfo
from Globals import InitializeClass, DTMLFile

class gnoFolder(ObjectManager,
                  PropertyManager,
                  RoleManager,
                  Item,
                  FindSupport):
    """gno Folder object implementation.

    gno Folder objects are folders that can contain subobjects
    and other supporting objects.  They provide properties to all
    Objects and other Object Types in them.  They also provide
    support methods for displaying Objects and Object Types.
    """

    meta_type = "Gno Folder"
   
    _properties = (
        {'id':'title', 'type': 'string', 'mode': 'w'},
        {'id':'image', 'type': 'selection', 'mode': 'wd', 'select_variable': 'image_select'},
        ) 

    manage_options = (
        {'label': 'Contents', 'action': 'manage_main'},
        {'label': 'View', 'action': ''},
        {'label': 'Properties', 'action': 'manage_propertiesForm'},         
        )

    allowedmetatypes = ('Gno Folder','Image','DTML Document','DTML Method','File','GNOWSYS','External Method','Folder','Mail Host','TinyTablePlus','Script (Python)','ZCatalog','Association','Association Type','Facet Type','Occurrence Type','Object','Object Type')

    def all_meta_types(self):
        
        if hasattr(self, 'allowedmetatypes'):
            result = []
            import Products
            for metaType in Products.meta_types:
                if metaType['name'] in self.allowedmetatypes:
                    result.append(metaType)
            return result
        else:
            return Products.meta_types
   
    def __init__(self, id, title):
        self.__version__ = '1.0'
        self.id = id
        self.title = title

#
# Factory methods
#

manage_addgnoFolderForm = DTMLFile('dtml/addgnofolderform', globals())

def manage_addgnoFolder(dispatcher, id, title, REQUEST=None):
    """Add gno Folder object"""
    
    dest = dispatcher.Destination()
    dest._setObject(id, gnoFolder(id, title))

    if REQUEST is not None:
        try:    url=dispatcher.DestinationURL()
        except: url=REQUEST['URL1']
        REQUEST.RESPONSE.redirect('%s/manage_main' % url)
    return id
    
InitializeClass(gnoFolder)
