#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the 
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
#  Boston, MA 02111-1307 USA.
######################################################################


from Globals import Persistent
from OFS.ObjectManager import ObjectManager
from OFS.SimpleItem import Item
from OFS.PropertyManager import PropertyManager
from OFS.FindSupport import FindSupport
from AccessControl.Role import RoleManager
from AccessControl import ClassSecurityInfo
from Globals import InitializeClass, DTMLFile
from Products.ZCatalog.CatalogAwareness import CatalogAware
import string

class Assoc(ObjectManager,
                  PropertyManager,
                  RoleManager,
                  Item,
                  FindSupport,
                  CatalogAware):
    """Association object implementation.
    """

    meta_type = "Association"

   
    _properties = (
        {'id':'LObjects', 'type': 'tokens', 'mode': 'w'},
        {'id':'AssociationType', 'type': 'tokens', 'mode': 'w'},
        {'id':'RObjects', 'type': 'tokens', 'mode': 'w'},
        {'id':'BaseNameA', 'type': 'string', 'mode': 'w'},
        ) 

    def __init__(self,id,LObjects,AssociationType,RObjects,BaseNameA):
     	self.id=id
	self.LObjects=LObjects
        self.AssociationType=AssociationType
        self.RObjects=RObjects
        self.BaseNameA=BaseNameA


    manage_options = (
        {'label': 'Contents', 'action': 'manage_main'},
        ) + PropertyManager.manage_options \

    def DelAsso(self,REQUEST,RESPONSE,URL1,URL2):
        """Deletes the object requested """

        temp=REQUEST['BaseNameA']
        RD = REQUEST['Mode']
        id = REQUEST['id1']
        self.Data.Associations.manage_delObjects(id)

        self.unindex_object()

        nm="Association"
        REQUEST.set('newnm',nm)
        REQUEST.set('newid',temp)
        
        if RD=='Edit':
            REQUEST.RESPONSE.redirect(URL2+'/EditForm')
        else:
            REQUEST.RESPONSE.redirect(URL2+'/replydelete?newid=%s&newnm=%s' % (temp,nm))
  

# changes are made on 9-12-2002 harsh

    def Intermed(self,REQUEST,RESPONSE,URL1,URL2):
        """Edits the object requested """

	lobj=[]
	temp11=repr(REQUEST['LObjects'])
	temp12=string.replace(temp11,"*","")
	temp13=string.replace(temp12,"['","")
	temp14=string.replace(temp13,"']","") 
	lobj.append(temp14)

	robj=[]
	temp21=repr(REQUEST['RObjects'])
	temp22=string.replace(temp21,"*","")
	temp23=string.replace(temp22,"['","")
	temp24=string.replace(temp23,"']","")
	robj.append(temp24)

	asstype = REQUEST['AssType']
	basename = temp14 +'_'+ asstype+'_'+ temp24
	id = string.strip(basename)    

	self._updateProperty('LObjects',lobj)
	self._updateProperty('AssociationType',asstype)
	self._updateProperty('RObjects',robj)
	self._updateProperty('BaseNameA',basename)

	self.reindex_object()
	nm="Association"
	REQUEST.set('newnm',nm)
	REQUEST.set('newid',basename)
	ur=self.absolute_url()

	REQUEST.RESPONSE.redirect(ur+'/replyedit?newid=%s&newnm=%s' % (basename,nm))
  
    def strconv(self,temp):
       """Converts tokens to strings """
       a=string.join(temp)
       return a

#
# Factory methods
#

manage_addnewAssocForm = DTMLFile('dtml/addnewassocform', globals())

# id parameter is removed on 3-12-02

def manage_addnewAssoc(dispatcher,REQUEST=None):
    """
    Add New Association object
    """
    dest = dispatcher.Destination()
    ur=dest.absolute_url()

    C = ''
    C = REQUEST['Constraint']   

    at=[]
    temp31=repr(REQUEST['AssType'])
    temp32=string.replace(temp31,"'","")
    temp33=string.replace(temp32,"'","")
    at.append(temp33)
    
    PATH = dispatcher.InstancePath + 'Remove'
    PATH = string.replace(PATH,'/Remove','')
    PATH = PATH + '/Data/Associations/'

    if C=='1':
        LObject = REQUEST['LObjects']

        robj=[]
        robj = REQUEST['RObjects']        
        for x in robj:
            RObject = []
            RObject.append(x)
            basename = LObject[0] +'_'+temp33+'_'+ x
            id = string.strip(basename)    
            id = string.replace(id,' ','')
            Path=ur+'/Data/Associations/'+id
            dest.Data.Associations._setObject(id,Assoc(id,LObject,at,RObject,basename))
            dest.Data.Associations[id].reindex_object()
	    ############This code catalogs the object.#################
            PATH = PATH + id
            objRef = dest.restrictedTraverse( PATH )
            objRef.index_object()
    else:
        if C=='2':
            RObject = REQUEST['RObjects']
    
            lobj=[]
            lobj = REQUEST['LObjects']        
            for x in lobj:
                LObject = []
                LObject.append(x)
                basename = x +'_'+temp33+'_'+ RObject[0]
                id = string.strip(basename)    
                id = string.replace(id,' ','')
                Path=ur+'/Data/Associations/'+id
                dest.Data.Associations._setObject(id,Assoc(id,LObject,at,RObject,basename))
		############This code catalogs the object.#################
		PATH = PATH + id
                objRef = dest.restrictedTraverse( PATH )
                objRef.index_object()
        else:
            RObject = REQUEST['RObjects']
            LObject = REQUEST['LObjects']
            basename = LObject[0] +'_'+temp33+'_'+ RObject[0]
            id = string.strip(basename)    
            id = string.replace(id,' ','')
            Path=ur+'/Data/Associations/'+id
            dest.Data.Associations._setObject(id,Assoc(id,LObject,at,RObject,basename))
	    ############This code catalogs the object.#################
            PATH = PATH + id
            objRef = dest.restrictedTraverse( PATH )
            objRef.index_object()

#    temp11=repr(REQUEST['LObjects'])
#    temp12=string.replace(temp11,"*","")
#    temp13=string.replace(temp12,"['","")
#    temp14=string.replace(temp13,"']","") 
#    lobj.append(temp14)

#    robj=[]
#    temp21=repr(REQUEST['RObjects'])
#    temp22=string.replace(temp21,"*","")
#    temp23=string.replace(temp22,"['","")
#    temp24=string.replace(temp23,"']","")
#    robj.append(temp24)   

    temp = 'Selected'
    nm="Associations"

    REQUEST.set('newnm',nm)
    REQUEST.set('newid',temp)

    if REQUEST is not None:
	try: url=dispatcher.DestinationURL()
        except: url=REQUEST['URL1']
        REQUEST.RESPONSE.redirect(url+'/replyadd?newid=%s&newnm=%s' % (temp,nm))

InitializeClass(Assoc)
