######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the 
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
#  Boston, MA 02111-1307 USA.
#
######################################################################

from xml.sax import make_parser
import xml.sax.handler
import string
import sys
import Products.PythonScripts, Globals
from Products.GNOWSYS.ObjectType import ObjectType
from Products.GNOWSYS.OccurrenceType import occurrencetype
from Products.GNOWSYS.AssociationType import AssocT
from Products.GNOWSYS.Object import Object
from Products.GNOWSYS.FacetType import facettype
from Products.GNOWSYS.Association import Assoc
from Products.PythonScripts.PythonScript import *
from Globals import InitializeClass, DTMLFile
from Globals import HTMLFile
from Globals import Persistent

import os



"A class to import XML topic maps data to the GNOWSYS data folder.__doc__"
gTopicTypeList=[]
gOccurrenceTypeList=[]
gAnAssocType={} #will have a structure of this form{id:' ',LRoles:' ',RRoles:' '}
gAssocTypeList=[] #will sore all the association types
gAssocTypeIDList=[] #to store only the ids of association Type which are stored in gAssocTypeList
gFacetTypeList=[]
gPSIList=['sort','display','object','objectType','association','associationType','occurrence','occurrenceType','facetType']

class InstanceHandler(xml.sax.handler.ContentHandler):
  
  inMap=0
  inTopic=0
  inInstance=0
  inOccurrence=0
  inRData=0
  inRRef=0
  inAssoc=0
  inOInstance=0 #in instance of topic occurrence
  inAInstance=0 #in instance of association occurrence
  inMember=0
  inRole=0
  memCount=0 #to keep track of whether it is left memeber or right member in association
  titlink=""
  oitlink=""
  aitlink=""
  def startElement(self, name, attrs):
    if name=="topicMap":
      self.inMap=1
    elif self.inMap:  
      if name=="topic":
        self.id=attrs.get("id","")
        self.inTopic=1
      elif self.inTopic:
        if name=="instanceOf" and self.inOccurrence==0:
          self.inInstance=1
        elif self.inInstance:
          if name=="topicRef":
            self.titlink=attrs.get("xlink:href","")
            self.titlink=string.replace(self.titlink,'#','')
            self.makeTopicInstanceList()
            self.inInstance=0
        elif name=="occurrence":
            self.inOccurrence=1
        elif self.inOccurrence:
          if name=="instanceOf":
            self.inOInstance=1
          elif self.inOInstance:
            if name=="topicRef":
              self.oitlink=attrs.get("xlink:href","")
              self.oitlink=string.replace(self.oitlink,'#','')
          elif name=="resourceData":
            self.inRData=1
            self.makeFacetInstanceList()
          elif name=="resourceRef":
            self.inRRef=1 
            self.makeOccurrenceInstanceList()
    
      elif name=="association":
        self.inAssoc=1
	self.memCount=0
      elif self.inAssoc:
        if name=="instanceOf":
          self.inAInstance=1
        elif self.inAInstance:
          self.aitlink=attrs.get("xlink:href","")
          self.aitlink=string.replace(self.aitlink,'#','')
          self.inAInstance=0 
        elif name=="member":
          self.memCount+=1;
          self.inMember=1
        elif self.inMember:
          if name=="roleSpec":
            self.inRole=1
          elif self.inRole:
            if name=="topicRef" or name=="subjectIndicatorRef":
              if self.memCount==1:
                self.amrtLeftlink=attrs.get("xlink:href","")
                self.amrtLeftlink=string.replace(self.amrtLeftlink,'#','')
              elif self.memCount==2:
                self.amrtRightlink=attrs.get("xlink:href","")
  		self.amrtRightlink=string.replace(self.amrtRightlink,'#','')      
  def endElement(self,name):
    if name=="occurrence":
      self.inOccurrence=0
    if name=="topic":
      self.inTopic=0
    if name=="association":
      self.inAssoc=0
      self.makeAssocInstanceList()
      self.aitlink=""
      self.amrtLeftlink=""
      self.amrtRightlink=""
    if name=="instanceOf":
      self.inInstance=0
      self.inOInstance=0
      self.inAInstance=0
    if name=="member":
      self.inMember=0
    if name=="roleSpec":
      self.inRole=0   
    if name=="topicMap":
      print "Topic Types:",gTopicTypeList
      print "Occurrence Types:",gOccurrenceTypeList
      print "Facet Types:",gFacetTypeList
      print "Association Types:",gAssocTypeList
      
  def makeTopicInstanceList(self):
    found=0
    if self.titlink in gPSIList:
      found=1
      self.changeInstanceList()
    for link in gTopicTypeList:
      if link==self.titlink:
        found=1
    if found==0:        
      gTopicTypeList.append(self.titlink)
      
  def makeOccurrenceInstanceList(self):
    found=0
    if self.oitlink<>"":
      for link in gOccurrenceTypeList:
        if link==self.oitlink:
          found=1
      if found==0:        
        gOccurrenceTypeList.append(self.oitlink)
    
  def makeFacetInstanceList(self):
    found=0
    if self.oitlink<>"":
      for link in gFacetTypeList:
        if link==self.oitlink:
          found=1
      if found==0:        
        gFacetTypeList.append(self.oitlink)
     
  def makeAssocInstanceList(self):
    found=0
    for link in gAssocTypeIDList:
      if link==self.aitlink:
        found=1
    if found==0:
      gAnAssocType={'id':self.aitlink,'LRoles':self.amrtLeftlink,'RRoles':self.amrtRightlink}        
      gAssocTypeList.append(gAnAssocType)
      gAssocTypeIDList.append(self.aitlink)
      
        
#the following function is used to make changes in the instancelist if required, say a particular id has gone into some wrong instancelist

  def changeInstanceList(self):
    self.id=string.strip(self.id)
    if self.titlink=='objectType':
      if self.id not in gTopicTypeList:
        gTopicTypeList.append(self.id)
    if self.titlink=='facetType':
      if self.id not in gFacetTypeList:
        gFacetTypeList.append(self.id)
      if self.id in gTopicTypeList:
        gTopicTypeList.remove(self.id)
      if self.id in gOccurrenceTypeList:
        gOccurrenceTypeList.remove(self.id)
    if self.titlink=='occurrenceType':
      if self.id not in gOccurrenceTypeList:
        gOccurrenceTypeList.append(self.id)
      if self.id in gTopicTypeList:
        gTopicTypeList.remove(self.id)
      if self.id in gFacetTypeList:
        gFacetTypeList.remove(self.id)
    if self.aitlink=='associationType':
      if self.id not in gAssocTypeIDList:
        gAssocTypeList.append(self.id)

    
class ImportHandler(xml.sax.handler.ContentHandler):
  
  "The following are the initialization for the data structures which are used to store data as the XTM document is parsed"
  inMap=0
  inTopic=0
  inBaseName=0
  inVariant=0
  inParam=0
  inVariantName=0
  anObject={}
  anObjectType={}
  anOccurrenceType={}
  anAssociation={}
  anAssociationType={}
  aFacetType={}
  objects=[]
  objectTypes=[]
  occurrenceTypes=[]
  associations=[]
  associationTypes=[]
  facetTypes=[]
  topicType=""
  inSubid=0
  inMember=0
  inOccurrence=0
  inInstance=0
  inVRData=0
  baseName=""
  sortName=""
  displayName=""
  templink=""
  tempOccDict={'id':'','value':''}
  "The following is the complete structure required to store the XTM data"

  XTMDict={'Objects':objects,'Object Types':objectTypes,'Association':associations,'Association Types':associationTypes,'Occurrence Types':occurrenceTypes,'Facet Types':facetTypes}

  #XTMDict={'objects':[{'id':'O1','basename':'Obj1'},{'id':'O2'}],'object types':[],'associations':[]}

  def checkType(self,flag="" ):
     
     if self.id in gAssocTypeIDList:
       print self.id
       self.topicType="anAssociationType"
     elif self.id in gTopicTypeList:
       self.topicType="anObjectType"
     elif self.id in gOccurrenceTypeList:
       self.topicType="anOccurrenceType"
     elif self.id in gFacetTypeList:
       self.topicType="aFacetType"
     elif flag=="association":
       self.topicType="anAssociation"
     else:
       self.topicType="anObject"
     print self.topicType                 
   
  def startElement(self, name, attrs):
    self.inBaseNameString=0
    if name=="topicMap":
      self.inMap=1
      self.titlink=[]  #for links in topic-instancOf-topicRef
      self.tislink=[]  #for links in topic-instancOf-subjectIndicatorRef
      self.tstlink=[]  #for links in topic-subjectIdentity-topicRef
      self.tsslink=[]  #for links in topic-subjectIdentity-subjectIndicator
      self.tsrlink=""  #for link  in topic-subjectIdentity-resourceRef
      self.toitlink=[] #for links in topic-occurrence-instanceOf-topicRef
      self.toislink=[] #for links in topic-occurrence-instanceOf-subjectIndicatorRef
      self.tbvptlink=[]#for links in topic-baseName-variant-parameters-topicRef
      self.tbvpslink=[]#for links in topic-baseName-variant-parameters-subjectIndicatorRef
      self.tbvrlink=[] #for links in topic-baseName-variantName-resourceRef
      self.aitlink=""  #for link  in association-instancOf-topicRef
      self.aislink=""  #for link  in association-instancOf-subjectIndicatorRef
      self.amrtLeftlink="" #for links in association-member-roleSpec-topicRef-LRole
      self.amrtRightlink="" #for links in association-member-roleSpec-topicRef-RRole
      self.amrslink="" #for links in association-member-roleSpec-subjectIndicatorRef
      self.amrLeftlink=[]  #for links in association-member-topicRef-LObject
      self.amrRightlink=[]  #for links in association-member-topicRef-RObject
      self.amtlink=[]  #for links in association-member-topicRef
      self.amslink=[]  #for links in association-member-subjectIndicatorRef
      self.inInstance=0
      self.gFacetlink=[]
      self.gOcclink=[]
      self.inRData=0
      self.tFacetlink=[]
      self.tOcclink=[]
      self.occRef=""
      self.oId="" 
    elif self.inMap:  
      if name=="topic":
        self.id=string.strip(attrs.get("id",""))
        self.inTopic=1
      elif self.inTopic:
        if name=="instanceOf" and self.inOccurrence==0:
          self.inInstance=1
        elif self.inInstance:
          if name=="topicRef":
            self.titlink.append(string.replace(attrs.get("xlink:href","") ,'#',''))
            self.inInstance=0
          elif name=="subjectIndicatorRef":
            self.tislink.append(string.replace(attrs.get("xlink:href",""),'#',''))
            self.inInstance=0
        elif name=="subjectIdentity":
          self.inSubid=1
        elif self.inSubid:
          if name=="resourceRef":
            self.tsrlink=attrs.get("xlink:href","") 
            self.tsrlink=string.replace(self.tsrlink,'#','')
          if name=="topicRef":
            self.tstlink.append(string.replace(attrs.get("xlink:href",""),'#',''))
          elif name=="subjectIndicatorRef":
            self.tsslink.append(string.replace(attrs.get("xlink:href",""),'#',''))
        elif name=="baseName":
          self.inBaseName=1
        elif self.inBaseName:
          if name=="baseNameString":
            self.inBaseNameString=1
          elif name=="variant":
            self.inVariant=1;
          elif self.inVariant:
            if name=="parameters":
              self.inParam=1
            elif self.inParam:
              if name=="topicRef":
                self.templink=attrs.get("xlink:href","")
                self.templink=string.replace(self.templink,'#','')
                self.tbvptlink.append(self.templink)
              elif name=="subjectIndicatorRef":
                self.templink=attrs.get("xlink:href","")
 		self.templink=string.replace(self.templink,'#','')
                self.tbvpslink.append(self.templink)
            elif name=="variantName":
              self.inVariantName=1
            elif self.inVariantName:
              if name=="resourceRef":
                self.tbvrlink=attrs.get("xlink:href","")
                self.tbvrlink=string.replace(self.tbvrlink,'#','')
                self.checkSortDisp() #checks if the resourceRef is for sortName or DisplayName
              elif name=="resourceData":
                self.inVRData=1
                
        elif name=="occurrence":
          self.inOccurrence=1
        elif self.inOccurrence:
          if name=="instanceOf":
            self.inOInstance=1
          elif self.inOInstance:
            print "4"
            if name=="topicRef":
              self.oId=attrs.get("xlink:href","")
              self.oId=string.replace(self.oId,'#','')
              self.tempOccDict={'id':self.oId,'value':'' }
              print "3",self.tempOccDict
              self.inOInstance=0
            elif name=="subjectIndicatorRef":
              self.oId=attrs.get("xlink:href","")
 	      self.oId=string.replace(self.oId,'#','')
              self.tempOccDict={'id':self.oId,value:''}
              self.topOrSub="sub"
              self.inOInstance=0
          elif name=="resourceData":
            self.inRData=1
            print "data",self.oId
          elif name=="resourceRef":
            self.occRef=attrs.get("xlink:href","")
            self.occRef=string.replace(self.occRef,'#','')
            self.tempOccDict['value']=self.occRef
            self.addPropertyLink()
        
      elif name=="association":
        self.memCount=0 #if its value is 1 then,left member and if 2, then right member
        self.inAssoc=1
        self.aid=attrs.get("id","")
      elif self.inAssoc:
        if name=="instanceOf":
          self.inAInstance=1
        elif self.inAInstance:
          if name=="topicRef":
            self.aitlink=attrs.get("xlink:href","")
            self.aitlink=string.replace(self.aitlink,'#','')
            self.inAInstance=0
          elif name=="subjectIndicatorRef":
            self.aislink=attrs.get("xlink:href","")
            self.aislink=string.replace(self.aislink,'#','')
            self.inAInstance=0
        elif name=="member":
          self.memCount+=1;
          self.inMember=1
        elif self.inMember:
          if name=="roleSpec":
            self.inRole=1
          elif self.inRole:
            if name=="topicRef" or name=="subjectIndicatorRef":
              if self.memCount==1:
                self.amrtLeftlink=attrs.get("xlink:href","")
                self.amrtLeftlink=string.replace(self.amrtLeftlink,'#','')
              elif self.memCount==2:
                self.amrtRightlink=attrs.get("xlink:href","")
                self.amrtRightlink=string.replace(self.amrtRightlink,'#','')
            #elif name=="subjectIndicatorRef":
             # if self.memCount==1:
              #  self.amrsLeftlink=attrs.get("xlink:href","")
              #if self.memCount==2:
              #  self.amrsRightlink=attrs.get("xlink:href","")
          elif name=="resourceRef" or name=="topicRef" or name=="subjectIndicatorRef":
            if self.memCount==1:
              self.amrLeftlink=attrs.get("xlink:href","")
              self.amrLeftlink=string.replace(self.amrLeftlink,'#','')
            if self.memCount==2:
              self.amrRightlink=attrs.get("xlink:href","")
              self.amrRightlink=string.replace(self.amrRightlink,'#','')
          #elif name=="topicRef":
           # self.amtlink.append(attrs.get("xlink:href",""))
          #elif name=="subjectIndicatorRef":
          #  self.amslink.append(attrs.get("xlink:href",""))
      elif name=="mergeMap":
        print name

  def characters(self, characters):
    if self.inBaseNameString:
      self.baseName= characters
    if self.inVRData:
      if string.find(self.templink,'sort')!=-1:
        self.sortName= characters
      if string.find(self.templink,'display')!=-1:
        self.displayName= characters
    if self.inRData:
      self.tempOccDict['value']=characters
      print characters
      print self.tempOccDict
      self.addPropertyLink()
      
  def endElement(self,name):

    if name=="instanceOf":
      self.inInstance=0
      self.inOInstance=0
    if name=="subjectIdentity":
      self.inSubid=0
    
    if name=="baseNameString":
      self.inBaseNameString=0

    if name=="variant":
      self.inVariant=0

    if name=="parameters":
      self.inParam=0

    if name=="variantName":
      self.inVariantName=0
      
    if name=="resourceData":
      self.inVRData=0
      self.inRData=0

    if name=="occurrence":
      self.occRef=""
      self.oId=""
    
    if name=="topic":
      if self.id not in gPSIList:
        self.checkType()
        if self.topicType=="anObjectType":
          if 'objectType' in self.titlink:
            self.titlink.remove('objectType')
          self.anObjectType={'id':self.id,'baseName':self.baseName,'sortName':self.sortName,'displayName':self.displayName,'instanceOf':self.titlink,'facets':self.tFacetlink,'occurrences':self.tOcclink}
          self.objectTypes.append(self.anObjectType)
        elif self.topicType=="anObject":
          if 'object' in self.titlink:
            self.titlink.remove('object')
          self.anObject={'id':self.id,'baseName':self.baseName,'sortName':self.sortName,'displayName':self.displayName,'instanceOf':self.titlink,'facets':self.tFacetlink,'occurrences':self.tOcclink}
          self.objects.append(self.anObject)
        elif self.topicType=="anAssociationType":
          self.getRoles() #to get the left and right roles from the gAssocTypeList
          self.anAssociationType={'id':self.id,'baseName':self.baseName,'sortName':self.sortName,'displayName':self.displayName,'LRoles':self.lRole,'RRoles':self.rRole}
          self.associationTypes.append(self.anAssociationType)
        elif self.topicType=="anOccurrenceType":
          self.anOccurrenceType={'id':self.id,'baseName':self.baseName,'sortName':self.sortName,'displayName':self.displayName}
          self.occurrenceTypes.append(self.anOccurrenceType)
        elif self.topicType=="aFacetType":
          self.aFacetType={'id':self.id,'baseName':self.baseName,'sortName':self.sortName,'displayName':self.displayName,}
          self.facetTypes.append(self.aFacetType)
        #print "the following are the objects",self.XTMDict
        print
       
        self.titlink=[]
        self.tislink=[]
        self.tbvrlink=[]
        self.inTopic=0
        self.inInstance=0
        self.inBaseName=0
        self.inOccurrence=0
        self.sortName=""
        self.displayName=""
        self.lRole=""
        self.rRole=""
        self.tempOccDict={}
        self.tFacetlink=[]
        self.tOcclink=[]
        
    if name=="occurrence":
      self.inOccurrence=0
      self.intoitlink=[]
      self.intoislink=[]
      self.oIsd=""
      self.tempOccDict={}
      
    if name=="association":
      self.checkType("association")
      
      if self.topicType=="anAssociation":
        if self.aid=="": #if the id doesn't exist, then generate one
          self.aid=string.replace(str(self.amrLeftlink),'#','')+'_'+string.replace(self.aitlink,'#','')+'_'+string.replace(str(self.amrRightlink),'#','')	
          print self.aid
        self.anAssociation={'id':self.aid,'instanceOf':self.aitlink,'LObjects':self.amrLeftlink,'RObjects':self.amrRightlink}
        self.associations.append(self.anAssociation)
      
      self.inAssoc=0
      self.inAInstance=0
      self.amrLeftLink=[]
      self.amrRightLink=[]
      self.aid=""
      

    if name=="roleSpec":
      self.inRole=0
 
    if name=="member":
      self.inMember=0

    if name=="topicMap":
      print "The whole dictionary is"
      for link in self.XTMDict.keys():
        print
        print link
        for tlink in self.XTMDict[link]:
          print tlink
      
      #filename=CLIENT_HOME+'/'+'importdict8.py'
      #filename='/tmp/importdict8.py'
      #f=open(filename, 'w')
      #id1=container.REQUEST.id()
      #f.write(id1)
      #f.write('XTMDict=')
      #f.write(str(self.XTMDict))
      #f.close()

    if name=="baseName":
      self.inBaseName=0
    
    gXTMDict=self.XTMDict


  def checkOccOrFacet(self):
    for link in self.toitlink:
      if link in gOccurrenceTypeList:
        self.value='Occ'
      elif link in gFacetTypeList:
        self.value='Facet'
    
  def checkSortDisp(self):
    if string.find(self.templink,'sort')!=-1:
      self.sortName=self.tbvrlink
    if string.find(self.templink,'display')!=-1:
      self.displayName= self.tbvrlink


  def getRoles(self):
    for link in gAssocTypeList:
      if link['id']==self.id:
       	self.lRole=link['LRoles']
        self.rRole=link['RRoles']

#this function adds to the occurrence or facet list with the actual value

  def addPropertyLink(self):
    if self.oId in gFacetTypeList:
      self.tFacetlink.append(self.tempOccDict)
      print "F",self.tFacetlink
    elif self.oId in gOccurrenceTypeList:
      self.tOcclink.append(self.tempOccDict)
    elif self.oId=="":
      print "1",self.tOcclink
      self.tempOccDict['id']='None'
      print "2",self.tOcclink
      self.tOcclink.append(self.tempOccDict)
      print "3",self.tOcclink    


#import sys

#from xml.sax import make_parser
#from testDict2 import ImportHandler
#from testDict2 import InstanceHandler
#file_path = Globals.package_home(globals())

def importTest(self,filename):
  ch1=InstanceHandler()
  saxparser1=make_parser()

  saxparser1.setContentHandler(ch1)
  
  #file_path=Globals.package_home(globals())

  #saxparser1.parse('/home/vartika/pyTest/'+filename)
  saxparser1.parse(filename)

  ch=ImportHandler()
  saxparser=make_parser()

  saxparser.setContentHandler(ch)
  
  #saxparser.parse('/home/vartika/pyTest/'+filename)
  saxparser.parse(filename)

  scr_id1=str(filename)
  ws = string.find(scr_id1,'\\')
  if ws!=-1:
    scr_idlist = scr_id1.split('\\')
  else:
    scr_idlist = scr_id1.split('/')
  scr_idlist.reverse()
  scr_id=scr_idlist[0]
  scr_id=string.replace(scr_id,'.','')
  #return ch.XTMDict
  manage_addPythonScript(self,scr_id)
  self._getOb(scr_id).write('XTMDict='+str(ch.XTMDict))
  #manage_addImportedObjectType(self,ch.XTMDict)
   
#def manage_addImportedObjectType(self,XTMDict):
  
  for link in ch.XTMDict.keys():
    if link=="Occurrence Types":
      addOccTypes(self,ch.XTMDict[link])
 
  for link in ch.XTMDict.keys():
    if link=="Facet Types":
      addFacetTypes(self,ch.XTMDict[link])

  for link in ch.XTMDict.keys():
    if link=="Object Types":
      addObjectTypes(self,ch.XTMDict[link])
    
  for link in ch.XTMDict.keys():
    if link=="Objects":
      addObjects(self,ch.XTMDict[link])
  
  for link in ch.XTMDict.keys():
    if link=="Association Types":
      addAssocT(self,ch.XTMDict[link])
  
  for link in ch.XTMDict.keys():
    if link=="Association":
      addAssociation(self,ch.XTMDict[link])
  

def addObjectTypes(self,OTList):
  Path = self.InstancePath
  Path = Path + 'Remove'
  Path = string.replace(Path,'/Remove','')
  for tlink in OTList:
        OTid=str(tlink['id'])
        OTid=string.replace(OTid,' ','')
        OTTitle=str(tlink['baseName'])
        OTIdentity=''
        OTDisplayName=str(tlink['displayName'])
        OTSortName=str(tlink['sortName'])
        OTInstanceList=tlink['instanceOf']
        OTScope=''
        OTkeywords=''
        descrFlag=0
        for occlink in tlink['occurrences']:
          if str(occlink['id'])=='Description':
              OTDescr=str(occlink['value'])
              descrFlag=1
        if descrFlag==0:
          OTDescr=''
        
        anOT=ObjectType(OTid,OTTitle,OTIdentity,OTTitle,OTDisplayName,OTSortName,OTInstanceList,OTScope,OTkeywords,OTDescr)
        if OTid not in('SystemObject','Role','Theme'):
          self.Data.ObjectType._setObject(OTid,anOT)
          addOccurrences(self,anOT,tlink)
          addFacets(self,anOT,tlink)
          RefPath = Path + '/Data/ObjectType/' + OTid
          Ref = self.restrictedTraverse(RefPath)          
          Ref.index_object()

def addOccTypes(self,OccTList):
  Path = self.InstancePath
  Path = Path + 'Remove'
  Path = string.replace(Path,'/Remove','')
  for tlink in OccTList:
    OccTid=str(tlink['id'])
    OccTid=string.replace(OccTid,' ','')
    OccTTitle=str(tlink['baseName'])
    OccTIdentity=''
    OccTDisplayName=str(tlink['displayName'])
    OccTSortName=str(tlink['sortName'])
    descrFlag=0
    #for occlink in tlink['occurrences']:
     # if str(occlink['id'])=='Description':
      #  OccTDescr=str(occlink['value'])
       #   descrFlag=1
    #if descrFlag==0:
    OccTDescr=''
        
    anOccT=occurrencetype(OccTid,OccTIdentity,OccTTitle,OccTDisplayName,OccTSortName,OccTDescr)
    self.Data.OccurrenceTypes._setObject(OccTid,anOccT)
    RefPath = Path + '/Data/OccurrenceTypes/' + OccTid
    Ref = self.restrictedTraverse(RefPath)
    Ref.index_object()
    
def addFacetTypes(self,FTList):
  Path = self.InstancePath
  Path = Path + 'Remove'
  Path = string.replace(Path,'/Remove','')
  for tlink in FTList:
    FTid=str(tlink['id'])
    FTid=string.replace(FTid,' ','')
    FTTitle=str(tlink['baseName'])
    FTIdentity=''
    FTDataType=''
    FTDisplayName=str(tlink['displayName'])
    FTSortName=str(tlink['sortName'])
    descrFlag=0
    #for occlink in tlink['occurrences']:
     # if str(occlink['id'])=='Description':
      #  OccTDescr=str(occlink['value'])
       #   descrFlag=1
    #if descrFlag==0:
    FTDescr=''
    
    if FTid!='Status':
      aFT=facettype(FTid,FTIdentity,FTTitle,FTDataType,FTDisplayName,FTSortName,FTDescr)
      self.Data.FacetTypes._setObject(FTid,aFT)
      RefPath = Path + '/Data/FacetTypes/' + FTid
      Ref = self.restrictedTraverse(RefPath)
      Ref.index_object()

def addAssocT(self,ATList):
  Path = self.InstancePath
  Path = Path + 'Remove'
  Path = string.replace(Path,'/Remove','')
  for tlink in ATList:
    #for attr in tlink.keys():
      #if attr=="id":
        ATid=str(tlink['id'])
	ATid=string.replace(ATid,' ','')
        ATTitle=str(tlink['baseName'])
        ATIdentity=''
        ATDisplayName=str(tlink['displayName'])
        ATSortName=str(tlink['sortName'])
	ATInverseName=''
        ATLRoles=tlink['LRoles']
        checkLRole="add"
        roleList=self.Data.ObjectType.objectIds()
        lroles=str(ATLRoles)
        if lroles not in roleList:
            checkLRole="not"
       
        checkRRole="add"
	ATRRoles=tlink['RRoles']
        rroles=str(ATRRoles)
        if rroles not in roleList:
            checkRRole="not"
                
        ATTrans=0
        ATSymmetric=0
        ATConstraint=0
        ATRigid = 0
        
        if checkLRole=="add" and checkRRole=="add":          
          anAT=AssocT(ATid,ATTitle,ATIdentity,ATDisplayName,ATSortName,ATInverseName,ATLRoles,ATRRoles,ATTrans,ATSymmetric,ATConstraint,ATTitle,ATRigid)
          self.Data.AssociationTypes._setObject(ATid,anAT)
          RefPath = Path + '/Data/AssociationTypes/' + ATid
          Ref = self.restrictedTraverse(RefPath)
          Ref.index_object()
         

def addObjects(self,ObjList):
  Path = self.InstancePath
  Path = Path + 'Remove'
  Path = string.replace(Path,'/Remove','')
  for tlink in ObjList:
    #for attr in tlink.keys():
      #if attr=="id":
        Objid=str(tlink['id'])
        Objid=string.replace(Objid,' ','')
        ObjTitle=str(tlink['baseName'])
        ObjIdentity=''
        ObjDisplayName=str(tlink['displayName'])
        ObjSortName=str(tlink['sortName'])
        ObjInstanceList=tlink['instanceOf']
        ObjScope=''
        Objkeywords=''
        descrFlag=0
        for occlink in tlink['occurrences']:
          if str(occlink['id'])=='Description':
              ObjDescr=str(occlink['value'])
              descrFlag=1
        if descrFlag==0:
          ObjDescr=''

        checkFlag="add"	  
        listOt=self.Data.ObjectType.objectIds()
        for objType in ObjInstanceList:
          objType1=str(objType)
          if objType1 not in listOt:
            checkFlag="not"
        
        if checkFlag=="add":
          
          anObj=Object(Objid,ObjTitle,ObjIdentity,ObjTitle,ObjDisplayName,ObjSortName,ObjInstanceList,ObjScope,ObjDescr,Objkeywords)
          if Objid !='Default':          
            self.Data.Objects._setObject(Objid,anObj)
	    addOccurrences(self,anObj,tlink)
            addFacets(self,anObj,tlink)
            RefPath = Path + '/Data/Objects/' + Objid
            Ref = self.restrictedTraverse(RefPath)            
            Ref.index_object()

def addAssociation(self,AssocList):
  Path = self.InstancePath
  Path = Path + 'Remove'
  Path = string.replace(Path,'/Remove','')
  for tlink in AssocList:
    #for attr in tlink.keys():
      #if attr=="id":
        Associd=str(tlink['id'])
	Associd=string.replace(Associd,' ','_')
        AssocTitle=Associd
        AssocLobj=tlink['LObjects']
	AssocRobj=tlink['RObjects']
        AssocType=tlink['instanceOf']

        listAt=self.Data.AssociationTypes.objectIds()
        checkFlag="add"
        Type=string.replace(str(AssocType),' ','_')
        if Type not in listAt:
            checkFlag="not"
        
        checkLobj="add"
        objList=self.Data.Objects.objectIds()
        Lobj=str(AssocLobj)
        if Lobj not in objList:
            checkLobj="not"
        
        checkRobj="add" 
        Robj=str(AssocRobj)
        if Robj not in objList:
            checkRobj="not"
        
        if checkFlag=="add" and checkLobj=="add" and checkRobj=="add":   
          anAssoc=Assoc(Associd,AssocLobj,AssocType,AssocRobj,AssocTitle)         
          self.Data.Associations._setObject(Associd,anAssoc)
          RefPath = Path + '/Data/Associations/' + Associd
          Ref = self.restrictedTraverse(RefPath)
          Ref.index_object()

def addOccurrences(self,anOT,tlink):        
  for occlink in tlink['occurrences']:
    OccType=str(occlink['id'])
    listOct=self.Data.OccurrenceTypes.objectIds()
    if OccType in listOct: #add the occurrence only if the Occurrence Type exists
      OccValue=str(occlink['value'])
      if OccType !='None':
        if anOT.hasProperty(OccType):
          exsistingoccurrences = []
          exsistingoccurrences = anOT.getProperty(OccType)
          exsistingoccurrences.append(OccValue)
          anOT._updateProperty(OccType,exsistingoccurrences)
        else:
          anOT.manage_addProperty(OccType,OccValue,'lines',REQUEST=None)
  anOT.reindex_object()
       
def addFacets(self,anOT,tlink):
  for ftlink in tlink['facets']:
    FtType=str(ftlink['id'])
    listFt=self.Data.FacetTypes.objectIds()
    if FtType in listFt:  #add the facet only if the Facet Type exists
      FtValue=str(ftlink['value'])
      if FtType !='None':
        if anOT.hasProperty(FtType):
          exsistingoccurrences = []
          exsistingoccurrences = anOT.getProperty(FtType)
          exsistingoccurrences.append(FtValue)
          anOT._updateProperty(FtType,exsistingoccurrences)
        else:
          anOT.manage_addProperty(FtType,FtValue,'lines',REQUEST=None)
  anOT.reindex_object()
