######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the 
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
#  Boston, MA 02111-1307 USA.
#
######################################################################

from string import replace, split
from Globals import Persistent
from OFS.ObjectManager import ObjectManager
from OFS.SimpleItem import Item
from OFS.PropertyManager import PropertyManager
from OFS.FindSupport import FindSupport
from AccessControl.Role import RoleManager
from AccessControl import ClassSecurityInfo
from Globals import InitializeClass, DTMLFile
from Products.PythonScripts.standard import url_quote
from Products.ZCatalog.CatalogAwareness import CatalogAware
from Products.ZCatalog.Catalog import Catalog

import string, Globals 

from Association import Assoc


file_path = Globals.package_home(globals())

def ocadd1(self,OccType,OccValue):
    """
        actually add occurrences.
    """
    if self.hasProperty(OccType):
        exsistingoccurrences = []
        exsistingoccurrences = self.getProperty(OccType)
        exsistingoccurrences.append(OccValue)
        self._updateProperty(OccType,exsistingoccurrences)
    else:
        self.manage_addProperty(OccType,OccValue,'lines',REQUEST=None)
    self.reindex_object()

def facetaddobj(self,ft,facetval,REQUEST):
      """
      This script is used for adding Facets
      """
      if self.hasProperty(ft) > 0:
             self._updateProperty(ft,facetval)	
	     self.reindex_object()
      else:
             #PATH = string.replace(self.surl,REQUEST['BASE0'],'')
	     #PATH = '/' + string.split( self.surl,'/').pop()
	     PATH = self.InstancePath + 'Remove'
	     PATH = string.replace(PATH,'/Remove','')
	     PATH = PATH + '/Data/FacetTypes/' + ft
	     facet = self.restrictedTraverse(PATH)
	     Type1 = ['float','int','long']
	     Type2 = ['boolean']
	     Type3 = ['lines','string','text','tokens','selection','multiple selection']

	     defFacetValue = facetval
	     if defFacetValue is not None:
                  facetDataType = facet.getProperty('datatype')
   	          self.manage_addProperty(ft, defFacetValue, facetDataType, REQUEST=None)
	     else:
        	     facetDataType = facet.getProperty('datatype')
                     if facetDataType in Type1:
                         defFacetValue = 0
                     elif facetDataType in Type2:
                         defFacetValue = 0
                     elif facetDataType in Type3:
                         defFacetValue = ''                 
                     self.manage_addProperty(ft,defFacetValue,facetDataType,REQUEST=None)
      self.reindex_object()

def rigidassociations(self,ObjectId,TOT,PATH):

    A = self.Data.Associations.objectIds()
    AT = self.Data.AssociationTypes.objectIds()
    
    PATH = self.InstancePath + 'Remove'
    PATH = string.replace(PATH,'/Remove','')

    OT = []
    LObjects = []
    RObjects = []
    AssociationType = []
                    
    for each in TOT:
        if each!='Role' and each!='Theme' and each!='SystemObject':
            OT.append(each)
    
    for eachATid in AT:
	
	ATPATH = PATH + '/Data/AssociationTypes/' + eachATid
	ATRef = self.restrictedTraverse( ATPATH )

        LRoles = ATRef.LRoles
        RRoles = ATRef.RRoles
        Rigid = ATRef.Rigid

        AssociationType = []
        AssociationType.append(eachATid)

        if Rigid==1:
            if LRoles[0] in OT:
                LObjects = []
                LObjects.append(ObjectId)
                for eachObjid in self.Catalog({'meta_type':'Object'}):
                    RObjects = []
                    if eachObjid.meta_type == 'Object':
                        if RRoles[0] in eachObjid.ObjectTypes:
                            RObjects.append(eachObjid.id)
                            BaseNameA = ObjectId + '_' + eachATid + '_' + eachObjid.id
                            Aid = string.strip(BaseNameA)    
                            Aid = string.replace(Aid,' ','')
                            if Aid not in A:
                                NewAssociation = Assoc(Aid,LObjects,AssociationType,RObjects,BaseNameA)
                                self.Data.Associations._setObject(Aid,NewAssociation)
				APATH = PATH + '/Data/Associations/' + Aid
				ARef = self.restrictedTraverse( APATH )
                                ARef.index_object()

            elif RRoles[0] in OT:
                RObjects = []
                RObjects.append(ObjectId)
                for eachObjid in self.Catalog({'meta_type':'Object'}):
                    LObjects = []
                    if eachObjid.meta_type == 'Object':
                        if LRoles[0] in eachObjid.ObjectTypes:
                            LObjects.append(eachObjid.id)
                            BaseNameA = eachObjid.id + '_' + eachATid + '_' +  ObjectId
                            Aid = string.strip(BaseNameA)    
                            Aid = string.replace(Aid,' ','')
                            if Aid not in A:
                                NewAssociation = Assoc(Aid,LObjects,AssociationType,RObjects,BaseNameA)
                                self.Data.Associations._setObject(Aid,NewAssociation)
				APATH = PATH + '/Data/Associations/' + Aid
				ARef = self.restrictedTraverse( APATH )
				ARef.index_object()                    


class Object(ObjectManager,
                  PropertyManager,
                  RoleManager,
                  Item,
                  FindSupport,
                  CatalogAware,
                  Catalog):
    """Object implementation.

    Object are container objects that can contain Objects
    and other supporting objects.  They also provide
    support methods for displaying Objects.
    """

    meta_type = "Object"

    _properties = (
      {'id':'title','type':'string','mode':'w'}, 
      {'id':'Identity','type':'string','mode':'w'},
      {'id':'BaseName','type':'string','mode':'w'},
      {'id':'DisplayName','type':'string','mode':'w'},
      {'id':'SortName','type':'string','mode':'w'},
      {'id':'ObjectTypes','type':'lines','mode':'w'},
      {'id':'Scope','type':'string','mode':'w'},
      {'id':'Description','type':'text','mode':'w'},
      {'id':'keywords','type':'lines','mode':'w'},
#      {'id':'Local','type':'lines','mode':'w'},
      {'id':'Status','type':'string','mode':'w'}, 
#      {'id':'Path','type':'string','mode':'w'},     
     ) 
     
    manage_options = (
        {'label': 'Contents', 'action': 'manage_main'},
        {'label': 'View', 'action': 'manage_deltopic'},
        {'label': 'Properties', 'action': 'manage_propertiesForm'},         
              
        ) 
          
          
    __ac_permissions__=(
        ('Manage Properties',('manage_addProperty',
                              'manage_editProperties',
                              'manage_delProperties',
                              'manage_changeProperties',
			      'Access content information')),
#         ('Delete Objects',('manage_delObjects)),
         )



    def __init__(self,id,title,Identity,BaseName,DisplayName,SortName,ObjectTypes,Scope,Description,keywords):
      self.id=id
      self.title=title
      self.Identity=Identity
      self.BaseName=BaseName
      self.DisplayName=DisplayName
      self.SortName=SortName
      self.ObjectTypes=ObjectTypes
      self.Scope=Scope
      self.Description=Description
      self.keywords=keywords
#      self.Path=Path
      self.Status='Public'
#      self.Local=[]
#      self.Local.append(ls)
      self.FacetValue=[]
      addDTML(self,'index_html',BaseName,'dtml/obj_index_html')
      self.manage_addDocument('content_dtml',BaseName)
      self.content_dtml.manage_edit('',BaseName,'content_dtml')
#      self.catalogDefaultObjects()

#####################################################
#This function was an attempt to catalog the default
#objects and Object Types but it doesn't seem to get
#what is absolute_url() hence not being used.
#####################################################

#    def catalogDefaultObjects(self):
#	""" """
#	PATH = string.replace( self.absolute_url(), REQUEST['BASE0'], '' )
#	objectType = self.restrictedTraverse( PATH + '/Data/ObjectTypes/' + 'SystemObject' )
#	objectType.index_object()
#	objectType = dsipatcher.restrictedTraverse( PATH + '/Data/ObjectTypes/' + 'Role' )
#	objectType.index_object()
#	objectType = self.restrictedTraverse( PATH + '/Data/ObjectTypes/' + 'Theme' )
#	objectType.index_object()
#	object = self.restrictedTraverse( PATH + '/Data/Objects/' + 'Default' )
#	object.index_object()

    def statadd(self,a,b):
        """
        """
        c=a+b
        print c
        return c
  
    def rlist(self,ul,objTT):
	"""
        This script is used for updating the values of the ObjectTypes after editing.
        """   
        #ul contains the list of the ObjectTypes to which the instance belongs

        abinit=ul
	b2=string.replace(abinit,"['","")
        b3=string.replace(b2,"']","")
	b4=string.replace(b3,"', '"," ")
	bfin=[]
	bfin=string.split(b4," ")

        #objTT contains the list of those ObjectTypes that have to be removed from the list of ObjectTypes to which the Object belongs.

	afin=[]
	afin=objTT
	nTT=filter(lambda x,afin=objTT: x not in afin,bfin)
	self._updateProperty('ObjectTypes',nTT)
	self.reindex_object()
	return      

       
    def Objectdel1(self,REQUEST,RESPONSE,URL1,URL2):
       """Deletes the requested object """

       temp=REQUEST['BaseName']
       self.Data.Objects.manage_delObjects(REQUEST['id1'])
       ########## Catalog ############
       self.unindex_object()
       #self.Catalog.manage_catalogFoundItems(REQUEST,RESPONSE,URL1,URL2,['Object'])
       nm="Object"
       REQUEST.set('newnm',nm)
       REQUEST.set('newid',temp)

       dobj=REQUEST['valobj']
       if dobj == 'dconc':
         tfnm2='/Bdelete'
       elif dobj == 'dexp':
         tfnm2='/Bdelete'
       elif dobj == 'dques':
         tfnm2='/Bdelete'
      
       else:
         tfnm2='/bkbdocdel'
       REQUEST.RESPONSE.redirect(URL2+tfnm2 + '?newid=%s&newnm=%s' % (temp,nm))



      # REQUEST.RESPONSE.redirect(URL2+'/replydelete?newid=%s&newnm=%s' % (temp,nm))

   
    def intermed(self,REQUEST,RESPONSE,URL1,URL2):
       """Edits the requested object """

       temp=REQUEST['BaseName']
       if len(temp)==0:
	  temp=REQUEST['id']

       self.manage_changeProperties(REQUEST)
       ################ Catalog ################
       self.reindex_object() 
       #self.Catalog.manage_catalogFoundItems(REQUEST,RESPONSE,URL1,URL2,['Object'])
       nm="Object"
       REQUEST.set('newnm',nm)
       REQUEST.set('newid',temp)
       ur=self.absolute_url()
       REQUEST.RESPONSE.redirect(ur+'/replyedit?newid=%s&newnm=%s' % (temp,nm))
 

    def app(self,REQUEST):
      """ 
         This script is used for updating the Occurrences
	 of a particular instance with the edited values
	 This script is called from the DTML Method occuredit
	"""
      avlocctypes = self.Data.OccurrenceTypes.objectIds()
      propertyids = self.propertyIds()
      for x in avlocctypes:
	if x in propertyids:
		NewValues = REQUEST[x]
		self._updateProperty(x,NewValues)
      self.reindex_object()
      self.REQUEST.RESPONSE.redirect('manage_occuredit')  

    def facetadd(self,REQUEST):
      """
      This script is used for adding Facets
      to a particular instance. 
      This script is called from the DTML Method manage_Facetmainform

      Script was modified on 19/11/2002 facets now are added as properties
      to the object.
      """

      ft = REQUEST['ft']
      facetval = REQUEST['facetval']
      facetaddobj(self,ft,facetval,REQUEST)

      anewid=REQUEST['message1']

      filen = ''
      
      #anewid = anewid[0]

      if anewid == 'ok':
         filen = 'manage_Facetmainform'
         self.REQUEST.RESPONSE.redirect(filen)
      if anewid == 'notok':
         filen = 'manage_Facetmainformq'
	 self.REQUEST.RESPONSE.redirect(filen + '?newid=%s' %(REQUEST['newid'] ))

      if anewid == 'Pend':
         filen = 'Aconfirm_post' 
         self.REQUEST.RESPONSE.redirect(filen)

      if anewid == 'Pend1':
         filen = 'Author'
         self.REQUEST.RESPONSE.redirect(filen)

      if anewid == 'default-dpost':
         filen = 'Assodisplaypost'
         self.REQUEST.RESPONSE.redirect(filen)

      if anewid == 'default-dpre':
         filen = 'Assodisplaypre'
         self.REQUEST.RESPONSE.redirect(filen)

      if anewid == 'default-prop':
         filen = 'Achapter'
         self.REQUEST.RESPONSE.redirect(filen)


      #self.REQUEST.RESPONSE.redirect('manage_Facetmainform')
   
    def facetscript(self,REQUEST):
      """
      This script is used for updating the Facets
      of a particular instance with the edited values
      This script is called from the DTML Method facetedit
      """
      ft = REQUEST['ft']
      facetval = REQUEST['facetval']
      facetaddobj(self,ft,facetval,REQUEST)
      self.REQUEST.RESPONSE.redirect('manage_facetedit')

    def ocadd(self,REQUEST):
      """

      This script is used for adding occurrences to a particular instance. 
      This script is called from the manage_occurmain method
      """
      #Edited & changes made on 25-11-2002, now occurrences will be added as new property of that object.
      OccType=REQUEST['ot']
      # ot contains the Occurrence Type

      OccValue=REQUEST['oval']
      # oval contains the Occurrence value

      Redirect = REQUEST['RD']
      
      ocadd1(self,OccType,OccValue)

      if Redirect=='Add':
          self.REQUEST.RESPONSE.redirect('manage_occurmain')
      else:
          self.REQUEST.RESPONSE.redirect('manage_occuredit')

    def remoccur(self,REQUEST):
      """
      This script removes the specified occurrences of a topic.
      occlist contains the list of Occurrences to be deleted
      """
      #a=REQUEST['occlist']
      #b=self.Local
      #occ=filter(lambda x,a=REQUEST['occlist']: x not in a,b)
      #self._updateProperty('Local',occ)
      #Delete the property which is being used as occurrence.
      Occurrences = REQUEST['occlist']
      self.manage_delProperties(Occurrences)       
      self.reindex_object()
      REQUEST.RESPONSE.redirect('occurrencesdel')

    def removefacet(self,REQUEST):
      """ This will delete the property which is being used as facet."""
      #a=REQUEST['facetlist']
      #b=self.FacetValue
      #fac1=filter(lambda x,a=REQUEST['facetlist']: x not in a,b)
      #self._updateProperty('FacetValue',fac1)
      Facets = REQUEST['facetlist']
      self.manage_delProperties(Facets)
      self.reindex_object()
      REQUEST.RESPONSE.redirect('facetdels')
      
    def updateunsel(self,REQUEST):
      """ 
      This script returns the list of ObjectTypes which are not a part of the 
      object types of the selected Object
      """
      list_of_ids=[]
      list_of_ids = self.Data.ObjectType.objectIds()
      b=[]
      b=self.ObjectTypes
      a=list_of_ids
      oTT=filter(lambda x,b=self.ObjectTypes: x not in b,list_of_ids)
      return oTT

#
# Factory methods
#

manage_addnewObjectForm = DTMLFile('dtml/addnewObjectform', globals())

manage_deltopic = DTMLFile('dtml/delObject',globals())

def manage_addnewObject(dispatcher,id,REQUEST,RESPONSE,URL1,URL2):
    """Add New Object object"""

    id = string.replace(id,' ','')
    
    dest = dispatcher.Destination()
    idt=dest.absolute_url()
    title=REQUEST['BaseName']

    if len(title)==0:
       title = id

    ur=dest.absolute_url()
    u=ur+'/Data/Objects/'+id
#    Path=u
#    ls = u 
#    li=dest.Data.ObjectType.objectIds()

    formid = REQUEST['HTTP_REFERER']   
    req1 = string.split(formid,'?')
    req2=string.split(req1[0],'/')
    len3=len(req2)
    len4=len3-1
    t1=req2[len4]

    if t1=='zadding-users':
      st = REQUEST['a']
      st1 = str(st)
      c2=REQUEST['c1']
      d2=REQUEST['d1']
      e2=REQUEST['e1']
      f2=REQUEST['f1']
      g2=REQUEST['g1']
      h2=REQUEST['h1']
      i2=REQUEST['i1']
      j2=REQUEST['j1']
      k2=REQUEST['k1']

    
    kb=REQUEST['nam']
    #Qdef=REQUEST['ques']
    Lobj=[]
    Lobj=REQUEST['ObjectTypes']

# Following code is not required
#    if kb=='2':
#      Qdef=REQUEST['ques']
#      Lobj.append(Qdef)
#    if kb=='1':
#      Lobj.append('book')
#    if kb=='3':
#      Cdef=REQUEST['concept']
#      Lobj.append(Cdef)
#      s='book'
#      Lobj.append(s)
#    if kb=='5':
#      Edef=REQUEST['experiments']
#      Lobj.append(Edef)
# End of code 

    dest.Data.Objects._setObject(id, Object(id,title,REQUEST['Identity'],title,REQUEST['DisplayName'],REQUEST['SortName'],Lobj,REQUEST['Scope'],REQUEST['Description'],REQUEST['keywords']))

    
#    dest.Data.Objects._setObject(id, Object(id,title,REQUEST['Identity'],title,REQUEST['DisplayName'],REQUEST['SortName'],REQUEST['ObjectTypes'],REQUEST['Scope'],REQUEST['Description'],REQUEST['keywords']))

    #dest.Data.Objects[id].reindex_object()

#    PATH =  string.replace(dispatcher.surl, REQUEST['BASE0'],'')
    PATH = dispatcher.InstancePath + 'Remove'
    PATH = string.replace(PATH,'/Remove','')

    rigidassociations(dest,id,REQUEST['ObjectTypes'],PATH)

    ############This code catalogs the object.#################
    PATH = PATH + '/Data/Objects/' + id
    objRef = dest.restrictedTraverse( PATH )
    objRef.index_object()


    temp=id
    name=title
    nm="Object"
    REQUEST.set('newnm',nm)
    REQUEST.set('newid',temp)
    REQUEST.set('newname',name)

    kw=REQUEST['keywords']
    kw1=str(kw)
    
    
    


    #kb=REQUEST['nam']


    tfnm = ''

    if kb=='1':
    	tfnm = '/replyaddObject'
    if kb=='2':
        tfnm = '/manage_Facetmainformq' 
    if kb=='3':
        tfnm = '/replyaddObjectq'
    if kb=='4':
        tfnm = '/replyObjectlog'
    if kb=='5':
        tfnm = '/replyaddObjecte'
    if kb=='6':
        tfnm = '/zdefault-content'
       

    if REQUEST is not None:
        try:    url=dispatcher.DestinationURL()
        except: url=REQUEST['URL1']
        if t1=='zadding-users':
       	  REQUEST.RESPONSE.redirect(url+tfnm + '?newid=%s&newnm=%s&newname=%s&kw2=%s&st2=%s&c3=%s&d3=%s&e3=%s&f3=%s&g3=%s&h3=%s&i3=%s&j3=%s&k3=%s' % (temp,nm,name,kw1,st1,c2,d2,e2,f2,g2,h2,i2,j2,k2))
        else:
          REQUEST.RESPONSE.redirect(url+tfnm + '?newid=%s&newnm=%s&newname=%s&kw2=%s' % (temp,nm,name,kw1))



#    if REQUEST is not None:
#        try:    url=dispatcher.DestinationURL()
#        except: url=REQUEST['URL1']
#	REQUEST.RESPONSE.redirect(url+'/replyaddObject?newid=%s&newnm=%s&newname=%s' % (temp,nm,name))
        
    return id


def addDTML(obj,id,title,file):     
    f=open(file_path+'/'+file+'.dtml')     
    file=f.read()
    f.close()     
    obj.manage_addDTMLMethod(id,title,file)     
    return getattr(obj,id)     

InitializeClass(Object)