#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the 
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
#  Boston, MA 02111-1307 USA.
######################################################################

from Globals import Persistent
from OFS.ObjectManager import ObjectManager
from OFS.SimpleItem import Item
from OFS.PropertyManager import PropertyManager
from OFS.FindSupport import FindSupport
from AccessControl.Role import RoleManager
from AccessControl import ClassSecurityInfo
from Globals import InitializeClass, DTMLFile
from Products.ZCatalog.CatalogAwareness import CatalogAware
import string

class AssocT(ObjectManager,
                  PropertyManager,
                  RoleManager,
                  Item,
                  FindSupport,
                  CatalogAware):
    """Association Type impelementation

    """

    meta_type = "Association Type"

  
    _properties = (
        {'id':'Identity', 'type': 'string', 'mode': 'rw'},
        {'id':'DisplayName', 'type': 'string', 'mode': 'rw'},
        {'id':'SortName', 'type': 'string', 'mode': 'rw'},
        {'id':'InverseName', 'type': 'string', 'mode': 'rw'},
        {'id':'LRoles', 'type': 'lines', 'mode': 'rw'},
        {'id':'RRoles', 'type': 'lines', 'mode': 'rw'},
	{'id':'Transitive','type':'boolean','mode':'rw'},
	{'id':'Symmetric','type':'boolean','mode':'rw'},
	{'id':'Constraint','type':'int','mode':'rw'},        
        {'id':'BaseNameA', 'type': 'string', 'mode': 'rw'},
        {'id':'title', 'type': 'string', 'mode': 'rw'},
        {'id':'Rigid', 'type': 'boolean', 'mode': 'rw'},
      ) 

    def __init__(self,id,title,Identity,DisplayName,SortName,InverseName,LRoles,RRoles,Transitive,Symmetric,C,BaseNameA,R):
        self.id=id
        self.Identity=Identity
        self.DisplayName=DisplayName
        self.SortName=SortName
        self.InverseName=InverseName
        self.LRoles=LRoles
        self.RRoles=RRoles
	self.Transitive = Transitive
	self.Symmetric = Symmetric
	self.Constraint = C
        self.BaseNameA=BaseNameA  
	self.Rigid = R
     
    manage_options = (
        {'label': 'Contents', 'action': 'manage_main'},
        ) + PropertyManager.manage_options \
	  + Item.manage_options
    
    def Intermed(self,REQUEST,RESPONSE,URL1,URL2):
        """Edits the object requested """
        temp=REQUEST['BaseNameA']

        self._updateProperty('BaseNameA',temp)
        self._updateProperty('Identity',REQUEST['Identity'])
        self._updateProperty('DisplayName',REQUEST['DisplayName'])
        self._updateProperty('SortName',REQUEST['SortName'])
        self._updateProperty('LRoles',REQUEST['LRoles'])
        self._updateProperty('RRoles',REQUEST['RRoles'])
        
        relation = REQUEST['Relation']
        if relation == 'None':
        	Transitive = 0
        	Symmetric = 0
        elif relation == 'Transitive':
        	Transitive = 1
        	Symmetric = 0
        else:
        	Transitive = 0
        	Symmetric = 1

        constraint = REQUEST['Constraint']
        if constraint == 'Many-To-One':
            C = 2
        elif constraint == 'One-To-Many':
            C = 1
        else:
            C = 0

        rigid = REQUEST['Rigid']
        if rigid == 'Yes':
            R = 1
        else:
            R = 0

        self._updateProperty('Transitive',Transitive)
        self._updateProperty('Symmetric',Symmetric)
        self._updateProperty('Constraint',C)
        self._updateProperty('Rigid',R)
	
	self.reindex_object()
        nm="AssociationType"
	REQUEST.set('newnm',nm)
	REQUEST.set('newid',temp)
	ur=self.absolute_url()
	REQUEST.RESPONSE.redirect(ur+'/replyedit?newid=%s&newnm=%s' % (temp,nm))


    def DelAssot(self,REQUEST,RESPONSE,URL1,URL2):
        """Deletes the requested association """
        temp=REQUEST['BaseNameA']        
	self.Data.AssociationTypes.manage_delObjects(REQUEST['id2'])
	self.unindex_object()
        nm="AssociationType"
	REQUEST.set('newnm',nm)
	REQUEST.set('newid',temp)
	REQUEST.RESPONSE.redirect(URL2+'/replydelete?newid=%s&newnm=%s' % (temp,nm))
 
    def strconv(self,temp):
        """Converts tokens to strings """
        a=string.join(temp)
        return a

# Factory methods

manage_addnewAssocTForm = DTMLFile('dtml/addnewassoctform', globals())

def manage_addnewAssocT(dispatcher, id, REQUEST=None):
    """Add New AssociationType object"""

    dest = dispatcher.Destination()
    ur=dest.absolute_url()

    id = string.replace(id,' ','')
    
    Path=ur+'/Data/AssociationTypes/'+id

    relation = REQUEST['Relation']

    if relation == 'None':
	Transitive = 0
	Symmetric = 0
    elif relation == 'Transitive':
	Transitive = 1
	Symmetric = 0
    else:
	Transitive = 0
	Symmetric = 1

    constraint = REQUEST['Constraint']

    if constraint == 'Many-To-One':
	C = 2
    elif constraint == 'One-To-Many':
        C = 1
    else:
        C = 0

    rigid = REQUEST['Rigid']
    if rigid == 'Yes':
        R = 1
    else:
        R = 0
	
    id = string.replace(str(id),' ','_')
	
    basenamea = REQUEST['BaseNameA']
    if len(basenamea)==0:
       basenamea = REQUEST['id']

    dest.Data.AssociationTypes._setObject(id, AssocT(id,basenamea,REQUEST['Identity'],REQUEST['DisplayName'],REQUEST['SortName'],REQUEST['InverseName'],REQUEST['LRoles'],REQUEST['RRoles'],Transitive,Symmetric,C,basenamea,R))

    ############This code catalogs the object.#################
#    PATH = string.replace(dispatcher.surl, REQUEST['BASE0'],'')
    PATH = dispatcher.InstancePath + 'Remove'
    PATH = string.replace(PATH,'/Remove','')
    PATH = PATH + '/Data/AssociationTypes/' + id
    objRef = dest.restrictedTraverse( PATH )
    objRef.index_object()

    temp=basenamea
    nm="AssociationType"    
    REQUEST.set('newnm',nm)
    REQUEST.set('newid',temp)
    REQUEST.set('newname',basenamea)
       
    if REQUEST is not None:
        try:    url=dispatcher.DestinationURL()
        except: url=REQUEST['URL1']
        REQUEST.RESPONSE.redirect(url+'/replyadd?newid=%s&newnm=%s&newname=%s' % (temp,nm,basenamea))

InitializeClass(AssocT)