#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the 
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
#  Boston, MA 02111-1307 USA.
#
######################################################################


from Globals import Persistent
from OFS import DTMLMethod
from OFS.ObjectManager import ObjectManager
from OFS.SimpleItem import Item
from OFS.PropertyManager import PropertyManager
from OFS.PropertySheets import PropertySheet
from OFS.FindSupport import FindSupport
from AccessControl.Role import RoleManager
from AccessControl import ClassSecurityInfo
from Globals import InitializeClass, DTMLFile
from Products.ZCatalog.CatalogAwareness import CatalogAware
import Products.PythonScripts, Globals
import string

file_path = Globals.package_home(globals())


def facetaddobjtype(self,ft,facetval,REQUEST):
      """
      This script is used for adding Facets
      """
      if self.hasProperty(ft)>0:
             self._updateProperty(ft,facetval)	
	     self.reindex_object()
      else:
             #PATH = string.replace(self.surl,REQUEST['BASE0'],'') 
	     #PATH = '/' + string.split( self.surl,'/').pop()
	     PATH = self.InstancePath + 'Remove'
	     PATH = string.replace(PATH,'/Remove','')
	     PATH = PATH + '/Data/FacetTypes/' + ft
	     facet = self.restrictedTraverse(PATH)
	     Type1 = ['float','int','long']
	     Type2 = ['boolean']
	     Type3 = ['lines','string','text','tokens','selection','multiple selection']

	     defFacetValue = facetval
	     if defFacetValue is not None:
                  facetDataType = facet.getProperty('datatype')
   	          self.manage_addProperty(ft, defFacetValue, facetDataType, REQUEST=None)
	     else:
                facetDataType = facet.getProperty('datatype')
                if facetDataType in Type1:
                    defFacetValue = 0
                elif facetDataType in Type2:
                    defFacetValue = 0
                elif facetDataType in Type3:
                    defFacetValue = ''                
                self.manage_addProperty(ft,defFacetValue,facetDataType,REQUEST=None)
      self.reindex_object()


class ObjectType(ObjectManager,
                  PropertyManager,
                  RoleManager,
                  Item,
                  FindSupport,
                  CatalogAware):

    """Object type object implementation.

    Object Type objects are folders that can contain Object TYpe objects
    and other supporting objects.  They provide properties to all
    Objects and Object types in them.  They also provide
    support methods for displaying Object Types.
    """

    meta_type = "Object Type"

    # added a new property title, and set its value of BaseName (by Nagarjuna)

    _properties = (

        {'id':'Identity', 'type': 'string', 'mode': 'w'}, 
        {'id':'title', 'type': 'string', 'mode': 'w'},
        {'id':'BaseName', 'type': 'string', 'mode': 'w'},
        {'id':'DisplayName', 'type': 'string', 'mode': 'w'}, 
        {'id':'SortName', 'type': 'string', 'mode': 'w'}, 
        {'id':'TTList', 'type': 'lines', 'mode': 'w'},
        {'id':'Scope', 'type': 'lines', 'mode': 'w'},
        {'id':'Description', 'type': 'text', 'mode': 'w'}, 
        {'id':'keywords','type':'lines','mode':'w'},
        {'id':'Status','type':'string','mode':'w'},
#	{'id':'Local','type':'lines','mode':'w'},
#        {'id':'Path','type':'string','mode':'w'},
     )

    manage_options = (
        {'label': 'Contents', 'action': 'manage_main'},
        {'label': 'Facets', 'action': 'manage_FacetForm'},
        ) + PropertyManager.manage_options \
          + Item.manage_options         

    def __init__(self,id,title,Identity,BaseName,DisplayName,SortName,TTList,Scope,keywords,Description):
        self.id=id
        self.title=title
        self.Identity=Identity
        self.BaseName=BaseName
        self.DisplayName=DisplayName
        self.SortName=SortName
        self.TTList=TTList
        self.Scope=Scope
        self.keywords=keywords
#        self.Path=[]
#        self.Path.append(ls)
        self.Description=Description
        self.Status='Public'

#        self.Local=[]
#        self.Local.append(ls)
        addDTML(self,'index_html',BaseName,'dtml/objtype_index_html')

        self.manage_addDocument('content_dtml',BaseName)      
        self.content_dtml.manage_edit(' ',BaseName,'content_dtml')
	
    def appOT(self,REQUEST):
      	""" 
	 This script is used for updating the Occurrences
	 of a particular instance with the edited values
	 This script is called from the DTML Method occuredit
      	"""
      	avlocctypes = self.Data.OccurrenceTypes.objectIds()
      	propertyids = self.propertyIds()
      	for x in avlocctypes:
	   if x in propertyids:
		NewValues = REQUEST[x]
		self._updateProperty(x,NewValues)
	self.reindex_object()

       
    def intermedOT(self,RESPONSE,URL1,URL2,REQUEST=None):
        """This method is called while editing the Object Type """ 
        temp=REQUEST['BaseName']
	if len(temp) == 0:
	   temp = REQUEST['id']

        self.manage_changeProperties(REQUEST)
        self.reindex_object()
        nm="ObjectType"
        REQUEST.set('newnm',nm)
	REQUEST.set('newid',temp)
	ur=self.absolute_url()
	REQUEST.RESPONSE.redirect(ur+'/replyedit?newid=%s&newnm=%s' % (temp,nm))
        return

    def facetadd(self, REQUEST=None):
        """
	Edited on 18/11/2002 function changed so that now facets
	will be added as Properties only. - Shashank
        
	This script is used for adding Facets
        to a particular instance. 
        This script is called from the DTML Method manage_Facetmainform
        """

        ft = REQUEST['ft']
        facetval = REQUEST['facetval']
        facetaddobjtype(self,ft,facetval,REQUEST)
        
        anewid=REQUEST['newid']
        filen1 = ''
        if anewid == 'ok':
          filen1 = 'manage_Facetmainform'
          self.REQUEST.RESPONSE.redirect(filen1)
        if anewid == 'Pend':
          filen1 = 'Aconfirm_post'
          self.REQUEST.RESPONSE.redirect(filen1)
        if anewid == '':
          filen1 = 'OTFormq'
          self.REQUEST.RESPONSE.redirect(filen1)
             
        #L1 = ['ok']
        #if anewid in L1:
          #self.REQUEST.RESPONSE.redirect('manage_Facetmainform')
        #L2 = ['Pend']
        #if anewid in L2:

         # self.REQUEST.RESPONSE.redirect('Aconfirm_post')
        #elif anewid not in L2:
          #self.REQUEST.RESPONSE.redirect('OTFormq')
      

 
        

    def removefacet(self,REQUEST):
        """ This will remove the property which is being used as facet."""

        Facets = REQUEST['facetlist']
        self.manage_delProperties(Facets)
	self.reindex_object()
        REQUEST.RESPONSE.redirect('facetdels')

    def facetscript(self,REQUEST):
        """
        This script is used for updating the Facets
        of a particular instance with the edited values
        This script is called from the DTML Method facetedit
        """       
        ft = REQUEST['ft']
        facetval = REQUEST['facetval']
        facetaddobjtype(self,ft,facetval,REQUEST)
        self.REQUEST.RESPONSE.redirect('OTfacetedit')


    def ocadd(self,REQUEST=None):
        """ Adds or updates an occurence value """
        OccType=REQUEST['ot']
        OccValue=REQUEST['oval']

	if self.hasProperty(OccType):
		exsistingoccurrences = []
		exsistingoccurrences = self.getProperty(OccType)
		exsistingoccurrences.append(OccValue)
		self._updateProperty(OccType,exsistingoccurrences)
	else:
		self.manage_addProperty(OccType,OccValue,'lines',REQUEST=None)
     
        Redirect = REQUEST['RD']
      	self.reindex_object()
        if Redirect=='Add':
            self.REQUEST.RESPONSE.redirect('manage_occurmain')
        else:
            self.REQUEST.RESPONSE.redirect('OToccuredit')
 
    def remoccur(self,REQUEST=None):
        """
        This script removes the specified occurrences of a topic.
        occlist contains the list of Occurrences to be deleted
        """

        Occurrences = REQUEST['occlist']
        self.manage_delProperties(Occurrences)
	self.reindex_object()
        REQUEST.RESPONSE.redirect('occurrencesdel')
  

    def OTremovelist(self,ul,objTT,REQUEST=None):
        """Used for editing MEmbership of object types """
        itbinit=ul
	itb2=string.replace(itbinit,"['","")
	itb3=string.replace(itb2,"']","")
	itb4=string.replace(itb3,"', '"," ")
	itbfin=[]
	itbfin=string.split(itb4," ")
	itafin=objTT
	nTT=filter(lambda x,itafin=objTT: x not in itafin,itbfin)
	self._updateProperty('TTList',nTT)
	self.reindex_object()
	self.REQUEST.RESPONSE.redirect('OTmembership')

    def ttdel(self,REQUEST,RESPONSE,URL1,URL2):
        """Deletes the requested object """
	
        temp=REQUEST['BaseName']
	if len(temp)==0:
	   temp = REQUEST['id']

	self.Data.ObjectType.manage_delObjects(REQUEST['id2'])
	self.unindex_object()
        nm="ObjectType"
 	REQUEST.set('newnm',nm)
	REQUEST.set('newid',temp)
        ot=REQUEST['val1']
        if ot=='bdel':
          tfnm1 = '/Bdelete'
        else:
          tfnm1 ='/bkbdocdel'
        REQUEST.RESPONSE.redirect(URL2+tfnm1 + '?newid='+temp+'&newnm='+nm)


        #REQUEST.RESPONSE.redirect(URL2+'/replydelete?newid='+temp+'&newnm='+nm)
 
    def OTupdateunsel(self,REQUEST):

         """ """
         list_of_ids=[]
         list_of_ids = self.Data.ObjectType.objectIds()
         b=[]
         b=self.TTList
         a=list_of_ids
         oTT=filter(lambda x,b=self.TTList: x not in b,a)
         return oTT 
    
#
# Factory methods
#

manage_addnewObjecttypeForm = DTMLFile('dtml/addnewObjecttypeform', globals())

def manage_addnewObjecttype(dispatcher, id, REQUEST=None):
    """Add New Object type object"""
    dest = dispatcher.Destination()

    id = string.replace(id,' ','')

    title=REQUEST['BaseName']
    if len(title)==0:
	title = id

    idt=dest.absolute_url() 
    u=idt+'/Data/ObjectType/'+id
    idt=idt+'/Data/ObjectType/'+id
#    Path=u
#    ls=idt
    kb=REQUEST['nam']
    LobjType=[]
    LobjType=REQUEST['TTList']
    if kb=='3':
        LobjType.append('Lesson')


    dest.Data.ObjectType._setObject(id, ObjectType(id,title,REQUEST['Identity'],title,REQUEST['DisplayName'],REQUEST['SortName'],REQUEST['TTList'],REQUEST['Scope'],REQUEST['keywords'],REQUEST['Description']))
   
    #dest.Data.ObjectType[id].reindex_object()

    ############This code catalogs the object.#################
#    PATH = string.replace(dispatcher.surl, REQUEST['BASE0'],'')
    PATH = dispatcher.InstancePath + 'Remove'
    PATH = string.replace(PATH,'/Remove','')
    PATH = PATH + '/Data/ObjectType/' + id
    objRef = dest.restrictedTraverse( PATH )
    objRef.index_object()
    
    # this is to make any member category get a by default status
    if kb=='11':
        objRef._updateProperty('Status','authobj')
   

   
    temp=id
    name = title
    nm="Object Type"
    REQUEST.set('newnm',nm)
    REQUEST.set('newid',temp)        

    tfnm = ''
    
    if kb=='2':
        tfnm = '/replyaddObjectType'
    if kb=='11':
        tfnm = '/replyaddObjectType1'
    if kb=='3':
        tfnm = '/replyaddObjectType2'

    if REQUEST is not None:
        try:    url=dispatcher.DestinationURL()
        except: url=REQUEST['URL1']
        REQUEST.RESPONSE.redirect(url+tfnm + '?newid=%s&newname=%s' % (temp,name))
    
#    if REQUEST is not None:
#        try:    url=dispatcher.DestinationURL()
#        except: url=REQUEST['URL1']
#        REQUEST.RESPONSE.redirect(url+'/replyaddObjectType?newid=%s&newname=%s' % (temp,name))

    return id

def addDTML(obj,id,title,file):
	f=open(file_path+'/'+file+'.dtml')
	file=f.read()
	f.close()
	obj.manage_addDTMLMethod(id,title,file)
	return getattr(obj,id)

InitializeClass(ObjectType)
