#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the 
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
#  Boston, MA 02111-1307 USA.
######################################################################

from OFS.ObjectManager import ObjectManager
from OFS.SimpleItem import Item
from OFS.PropertyManager import PropertyManager
from OFS.FindSupport import FindSupport

from AccessControl.Role import RoleManager
from AccessControl import ClassSecurityInfo

from Globals import Persistent
from Globals import InitializeClass, DTMLFile

from Products.ZCatalog.CatalogAwareness import CatalogAware

import string

def validateSelected(Objects):
    Error = 'No'
    if '----------' in Objects:
        Error = 'Yes'

    return Error

class Assoc(ObjectManager,
                  PropertyManager,
                  RoleManager,
                  Item,
                  FindSupport,
                  CatalogAware):
    """
    Relation implementation.
    """
    meta_type = "GRelation"
   
    _properties = (
        {'id':'LObjects', 'type': 'lines', 'mode': 'w'},
        {'id':'RelationType', 'type': 'lines', 'mode': 'w'},
        {'id':'RObjects', 'type': 'lines', 'mode': 'w'},
        {'id':'BaseName', 'type': 'string', 'mode': 'w'},
        {'id':'Participant', 'type': 'string', 'mode': 'w'},
        {'id':'ParticipantType', 'type': 'string', 'mode': 'w'},        
        ) 

    def __init__(self,id,LObjects,RelationType,RObjects,BaseName,Participant,ParticipantType):
     	self.id=id
	self.LObjects=LObjects
        self.RelationType=RelationType
        self.RObjects=RObjects
        self.BaseName=BaseName
        self.Participant=Participant        
        self.ParticipantType=ParticipantType

    manage_options = (
        {'label': 'Contents', 'action': 'manage_main'},
        ) + PropertyManager.manage_options \
	  + Item.manage_options

    def DelAsso(self,REQUEST,RESPONSE,URL1,URL2):
        """
        Deletes the object requested
        """

        id = REQUEST['id']
        BaseName=REQUEST['BaseName']

        RD = REQUEST['Mode']

        oList = self.Data.Objects.objectIds('GObject')
        otList = self.Data.ObjectType.objectIds('GObject Type')

        for each in self.Catalog():
            if each.meta_type=='GRelation':
                if each.id==id:
                    for x in each.RObjects:
                        PATH = self.InstancePath + "Data/"
                        if x in oList:
                            PATH = PATH + "Objects/" + x
                            ref = self.restrictedTraverse( PATH )
                            rList = ref.getProperty( 'rRolePlayedIn' )
                            if id in rList:
                                rList.remove(id)
                                ref._updateProperty('rRolePlayedIn',rList)
                                ref.reindex_object()	                
                        elif x in otList:
                            PATH = PATH + "ObjectType/" + x
                            ref = self.restrictedTraverse( PATH )
                            rList = ref.getProperty( 'rRolePlayedIn' )
                            if id in rList:
                                rList.remove(id)
                                ref._updateProperty('rRolePlayedIn',rList)
                                ref.reindex_object()	    
                    for x in each.LObjects:
                        PATH = self.InstancePath + "Data/"
                        if x in oList:
                            PATH = PATH + "Objects/" + x
                            ref = self.restrictedTraverse( PATH )
                            rList = ref.getProperty( 'lRolePlayedIn' )
                            if id in rList:
                                rList.remove(id)
                                ref._updateProperty('lRolePlayedIn',rList)
                                ref.reindex_object()	                
                            elif x in otList:
                                PATH = PATH + "ObjectType/" + x
                                ref = self.restrictedTraverse( PATH )
                                rList = ref.getProperty( 'lRolePlayedIn' )
                                if id in rList:
                                    rList.remove(id)
                                    ref._updateProperty('lRolePlayedIn',rList)
                                    ref.reindex_object()	                

        self.Data.Relations.manage_delObjects(id)
        self.unindex_object()

        nm="Relation"

	REQUEST.set('newnm',nm)
        REQUEST.set('newid',BaseName)
        
        if RD=='Edit':
            REQUEST.RESPONSE.redirect(self.surl + '/EditForm')
        else:
            REQUEST.RESPONSE.redirect(self.surl + '/replydelete?newid=%s&newnm=%s' % (BaseName,nm))
  
    def strconv(self,temp):
       """
       Converts tokens to strings
       """
       a=string.join(temp)
       return a

# Factory methods

manage_addnewRelationForm = DTMLFile('dtml/addnewRelationform', globals())

def manage_addnewRelation(dispatcher,REQUEST=None):
    """
    Add New Relation object
    """
    dest = dispatcher.Destination()

    A=dest.Data.Relations.objectIds() 
               
    C = ''
    C = REQUEST['Constraint']   

    Participant = REQUEST['Participant']
    ParticipantType = REQUEST['ParticipantType']            

    at=[]
    temp31=repr(REQUEST['AssType'])
    temp32=string.replace(temp31,"'","")
    temp33=string.replace(temp32,"'","")
    at.append(temp33)
    
    PATH = dispatcher.InstancePath
    PATH = PATH + 'Data/Relations/'

    if C=='1':
        LObject = REQUEST['LObjects']
        if validateSelected(LObject)=='Yes':
            dest.REQUEST.RESPONSE.redirect(dest.surl + '/relationValidateError' )
            return

        robj=[]
        robj = REQUEST['RObjects']
        if validateSelected(robj)=='Yes':
            dest.REQUEST.RESPONSE.redirect(dest.surl + '/relationValidateError' )
            return
        
        for x in robj:
            RObject = []
            RObject.append(x)
            basename = LObject[0] +'_'+temp33+'_'+ x
            id = string.strip(basename)    
            id = string.replace(id,' ','')
	    
	    if id in  A:
		dest.REQUEST.RESPONSE.redirect(dest.surl + '/relationAlreadyExistsError')
	    else:
           	dest.Data.Relations._setObject(id,Assoc(id,LObject,at,RObject,basename,Participant,ParticipantType))
            	ARef = dest.restrictedTraverse( PATH + id )
            	ARef.index_object()  
    else:
        if C=='2':
            RObject = REQUEST['RObjects']
            if validateSelected(RObject)=='Yes':
                dest.REQUEST.RESPONSE.redirect(dest.surl + '/relationValidateError' )
                return
            lobj=[]
            lobj = REQUEST['LObjects']
            if validateSelected(lobj)=='Yes':
                dest.REQUEST.RESPONSE.redirect(dest.surl + '/relationValidateError' )
                return

            for x in lobj:
                LObject = []
                LObject.append(x)
                basename = x +'_'+temp33+'_'+ RObject[0]
                id = string.strip(basename)    
                id = string.replace(id,' ','')
                dest.Data.Relations._setObject(id,Assoc(id,LObject,at,RObject,basename,Participant,ParticipantType))
                ARef = dest.restrictedTraverse(PATH + id)
                ARef.index_object()  
        else:
            RObject = REQUEST['RObjects']
            if validateSelected(RObject)=='Yes':
                dest.REQUEST.RESPONSE.redirect(dest.surl + '/relationValidateError' )
                return
            LObject = REQUEST['LObjects']
            if validateSelected(LObject)=='Yes':
                dest.REQUEST.RESPONSE.redirect(dest.surl + '/relationValidateError' )
                return
            
            basename = LObject[0] +'_'+temp33+'_'+ RObject[0]
            id = string.strip(basename)    
            id = string.replace(id,' ','')

            dest.Data.Relations._setObject(id,Assoc(id,LObject,at,RObject,basename,Participant,ParticipantType))
            PATH = PATH + id
            ARef = dest.restrictedTraverse( PATH )
            ARef.index_object()

    ####################################################################
    #This code maintains relations counter on the instance
    instancePath = string.replace( dest.InstancePath + 'Remove', '/Remove', '' )
    instanceRef = dest.restrictedTraverse( instancePath )
    rCounter = instanceRef.getProperty( 'relations' )
    rCounter = rCounter + 1
    instanceRef._updateProperty('relations',rCounter)
    totalCounter = instanceRef.getProperty( 'total' )
    totalCounter = totalCounter + 1
    instanceRef._updateProperty('total',totalCounter)
    ####################################################################
    ####################################################################
    #This code maintains neighborhood information
    oList = dest.Data.Objects.objectIds('GObject')
    otList = dest.Data.ObjectType.objectIds('GObject Type')

    for x in RObject:
        PATH = dest.InstancePath + "Data/"
        if x in oList:
            PATH = PATH + "Objects/" + x
            ref = dest.restrictedTraverse( PATH )
            rList = ref.getProperty( 'rRolePlayedIn' )
            rList.append(id)#insert(len(rList), id)
            ref._updateProperty('rRolePlayedIn',rList)
	    ref.reindex_object()	                
        elif x in otList:
            PATH = PATH + "ObjectType/" + x
            ref = dest.restrictedTraverse( PATH )
            rList = ref.getProperty( 'rRolePlayedIn' )
            rList.append(id)#insert(len(rList), id)
            ref._updateProperty('rRolePlayedIn',rList)
	    ref.reindex_object()	    
    for x in LObject:
        PATH = dest.InstancePath + "Data/"
        if x in oList:
            PATH = PATH + "Objects/" + x
            ref = dest.restrictedTraverse( PATH )
            rList = ref.getProperty( 'lRolePlayedIn' )
            rList.append(id)#insert(len(rList), id)
            ref._updateProperty('lRolePlayedIn',rList)
	    ref.reindex_object()	                
        elif x in otList:
            PATH = PATH + "ObjectType/" + x
            ref = dest.restrictedTraverse( PATH )
            rList = ref.getProperty( 'lRolePlayedIn' )
            rList.append(id)#insert(len(rList), id)
            ref._updateProperty('lRolePlayedIn',rList)
	    ref.reindex_object()	                

    ####################################################################
    temp = 'Selected'
    nm="Relations"

    REQUEST.set('newnm',nm)
    REQUEST.set('newid',temp)

    REQUEST.RESPONSE.redirect(dest.surl + '/replyadd?newid=%s&newnm=%s' % (temp,nm))

InitializeClass(Assoc)
