#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the 
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
#  Boston, MA 02111-1307 USA.
######################################################################

from OFS.ObjectManager import ObjectManager
from OFS.SimpleItem import Item
from OFS.PropertyManager import PropertyManager
from OFS.FindSupport import FindSupport

from AccessControl.Role import RoleManager
from AccessControl import ClassSecurityInfo

from Globals import Persistent
from Globals import InitializeClass, DTMLFile

from Products.ZCatalog.CatalogAwareness import CatalogAware

from Products.GNOWSYS05.Relation import Assoc

import string

def necessaryAssocs(self,id, LRoles,RRoles,flag,OTFlag,PATH):
	A = self.Data.Relations.objectIds()
	AssocTid=[]
	AssocTid.append(id)

	if OTFlag=='True':
            Participant='ObjectTypes'
        else:
            Participant='Objects'						

	if flag=='OTO':
	        LObjects=[]
	        for eachObjid in self.Catalog({'meta_type':'GObject'}):
		     LObjects=[]	 
                     if eachObjid.meta_type == 'GObject':
                        if LRoles[0] in eachObjid.ObjectTypes:
                            LObjects.append(eachObjid.id)                            
                            BaseName = eachObjid.id + '_' + AssocTid[0] + '_' +RRoles[0]		      
                            Aid = string.strip(BaseName)
                            Aid = string.replace(Aid,' ','')
  		           
                            if Aid not in A:
	                      NewRelation = Assoc(Aid,LObjects,AssocTid,RRoles,BaseName,Participant,flag)
        	              self.Data.Relations._setObject(Aid,NewRelation)
                              APATH = PATH + 'Data/Relations/' + Aid
                              ARef = self.restrictedTraverse( APATH )
                              ARef.index_object()	

	if flag=='OOT':
	        for eachObjid in self.Catalog({'meta_type':'GObject'}):
	    	     RObjects=[] 
                     if eachObjid.meta_type == 'GObject':
                        if RRoles[0] in eachObjid.ObjectTypes:
                            RObjects.append(eachObjid.id)                            
                            BaseName = LRoles[0] + '_' + AssocTid[0] + '_' + eachObjid.id		      
                            Aid = string.strip(BaseName)
                            Aid = string.replace(Aid,' ','')
  		           
                            if Aid not in A:
	                      NewRelation = Assoc(Aid,LRoles,AssocTid,RObjects,BaseName,Participant,flag)
        	              self.Data.Relations._setObject(Aid,NewRelation)
                              APATH = PATH + 'Data/Relations/' + Aid
                              ARef = self.restrictedTraverse( APATH )
                              ARef.index_object()

class AssocT(ObjectManager,
                  PropertyManager,
                  RoleManager,
                  Item,
                  FindSupport,
                  CatalogAware):
    """
    Relation Type impelementation.
    """

    meta_type = "GRelation Type"

    _properties = (
        {'id':'BaseName', 'type': 'string', 'mode': 'rw'},
        {'id':'RelMetaType', 'type': 'lines', 'mode': 'rw'},
        {'id':'LRoles', 'type': 'lines', 'mode': 'rw'},
        {'id':'RRoles', 'type': 'lines', 'mode': 'rw'},
	{'id':'Reflexive','type':'string','mode':'rw'},
	{'id':'Transitive','type':'string','mode':'rw'},
	{'id':'Symmetric','type':'string','mode':'rw'},
	{'id':'Constraint','type':'int','mode':'rw'},        
        {'id':'Necessary', 'type': 'boolean', 'mode': 'rw'},
	{'id':'Flag','type':'string','mode':'rw'},
	{'id':'Altname','type':'string','mode':'rw'},
	{'id':'Inversename','type':'string','mode':'rw'},
	{'id':'OTFlag','type':'string','mode':'rw'},        
      ) 

    def __init__(self,id,BaseName,RelMetaType,LRoles,RRoles,Reflexive,Transitive,Symmetric,C,R,flag,Altname,Inversename,OTFlag):
        self.id=id
	self.BaseName=BaseName  
	self.RelMetaType=RelMetaType  
        self.LRoles=LRoles
        self.RRoles=RRoles
	self.Reflexive = Reflexive
	self.Transitive = Transitive
	self.Symmetric = Symmetric
	self.Constraint = C
	self.Necessary = R
	self.Flag = flag
	self.Altname = Altname
	self.Inversename = Inversename
	self.OTFlag = OTFlag        
     
    manage_options = (
        {'label': 'Contents', 'action': 'manage_main'},
        ) + PropertyManager.manage_options \
	  + Item.manage_options
    
    def editRelationType(self,REQUEST,RESPONSE,URL1,URL2):
        """
	Edits the object requested
	"""

	try:
		RelMetaType=REQUEST['RelMetaType']
		self._updateProperty('RelMetaType',RelMetaType)
	except:
		pass

        BaseName=REQUEST['BaseName']
        self._updateProperty('BaseName',BaseName)

        Inversename=REQUEST['Inversename']
        self._updateProperty('Inversename',Inversename)

        Altname=REQUEST['Altname']
        self._updateProperty('Altname',Altname)

        constraint = REQUEST['Constraint']
        if constraint == 'Many-To-One':
            C = 2
        elif constraint == 'One-To-Many':
            C = 1
        else:
            C = 0

        necessary= REQUEST['Necessary']
        if necessary== 'Yes':
            R = 1
        else:
            R = 0

        Reflexive = REQUEST['Reflexive']
        self._updateProperty('Reflexive',Reflexive)
        Symmetric = REQUEST['Symmetric']
        self._updateProperty('Symmetric',Symmetric)
        Transitive = REQUEST['Transitive']
        self._updateProperty('Transitive',Transitive)

        self._updateProperty('Constraint',C)
        self._updateProperty('Necessary',R)
	
	self.reindex_object()
        nm="RelationType"
	REQUEST.set('newnm',nm)
	REQUEST.set('newid',BaseName)

	REQUEST.RESPONSE.redirect(self.surl + '/replyedit?newid=%s&newnm=%s' % (BaseName,nm))
	    
    def deleteRelationType(self,REQUEST,RESPONSE,URL1,URL2):
        """
	Deletes the requested relation
	"""

	id = REQUEST['id']
        BaseName=REQUEST['BaseName']

	oList = self.Data.Objects.objectIds('GObject')
	otList = self.Data.ObjectType.objectIds('GObject Type')	

	for each in self.Catalog():
		if each.meta_type=='GRelation Type':
			if each.id==id:
				for x in each.RRoles:
					PATH = self.InstancePath + "Data/"
					if x in oList:
						PATH = PATH + "Objects/" + x
						ref = self.restrictedTraverse( PATH )
						rList = ref.getProperty( 'rRoleContainerIn' )
						if id in rList:
							rList.remove(id)
							ref._updateProperty('rRoleContainerIn',rList)
							ref.reindex_object()
					elif x in otList:
						PATH = PATH + "ObjectType/" + x
						ref = self.restrictedTraverse( PATH )
						rList = ref.getProperty( 'rRoleContainerIn' )
						if id in rList:
							rList.remove(id)#insert(len(rList), id)
							ref._updateProperty('rRoleContainerIn',rList)
							ref.reindex_object()			
				for x in each.LRoles:
					PATH = self.InstancePath + "Data/"
					if x in oList:
						PATH = PATH + "Objects/" + x
						ref = self.restrictedTraverse( PATH )
						rList = ref.getProperty( 'lRoleContainerIn' )
						if id in rList:
							rList.remove(id)
							ref._updateProperty(lRoleContainerIn,rList)
							ref.reindex_object()			
					elif x in otList:
						PATH = PATH + "ObjectType/" + x
						ref = self.restrictedTraverse( PATH )
						rList = ref.getProperty( 'lRoleContainerIn' )
						if id in rList:
							rList.remove(id) #insert(len(rList), id)
							ref._updateProperty('lRoleContainerIn',rList)
							ref.reindex_object()

	self.Data.RelationTypes.manage_delObjects(id)
	self.unindex_object()

        nm="RelationType"
	REQUEST.set('newnm',nm)
	REQUEST.set('newid',BaseName)
	REQUEST.RESPONSE.redirect(self.surl +'/replydelete?newid=%s&newnm=%s' % (BaseName,nm))
 
    def strconv(self,temp):
        """
	Converts tokens to strings
	"""
        a=string.join(temp)
        return a

# Factory methods

manage_addnewRelationTypeForm = DTMLFile('dtml/addnewRelationTypeform', globals())

def manage_addnewRelationType(dispatcher, id, REQUEST=None):
    """
    Add New RelationType
    """
    dest = dispatcher.Destination()

    id = string.replace(id,' ','')    
    constraint = REQUEST['Constraint']

    if constraint == 'Many-To-One':
	C = 2
    elif constraint == 'One-To-Many':
        C = 1
    elif constraint == 'Many-To-Many':
        C = 3    
    else:
        C = 0

    necessary= REQUEST['Necessary']
    if necessary== 'Yes':
        R = 1
    else:
        R = 0
	
    id = string.replace(str(id),' ','_')

    dummyflag = REQUEST['hassoctbtw']

    if dummyflag == '1':
	 flag = 'OOT' ##then default one-many##
	 C = 1
    elif dummyflag == '2':
	flag ='OTO' ##then default many-one##
	C = 2
    else :
	flag ='OTOT'  	

    BaseName = REQUEST['BaseName']
    RelMetaType=REQUEST['RelMetaType']
    if len(BaseName)==0:
       BaseName = REQUEST['id']	

    RRoles = REQUEST['RRoles']
    LRoles = REQUEST['LRoles']

    Reflexive = REQUEST['Reflexive']
    Symmetric = REQUEST['Symmetric']
    Transitive = REQUEST['Transitive']
    Altname = REQUEST['Altname']
    Inversename = REQUEST['Inversename']

# Checks wheather Object Types are allowed to participate in relations of this Relation Type or not.
    OTFlag = REQUEST['OTFlag']
    if OTFlag=='Yes':
        OTFlag='True'
    else:
        OTFlag='False'

    dest.Data.RelationTypes._setObject(id,AssocT(id,BaseName,RelMetaType,LRoles,RRoles,Reflexive,Transitive,Symmetric,C,R,flag,Altname,Inversename,OTFlag))

    ####################################################################
    #This code increments the association_type counter of the instance
    instancePath = string.replace( dest.InstancePath + 'Remove', '/Remove', '' )
    instanceRef = dest.restrictedTraverse( instancePath )
    rtCounter = instanceRef.getProperty( 'relation_types' )
    rtCounter = rtCounter + 1
    instanceRef._updateProperty('relation_types',rtCounter)
    totalCounter = instanceRef.getProperty( 'total' )
    totalCounter = totalCounter + 1
    instanceRef._updateProperty('total',totalCounter)
    
    ####################################################################
    ####################################################################
    #This code keeps the association_type property of the object type up to date.

    oList = dest.Data.Objects.objectIds('GObject')
    otList = dest.Data.ObjectType.objectIds('GObject Type')

    for x in RRoles:
        PATH = dest.InstancePath + "Data/"
        if x in oList:
            PATH = PATH + "Objects/" + x
            ref = dest.restrictedTraverse( PATH )
            rList = ref.getProperty( 'rRoleContainerIn' )
	    rList.append(id) #insert(len(rList), id)
            ref._updateProperty('rRoleContainerIn',rList)
	    ref.reindex_object()	    
        elif x in otList:
            PATH = PATH + "ObjectType/" + x
            ref = dest.restrictedTraverse( PATH )
            rList = ref.getProperty( 'rRoleContainerIn' )
	    rList.append(id)#insert(len(rList), id)
            ref._updateProperty('rRoleContainerIn',rList)
	    ref.reindex_object()	    	    
    for x in LRoles:
        PATH = dest.InstancePath + "Data/"
        if x in oList:
            PATH = PATH + "Objects/" + x
            ref = dest.restrictedTraverse( PATH )
            rList = ref.getProperty( 'lRoleContainerIn' )
	    rList.append(id)#insert(len(rList), id)
            ref._updateProperty('lRoleContainerIn',rList)
	    ref.reindex_object()	    	    
        elif x in otList:
            PATH = PATH + "ObjectType/" + x
            ref = dest.restrictedTraverse( PATH )
            rList = ref.getProperty( 'lRoleContainerIn' )
	    rList.append(id) #insert(len(rList), id)
            ref._updateProperty('lRoleContainerIn',rList)
	    ref.reindex_object()	    	    

    PATH = dispatcher.InstancePath
    ATPATH = PATH + 'Data/RelationTypes/' + id
    ATRef = dest.restrictedTraverse( ATPATH )
    ATRef.index_object()
    
    ####################################################################
# following method will be used if necessary property is true & RelationType is OT-O or O-OT.
    if necessary== 'Yes':
            necessaryAssocs(dest,id,LRoles,RRoles,flag,OTFlag,PATH)	    

    nm="RelationType"
    REQUEST.set('newnm',nm)
    REQUEST.set('newid',BaseName)
       
    REQUEST.RESPONSE.redirect(dest.surl + '/replyadd?newid=%s&newnm=%s' % (BaseName,nm))

InitializeClass(AssocT)
