#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the 
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
#  Boston, MA 02111-1307 USA.
#
######################################################################

from OFS import SimpleItem
from Globals import DTMLFile,InitializeClass
#from listing1 import *
import string
#from functiontype import *
#from flow import *
from GNOWSYS import *
class conditiontype(PropertyManager,SimpleItem):
        """adding a condition type"""
        
	meta_type = 'GCondition'
	
	manage_options = (
        	{'label': 'Properties', 'action': 'manage_propertiesForm',},
        	{'label': 'View', 'action': 'viewcond',},
        	)	
	
	_properties= (
        	{'id':'id', 'type':'string', 'mode':'r'},
        	{'id':'title', 'type':'string', 'mode':'r'},
		)

	def __init__(self,id,title):
		""" Initialising the condition type"""
		self.id=id
		self.title=title
		if self.id=='if' or self.id=='elif':
			self.manage_addProperty('input1','','string')
			self.manage_addProperty('oper','','string')
			self.manage_addProperty('input2','','string')
		elif self.id=='for':
			self.manage_addProperty('start','','string')
			self.manage_addProperty('stop','','string')
			self.manage_addProperty('step','','string')
			self.manage_addProperty('i','','string')	
		elif self.id=='while':
			self.manage_addProperty('input1','','string')
			self.manage_addProperty('oper','','string')
			self.manage_addProperty('input2','','string')
			self.manage_addProperty('step','','string')

        	
	def checkcond(self,REQUEST,RESPONSE=None):
		"""checks the condition"""
		self.surl=REQUEST['URL3']
		if self.__name__=='if' or self.__name__=='elif':
			input1=REQUEST.form['input1']
			input2=REQUEST.form['input2']
			oper=REQUEST.form['oper']
			con=compile(input1+oper+input2,'','eval')
			c=eval(con)
			REQUEST.set('evalres',str(c))
			RESPONSE.redirect(self.surl+'/FlowBase/'+REQUEST['objid']+'/execute?evalres=%s'%(str(c)))
		elif self.__name__=='for':
			start=REQUEST['start']
			stop=REQUEST['stop']
			step=REQUEST['step']
			i=REQUEST['i']
			REQUEST.set('start',start)
			REQUEST.set('stop',stop)
			REQUEST.set('step',step)
			REQUEST.set('i',i)
			RESPONSE.redirect(self.surl+'/FlowBase/'+REQUEST['objid']+'/execute?start=%s&stop=%s&step=%s&i=%s'%(start,stop,step,i))
			#return str(c)
		elif self.__name__=='while':
			input1=REQUEST['input1']
			input2=REQUEST['input2']
			oper=REQUEST['oper']
			step=REQUEST['step']
			REQUEST.set('input1',input1)
			REQUEST.set('input2',input2)
			REQUEST.set('oper',oper)
			REQUEST.set('step',step)
			RESPONSE.redirect(self.surl+'/FlowBase/'+REQUEST['objid']+'/execute?input1=%s&input2=%s&oper=%s&step=%s'%(input1,input2,oper,step))
		
	def callcondition(self,REQUEST,RESPONSE=None):
		""" Accept arguments """
		
		if REQUEST.has_key('condlist'):
			id=REQUEST['condlist']
		else:
			id=self.id
		REQUEST.set('cond',id)
		REQUEST.set('objid',REQUEST['objid'])
		#REQUEST.set('name',fs2)
		#REQUEST.set('arguments',str(k))
		#REQUEST.set('module',self.modulen)
               	REQUEST.set('item',REQUEST['item'])
        	REQUEST.set('result',REQUEST['result'])
		REQUEST.set('incon',REQUEST['incon'])
		return '<html><body>hi</body></html>'
		#RESPONSE.redirect('inputPage2?cond=%s&item=%s&result=%s&objid=%s&incon=%s'%(id,REQUEST['item'],REQUEST['result'],REQUEST['objid'],REQUEST['incon']))
		#return '<html><body>'+modulename+'<br>'+self.defline+'</body></html>'	
				
	#inputPage2=DTMLFile('pdtml/inputPage2',globals())
	viewcond=DTMLFile('pdtml/viewcond',globals())
	#selfuncon=DTMLFile('pdtml/selfuncon',globals())
	condPage=DTMLFile('pdtml/condPage',globals())
	#inputPage2=DTMLFile('pdtml/inputPage2',globals())

def manage_addcon(dispatcher,id,defline,doc,module,REQUEST=None):
    "Add a functiontype to a folder."
    dest=dispatcher.Destination()
    title=string.split(defline,'(')[0]
    idt=dest.absolute_url()
    #u=idt+'/Functions/'+id
    dest.Functions._setObject(id,functiontype(id,title,defline,doc,module))
    #return '<html><body> ID:'+id+'<br>Docstr'+doc+'<br>'+'</body></html>'
    if REQUEST is not None:
        return dispatcher.manage_main(dispatcher, REQUEST)

#manage_addfunctiontype=DTMLFile('www/manage_addfunctiontype',globals())

InitializeClass(conditiontype)
