#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the 
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
#  Boston, MA 02111-1307 USA.
#
######################################################################

from OFS import SimpleItem
from GNOWSYS import *
from Globals import DTMLFile,InitializeClass
from Products.GNOWSYS06.GNOWSYS import *
#from listing import *
import string
import fpformat
from conditiontype import *
#from fflow import *

class Flow(ObjectManager,
           PropertyManager,
           RoleManager,
           Item,
           FindSupport,
           ZCatalog,
	   SimpleItem):
        """adding a function type"""

        meta_type ='GFlow'

	_properties= (
        {'id':'id', 'type':'string', 'mode':'r'},
        {'id':'title', 'type':'string', 'mode':'r'},
        {'id':'countfunc', 'type':'int', 'mode':'r'},
        )	

        manage_options = (
 		{'label': 'Contents', 'action': 'manage_main'},
                {'label':'Edit','action':'editflow',},
		{'label': 'Properties', 'action': 'manage_propertiesForm'},
                {'label':'View','action':'getValues',},
		{'label':'Constraint','action':'rangenum',},
                )

        def __init__(self,id,title,livar,funobj):
                """ Initialising the function type"""
                self.id=id			#id of the flow object
                self.title=title		#title of the flow object
		self.FunObj=funobj		#The functions in a flow object
		temp=[]
		livar=string.replace(livar,"[",'')
		livar=string.replace(livar,"]",'')
		livar=string.replace(livar,"'","")
		for i in string.split(livar,',',-1):
			temp.append(i)
			
		self.livar=temp	
		for i in range(len(self.livar)):
			self.manage_addProperty(self.livar[i],'','string')
		#self.FunObj=[]			
		self.counter=0		
		self.url=''
		self.typ="complete"
		self.countfunc=len(self.FunObj)

	def callforinit(self,REQUEST,RESPONSE=None):
		""" Initailising the properties """
		msg="Error"
		self.modval=0
		modulename=''
		#phyurl = dest.getPhysicalPath()[1]
		phyurl = self.InstancePath
		try:
			path= phyurl +'PBase/FlowBase/'+self.title
			m=self.restrictedTraverse(path,default=None)
			s=m.propertyIds()
		except AttributeError,msg:
			return
		self.ids=m.ids	
		for j in range(len(s)):
			if s[j]!="id" and s[j]!="title" and s[j]!="countfunc":
				self.manage_addProperty(s[j],m.getProperty(s[j]),m.getPropertyType(s[j]))
		for i in self.propertyIds():
			if string.find(i,'_module_')!=-1:
        			modulename=self.getProperty(i)  
		if modulename=="maths" or modulename=="umaths" or modulename=="cmaths" or modulename=="Numeric":
                        self.url=REQUEST['URL3']+'/PBase/Functions/Math/'
                elif modulename=="string":
                        self.url=REQUEST['URL3']+'/PBase/Functions/String/'
                else:
                        self.url=REQUEST['URL3']+'/PBase/Functions/'
		REQUEST.set('newname',self.getProperty('id'))
		if REQUEST is not None:
        		url=REQUEST['URL1']
			vname='Flow'
			REQUEST.set('newid',vname)
        		RESPONSE.redirect(url+'/confirm?newname=%s&newid=%s' % (self.getProperty('id'),vname))
		#return self.manage_main(m,REQUEST)
	
	def __call__(self,*args):
		""" Flow function  """
		lival=[]
		if len(args)!=len(self.livar):
			return '<html><body>Number of given inputs does not match number of required inputs.<form action="index_html"><input type="submit" value="go to main page"></form></body></html>'
		for i in range(len(args)):
			lival.append(string.replace(args[i],' ',''))
		for i in range(len(self.livar)):
			self._updateProperty(self.livar[i],lival[i]) # Update/Set values of the variables 
		for i in self.propertyIds():	
			if string.find(i,'_Result')!=-1:
				self._updateProperty(i,'0')	#Initialises all the results to 0
		self.setprop()
		return str(self.Final_Result)  
		
	def editobject(self,REQUEST,RESPONSE=None):
		"Edits the flow object"
		funobj=string.replace(self.funobj,'|',',')
		REQUEST.set('FunctionObject',funobj)
		REQUEST.set('objid',self.__name__)
		# Redirect to interfun for going to the flowform page
                RESPONSE.redirect('interfun?FunctionObject=%s&objid=%s'%(funobj,self.__name__))

	def setprop(self,REQUEST=None,RESPONSE=None):
		""" Set the input values as properties"""
		if REQUEST is not None:
			lival=REQUEST.form['lival'] 			# Take the list of variables from the DTML page
			for i in range(len(self.livar)):
				self._updateProperty(self.livar[i],lival[i]) # Update/Set values of the variables 
			for i in self.propertyIds():	
				if string.find(i,'_Result')!=-1:
					self._updateProperty(i,'0')	#Initialises all the results to 0
		self.counter=0
		self.cnt=0
		self.k=0
		self.rmcnt=0
		self.newval=0
		self.funlist=[]
		self.forbit=0					# This bit is set if when a 'for' loop is in execution
		self.execfun=[]
		for i in range(len(self.ids)):
			self.execfun.append('ne')
		self.whilebit=0					# This bit is set if when a 'while' loop is in execution
		self.toexec=0					# This bit is set to indicate execute has to be called
		self.funlist.extend(self.FunObj)		# Initialise the funlist to the original list of function objects
		self.execute()
		#self._updateProperty('Final_Result',self.funlist)
		#return '<html><body><br><b>'+str(self.cnt)+str(self.funlist)+'<br>'+str(self.ids)+'<br>'+str(self.execfun)+':</b>'+str(self.Final_Result)+'<br>'+'<br>'+'</body></html>'
		#return str(self.funlist)
		if REQUEST is not None:
			REQUEST.set('result',self.Final_Result)
                	REQUEST.set('flid',self.id)
                	REQUEST.set('fltitle',self.title)
			RESPONSE.redirect('FlowResult?result=%s&flid=%s&fltitle=%s'%(self.Final_Result,self.id,self.title))
		else:
			return
		#return
		#try()
		#RESPONSE.redirect('execute')


	def execute(self,RESPONSE=None):
		"""execute the selected functions"""
		msg="Error!"
		FunObj=[]
		FunObj.extend(self.funlist)
		#return  '<html><body>'+str(self.funlist[self.counter])+str(self.counter)+'</body></html>'
		if self.counter<len(self.funlist):	#Check which function is to be executed
			#if self.funlist[self.counter]=="endfor":
				#return self.funlist[self.counter]
			if string.find(self.funlist[self.counter-1],'ifdonefalse')!=-1:
				self.cnt=self.cnt+self.rmcnt
				self.rmcnt=0
			if self.whilebit!=1 and self.forbit!=1:
				self.execfun[self.cnt]='e'
                              	self.cnt=self.cnt+1
			if string.find(self.funlist[self.counter-1],'if')!=-1 and string.find(self.funlist[self.counter-1],'endif')==-1 and string.find(self.funlist[self.counter-1],'elif')==-1:
				self.cnt=self.cnt+self.rmcnt
				self.rmcnt=0
			#return  '<html><body>'+str(self.funlist[self.counter])+str(self.counter)+'</body></html>'
			if self.funlist[self.counter]=="if" or self.funlist[self.counter]=="elif":
                                currid=self.ids[self.cnt-1]
				#return '<html><body>'+str(self.ids)+str(self.cnt)+str(self.rmcnt)+'<br>'+str(self.funlist)+str(self.counter)+str(self.k)+'</body></html>'
				currnum=int(string.split(currid,'_id_',1)[1])
				self.counter=self.counter+1
				in1=string.replace(currid,'_id_','_input1_')
				in2=string.replace(currid,'_id_','_input2_')
				op=string.replace(currid,'_id_','_oper_')
				input1=self.getProperty(in1)
				input2=self.getProperty(in2)
				cond=self.getProperty(op)
				input=[]
				try:
					for q in [input1,input2]:
						if q in self.propertyIds():
							input.append(self.getProperty(q))
						elif string.find(q,'Result')!=-1:
							for p in range(self.k):
								if string.find(q,str(p))!=-1:
									for i in self.propertyIds():
										if string.find(i,str(p))!=-1 and string.find(i,'_Result')!=-1:
											input.append(self.getProperty(i))
						else:
							input.append(q)
				except:
					return
				self.funlist[self.counter-1]=self.funlist[self.counter-1]+"done"
				FunObj[self.counter-1]=FunObj[self.counter-1]+"done"
				#return input[0]+cond+input[1]
				con=compile(input[0]+cond+input[1],'','eval')
        			c=eval(con)
				l=-1
				g=-1
				h=-1
				f=-1
				f1=-1
				try:
					f=self.funlist.index('ifdone')
				except: ValueError,msg
				try:
					f1=self.funlist.index('if')
				except: ValueError,msg
				try:
					g=self.funlist.index('elif')
				except: ValueError,msg
				try:
					h=self.funlist.index('else')	 
				except: ValueError,msg
				try:
					l=self.funlist.index('endif')
				except: ValueError,msg
  					
				if c==1:
					tempval=0
					if f1!=-1 and f1<l:   # if 'if' contains nested if loop
						pass
		
					elif l!=-1:	      # if endif present	
						if g!=-1:     # if elif present delete all fns following it	
							for q in range(g,l):
								if string.find(FunObj[q],'if')==-1 and FunObj[q]!='else':
									self.rmcnt=self.rmcnt+1 #rmcnt gives a count of all the functions deleted  and it is used to increment the cnt
								if string.find(FunObj[q],'elif')!=-1 or FunObj[q]=='else':
									tempval=tempval+1		  
								self.funlist.remove(FunObj[q])
								
						elif h!=-1:   # if else present delete all  fns following it
							for q in range(h,l):
								if string.find(FunObj[q],'if')==-1 and FunObj[q]!='else':
									self.rmcnt=self.rmcnt+1
								if string.find(FunObj[q],'elif')!=-1 or FunObj[q]=='else':
									tempval=tempval+1		  
								self.funlist.remove(FunObj[q])
							#return
					self.newval=self.rmcnt    # newval keeps count of all the fns deleted
					self.rmcnt=self.rmcnt+tempval
					#return '<html><body>'+str(self.funlist)+str(self.k)+str(self.rmcnt)+'</body></html>'	
				else:
					if f1==-1 and g==-1 and h==-1:   # if 'if' is not followed by elif/else
						if l!=-1:
							temp=0
							self.funlist[self.counter-1]=self.funlist[self.counter-1]+"false"
							for q in range(self.counter,l+1):
								if string.find(FunObj[q],'if')==-1:
									self.rmcnt=self.rmcnt+1
									temp=temp+1
								if string.find(FunObj[q],'endif')!=-1:
									self.rmcnt=self.rmcnt+1
								self.funlist.remove(FunObj[q])
							#self.counter=self.counter-1
							if self.counter<len(self.funlist): # if the 'if' function is followed by some other functions
								self.k=self.k+temp	
					elif f1!=-1 and f<l and f1<l:            # if 'if' is followed by a nested if-endif  
						for q in range(self.counter-1,l+1):
							if string.find(FunObj[q],'if')==-1 and FunObj[q]!='else' and FunObj[q]!='endif':
								self.rmcnt=self.rmcnt+1
								self.k=self.k+1
							self.funlist.remove(FunObj[q])
						self.counter=self.counter-1
						self.cnt=self.cnt+self.rmcnt
						#return			
					elif l!=-1:			# if 'endif' is present	
						if g!=-1:   		# if 'elif' is present
							for q in range(self.counter-1,g):
								if string.find(FunObj[q],'if')==-1 and FunObj[q]!='else':
									self.rmcnt=self.rmcnt+1
									self.k=self.k+1
								#if string.find(FunObj[q],'if')!=-1:
									#self.rmcnt=self.rmcnt+1
								self.funlist.remove(FunObj[q])
						if h!=-1 and f==-1 and self.funlist[self.counter-1]!="elif":  #if else is present and if nested if is not present
							for q in range(self.counter-1,h):
								if string.find(FunObj[q],'if')==-1 and FunObj[q]!='else':
									self.rmcnt=self.rmcnt+1
									self.k=self.k+1
								self.funlist.remove(FunObj[q])
						elif g==-1 and h!=-1:  # if elif absent and else present
							for q in range(self.counter-1,h):
								if string.find(FunObj[q],'if')==-1 and FunObj[q]!='else':
									self.rmcnt=self.rmcnt+1
									self.k=self.k+1
								self.funlist.remove(FunObj[q])
						#if self.funlist[self.counter-1]=="elifdone":
						self.counter=self.counter-1
				self.toexec=1
			elif self.funlist[self.counter]=="else": # if else condition is true in an if-endif construct then increment counter so that the next function can be executed and redirect to execute
				if 'ifdoney' in self.funlist or 'elifdoney' in self.funlist or 'elsedoney' in self.funlist:
					l=-1
					e=-1
					l=self.funlist.index('else')
					try:
						e=self.funlist.index('endif')
					except: ValueError,msg
					if e>l:
						for q in range(self.counter,e):
							#if string.find(FunObj[q],'if')
							self.rmcnt=self.rmcnt+1
							self.funlist.remove(FunObj[q])
				else:
					self.funlist[self.counter]=self.funlist[self.counter]+"done"
				self.counter=self.counter+1
				self.toexec=1
				#return
				#self.execute()
				#u=REQUEST['URL3']+'/FlowObjects/'+self.__name__+'/execute'
			elif self.funlist[self.counter]=="endif": # if 'endif' is encountered 
				#return '<html><body>'+str(self.funlist)+'<br>'+str(self.k)+'<br>'+str(self.cnt)+'<br>'+str(self.rmcnt)+'</body></html>'
				#if 'elifdone' in self.funlist: 
				#if self.counter+1<=len(self.funlist)-1: 
					#pass
				#if self.funlist[self.counter+1]=="endif":
					#self.k=self.k+1
				#self._updateProperty('Final_Result',str(self.cnt))
				Resifpresent=0;
				for each in self.propertyIds():
					if string.find(each,'Resultofif')!=-1:
						Resifpresent=1
						break
				if Resifpresent==1:
					for i in range(self.cnt-2,-1,-1):
						if string.find(self.ids[i],'if')!=-1 and string.find(self.ids[i],'elif')==-1:
							ival=string.split(self.ids[i],'_id_')[1]
							t=i
							break
				
					for j in range(self.cnt-2,t,-1):
						if self.execfun[j]=='e' and string.find(self.ids[j],'if')==-1:
							sm=self.ids[j]
							sm=string.replace(sm,'_id_','_Result_')
							tempname='Resultofif'+str(ival)
							if tempname in self.propertyIds():
								self._updateProperty('Resultofif'+str(ival),self.getProperty(sm))
								break
				
				ebit=-1
				if self.counter+1<=len(self.funlist)-1:   # Check whether there are more functions to continue after endifdone
					ebit=0
					if self.funlist[self.counter+1]=="endif":
						#self.k=self.k+1
						ebit=1			  # Indicates there is another endif to follow after this endif	
				
				if self.funlist[self.counter-1]=="endifdone": # Check whether the prev obj was endif too
					pass
				elif 'elsedone' in self.funlist and ebit!=1:  # If elsedone then k need not be incremented on encountering endif
					t=self.funlist.index('elsedone')
					self.funlist[t]=self.funlist[t]+"y"
				elif 'elifdone' in self.funlist: 
					#and ebit!=1:
					
					t=self.funlist.index('elifdone')
					self.funlist[t]=self.funlist[t]+"y"
					self.k=self.k+self.newval
					
				elif 'ifdone' in self.funlist:
					#and ebit!=1:  
					t=self.funlist.index('ifdone')
					self.funlist[t]=self.funlist[t]+"y"
					self.k=self.k+self.newval  # newval is added to k so that k points to the next function to be executed
					self.newval=0              # Reinitialise
					
					#return '<html><body>'+str(len(self.funlist))+'<br>'+str(self.k)+'<br>'+str(self.counter+1)+'<br>'+str(self.rmcnt)'</body></html>'
				else:
					if ebit!=0:
						self.k=self.k+1
				
				self.funlist[self.counter]=self.funlist[self.counter]+"done"
				self.counter=self.counter+1
				self.toexec=1
				#return
				#self.execute()
				#u=REQUEST['URL3']+'/FlowObjects/'+self.__name__+'/execute'
			elif self.funlist[self.counter]=="for":
				self.ForList=[]
				currid=self.ids[self.cnt-1]
				currnum=int(string.split(currid,'_id_',1)[1])
				self.inp1=string.replace(currid,'_id_','_start_')
				inp2=string.replace(currid,'_id_','_stop_')
				inp3=string.replace(currid,'_id_','_step_')
				self.inp4=string.replace(currid,'_id_','_i_')
				start=self.getProperty(self.inp1)
				stop=self.getProperty(inp2)
				step=self.getProperty(inp3)
				ival=self.getProperty(self.inp4)
				input=[]
				for q in [start,stop,step,ival]:
					if q in self.propertyIds():
						input.append(self.getProperty(q))
					elif string.find(str(q),'Result')!=-1:
						for p in range(self.k):
							if string.find(q,str(p))!=-1:
								for i in self.propertyIds():
									if string.find(i,str(p))!=-1 and string.find(i,'_Result')!=-1:
										input.append(self.getProperty(i))
					else:
						input.append(q)
				self.start=int(input[0])
				self.stop=int(input[1])
				self.step=int(input[2])
				self.ival=input[3]
				self.actualvalue=self.ival
				if self.ival=="start":
					self._updateProperty(self.inp4,self.start)
				fend=-1
				nextendfor=1
				for i in range(self.counter+1,len(self.funlist)):
					if self.funlist[i]=="for":
						nextendfor=nextendfor+1
					elif self.funlist[i]=="endfor":
						nextendfor=nextendfor-1
					elif nextendfor==0:
						break
					if self.funlist[i]!="endfor":
						self.ForList.append(0)
				self.counter=self.counter+1
				self.forbit=1
				self.toexec=1

			elif self.forbit==1:
				val=0	
				if self.start<=self.stop:
					k=0
					if self.actualvalue=="start":
						self._updateProperty(self.inp4,self.start)
					for i in range(len(self.ForList)):
						if self.ForList[i]==0:			#Check whether the bit for the function is set to 0 if yes then that function has to be executed
							self.ForList[i]=1
							self.k=self.k+1
							self.toexec=2
							break
						else:	
							k=k+1				# If set to 1 then increment k
					if k==len(self.ForList):			# if k=length(self.ForList) then all functions have been executed once so reinitalise
						for i in range(len(self.ForList)):
							self.ForList[i]=0
							self.k=self.k-1
						self.start=self.start+self.step
						self.toexec=1
						
				else:							# if start>stop then for loop has ended
					self.forbit=0
					self.counter=self.counter+len(self.ForList)
					for i in range(len(self.ForList)):
                                        	self.execfun[self.cnt]='e'
						self.cnt=self.cnt+1
					self.k=self.k+len(self.ForList)
					if self.ival=="start":
						self._updateProperty(self.inp4,'start')
					self.toexec=1					
			elif self.funlist[self.counter]=="endfor" or self.funlist[self.counter]=="endwhile":
				self.counter=self.counter+1
				self.toexec=1
				
			elif self.funlist[self.counter]=="while":
                                self.WhileList=[]
				currid=self.ids[self.cnt-1]
				currnum=int(string.split(currid,'_id_',1)[1])
				#self.counter=self.counter+1
				inp1=string.replace(currid,'_id_','_input1_')
				inp2=string.replace(currid,'_id_','_oper_')
				inp3=string.replace(currid,'_id_','_input2_')
				inp4=string.replace(currid,'_id_','_step_')
				input1=self.getProperty(inp1)
				oper=self.getProperty(inp2)
				input2=self.getProperty(inp3)
				step=self.getProperty(inp4)
				input=[]
				for q in [input1,oper,input2,step]:
					if q in self.propertyIds():
						input.append(self.getProperty(q))
					elif string.find(q,'Result')!=-1:
						for p in range(self.k):
							if string.find(q,str(p))!=-1:
								for i in self.propertyIds():
									if string.find(i,str(p))!=-1 and string.find(i,'_Result')!=-1:
										input.append(self.getProperty(i))
					else:
						input.append(q)
				self.input1=int(input[0])
				self.oper=input[1]
				self.input2=int(input[2])
				self.step=int(input[3])
				wend=-1
				nextendwhile=1
				for i in range(self.counter+1,len(self.funlist)):
					if self.funlist[i]=="while":
						nextendwhile=nextendwhile+1
					elif self.funlist[i]=="endwhile":
						nextendwhile=nextendwhile-1
					elif nextendwhile==0:
						break
					if self.funlist[i]!="endwhile":
						self.WhileList.append(0)
				self.counter=self.counter+1
				self.whilebit=1
				self.funbit=1
				self.toexec=1
	
			elif self.whilebit==1:
                                val=0
				con=compile(str(self.input1)+str(self.oper)+str(self.input2),'','eval')
        			c=eval(con)
				k=0
                                if c==1:
					for i in range(len(self.WhileList)):
                                               if self.WhileList[i]==0:              #Check whether the bit for the function is set to 0 
							self.WhileList[i]=1
                                                        self.k=self.k+1
							break
                                               else:
                                                        k=k+1                           # If set to 1 then increment k
                                        if k==len(self.WhileList):                      # if k=length(self.ForList) then all functions have 
                                                for i in range(len(self.WhileList)):
                                                        self.WhileList[i]=0
                                                        self.k=self.k-1
                                                self.input1=self.input1+self.step
						self.toexec=1
			        else:                                              # if start>stop then for loop has ended
                                        self.whilebit=0
                                        self.counter=self.counter+len(self.WhileList)
					for i in range(len(self.WhileList)):
                                        	self.execfun[self.cnt]='e'
						self.cnt=self.cnt+1
					self.k=self.k+len(self.WhileList)
					self.toexec=1
					#self.execute()
			else:
				#if self.k==4:
					#return
				self.k=self.k+1
				self.counter=self.counter+1
				self.toexec=0
			if self.counter<len(self.funlist):
			 	if string.find(self.funlist[self.counter-1],'endif')!=-1 or string.find(self.funlist[self.counter],'elif')!=-1 or string.find(self.funlist[self.counter-1],'else')!=-1:
					self.cnt=self.cnt+self.rmcnt
					self.rmcnt=0
					#return
					#if self.counter==2:
					#return
			if self.toexec==1:
				self.toexec=0
				self.execute()
				#return a
			else:
				#if self.k==5:
					#return
				self.execsinglefun(self.k-1)
				
					
				#return '<html><body><br><b>Result of '+self.id+'('+self.title+')'+':</b>'+str(self.Final_Result)+'<br>'+'<br>'+'</body></html>'
				
		
		elif self.counter==len(self.funlist): # If all fns have been excuted then display result.
			
			try:
				a=self.ids[self.cnt-1]
				cnt=self.cnt-1
			except:
				a=self.ids[self.cnt-2]
				cnt=self.cnt-2

			self._updateProperty('Final_Result',self.execfun)			

			for i in range(cnt,-1,-1):
				if self.execfun[i]=='e':
					if string.find(self.ids[i],'if')==-1 and string.find(self.ids[i],'while')==-1 and string.find(self.ids[i],'for')==-1 and string.find(self.ids[i],'else')==-1:
						s=self.ids[i]
						s=string.replace(s,'_id_','_Result_')
						self._updateProperty('Final_Result',self.getProperty(s))
						break
				#return str(self.cnt)


	def execsinglefun(self,cnt):
		"execute functions"
                #return '<html><body>Hi !!</body></html>'
		funcount=cnt
       		temp=[]
		n=[]
       		m=[]
		#phyurl=self.getPhysicalPath()[1]   #Get the product instance id
		phyurl=self.InstancePath		
		proplist=[]
		s=self.propertyIds()	   #Get the properties of the flow object from the property sheet
		for i in s:
			if string.find(i,'_')!=-1 and string.find(i,'Result')==-1 and string.find(i,'if_')==-1 and string.find(i,'for_')==-1  and string.find(i,'while_')==-1 and string.find(i,'else_')==-1:
				funcnum=int(string.split(i,'_',2)[2])
				if funcnum==funcount:
					if string.find(i,'_id_')!=-1:
						funcid=string.split(i,'_id_',1)[0]
					if string.find(i,'_title_')!=-1:
						funcname=self.getProperty(i)
					if string.find(i,'_id_')==-1 and string.find(i,'_title_')==-1 and string.find(i,'_module_')==-1 and string.find(i,'_rangeofnum_')==-1 and string.find(i,'_documentation_')==-1:
						proplist.append(i)	
						vallist=[]
						propval=self.getProperty(i)
						if string.find(propval,',')!=-1:
							for t in string.split(propval,',',-1):
								if t in s:
									vallist.append(self.getProperty(t))
								else:
									#if string.find(propval,'[')==-1:
									vallist.append(t)		
							if string.find(str(vallist),'Result')!=-1 or string.find(str(vallist),'for_i_')!=-1:
								for t in vallist: 
									if string.find(t,'Result')!=-1 or string.find(t,'for_i_')!=-1:
										for l in range(0,funcount+1):
											 if string.find(t,str(l))!=-1:
												if string.find(t,str(l))!=-1:
													a=''
													try:
														a=string.find(t,'_i_')[1]
														b="for_i"
													except:
														try:
															a=string.split(t,'if')[1]
															b="Resultofif"
														except:
															try:
																a=string.split(t,'Result')[1]
																b="Result"
															except:
																pass
                                                                        		 		if a==str(l):# if the strings exactly match
                                                                                				for k in s:
															 if string.find(k,b)!=-1 and string.find(k,'_Result_'+str(l))!=-1:
                                                                                         		       			#This is to retreive Result'n' from the property sheet
																q=k
																ind=vallist.index(t)
																vallist.remove(t)
																vallist.insert(ind,str(self.getProperty(q)))
																break
															 elif string.find(k,b)!=-1 and string.find(k,'for_i_'+str(l))!=-1:
																q=k
																ind=vallist.index(t)
																vallist.remove(t)
																vallist.insert(ind,str(self.getProperty(q)))
																break
															 elif string.find(k,b)!=-1 and string.find(k,'Resultofif'+str(l))!=-1:
																q=k
																ind=vallist.index(t)
																vallist.remove(t)
																vallist.insert(ind,str(self.getproperty(q)))
																break
								vallist=string.replace(str(vallist),"'","")
							temp.append(vallist)
						else:
							if propval in s:
								temp.append(self.getProperty(propval))	
							else:
								#if string.find(propval,'Result')==-1:
								temp.append(propval)
						#self._updateProperty('Final_Result',str(vallist)+str(temp))
						#return
					
			#return '<html><body>'+str(temp)+'<br>'+str(vallist)+'</body></html>'	
					#if string.find(i,'_documentation_')==-1:
					for t in temp:    # For elements in temp which holds args for current function, search for Result,for_i and Resultofif values ig present  
						if string.find(str(t),'Result')!=-1 or string.find(str(t),'for_i_')!=-1:
							for l in range(0,funcount+1):
								if string.find(t,str(l))!=-1:
									a=''
									try:
										a=string.find(t,'_i_')[1]
										b="for_i"
										
									except:
										try:
											a=string.split(t,'if')[1]
											b="Resultofif"
										except:
											try:
												a=string.split(t,'Result')[1]
												b="Result"
											except:
												pass
									if a==str(l):# if the strings exactly match 
										for k in s:
											if string.find(k,b)!=-1 and string.find(k,'_Result_'+str(l))!=-1:
												#This is to retreive Result'n' from the property sheet	
												q=k
												ind=temp.index(t)
												temp.remove(t)
												temp.insert(ind,str(self.getProperty(q)))
												break
											elif string.find(k,b)!=-1 and string.find(k,'for_i_'+str(l))!=-1:
												# This is for retreiving for_i_n value
												q=k
												#return str(temp)
												ind=temp.index(t)
												temp.remove(t)
												temp.insert(ind,str(self.getProperty(q)))
												break
											elif string.find(k,b)!=-1 and string.find(k,'Resultofif'+str(l))!=-1:
												# This is for retreiving Resultofif'n' value
												q=k
												ind=temp.index(t)
												temp.remove(t)
												temp.insert(ind,str(self.getProperty(q)))
												break	
		modulename=self.getProperty(funcid+'_module_'+str(funcount)) # Get the modulename
		#return '<html><body>'+funcid+'<br>'+modulename+'</body><html>'
		if modulename=='umaths':				     # Convert all math function  arguments to float
                	for j in range(len(temp)):
				try:
					temp[j]=str(float(temp[j]))
				except:
					print "Error"
					print temp
					#self._updateProperty('Final_Result',str(proplist))
	        elif modulename=='UserList':
                        if 'List' in temp:
                                temp.remove('List')
		for i in range(len(temp)):
			if type(temp[i])==type([1,2,3,4,5]):
				c=1
				liarg=temp[i]
			else:
				temp[i]=str(temp[i])
                		c=temp[i].count('[')    #Checking if passed values r in a list
         			if c>0:    
	                   		rt=string.replace(temp[i],"[","")
                        		rtt=string.replace(rt,"]","")
					if string.find(rtt,', ')!=-1:
						rtt=string.replace(rtt,', ',',')
                        		liarg=string.split(rtt,",",-1)
			if c>0:
	                       	for k in liarg:         #Checking for args datatype.
                                	#k=str(k)
					if k.isdigit():#extra
                                        	n.append(int(k))#extra
                                	elif (re.search('^-[0-9]*[0-9]',k)!=None or re.search('^[0-9]*[0-9]',k)!=None):
                                                if (re.search('[a-z]|[A-Z]',k)!=None):
                                                        n.append(str(k))
                                                elif string.find(k,'.')!=-1:
                                                        n.append(float(k))
                                                else:
                                                        n.append(int(k))
                               		elif k=="" or k=='None':
    	                           		n.append(None)
                                	elif k.endswith("'"):
                                        	n.append(string.replace(k,"'",""))
                                	else:
                                        	n.append(str(k))

                        	m.append(n)
                        	n=[]
                	else:           #Args which are not in a list
				#temp[i]=str(temp[i])
				if temp[i].isdigit():
                                	m.append(int(temp[i]))
                        	elif (re.search('^-[0-9]*[0-9]',temp[i])!=None or re.search('^[0-9]*[0-9]',temp[i])!=None):   
                             		if (re.search('[a-z]|[A-Z]',temp[i])!=None):
                                                m.append(str(temp[i]))
                                        elif string.find(temp[i],'.')!=-1:
                                                #if string.find(temp[i],'.')!=-1:
                                                m.append(float(temp[i]))
                                        else:
                                                m.append(int(temp[i]))
                        	elif temp[i].isspace():
                                	m.append(' ')
                        	elif temp[i].endswith("'"):
                                	m.append(string.replace(temp[i],"'",""))
                       		elif temp[i]=='None' or temp[i]=="":
                                	m.append(None)
                       		else :
                                	if modulename=="cmaths":
						m.append(complex(str(temp[i])))
					else:
						m.append(str(temp[i]))

		args=tuple(m)           #Converting to tuple for passing args in Apply func

        	#For execution of the function selected
		if modulename=="maths":
			modulename="math"
		if modulename=="cmaths":
			modulename="cmath"
		if modulename=="umaths":
			modulename="umath"
		#os.chdir(funref.dbname)
		#return '<html><body>'+str(self.funtype)+str(args)+str(modulename)+'</body></html>'
		b=None
		funref=self.restrictedTraverse( phyurl +'PBase/Functions/'+self.funlist[self.counter-1],default=None)
		if funref is not None:
                	if funref.funtype==2:# and modulename=="UserList":
				st="from "+modulename+" import *"
				evalst=compile(st,'','single') #Importing the module
   				exec evalst
				p=''
				if modulename=="UserList":
                                	p=str(args[0])
					if string.find(p,'[')==-1:
                                        	p='['+p+']'
					lenarg=len(args)
					newargs=[]
					for i in range(1,lenarg):
						newargs.append(args[i])
					#self._updateProperty('Final_Result',newargs)
					#return
					args=tuple(newargs)
				evalst1=compile('a='+funref.clname+'('+p+')','','single')
                        	exec evalst1  
                        	name='a.'+funcname
                        	evalfun=compile('b=apply('+name+','+str(args)+')','','single')  #Calling func with args
				exec evalfun
				if b is None:
                        		b=a
				
		else:
			st="import "+modulename
			evalst=compile(st,'','single') #Importing the module
   			exec evalst
			name=modulename+'.'+funcname
        		evalfun=compile('b=apply('+name+','+str(args)+')','','single')  #Calling func with args
        		try:
				exec evalfun
			except: 
				return
		if type(b)==type(3.12):
			b=fpformat.fix(b,2)
		res=('result',b)
		self._updateProperty(funcid+'_Result_'+str(funcount),b)
		self.execute()
		#RESPONSE.redirect(self.surl+'/manage_addProduct/List/FlowObjects/'+obj+'/execute')
	
	def checkanswer(self,REQUEST,RESPONSE=None):
		""" Check the answer """
		answer=float(REQUEST.form.keys['answer'])
		chanswer=float(REQUEST.form.keys['chanswer'])
		if answer==chanswer:
			return str("Right")
		else:	
			return str("Wrong")
	
	def DelFlowO(self,REQUEST,RESPONSE=None):
                """Delete the flow object"""
                delid=REQUEST.form['id']
                #dest=dispatcher.Destination()
                self.PBase.FlowObjects.manage_delObjects(delid)
                nm="FlowObject"
                REQUEST.set('newnm',nm)
                REQUEST.set('newid',delid)
                REQUEST.RESPONSE.redirect(REQUEST['URL2']+'/replydelete?newid=%s&newnm=%s' %(delid,nm))

	def updateFlow(self,REQUEST,RESPONSE=None):
		""" Update the properties """
		for key in REQUEST.form.keys():
			self._updateProperty(key,REQUEST.form[key])
		REQUEST.set('newid','Flow')
		REQUEST.set('newname',self.id)
		RESPONSE.redirect('confirmUpdate?newid=%s&newname=%s'%(self.id,'Flow'))

	getValues=DTMLFile('pdtml/getValues',globals())
	FlowResult=DTMLFile('pdtml/FlowResult',globals())
	changeFlowProp=DTMLFile('pdtml/changeFlowProp',globals())
	confirmUpdate=DTMLFile('pdtml/confirmUpdate',globals())

def manage_Flow(dispatcher,id,objid,livar,ftype,REQUEST=None,RESPONSE=None):
     "Add a flow object to a folder."
     dest=dispatcher.Destination()
     #phyurl = dest.getPhysicalPath()[1]
     phyurl = dest.InstancePath     
     phypath=phyurl+'PBase/FlowBase/'+objid
     #return '<html><body>'+str(REQUEST)+'<br>'+str(objid)+'</body></html>'
     obj=dispatcher.restrictedTraverse(phypath)
     #if 'ftype' in REQUEST.keys():
     if REQUEST['ftype']=='comp':
	funobj=obj.FObj
     else:
    	funobj=obj.FunObj    

#     dest.PBase.FlowObjects._setObject(id,Flow(id,objid,livar,funobj,phyurl))
     dest.PBase.FlowObjects._setObject(id,Flow(id,objid,livar,funobj))

     #if REQUEST is not None:   
        #try:    url=dispatcher.DestinationURL()
        #except: url=REQUEST['URL1']
        #REQUEST.RESPONSE.redirect(url+'/confirmFl?newname=%s' % (id))


     if REQUEST is not None:
        FlowRef = dest.restrictedTraverse( phyurl + 'PBase/FlowObjects/'+id)
	FlowRef.callforinit(REQUEST,RESPONSE)

	#RESPONSE.redirect('/'+phyurl+'/PBase/FlowObjects/'+id+'/callforinit')
	#RESPONSE.redirect('/'+phyurl+'/PBase/FlowObjects/'+id+'/callforinit')
        #return dispatcher.manage_main(dispatcher, REQUEST)

manage_addFlow=DTMLFile('pdtml/manage_addFlow',globals())
addnewFlowform=DTMLFile('pdtml/addnewFlowform',globals())


InitializeClass(Flow)

