#####################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the 
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
#  Boston, MA 02111-1307 USA.
#
######################################################################

from OFS.ObjectManager import ObjectManager
from OFS.SimpleItem import Item
from OFS.PropertyManager import PropertyManager
from OFS.FindSupport import FindSupport

from AccessControl.Role import RoleManager
from AccessControl import ClassSecurityInfo

from Globals import Persistent
from Globals import InitializeClass, DTMLFile

from Products.PythonScripts.standard import url_quote
from Products.ZCatalog.CatalogAwareness import CatalogAware
from Products.ZCatalog.Catalog import Catalog

# here the 2 import statements are added by Chitra
from Products.BTreeFolder2.BTreeFolder2 import BTreeFolder2
from OFS.Image import File

from ExtensionClass import Base
import string, Globals 
import os

from Products.GNOWSYS06.Relation import Assoc

file_path = Globals.package_home(globals())

def attributeaddobj(self,ft,fillmode,attributeval):
      """
      This function is used for adding Attributes
      """
      defAttributeValue = attributeval
      mandatory=[]
      optional=[]
      token=0
      mandatory=self.Mandatory
      optional=self.Optional
      if fillmode=='Mandatory':
         for a in mandatory:
       	     if a==ft:
		token=1
		break
             else: 
		token=0
	 if token==0:  
	    for a in optional:
	      if a==ft:
		self.Optional.remove(a)
		break
            self.Mandatory.append(ft)
      elif fillmode=='Optional':
          for a in optional:
       	     if a==ft:
		token=1
		break
             else: 
		token=0
	  if token==0:
             for a in mandatory:
		if a==ft:
		  self.Mandatory.remove(a)
		  break
	     self.Optional.append(ft)

      if self.hasProperty(ft) > 0:
             self._updateProperty(ft,attributeval)	
      else:
	     PATH = self.InstancePath + 'Data/AttributeTypes/' + ft
	     attribute = self.restrictedTraverse(PATH)
	     Type1 = ['float','int','long']

	     Type2 = ['boolean']
	     Type3 = ['lines','string','text','tokens','selection','multiple selection']

	     if defAttributeValue is not None:
                  attributeDataType = attribute.getProperty('datatype')
   	          self.manage_addProperty(ft, defAttributeValue, attributeDataType, REQUEST=None)
	     else:
        	     attributeDataType = attribute.getProperty('datatype')
                     if attributeDataType in Type1:
                         defAttributeValue = 0
                     elif attributeDataType in Type2:
                         defAttributeValue = 0
                     elif attributeDataType in Type3:
                         defAttributeValue = ''                 
                     self.manage_addProperty(ft,defAttributeValue,attributeDataType,REQUEST=None)

      self.reindex_object()

def necessaryassociations(self,ObjectId,TOT,PATH):
    """
    This function adds necessary associations.
    """

    A = self.Data.Relations.objectIds()
    AT = self.Data.RelationTypes.objectIds()
    
    PATH = self.InstancePath
 
    OT = []
    LObjects = []
    RObjects = []
    RRelationType = []
                    
    for each in TOT:
        if each!='Role' and each!='Theme' and each!='SystemObject':
            OT.append(each)
    logFile = open( '/tmp//logFile', 'w')
    for eachATid in AT:	
	ATPATH = PATH + 'Data/RelationTypes/' + eachATid
	ATRef = self.restrictedTraverse( ATPATH )
        logFile.write( ATPATH + '\n' )
        Necessary = ATRef.Necessary
        if Necessary == 1:
          RRelationType.append(eachATid)
    logFile.close()
    for eachATid in RRelationType:	
	ATPATH = PATH + 'Data/RelationTypes/' + eachATid
	ATRef = self.restrictedTraverse( ATPATH )
        LRoles = ATRef.LRoles
        RRoles = ATRef.RRoles
	Flag = ATRef.Flag
        OTFlag= ATRef.OTFlag

        if OTFlag=='True':
              Participant='ObjectTypes'
        else:
              Participant='Objects'

        if Flag=='OTOT':		
            if LRoles[0] in OT:
                LObjects = []
                LObjects.append(ObjectId)
                for eachObjid in self.Catalog({'meta_type':'GObject'}):
                    RObjects = []
                    if eachObjid.meta_type == 'GObject':
                         if RRoles[0] in eachObjid.ObjectTypes:
                            RObjects.append(eachObjid.id)
                            BaseName = ObjectId + '_' + eachATid + '_' + eachObjid.id
                            Aid = string.strip(BaseName)    
                            Aid = string.replace(Aid,' ','')
                            if Aid not in A:
                                NewRelation = Assoc(Aid,LObjects,RRelationType,RObjects,BaseName,Participant,Flag)
                                self.Data.Relations._setObject(Aid,NewRelation)
				APATH = PATH + 'Data/Relations/' + Aid
				ARef = self.restrictedTraverse( APATH )
                                ARef.index_object()
            elif RRoles[0] in OT:
                RObjects = []
                RObjects.append(ObjectId)
                for eachObjid in self.Catalog({'meta_type':'GObject'}):
                    LObjects = []
                    if eachObjid.meta_type == 'GObject':
                        if LRoles[0] in eachObjid.ObjectTypes:
                            LObjects.append(eachObjid.id)
                            BaseName = eachObjid.id + '_' + eachATid + '_' +  ObjectId
                            Aid = string.strip(BaseName)    
                            Aid = string.replace(Aid,' ','')
                            if Aid not in A:
                                NewRelation = Assoc(Aid,LObjects,RRelationType,RObjects,BaseName,Participant,Flag)
                                self.Data.Relations._setObject(Aid,NewRelation)
				APATH = PATH + 'Data/Relations/' + Aid
				ARef = self.restrictedTraverse( APATH )
				ARef.index_object()                

        elif Flag=='OTO':
            RObjects=[]       
	    RObjects.append (RRoles[0])     

            if LRoles[0] in OT :       
                  LObjects = []
                  LObjects.append(ObjectId)
                  BaseName = ObjectId + '_' + eachATid + '_' + RObjects[0]		      
                  Aid = string.strip(BaseName)
                  Aid = string.replace(Aid,' ','')
  		           
                  if Aid not in A:
                      NewRelation = Assoc(Aid,LObjects,RRelationType,RObjects,BaseName,Participant,Flag)
      	              self.Data.Relations._setObject(Aid,NewRelation)
                      APATH = PATH + 'Data/Relations/' + Aid
                      ARef = self.restrictedTraverse( APATH )
                      ARef.index_object()

        elif Flag=='OOT':

            LObjects=[]      
            LObjects.append(  LRoles[0] )
     
            if RRoles[0] in OT :       
                  RObjects = []
 		  RObjects.append(ObjectId)
                  BaseName = LObjects[0] + '_' + eachATid + '_' + RObjects[0]		      
                  Aid = string.strip(BaseName)
                  Aid = string.replace(Aid,' ','')
  		           
                  if Aid not in A:
                      NewRelation = Assoc(Aid,LObjects,RRelationType,RObjects,BaseName,Participant,Flag)
      	              self.Data.Relations._setObject(Aid,NewRelation)
                      APATH = PATH + 'Data/Relations/' + Aid
                      ARef = self.restrictedTraverse( APATH )
                      ARef.index_object()

# the ZopePageTemplate is added instead of the ObjectManager, PropertyManager, RoleManager & Item by Chitra

class Object(File,
                  FindSupport,
                  CatalogAware,
                  Catalog):
    """
    Object implementation.
    """
    meta_type = "GObject"

    _properties = (
      {'id':'BaseName','type':'ustring','mode':'w'},
      {'id':'ObjectTypes','type':'ulines','mode':'w'},
      {'id':'Description','type':'utext','mode':'w'},
      {'id':'Status','type':'ustring','mode':'w'}, 
      {'id':'Mandatory','type':'ulines','mode':'w'}, 
      {'id':'Optional','type':'ulines','mode':'w'},
      {'id':'lRoleContainerIn','type':'ulines','mode':'w'},
      {'id':'rRoleContainerIn','type':'ulines','mode':'w'},
      {'id':'lRolePlayedIn','type':'ulines','mode':'w'},
      {'id':'rRolePlayedIn','type':'ulines','mode':'w'},       
     ) 

#     manage_options = (
#         { 'label': 'Contents', 'action': 'manage_main'},
#         { 'label': 'View', 'action': 'manage_deltopic'},
#         { 'label': 'Properties', 'action': 'manage_propertiesForm'},
#         ) + Item.manage_options

#  the changes are made by Hussain 
    manage_options = (
          ) + File.manage_options

    __ac_permissions__=(
        ('Manage Properties',('manage_addProperty',
                              'manage_editProperties',
                              'manage_delProperties',
                              'manage_changeProperties',
			      'Access content information')),
         )

    def __init__(self,id,BaseName,ObjectTypes,Description,Mandatory,Optional):
      self.id=id
      self.BaseName=BaseName
      self.ObjectTypes=ObjectTypes
      self.Description=Description
      self.Mandatory=Mandatory
      self.Optional=Optional

      self.lRoleContainerIn = []
      self.rRoleContainerIn = []     
      self.lRolePlayedIn = []
      self.rRolePlayedIn = []     
      self.Status='Public'
      #Variables added by hussain to incorporate changes that needed MetaType to behave as file Object
      self.content_type="text/html"
      self.data=""
# the comment is made by Chitra as the index_html is removed
#      addDTML(self,'index_html',BaseName,'dtml/obj_index_html')

    def statadd(self,a,b):
        """
        """
        c=a+b
        print c
        return c
  
    def rlist(self,ul,objTT):
	"""
        This function updates ObjectTypes property after editing object.
        """   
## ul contains the list of the ObjectTypes to which the instance belongs

        abinit=ul
	b2=string.replace(abinit,"['","")
        b3=string.replace(b2,"']","")
	b4=string.replace(b3,"', '"," ")
	bfin=[]
	bfin=string.split(b4," ")

#objTT contains the list of those ObjectTypes that have to be removed from the list of ObjectTypes to which the Object belongs.

	afin=[]
	afin=objTT
	nTT=filter(lambda x,afin=objTT: x not in afin,bfin)
	self._updateProperty('ObjectTypes',nTT)
	self.reindex_object()
	return      

    def deleteObject(self,REQUEST,RESPONSE,URL1,URL2):
       """
       Deletes the requested object.
       """
       id=REQUEST['id']
       BaseName=REQUEST['BaseName']

#This code maintains the neighborhood information

#       PATH = self.InstancePath + 'Data/ObjectType/'
# the above statement is replaced by the one below by hitesh

       PATH = self.InstancePath + 'Data/ObjectType/' + id[0] + '/'
       for each in self.Catalog():
             if each.meta_type=='GObject Type':
                   if each.id==id:
                         for xOt in self.ObjectTypes:
                               otRef = self.restrictedTraverse( PATH + xOt )
                               childObjectList = otRef.getProperty( 'child_objects' )
                               if id in childObjectList:
                                     childObjectList.remove(id)
                                     otRef._updateProperty('child_objects',childObjectList)
                                     otRef.reindex_object()          

#      del_path = self.InstancePath + 'Data/Objects/' 
# the above statement is replaced by the one below by hitesh

       del_path = self.InstancePath + 'Data/Objects/' + id[0] + '/'
       del_ref = self.restrictedTraverse(del_path)
       del_ref.manage_delObjects(id)
#       self.Data.Objects.manage_delObjects(id)
       self.unindex_object()
       #if the BtreeFolder now doesn't contain any more Objects then delete it as well
#       print "Objects " , del_ref.objectIds()
#       del_path = self.InstancePath + 'Data/Objects/'
#       del_ref = self.restrictedTraverse(del_path)
#       del_ref.manage_delObjects(id[0])


       # following two lines remove content file from file system.
       contentFile = os.path.normpath(CLIENT_HOME + '/GContent' + self.InstancePath +'Data/Objects/' + id[0])
       list_files = os.listdir(contentFile)
       #looping over the list to check wether the file containing the content of this object exist
       #this is done by checking only the filename with the id of the object ignoring the extension
       for file in list_files:
             if self.id == os.path.splitext(file)[0]: #Checking the filename with the id of the Object
                   #Removing the contents file from the filesystem
                   os.remove(contentFile + os.sep +  file)
       #Checking wether the directory is empty if so removing the directory as well       
       list_files = os.listdir(contentFile)
       if list_files==[]:
             os.rmdir(contentFile)
       
       nm="Object"
       REQUEST.set('newid',BaseName)
       REQUEST.set('newnm',nm)

#       REQUEST.RESPONSE.redirect(self.surl+ /replydelete?newid=%s&newnm=%s' % (BaseName,nm))

# the above statement is replaced by the one below by hitesh

       REQUEST.RESPONSE.redirect(self.surl+ '/Programs/replydelete?newid=%s&newnm=%s' % (BaseName,nm))
   
    def editObject(self,REQUEST,RESPONSE,URL1,URL2):
       """
       Edits the requested object
       """
       id = REQUEST['id']
       BaseName=REQUEST['BaseName']
       Description=REQUEST['Description']

       if len(BaseName)==0:
	  BaseName=id

       self._updateProperty('BaseName',BaseName)	
       self._updateProperty('Description',Description)	
       self.reindex_object() 

       nm="Object"
       REQUEST.set('newid',BaseName)
       REQUEST.set('newnm',nm)

#       REQUEST.RESPONSE.redirect(self.surl + '/replyedit?newid=%s&newnm=%s' % (BaseName,nm))

# the above statement is replaced by the one below by hitesh

       REQUEST.RESPONSE.redirect(self.surl + '/Data/Objects/Programs/' + id[0] + '/' + id + '/replyedit?newid=%s&newnm=%s' % (BaseName,nm))

    def attributeadd(self,REQUEST):
      """
      This function is used to add Attibutes
      """
      ft = REQUEST['ft']
      attributeval = REQUEST['attributeval']
      M = REQUEST['fillmode']

      PATH = self.InstancePath

      Replytype='Object'
      eflag=REQUEST['log']

      if M=='Mandatory' and attributeval == '' :
	self.REQUEST.RESPONSE.redirect(self.surl + '/Programs/AttributefillmodeError?Replytype=%s&eflag=%s' % (Replytype,eflag))
	return
      else:
	    if M=='Mandatory':	
    		attributeaddobj(self,ft,'Mandatory',attributeval)
	    else:
	    	attributeaddobj(self,ft,'Optional',attributeval)

#to check from where the call is made & redirect accordingly #

      filen = ''
      tmp = 'T'

      if eflag=='Edit':
            self.REQUEST.RESPONSE.redirect('manage_OEditform?val=%s' % tmp)
      else:
          		 filen = 'manage_OAttributemainform'
          		 self.REQUEST.RESPONSE.redirect(filen)
   
    def attributeEdit(self,REQUEST):
      """
      This function updates the Attibutes
      """
      ft = REQUEST['ft']
      attributeval = REQUEST['attributeval']
      omand=REQUEST['fillmode']

      Replytype='Object'
      eflag=REQUEST['log']

      if omand=='Mandatory' and attributeval=='' :
	self.REQUEST.RESPONSE.redirect(self.surl + '/Programs/AttributefillmodeError?Replytype=%s&eflag=%s' % (Replytype,eflag))
	return
      else:
	  if omand=='Mandatory':	
    		attributeaddobj(self,ft,'Mandatory',attributeval)
	  else:
	    	attributeaddobj(self,ft,'Optional',attributeval)

      self.REQUEST.RESPONSE.redirect('manage_OEditform')

    def removeattribute(self,REQUEST):
      """ 
      This function deletes attribute.
      """
      Attibutes = REQUEST['attributelist']
      tmpopt=[]
      tmpmand=[]
      tmpopt=self.getProperty('Optional')
      tmpmand=self.getProperty('Mandatory')
      for fc in Attibutes:
		for tmpfc in tmpopt:
			if fc==tmpfc:
			   tmpopt.remove(tmpfc)
		for tmpfc in tmpmand:
			if fc==tmpfc:
			   tmpmand.remove(tmpfc)

      self._updateProperty('Optional',tmpopt)
      self._updateProperty('Mandatory',tmpmand)

      self.manage_delProperties(Attibutes)
      self.reindex_object()
      REQUEST.RESPONSE.redirect(self.surl + '/Programs/attributedels')
      
    def updateunsel(self,REQUEST):
      """ 
      This script returns the list of ObjectTypes which are not a part of the 
      object types of the selected Object
      """
      list_of_ids=[]
      for x in self.Catalog({'meta_type':'GObject'}):
            if x.meta_type == 'GObject':
                  list_of_ids.append(x.id)
      b=[]
      b=self.ObjectTypes
      a=list_of_ids
      oTT=filter(lambda x,b=self.ObjectTypes: x not in b,list_of_ids)
      return oTT

# Factory methods

manage_addnewObjectForm = DTMLFile('dtml/addnewObjectform', globals())

def manage_addnewObject(dispatcher,id,REQUEST,RESPONSE,URL1,URL2):
    """
    This function adds New Object
    """
    id = string.replace(id,' ','')    
    dest = dispatcher.Destination()

    BaseName=REQUEST['BaseName']
    if len(BaseName)==0:
       BaseName = id
    ObjectTypes=[]
    ObjectTypes=REQUEST['ObjectTypes']
    Description=REQUEST['Description']
    Mandatory=[]
    Optional=[]

# here the contents are added by hitesh

    first_char = id[0]

    folder_path = 'Data/Objects/'
    opath = folder_path + first_char

    opathref = dest.restrictedTraverse(opath,"None")

    if opathref == "None" :
          folder_ref = dest.restrictedTraverse(folder_path)
          folder_ref._setObject(first_char,BTreeFolder2(first_char))
          opathref = dest.restrictedTraverse(opath)
          
    opathref._setObject(id, Object(id,BaseName,ObjectTypes,Description,Mandatory,Optional))

# changes are made till here

    PATH = dispatcher.InstancePath
    path = PATH       

#    PATH = PATH + 'Data/Objects/' + id
#   the above statement is replaced by the one below by hitesh

    PATH = PATH + 'Data/Objects/' + first_char + '/' + id
    objectRef = dest.restrictedTraverse( PATH )

    parentObjectTypes=objectRef.getProperty('ObjectTypes')
    
    for i in parentObjectTypes:

#	    parentObjectTypePath = path + 'Data/ObjectType/' + i
            # the above statement is replaced by the one below by hitesh
	    parentObjectTypePath = path + 'Data/ObjectType/' + i[0] + '/' + i

	    parentObjectTypeRef= objectRef.restrictedTraverse( parentObjectTypePath )

	    manadatoryValues=[]
	    optionalValues=[]
	    manadatoryValues=parentObjectTypeRef.getProperty('Mandatory')
	    optionalValues=parentObjectTypeRef.getProperty('Optional')

	    for i in manadatoryValues:
                if i not in objectRef.Mandatory:
			objectRef.Mandatory.append(i)
			if i in objectRef.Optional:
				objectRef.Optional.remove(i)
	    for i in optionalValues:
		if i not in objectRef.Optional and  i not in objectRef.Mandatory:
        		objectRef.Optional.append(i)

##########This Code Increments the object counter for Instance#######
    instancePath = string.replace( dest.InstancePath + 'Remove', '/Remove', '' )
    instanceRef = dest.restrictedTraverse( instancePath )
    objCounter =  instanceRef.getProperty( 'objects' )
    objCounter = objCounter + 1
    instanceRef._updateProperty('objects',objCounter)
    totalCounter = instanceRef.getProperty( 'total' )
    totalCounter = totalCounter + 1
    instanceRef._updateProperty('total',totalCounter)
    
##########This code maintains the Object neighbour hood information ##############

    for otId in ObjectTypes:

 #        otPath = PATH + '/Data/ObjectType/' + otId 
          # the above statement is replaced by the one below by hitesh
          otPath = path + 'Data/ObjectType/' + otId[0] + '/' + otId
          pObjectTypeRef = dest.restrictedTraverse( otPath )
          childObjectList = list(pObjectTypeRef.getProperty( 'child_objects' ))
          childObjectList.append(id)
          pObjectTypeRef._updateProperty('child_objects',childObjectList)
          pObjectTypeRef.reindex_object()                                  

    necessaryassociations(dest,id,ObjectTypes,PATH)

####Indexes Object with Catalog
    objectRef.index_object()

#    REQUEST.set('BaseName',BaseName)
#    REQUEST.set('Id',id)

#    REQUEST.RESPONSE.redirect(PATH + '/addContent?Id=%s&BaseName=%s' % (id,BaseName))
# the above statement is replaced by the one below by hitesh

#    REQUEST.RESPONSE.redirect(dest.surl + '/Programs/Data/Objects/' + id[0] + '/' + id  + '/addContent?Id=%s&BaseName=%s' % (id,BaseName))
    REQUEST.RESPONSE.redirect(dest.surl + '/Programs/Data/Objects/' + id[0] + '/' + id  + '/addContent')
    return id

def addDTML(obj,id,title,file):     
    f=open(file_path+'/'+file+'.dtml')     
    file=f.read()
    f.close()     
    obj.manage_addDTMLMethod(id,title,file)     
    return getattr(obj,id)     

InitializeClass(Object)
