#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the 
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
#  Boston, MA 02111-1307 USA.
######################################################################

from OFS.SimpleItem import Item
from OFS.PropertyManager import PropertyManager
from OFS.FindSupport import FindSupport

from AccessControl.Role import RoleManager
from AccessControl import ClassSecurityInfo

from Globals import Persistent
from Globals import InitializeClass, DTMLFile

from Products.ZCatalog.CatalogAwareness import CatalogAware

# here the import statement is added by Chitra
#from Products.PageTemplates.ZopePageTemplate import ZopePageTemplate
from OFS.Image import File
from Products.BTreeFolder2.BTreeFolder2 import BTreeFolder2

  
import string

def validateSelected(Objects):
    Error = 'No'
    if '----------' in Objects:
        Error = 'Yes'

    return Error

# the ZopePageTemplate is added instead of the ObjectManager, PropertyManager, RoleManager & Item by Chitra
class Assoc(File,
                  FindSupport,
                  CatalogAware):
    """
    Relation implementation.
    """
    meta_type = "GRelation"
   
    _properties = (
        {'id':'LObjects', 'type': 'ulines', 'mode': 'w'},
        {'id':'RelationType', 'type': 'ulines', 'mode': 'w'},
        {'id':'RObjects', 'type': 'ulines', 'mode': 'w'},
        {'id':'BaseName', 'type': 'ustring', 'mode': 'w'},
        {'id':'Participant', 'type': 'ustring', 'mode': 'w'},
        {'id':'ParticipantType', 'type': 'ustring', 'mode': 'w'},        
        ) 

    def __init__(self,id,LObjects,RelationType,RObjects,BaseName,Participant,ParticipantType):
     	self.id=id
	self.LObjects=LObjects
        self.RelationType=RelationType
        self.RObjects=RObjects
        self.BaseName=BaseName
        self.Participant=Participant        
        self.ParticipantType=ParticipantType
       #Variables added by hussain to incorporate changes that needed MetaType to behave as file Object
        self.content_type="text/html"
        self.data=""

       
#     manage_options = (
#         { 'label': 'Contents', 'action': 'manage_main'},
#         { 'label': 'View', 'action': 'manage_deltopic'},
#         { 'label': 'Properties', 'action': 'manage_propertiesForm'},
#         ) + Item.manage_options

# the changes are made by Chitra

#    manage_options = (
#        ) + ZopePageTemplate.manage_options

    manage_options = (
        ) + File.manage_options
    
    def DelAsso(self,REQUEST,RESPONSE,URL1,URL2):
        """
        Deletes the object requested
        """
       
        id = REQUEST['id']
        BaseName=REQUEST['BaseName']

        RD = REQUEST['Mode']
        
        oList=[]
        otList=[]
        
        for o_hash in  self.Data.Objects.objectIds():
            o_hash_ref=self.restrictedTraverse(self.InstancePath + "Data/Objects/"  + o_hash)
            print "Object initial = ",o_hash_ref 
            oList.append(o_hash_ref.objectIds('GObject'))
            
        for ot_hash in  self.Data.ObjectType.objectIds():
            ot_hash_ref=self.restrictedTraverse(self.InstancePath + "Data/ObjectType/"  + ot_hash)
            otList.append(ot_hash_ref.objectIds('GObject Type'))

        rel_type=""        
        for each in self.Catalog():
            if each.meta_type=='GRelation':
                if each.id==id:
                    rel_type=each.RelationType[0]
                    for x in each.RObjects:
                        PATH = self.InstancePath + "Data/"
                        if x in oList:
#                            PATH = PATH + "Objects/" + x
# changes hitesh
                            PATH = PATH + "Objects/" + x[0] + '/' + x
                            
                            ref = self.restrictedTraverse( PATH )
                            rList = ref.getProperty( 'rRolePlayedIn' )
                            if id in rList:
                                rList.remove(id)
                                ref._updateProperty('rRolePlayedIn',rList)
                                ref.reindex_object()	                
                        elif x in otList:
#                            PATH = PATH + "ObjectType/" + x
# changes hitesh
                            PATH = PATH + "ObjectType/" + x[0] + '/' + x
                            
                            ref = self.restrictedTraverse( PATH )
                            rList = ref.getProperty( 'rRolePlayedIn' )
                            if id in rList:
                                rList.remove(id)
                                ref._updateProperty('rRolePlayedIn',rList)
                                ref.reindex_object()	    
                    for x in each.LObjects:
                        PATH = self.InstancePath + "Data/"
                        if x in oList:
                            
#                            PATH = PATH + "Objects/" + x
# changes hitesh
                            PATH = PATH + "Objects/" + x[0] + '/' + x                            

                            ref = self.restrictedTraverse( PATH )
                            rList = ref.getProperty( 'lRolePlayedIn' )
                            if id in rList:
                                rList.remove(id)
                                ref._updateProperty('lRolePlayedIn',rList)
                                ref.reindex_object()	                
                            elif x in otList:
#                                PATH = PATH + "ObjectType/" + x
# changes hitesh
                                PATH = PATH + "ObjectType/" + x[0] + '/' + x
                                ref = self.restrictedTraverse( PATH )
                                rList = ref.getProperty( 'lRolePlayedIn' )
                                if id in rList:
                                    rList.remove(id)
                                    ref._updateProperty('lRolePlayedIn',rList)
                                    ref.reindex_object()	                

        rel_ref=self.restrictedTraverse(self.InstancePath + "Data/Relations/" + rel_type + "/" + id[0] + "/" + id ) 
        rel_ref.manage_delObjects(id)
        self.unindex_object()

        nm="Relation"

	REQUEST.set('newnm',nm)
        REQUEST.set('newid',BaseName)
        
        if RD=='Edit':
            REQUEST.RESPONSE.redirect(self.surl + '/Programs/EditForm')
        else:
            REQUEST.RESPONSE.redirect(self.surl + '/Programs/replydelete?newid=%s&newnm=%s' % (BaseName,nm))
  
    def strconv(self,temp):
       """
       Converts tokens to strings
       """
       a=string.join(temp)
       return a

# Factory methods

manage_addnewRelationForm = DTMLFile('dtml/addnewRelationform', globals())

def manage_addnewRelation(dispatcher,REQUEST=None):
    """
    Add New Relation object
    """
    dest = dispatcher.Destination()

    A=dest.Catalog({'meta_type':'GRelation Type' })
               
    C = ''
    C = REQUEST['Constraint']   

    Participant = REQUEST['Participant']
    ParticipantType = REQUEST['ParticipantType']            

    at=[]
    ass_type=repr(REQUEST['AssType'])
    ass_type_lt=string.replace(ass_type,"['","")
    ass_type_rt=string.replace(ass_type_lt,"']","") 
    ass_type_rt=string.replace(ass_type_rt,"'","")
    at.append(ass_type_rt)
    
    PATH = dispatcher.InstancePath
    PATH = PATH + 'Data/Relations'

    if C=='1':
        LObject = REQUEST['LObjects']
        #LObject = REQUEST['LParticipants']
        if validateSelected(LObject)=='Yes':
            dest.REQUEST.RESPONSE.redirect(dest.surl + '/Programs/relationValidateError' )
            return

        robj=[]
        robj = REQUEST['RObjects']
        #RObject = REQUEST['RParticipants']
        RObject = REQUEST['RObjects']
        if validateSelected(robj)=='Yes':
            dest.REQUEST.RESPONSE.redirect(dest.surl + '/Programs/relationValidateError' )
            return
        
        for x in robj:
            RObject = []
            RObject.append(x)
            basename = LObject[0] +'_'+ass_type_rt+'_'+ x
            id = string.strip(basename)    
            id = string.replace(id,' ','')
            id = string.replace(id, "'", "")
	    
	    if id in  A:
		dest.REQUEST.RESPONSE.redirect(dest.surl + '/Programs/relationAlreadyExistsError')
	    else:

##############################################################################################
# changes hitesh
                rel_initial_path = PATH + '/' + ass_type_rt

                folder_ref=dest.restrictedTraverse(rel_initial_path,"None")
                if folder_ref == "None" :
                        make_folder = dest.restrictedTraverse(PATH)
                        make_folder._setObject(ass_type_rt,BTreeFolder2(ass_type_rt))
                        
                rel_path = rel_initial_path + '/' + id[0]
                rel_ref=dest.restrictedTraverse(rel_path,"None")
                
                if rel_ref == "None" :
                    folder_ref=dest.restrictedTraverse(rel_initial_path)
                    folder_ref._setObject(id[0],BTreeFolder2(id[0]))

                rel_ref=dest.restrictedTraverse(rel_path)                    
#           	dest.Data.Relations._setObject(id,Assoc(id,LObject,at,RObject,basename,Participant,ParticipantType))
           	rel_ref._setObject(id,Assoc(id,LObject,at,RObject,basename,Participant,ParticipantType))

#            	ARef = dest.restrictedTraverse( PATH + id )
            	ARef = dest.restrictedTraverse( rel_path + '/' + id )
                
###############################################################################################            
            	ARef.index_object()  
    else:
        if C=='2':
            RObject = REQUEST['RObjects']
            #RObject = REQUEST['RParticipants']
            if validateSelected(RObject)=='Yes':
                dest.REQUEST.RESPONSE.redirect(dest.surl + '/Programs/relationValidateError' )
                return
            lobj=[]
            lobj = REQUEST['LObjects']
            #lobj = REQUEST['LParticipants']
            if validateSelected(lobj)=='Yes':
                dest.REQUEST.RESPONSE.redirect(dest.surl + '/Programs/relationValidateError' )
                return

            for x in lobj:
                LObject = []
                LObject.append(x)
                basename = x + '_' + ass_type_rt + '_' + RObject[0]
                id = string.strip(basename)    
                id = string.replace(id,' ','')
                id = string.replace(id, "'", "")

##############################################################################################
# changes hitesh
                rel_initial_path = PATH + '/' + ass_type_rt

                folder_ref=dest.restrictedTraverse(rel_initial_path,"None")
                if folder_ref == "None" :
                        make_folder = dest.restrictedTraverse(PATH)
                        make_folder._setObject(ass_type_rt,BTreeFolder2(ass_type_rt))
                        
                rel_path = rel_initial_path + '/' + id[0]
                rel_ref=dest.restrictedTraverse(rel_path,"None")
                
                if rel_ref == "None" :
                    folder_ref=dest.restrictedTraverse(rel_initial_path)
                    folder_ref._setObject(id[0],BTreeFolder2(id[0]))

                rel_ref=dest.restrictedTraverse(rel_path)                    
#           	dest.Data.Relations._setObject(id,Assoc(id,LObject,at,RObject,basename,Participant,ParticipantType))
           	rel_ref._setObject(id,Assoc(id,LObject,at,RObject,basename,Participant,ParticipantType))

#            	ARef = dest.restrictedTraverse( PATH + id )
            	ARef = dest.restrictedTraverse( rel_path + '/' + id )

###############################################################################################
                ARef.index_object()  
        else:
            #RObject = REQUEST['RParticipants']
            RObject = REQUEST['RObjects']
            if validateSelected(RObject)=='Yes':
                dest.REQUEST.RESPONSE.redirect(dest.surl + '/Programs/relationValidateError' )
                return
            LObject = REQUEST['LObjects']
            #LObject = REQUEST['LParticipants']
            if validateSelected(LObject)=='Yes':
                dest.REQUEST.RESPONSE.redirect(dest.surl + '/Programs/relationValidateError' )
                return
            
            basename = LObject[0] + '_' + ass_type_rt + '_' + RObject[0]
            id = string.strip(basename)    
            id = string.replace(id,' ','')
            id = string.replace(id, "'", "")
#            PATH = PATH + id
##############################################################################################
# changes hitesh
            rel_initial_path = PATH + '/' + ass_type_rt

            folder_ref=dest.restrictedTraverse(rel_initial_path,"None")
            if folder_ref == "None" :
                make_folder = dest.restrictedTraverse(PATH)
                make_folder._setObject(ass_type_rt,BTreeFolder2(ass_type_rt))
                        
            rel_path = rel_initial_path + '/' + id[0]
            rel_ref=dest.restrictedTraverse(rel_path,"None")
              
            if rel_ref == "None" :
                folder_ref=dest.restrictedTraverse(rel_initial_path)
                folder_ref._setObject(id[0],BTreeFolder2(id[0]))

            rel_ref=dest.restrictedTraverse(rel_path)                    
#           	dest.Data.Relations._setObject(id,Assoc(id,LObject,at,RObject,basename,Participant,ParticipantType))
            rel_ref._setObject(id,Assoc(id,LObject,at,RObject,basename,Participant,ParticipantType))

#            	ARef = dest.restrictedTraverse( PATH + id )
            ARef = dest.restrictedTraverse( rel_path + '/' + id )

##############################################################################################
            ARef.index_object()

    ####################################################################
    #This code maintains relations counter on the instance
    instancePath = string.replace( dest.InstancePath + 'Remove', '/Remove', '' )
    instanceRef = dest.restrictedTraverse( instancePath )
    rCounter = instanceRef.getProperty( 'relations' )
    rCounter = rCounter + 1
    instanceRef._updateProperty('relations',rCounter)
    totalCounter = instanceRef.getProperty( 'total' )
    totalCounter = totalCounter + 1
    instanceRef._updateProperty('total',totalCounter)
    ####################################################################
    ####################################################################
    #This code maintains neighborhood information
    oList = dest.Data.Objects.objectIds('GObject')
    otList = dest.Data.ObjectType.objectIds('GObject Type')

    for x in RObject:
        PATH = dest.InstancePath + "Data/"
        if x in oList:
#            PATH = PATH + "Objects/" + x
# changes hitesh
            PATH = PATH + "Objects/" + x[0] + '/' + x
            ref = dest.restrictedTraverse( PATH )
            rList = ref.getProperty( 'rRolePlayedIn' )
            rList.append(id)#insert(len(rList), id)
            ref._updateProperty('rRolePlayedIn',rList)
	    ref.reindex_object()	                
        elif x in otList:            
#            PATH = PATH + "ObjectType/" + x
# changes hitesh
            PATH = PATH + "ObjectType/" + x[0] + '/'+ x
            ref = dest.restrictedTraverse( PATH )
            rList = ref.getProperty( 'rRolePlayedIn' )
            rList.append(id)#insert(len(rList), id)
            ref._updateProperty('rRolePlayedIn',rList)
	    ref.reindex_object()	    
    for x in LObject:
        PATH = dest.InstancePath + "Data/"
        if x in oList:
#            PATH = PATH + "Objects/" + x
# changes hitesh
            PATH = PATH + "Objects/" + x[0] + '/' + x
            ref = dest.restrictedTraverse( PATH )
            rList = ref.getProperty( 'lRolePlayedIn' )
            rList.append(id)#insert(len(rList), id)
            ref._updateProperty('lRolePlayedIn',rList)
	    ref.reindex_object()	                
        elif x in otList:
#            PATH = PATH + "ObjectType/" + x
# chnages hitesh
            PATH = PATH + "ObjectType/" + x[0] + '/' + x
            ref = dest.restrictedTraverse( PATH )
            rList = ref.getProperty( 'lRolePlayedIn' )
            rList.append(id)#insert(len(rList), id)
            ref._updateProperty('lRolePlayedIn',rList)
	    ref.reindex_object()	                

    ####################################################################
    temp = 'Selected'
    nm="Relations"

    REQUEST.set('newnm',nm)
    REQUEST.set('newid',temp)

    REQUEST.RESPONSE.redirect(dest.surl + '/Programs/replyadd?newid=%s&newnm=%s' % (temp,nm))

InitializeClass(Assoc)
