#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the 
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
#  Boston, MA 02111-1307 USA.
#
######################################################################

import os
import string
import re
import pickle
from OFS import SimpleItem
from Globals import DTMLFile,InitializeClass
from Globals import HTMLFile
from listpy import *
from listcf import *
from FunctionType import *
from conditiontype import *
from ClassType import *
from FlowType import *
from Function import *
from GNOWSYS import *
from AccessControl.DTML import RestrictedDTML


# Listing class inherits the classes for creating folders and giving
# other related functionalities in the Web Interface 


def getfunctionsinsideclass(self,fnm,classname):
    """Gives functions inside the class"""
    pathlist=string.split(self.filepath,'/')
    filename=pathlist.pop()
    filepath1=string.join(pathlist,'/')
    sys.path.append(filepath1)
    
    #return str(fnm)+str(classname)
    try:
        exec 'import '+fnm
    except:
        return 'err'
    try:
        exec 'classinst='+fnm+'.'+classname
        
    except:
        try:
            exec 'from '+fnm+' import '+classname
            exec 'classinst='+classname
           
        except:
            pass
    dictfuncl=[]
    try:
        dictfuncl=inspect.getmembers(classinst,inspect.isroutine)# function inside class

    except:
        try:
            dictfuncl=inspect.getmembers(classinst,inspect.isroutine)# function inside class

        except:
            pass

    funcl=[]    
    if dictfuncl!=[]:    
        for k in dictfuncl:
            if type(k) is type([]):
                if dictfuncl[k]!=[]:
                    tmplist=k
                    for j in tmplist:
                        funcl.append(j[0])
            else:
                tmplist=k
                funcl.append(tmplist[0])
    return funcl


class listing(ObjectManager,
           PropertyManager,
           RoleManager,
           Item,
           FindSupport,
           ZCatalog,
	   SimpleItem,
	   RestrictedDTML, 
           HTML, 
           Acquisition.Implicit,
	   ):
    """A listing product"""

    meta_type = 'gnoListing'

    _properties= ( 
	{'id':'id', 'type':'string', 'mode':'r'},
	{'id':'title', 'type':'string', 'mode':'w'},
        )

    manage_options =(
        {'label': 'Contents', 'action': 'manage_main'},
        {'label': 'View', 'action': 'enterpath',},
	{'label': 'Flow', 'action': 'interfun',},
	{'label': 'Properties', 'action': 'manage_propertiesForm'}, 
	{'label': 'Roles', 'action': 'manage_access',},

	)

    allowedmetatypes = ('DTML Method','DTML Document','Folder','Temporary Folder','User Folder','Image','File','External Method','Script(Python)','ZCatalog','Association','Association Type','Facet Type','Occurrence Type','Object','Object Type','Transparent Folder','Z Search Interface','Cookie Crumbler','Accelerated HTTP Cache Manager', 'Ram Cache Manager', 'Browser Id Manager', 'Page Template','Function','FunctionType','Flow','Flow Type','Class','Class Type')
    def all_meta_types(self):
        if hasattr(self, 'allowedmetatypes'):
            result = []
            import Products
            for metaType in Products.meta_types:
                if metaType['name'] in self.allowedmetatypes:
                    result.append(metaType)
            return result
        else:
            return Products.meta_types

    def __init__(self, id, title):
        "Inits the product with default values"
        self.id = id
        self.title = title
	self.FunObject=[]    # List of functions which are selected in the flow object   
	self.pyfdir=[]       # List of the diretory path of  pyfiles
	self.pycldict=[]     # List of dictionary of classes
	self.pyfundict=[]    # List of dictionary of functions
	self.filepath=None    
	self.cfline=[]       # List of line numbers of functions within classes   
	self.fline=[]        # List of line numbers of functions outside classes
	self.fs=""      
        self.modname=""
	self.meth={}            
	self.dbname=[]      
	self.docstring=''   
	self.dirdir=[]       # List of path of the  dierctories

    def manage_editAction(self, title, RESPONSE=None):
        "Changes the product values"
        self.title = title
        self._p_changed = 1  # Makes the change persistant in ZODB
        RESPONSE.redirect('manage_editForm')

    def callistpy(self,searchPath,REQUEST,RESPONSE=None):
        "displays path"
	l1=listpy(REQUEST['searchPath'])   # Create an object of listpy to display py files in a given path
        pyf=str(l1.pyfiles)                 # All .py files in the search path
	pyd=str(l1.direct)                  # All directories within the search path
	self.dirdir=pyd
        linktype=REQUEST['linktype']
#        return linktype
	temp=string.replace(pyf,"[","")
	temp1=string.replace(temp,"]","")
	
	temp2=string.replace(pyd,"[","")
	temp3=string.replace(temp2,"]","")
	#self.dirdir=l1.dirpath
	self.pyfdir=l1.pathpyfiles
	REQUEST.set('pyfiles',temp1)
	REQUEST.set('direct',temp3)
	RESPONSE.redirect('resultPage?pyfiles=%s&direct=%s&linktype=%s' %(temp1,temp3,linktype)) # Redirect to ResultPage for displaying

    def callistcf(self,REQUEST,RESPONSE=None):
	"""calls listcf ...lists all functions/classes and their line nos"""
	if 'pathno' in REQUEST.keys():
		pathnum=int(REQUEST['pathno'])
		self.filepath=self.pyfdir[pathnum-1]
	elif 'path' in REQUEST.keys():
		self.filepath=REQUEST['path']
        linktype=REQUEST['linktype']
#        return linktype
	l2=listcf(self.filepath)
        
        # Create an object of listclfn which is used to display classes and functions

	self.pycldict=l2.collectivelist[0]
	self.pyfundict=l2.collectivelist[1]
        temp1=string.join(self.pyfundict)
        temp2=string.join(self.pycldict)
        if linktype=='fntp':
            RESPONSE.redirect('resultPage1?&newfun=%s&linktype=%s' %(temp1,linktype)) # Redirect to ResultPage to display results
        else:
            RESPONSE.redirect('resultpageforclass?&newfun=%s&linktype=%s' %(temp2,linktype)) # Redirect to ResultPage to display results

    def createfuntype(self,functionname,REQUEST,RESPONSE=None):
	"""creating a function type of selected function"""

        pathlist=[]
        argument = ''
        docstring = ''
        modulename = ''
        filepath1 = ''
        pathlist=string.split(self.filepath,'/')
        
        filename=pathlist.pop()

        filepath1=string.join(pathlist,'/')

        sys.path.append(filepath1)
        modulename=string.split(filename,'.')[0]
        exec 'import '+modulename
        exec 'modinst='+modulename
        funlist=[]
        funlist=inspect.getmembers(modinst,inspect.isroutine)
        arglist=[]
#        docstring='abcd'
        
        for k in funlist:            
            if k[0]==functionname:
                exec 'funinst='+modulename+'.'+k[0]
                tmp=inspect.getdoc(funinst)
                docstr=''
                if tmp!=None:
                    docstr=string.strip(tmp)
                    document=string.replace(docstr,"\n"," ")
                    
#                docstring=string.replace(docstr," ","$")                  
                tmptuple=inspect.getargspec(funinst)
                if tmptuple[0]!=[]:
                    for k in tmptuple[0]:
                        if k!='self':
                            arglist.append(k)
                    
                    arg=string.join(arglist)
                    argument=string.replace(arg," ","$")
                else:
                    argument='None'

        fp=open('/tmp/doc','w')
        fnm='/tmp/doc'
        pickle.dump(docstr,fp)
        fp.close()

        RESPONSE.redirect(self.surl+'/manage_addProduct/GNOWSYS06/manage_addFunctionType?name=%s&docfile=%s&arguments=%s&module=%s&filepath=%s'%(functionname,fnm,argument,modulename,filepath1))
#        RESPONSE.redirect(self.surl+'/temp?tmpstr=%s'%tmpcoll)

    def callistclfun(self,pathnocl,REQUEST,RESPONSE=None):
	"listclfun function"

	self.clno=int(pathnocl)
	self.typefun=''
	self.clname=self.pycldict[self.clno-1][0]
	#dict=self.pycldict[t1-1][1].__dict__
	#self.meth=dict["methods"]
	#meth1=str(dict["methods"].keys())
	meth1=str(self.clfn[self.clno-1])
	temp1=string.replace(meth1,"[","")
	temp2=string.replace(temp1,"]","")
	REQUEST.set('meth1',temp2)
	RESPONSE.redirect('resultPage2?meth1=%s'%(temp2))

    def createobj(self,REQUEST,RESPONSE=None):
	"""Create class instance"""
	
        l2=listcf(self.filepath)
        module=string.split(self.filepath,'/')
        mod= module.pop()
        fnm=string.split(mod,'.')[0]
#       return fnm

        clsname=REQUEST['classname']

        total=[]

        lst=[]
        fun=[]
	
        fun=getfunctionsinsideclass(self,fnm,clsname)
        
#        for i in range(len(fun)):
#              ind= string.find(fun[i],'_')
##              if ind==0:
##                  fun.remove(each)
        methods=string.join(fun,',')

         
	RESPONSE.redirect(self.surl+'/manage_addProduct/GNOWSYS06/manage_addClassType?module=%s&clname=%s&methods=%s&path=%s'%(fnm,clsname,methods,self.filepath))

    def callintermed(self,REQUEST,RESPONSE=None):
        intermed(REQUEST)
    def createobjfactory(self,REQUEST,RESPONSE=None):
        """create objects of all classes in a perticular module"""
#        return self.filepath
        filelist=string.split(self.filepath,'/').pop()
        pfile=string.split(filelist,'.')[0]

        l2=listcf(pfile)# Create an object of listclfn

        if l2.a=='Error':
            return "err"                            
        

        pathlist=[]
        argument = ''
        docstring = ''
        modulename = ''
        filepath1 = ''
        pathlist=string.split(self.filepath,'/')
        filename=pathlist.pop()
        filepath1=string.join(pathlist,'/')
        sys.path.append(filepath1)
        dbname=filepath1
        fp=open('/tmp/t5.txt','a+')
        fp.write(dbname+'\n')
        fp.close
        modulename=string.split(filename,'.')[0]
        exec 'import '+modulename
        exec 'modinst='+modulename
        clslist=[]
        clslist=l2.classin

        arglist=[]
        args='None'
        ttt=0
        for k in clslist:            
            name=k
            try:
                exec 'clsinst='+modulename+'.'+k

                tmp=inspect.getdoc(clsinst)
            except:
                return 'err1'
                continue
            docstr=''
            if tmp!=None:
                docstr=string.strip(tmp)
                document=string.replace(docstr,"\n"," ")
            fun=getfunctionsinsideclass(self,modulename,k)
            
            methods=string.join(fun,',')
            
            title=name
            module=modulename
            name=module+'-'+name
            fp=open('/tmp/doc','w')
            doc='/tmp/doc'
            pickle.dump(docstr,fp)
            fp.close()
            flg=1

            if self.PBase.ClassBase.objectIds()!=[]:
                for k1 in self.PBase.ClassBase.objectIds():
                    if k1!=name:
                        flg==1
                    else:
                        flg=0
                if flg==1:
                    
                    try:

                        self.PBase.ClassBase._setObject(name,ClassType(name,title,k,module,methods,self.filepath))
                        
                        ttt=ttt+1
                    except:
                        return 'err4'
                        pass
            else:
                        ttt=ttt+1
                        self.PBase.ClassBase._setObject(name,ClassType(name,title,k,module,methods,filepath1))

        if flg==1:
            if ttt>0:
                REQUEST.RESPONSE.redirect('confirmClassAddition?modname=%s'%(self.filepath))
            else:
                return 'Error in set'

            
        

    def createfactory(self,REQUEST,RESPONSE=None):
	"""instantiate all functions within one particular module"""

        filelist=string.split(self.filepath,'/').pop()
        pfile=string.split(filelist,'.')[0]

        l2=listcf(pfile)# Create an object of listclfn

        if l2.a=='Error':
            return "err"                            
        

        pathlist=[]
        argument = ''
        docstring = ''
        modulename = ''
        filepath1 = ''
        pathlist=string.split(self.filepath,'/')
        filename=pathlist.pop()
        filepath1=string.join(pathlist,'/')
        sys.path.append(filepath1)
        dbname=filepath1
        fp=open('/tmp/t5.txt','a+')
        fp.write(dbname+'\n')
        fp.close
        modulename=string.split(filename,'.')[0]
        exec 'import '+modulename
        exec 'modinst='+modulename
        funlist=[]
        funlist=l2.fun
        arglist=[]
        args='None'
        ttt=0
        for k in funlist:            
            name=k
            try:
                exec 'funinst='+modulename+'.'+k

                tmp=inspect.getdoc(funinst)
            except:
                return 'err1'
                continue
            docstr=''
            if tmp!=None:
                docstr=string.strip(tmp)
                document=string.replace(docstr,"\n"," ")
                
            try:    
                tmptuple=inspect.getargspec(funinst)

            except:
                
                continue
            if tmptuple[0]!=[]:
                for k in tmptuple[0]:
                    if k!='self':
                        arglist.append(k)
                        if arglist!=[]:
                            for tmp in arglist:
                                if tmp=='id' or tmp=='title' or tmp=='module' or tmp=='self':
                                    arglist.remove(tmp)
                            try:
                                args=string.join(arglist)
                            except:
                               
                                continue
            else:
        
                args='None'
            parameter=args                
            title=name
            module=modulename
            name=module+'-'+name
            fp=open('/tmp/doc','w')
            doc='/tmp/doc'
            pickle.dump(docstr,fp)
            fp.close()
            flg=1  
            if self.objectIds()!=[]:
                for k1 in self.objectIds():
                    if k1!=name:
                        flg==1
                    else:
                        flg=0
                if flg==1:
                    fp=open('/tmp/t2.txt','a+')
                    fp.write(name)
                    fp.close()
                    try:
                        self._setObject(name,FunctionType(name,title,parameter,doc,module,dbname))
                        ttt=ttt+1
                    except:
                        return 'err4'
                        pass
            else:
                self._setObject(name,FunctionType(name,title,parameter,doc,module,dbname))
        
        RESPONSE.redirect('confirmAddition?modname=%s'%(self.filepath))
        
## 	else:
## 		message=dirpath+' is not a directory. Please enter a directory path.'
## 		REQUEST.set('msg',message)
## 		RESPONSE.redirect('errorPage?msg=%s'%(message))

##     def setfunObject(self,name,defline,doc,modname,dbname):
## 	""" call setObject"""
## 	phyurl=self.InstancePath
## 	if name[0:1]=='_':
## 		name=name[1:]
## 	m=self.restrictedTraverse( phyurl + 'PBase/Functions/',default=None)
## 	print phyurl
## 	try:
## 		m._setObject(name,FunctionType(name,name,defline,doc,modname,dbname))
## 	except:
## 		print "Exception"

    def setclassObject(self,name,methods,linenos,dbname):
	""" call setObject """
	phyurl=self.InstancePath
	if name[0:1]=='_':
		name=name[1:]
	m=self.restrictedTraverse( phyurl +'PBase/ClassBase/',default=None)
	try:
		m._setObject(name,ClassType(name,name,name,methods,linenos,dbname))
	except:
		print "Exception"


    def addfile(self,REQUEST,RESPONSE):
	"""Add the composed file"""
	content=REQUEST['problem']
	content="<dtml-var standard_html_header>"+content+"<dtml-var standard_html_footer>"
	filename=REQUEST['filename']
	title=REQUEST['title']
	phyurl=self.InstancePath
	m=self.restrictedTraverse( phyurl + 'PBase/WordProblems',default=None)
	m.manage_addDTMLMethod(filename,title,content)
	REQUEST.set('newname',filename)
	REQUEST.set('newid',title)
	RESPONSE.redirect('confirm?newid=%s&newname=%s' %(title,filename))

    #the below function editForm is not used	
    def editForm(self,REQUEST,RESPONSE=None):
    	""" Edits the form """
	id=REQUEST.form['id']
	phyurl=self.InstancePath
	return
	fp=fopen( phyurl +'PBase/WordProblems/'+id,'r')
	a=fp.fread()
	return str(a)    	
    
    def DelWP(self,REQUEST,RESPONSE=None):
	"""Deletes the Word Problem"""
	delid=REQUEST.form['id']
        self.PBase.WordProblems.manage_delObjects(delid)
        nm="WordProblems"
        REQUEST.set('newnm',nm)
        REQUEST.set('newid',delid)
        REQUEST.RESPONSE.redirect(REQUEST['URL2']+'/replydelete?newid=%s&newnm=%s' %(delid,nm))

    def checkanswer(self,REQUEST,RESPONSE=None):
        """ Check the answer """
	answer=float(REQUEST.form['answer'])
        chanswer=float(REQUEST.form['chanswer'])
        if answer==chanswer:
		comment="right"
        else:
		comment="wrong"
	REQUEST.set('comment',comment)
	REQUEST.set('chanswer',chanswer)
	REQUEST.set('answer',answer)
	RESPONSE.redirect('WordResult?comment=%s&chanswer=%s&answer=%s' %(comment,chanswer,answer))

    def interfun(self,REQUEST,RESPONSE=None):
	"Form forflow to flowform"
	# Check initally whether FunctionObject already exists (ie Edit Flow Object) or create a new Flow Object
	self.FunObject=[]
	if 'FunctionObject' in REQUEST.keys():
		FunObj=string.replace(REQUEST['FunctionObject'],"'","")
		for i in string.split(FunObj,",",-1):		
			self.FunObject.append(i)
	FunObject=string.replace(str(self.FunObject),"[","")
	FunObject=string.replace(FunObject,"]","")
	FunObject=string.replace(FunObject,"'","")
	REQUEST.set('FunctionObject',FunObject)
	if 'objid' in REQUEST.keys():
		objvar=REQUEST['objid']
	else:
		objvar=''
	REQUEST.set('objid',objvar)
	if 'typ' in REQUEST.form.keys(): 
		t=REQUEST.form['typ']
	else:
		t='none'
	REQUEST.set('typ',t)
	err='None'
	if 'error' in REQUEST.keys():
		err=REQUEST['error']
	# Redirect to flowform initially
	RESPONSE.redirect('addnewFlowtypeform?FunctionObject=%s&objid=%s&typ=%s&err=%s'%(FunObject,objvar,t,err))
	

    def makeflow(self,REQUEST,RESPONSE=None):
	"Redirect to the flow page"
	error=''
	fobj=REQUEST['selobj']
	fobj=string.replace(fobj,"'","")
	self.FunObject=string.split(fobj,",",-1)
	if self.FunObject.count('if')>0:
		ifcnt=self.FunObject.count('if')
		endifcnt=self.FunObject.count('endif')
		if ifcnt!=endifcnt:
			error='<h3>Error !!!</h3>if without endif<br>'
  	if self.FunObject.count('for')>0:
                forcnt=self.FunObject.count('for')
                endforcnt=self.FunObject.count('endfor')
                if forcnt!=endforcnt:
                        error='<h3>Error !!!</h3>for without endfor<br>'
	if self.FunObject.count('while')>0:
                whcnt=self.FunObject.count('while')
                endwhcnt=self.FunObject.count('endwhile')
                if whcnt!=endwhcnt:
                        error='<h3>Error !!!</h3>while without endwhile<br>'
	FunObject=string.replace(str(self.FunObject),"[","")
        FunObject=string.replace(FunObject,"]","")
	FunObject=string.replace(FunObject," ","")
	if error!='':
		REQUEST.set('FunctionObject',FunObject)
		REQUEST.set('error',error)
		RESPONSE.redirect('interfun?FunctionObject=%s&error=%s'%(FunObject,error))
	else:
        	# Redirect to Flow to create a flow object of the selected functions in Function Object
		FunObject=string.replace(FunObject,"','","|")
		REQUEST.set('FunctionObject',FunObject)
		ty=REQUEST['typ']
		if ty=='':
			ty=REQUEST['typ1']
		REQUEST.set('typ',ty)
		REQUEST.set('objid',REQUEST.form['objid'])
		RESPONSE.redirect(self.surl+'/manage_addProduct/GNOWSYS06/manage_addFlowType?FunctionObject=%s&objid=%s&typ=%s'%(FunObject,REQUEST.form['objid'],ty))
		
	
    errorPage = DTMLFile('pdtml/errorPage',globals())   # Result of all directories and .py files within a given search path
    confirmdir = DTMLFile('pdtml/confirmdir',globals())
    
    selecttype = DTMLFile('pdtml/selecttype',globals()) 
    confirmAddition = DTMLFile('pdtml/confirmAddition',globals())
    confirmClassAddition = DTMLFile('pdtml/confirmClassAddition',globals())     
    selection = DTMLFile('pdtml/selection',globals()) 
    manage_editForm = DTMLFile('pdtml/manage_editForm',globals()) # Edit the content of the object
    resultPage = DTMLFile('pdtml/resultPage',globals())   # Result of all directories and .py files within a given search path
    resultPage1= DTMLFile('pdtml/resultPage1',globals())	# Result of all classes and functions within a .py file
    resultpageforclass= DTMLFile('pdtml/resultpageforclass',globals())	# Result of all classes  within a .py file
    resultPage2= DTMLFile('pdtml/resultPage2',globals())  # Result of all functions withn a class
    addnewFlowtypeform=DTMLFile('pdtml/addnewFlowtypeform',globals())	# Displays all functions in the Functions folder which can be selected for reating flow objects
    forflow=DTMLFile('pdtml/forflow',globals())             
    selfuncon=DTMLFile('pdtml/selfuncon',globals())	
    condPage=DTMLFile('pdtml/condPage',globals()) 
    WordResult=DTMLFile('pdtml/WordResult',globals()) 
    inputPage2=DTMLFile('pdtml/inputPage2',globals())
    #manage_addFunction=DTMLFile('pdtml/manage_addFunction',globals())
    choice=DTMLFile('pdtml/choice',globals())	
    composeProb=DTMLFile('pdtml/composeProb',globals())
    editProb=DTMLFile('pdtml/editProb',globals())
    exWP=DTMLFile('pdtml/exWP',globals())


# constructor pages. Only used when the product is added to a folder.

callinterfun=DTMLFile('pdtml/callinterfun',globals())
enterpath = DTMLFile('pdtml/enterpath',globals()) # Used to view content of the object


def get_attr(base_obj,curr_obj,err):
    try:
        curr_folder = getattr(base_obj,curr_obj)
    except:
        return err
    return curr_folder

#index_html=DTMLFile('index_html',globals())

InitializeClass(listing)




                
## 	t=[]
## 	self.classnm=''
## 	t1=int(pathnofn)
## 	fp=open(self.filepath)
## 	if val=="1":                           # val==1 indicates function
## 		no=self.fline[t1-1]
## 		self.fname=self.pyfundict[t1-1]	
## ## 	elif val=="2":                          # val==2 indicates function within a class
## ## 		no=self.cfline[self.clno-1][t1-1]
## ## 		self.fname=self.clfn[self.clno-1][t1-1]
		
## 	for i in range(no):
## 		fread=fp.readline()
## 	self.dbname=os.path.split(self.filepath)
## 	if self.dbname[1]=="maths":
## 		self.dbname[1]="math"
##         os.chdir(self.dbname[0])
##         self.modname=os.path.splitext(self.dbname[1])[0]
## 	if val=="1":
## 		evalst=compile('import '+self.modname,'','single') #Importing the module
##        		exec evalst
##         	name=self.modname+'.'+self.fname[0]
##         	evaldoc=compile('docu='+name+'.__doc__','','single') # Documentation of the function
##         	exec evaldoc
##         elif val=="2":
## 		self.classnm=self.pycldict[self.clno-1][0]
## 		evalst=compile('from '+self.modname+' import *' ,'','single')
## 		exec evalst
## 		evaldoc=compile('docu='+self.clname+'.__doc__','','single')
## 		exec evaldoc
                
## 	if docu==None:
## 		docu=''
## 	t.append(string.replace(docu," ","|"))
## 	f=string.replace(fread,' ','')
## 	f=string.split(f,'def')[1]
## 	ff=self.classnm+"_|_"+str(val)+"|"+self.filepath+"|"+f
## 	REQUEST.set('defline',ff)
## 	REQUEST.set('docstring',str(t))
## 	fp.close()
## 	# Redirect to functiontype for adding a new function




##     fnm1=self.filepath
##     fnm1=string.replace(fnm1,'/','.')

##     tmplst=[]
    
##     tmplst=string.split(fnm1,'.')

##     tmplst.pop()
##     tmplst.pop(0)

##     fnm1=string.join(tmplst,'.')
## #    return fnm1
    


    
#    return classinst
#    classinst.append(tmpclassinst)
#    if classinst!=[]:
#        for i in classinst:
