######################################################################
#
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330,
#  Boston, MA 02111-1307 USA.
#
######################################################################
#
#   The Export module for Gnowledge Markup Language (GnowML)
#
#   Initially Created by :
#       Ganesh Jayaraman : ganesh_jayaraman@rediffmail.com
#       Karmalkar Vishal : karmalkarv@rediffmail.com
#       Sawant Khalil    : khalil_sawant@rediffmail.com
#               Shah & Anchor Kutchhi Engineering College
#
######################################################################

import os,sys,string

def validfilename(filename):

    if filename=='':
        return 0
    v =filename.isalnum()

    return v

def getStart():

    start=[]
    start.append('<GnowML version="0.5">\n\n')

    return start

def getEnd():

    End=[]
    End.append('</GnowML>')

    return End

def getmetaTypes(self):

    metaType=[]

    for eachMetaType in self.Catalog():
        if eachMetaType.meta_type=='GMetaType':
            if eachMetaType.id=='DMetaType':
                continue
            metaType.append('\t<metaType id="'+eachMetaType.id+'" ')
            metaType.append('baseName="'+eachMetaType.BaseName+'">\n')
            for eachAttribute in eachMetaType.Mandatory:
                metaType.append('\t\t<attribute ref="'+eachAttribute+'" ')
                metaType.append('mandatory="True" ')
                for secondAttribute in eachMetaType.Defined:
                    if eachAttribute==secondAttribute:
                        metaType.append('defining="True" ')
                for secondAttribute in eachMetaType.Possible:
                    if eachAttribute==secondAttribute:
                        metaType.append('defining="False" ')
                values=self.getAnyProperty(eachMetaType.id,'GMetaType',eachAttribute)
                metaType.append('value="')
                #if eachAttribute=='www' or eachAttribute=='file' or eachAttribute=='ftp':
                if eachAttribute=='path':
                    metaType.append(str(values[0]))
                else:
                    metaType.append(str(values))
                metaType.append('"/>\n')
            for eachAttribute in eachMetaType.Optional:
                metaType.append('\t\t<attribute ref="'+eachAttribute+'" ')
                metaType.append('mandatory="False" ')
                for secondAttribute in eachMetaType.Defined:
                    if eachAttribute==secondAttribute:
                        metaType.append('defining="True" ')
                for secondAttribute in eachMetaType.Possible:
                    if eachAttribute==secondAttribute:
                        metaType.append('defining="False" ')
                values=self.getAnyProperty(eachMetaType.id,'GMetaType',eachAttribute)
                metaType.append('value="')
                #if eachAttribute=='www' or eachAttribute=='file' or eachAttribute=='ftp':
                if eachAttribute=='path':
                    metaType.append(str(values[0]))
                else:
                    metaType.append(str(values))
                metaType.append('"/>\n')
            for eachSubTypeOf in eachMetaType.PMetaType:
                metaType.append('\t\t<subTypeOf ref="'+eachSubTypeOf+'"/>\n')
            if eachMetaType.Description!='':
                metaType.append('\t\t<description>'+eachMetaType.Description+'</description>\n')
            metaType.append('\t</metaType>\n\n')

    return metaType

def getmetaTypeRelations(self):

    metaTypeRelations=[]

    for eachMetaTypeRelation in self.Catalog():
        if eachMetaTypeRelation.meta_type=='GMetaTypeRelation':
            metaTypeRelations.append('\t<metaTypeRelation\n')
            metaTypeRelations.append('\t\tid="'+eachMetaTypeRelation.id+'"\n')
            metaTypeRelations.append('\t\tbaseName="'+eachMetaTypeRelation.BaseName+'"\n')
            metaTypeRelations.append('\t\troleType="'+eachMetaTypeRelation.CFlag+'"\n')
            metaTypeRelations.append('\t\treflexivity="'+eachMetaTypeRelation.Reflexive+'"\n')
            metaTypeRelations.append('\t\tsymmetry="'+eachMetaTypeRelation.Symmetric+'"\n')
            metaTypeRelations.append('\t\ttransitivity="'+eachMetaTypeRelation.Transitive+'">\n\n')

            for eachLeftRole in eachMetaTypeRelation.LRoles:
                metaTypeRelations.append('\t\t<leftRole ref="'+eachLeftRole+'"/>\n')

            for eachRightRole in eachMetaTypeRelation.RRoles:
                metaTypeRelations.append('\t\t<rightRole ref="'+eachRightRole+'"/>\n')

            metaTypeRelations.append('\t</metaTypeRelation>\n\n')

    return metaTypeRelations

def getobjectTypes(self):

    objectTypes=[]

    for eachObjectType in self.Catalog():
        if eachObjectType.meta_type=='GObject Type':
            if eachObjectType.id=='DObjectType':
                continue
            if eachObjectType.id=='book':
                continue
            if eachObjectType.id=='dtd_book':
                continue
            objectTypes.append('\t<objectType id="'+eachObjectType.id+'" ')
            objectTypes.append('baseName="' + eachObjectType.BaseName +'">\n')
            for eachAttribute in eachObjectType.Mandatory:
                objectTypes.append('\t\t<attribute ref="'+eachAttribute+'" ')
                objectTypes.append('mandatory="True" ')
                for secondAttribute in eachObjectType.Defined:
                    if eachAttribute==secondAttribute:
                        objectTypes.append('defining="True" ')
                for secondAttribute in eachObjectType.Possible:
                    if eachAttribute==secondAttribute:
                        objectTypes.append('defining="False" ')
                values=self.getAnyProperty(eachObjectType.id,'GObject Type',eachAttribute)
                objectTypes.append('value="')
                #if eachAttribute=='www' or eachAttribute=='file' or eachAttribute=='ftp': 
                if eachAttribute=='path':
                    objectType.append(str(values[0]))
                else:
                    objectTypes.append(str(values))
                objectTypes.append('"/>\n')

            for eachAttribute in eachObjectType.Optional:
                objectTypes.append('\t\t<attribute ref="'+eachAttribute+'" ')
                objectTypes.append('mandatory="False" ')
                for secondAttribute in eachObjectType.Defined:
                    if eachAttribute==secondAttribute:
                        objectTypes.append('defining="True" ')
                for secondAttribute in eachObjectType.Possible:
                    if eachAttribute==secondAttribute:
                        objectTypes.append('defining="False" ')
                values=self.getAnyProperty(eachObjectType.id,'GObject Type',eachAttribute)
                objectTypes.append('value="')
                #if eachAttribute=='www' or eachAttribute=='file' or eachAttribute=='ftp':
                if eachAttribute=='path':
                    objectTypes.append(str(values[0]))
                else:
                    objectTypes.append(str(values))
                objectTypes.append('"/>\n')

            for eachSubTypeOf in eachObjectType.PObjectType:
                objectTypes.append('\t\t<subTypeOf ref="'+eachSubTypeOf+'"/>\n')

            for eachMetaType in eachObjectType.PMetaType:
                objectTypes.append('\t\t<instanceOf ref="'+eachMetaType+'"/>\n')

            if eachObjectType.Description!='':
                objectTypes.append('\t\t<description>'+eachObjectType.Description+'</description>\n')

            objectTypes.append('\t</objectType>\n\n')

    return objectTypes

def getobjects(self):

    objects=[]

    for eachObject in self.Catalog():
        if eachObject.meta_type=='GObject':
            if eachObject.id=='chapter':
                continue
            if eachObject.id=='section':
                continue
            if eachObject.id=='subsection':
                continue
            if eachObject.id=='subsubsection':
                continue
            objects.append('\t<object id="'+eachObject.id+'" ')
            objects.append('baseName="'+eachObject.BaseName+'">\n')

            for eachAttribute in eachObject.Mandatory:
                objects.append('\t\t<attribute ref="'+eachAttribute+'" ')
                objects.append('mandatory="True" ')
                values=self.getAnyProperty(eachObject.id,'GObject',eachAttribute)
                objects.append('value="')
                #if eachAttribute=='www' or eachAttribute=='file' or eachAttribute=='ftp':
                if eachAttribute=='path':
                    objects.append(str(values[0]))
                else:
                    objects.append(str(values))
                objects.append('"/>\n')
            for eachAttribute in eachObject.Optional:
                objects.append('\t\t<attribute ref="'+eachAttribute+'" ')
                objects.append('mandatory="False" ')
                values=self.getAnyProperty(eachObject.id,'GObject',eachAttribute)
                objects.append('value="')
                #if eachAttribute=='www' or eachAttribute=='file' or eachAttribute=='ftp':
                if eachAttribute=='path':
                    objects.append(str(values[0]))
                else:
                    objects.append(str(values))
                objects.append('"/>\n')

            for eachObjectType in eachObject.ObjectTypes:
                objects.append('\t\t<instanceOf ref="'+eachObjectType+'"/>\n')
            if eachObject.Description!='':
                objects.append('\t\t<description>'+eachObject.Description+'</description>\n')
            objects.append('\t</object>\n\n')

    return objects

def getrelationTypes(self):

    relationTypes=[]

    for eachRelationType in  self.Catalog({'meta_type':'GRelation Type'}):
        if eachRelationType.meta_type=='GRelation Type':
            if eachRelationType.id=='is_of_DTD_element_type':
                continue
            relationTypes.append('\t<relationType\n')
            relationTypes.append('\t\tid="'+eachRelationType.id+'"\n')
            relationTypes.append('\t\tbaseName="'+eachRelationType.BaseName+'"\n')
            relationTypes.append('\t\taltName="'+eachRelationType.Altname+'"\n')
            relationTypes.append('\t\tinvName="'+eachRelationType.Inversename+'"\n')
            relationTypes.append('\t\troleType="'+eachRelationType.Flag+'"\n')
            relationTypes.append('\t\treflexivity="'+eachRelationType.Reflexive+'"\n')
            relationTypes.append('\t\tsymmetry="'+eachRelationType.Symmetric+'"\n')
            relationTypes.append('\t\ttransitivity="'+eachRelationType.Transitive+'"\n')
            relationTypes.append('\t\tcardinality="'+str(eachRelationType.Constraint)+'"\n')
            relationTypes.append('\t\tOTFlag="'+str(eachRelationType.OTFlag)+'"\n')
            relationTypes.append('\t\tnecessary="'+str(eachRelationType.Necessary)+'">\n\n')

            for eachMetaType in eachRelationType.RelMetaType:
                relationTypes.append('\t\t<instanceOf ref="'+eachMetaType+'"/>\n')

            for eachLeftRole in eachRelationType.LRoles:
                relationTypes.append('\t\t<leftRole ref="'+eachLeftRole+'"/>\n')

            for eachRightRole in eachRelationType.RRoles:
                relationTypes.append('\t\t<rightRole ref="'+eachRightRole+'"/>\n')

            relationTypes.append('\t</relationType>\n\n')

    return relationTypes

def getrelations(self):

    relations=[]

    for eachRelation in self.Catalog({'meta_type':'GRelation'}):
        if eachRelation.meta_type=='GRelation':
            relations.append('\t<relation id="'+eachRelation.id+'" ')
            relations.append('baseName="'+eachRelation.BaseName+'" ')
            for eachLeftObject in eachRelation.LObjects:
                relations.append('leftObject="'+eachLeftObject+'" ')
            for eachRightObject in eachRelation.RObjects:
                relations.append('rightObject="'+eachRightObject+'" ')
            relations.append('participant="'+eachRelation.Participant+'">\n')
            relations.append('participanttype="'+eachRelation.ParticipantType+'">\n')
            for eachRelationType in eachRelation.RelationType:
                relations.append('\t\t<instanceOf ref="'+eachRelationType+'"/>\n')

            relations.append('\t</relation>\n\n')

    return relations

def getattributeTypes(self):

    attributeTypes=[]

    for eachAttributeType in self.Catalog():
        if eachAttributeType.meta_type=='GAttribute Type':
            if eachAttributeType.id=='path':
                continue
            #if eachAttributeType.id=='www':
            #    continue
            #if eachAttributeType.id=='ftp':
            #    continue
            #if eachAttributeType.id=='file':
            #    continue
            if eachAttributeType.id=='Status':
                continue
            if eachAttributeType.id=='PStatus':
                continue
            attributeTypes.append('\t<attributeType id="'+eachAttributeType.id+'" ')
            attributeTypes.append('baseName="'+eachAttributeType.BaseName+'" ')
            attributeTypes.append('dataType="'+eachAttributeType.datatype+'">\n')
            for eachAttMetaType in eachAttributeType.AttMetaType:
                attributeTypes.append('\t\t<instanceOf ref="'+eachAttMetaType+'"/>\n')

            if eachAttributeType.Description!='':
                attributeTypes.append('\t\t<description>'+eachAttributeType.Description+'</description>\n')

            attributeTypes.append('\t</attributeType>\n\n')

    return attributeTypes


def createGnowMLFile(self,REQUEST):

    try:
        rootdirectory = os.listdir('/tmp/')
    except:
        os.makedirs('tmp')
        rootdirectory = os.listdir('/tmp/')

    filename = REQUEST['filename']
    if validfilename(filename)==0:
        url = self.surl + '/Programs/exportCheckfilename'
        REQUEST.RESPONSE.redirect(url)
        return

    gmlFileName = filename + '.gml'
    tmpgmlFileName = '/tmp/' + gmlFileName
    file=open(tmpgmlFileName,'w')
    file.writelines(getStart())
    file.writelines(getmetaTypes(self))
    file.writelines(getmetaTypeRelations(self))
    file.writelines(getobjectTypes(self))
    file.writelines(getobjects(self))
    file.writelines(getrelationTypes(self))
    file.writelines(getrelations(self))
    file.writelines(getattributeTypes(self))
    file.writelines(getEnd())
    file.close()

    file=open(tmpgmlFileName,'r')
    gmlfiledata = file.read()
    file.close()

    self.GnowML_Files.manage_addProduct['OFSP'].manage_addFile(gmlFileName,gmlfiledata,gmlFileName,'','')
    tgzFileName = filename + '.tgz'
    tmptgzFileName = '/tmp/' +  tgzFileName
    tgzFilePath = CLIENT_HOME + '/GContent' + self.InstancePath
    os.chdir(tgzFilePath)
    os.system('tar -cvzf ' + tmptgzFileName + ' Data/' )

    if os.path.exists(tmptgzFileName):
        file=open(tmptgzFileName,'r')
        tgzfiledata = file.read()
        file.close()
    else:
        pass

    self.GnowML_Files.manage_addProduct['OFSP'].manage_addFile(tgzFileName,tgzfiledata,tgzFileName,'','')

    os.remove(tmpgmlFileName)
    os.remove(tmptgzFileName)

    REQUEST.RESPONSE.redirect( self.surl + '/Programs/GnowMLReplyExport?gmlfilename=%s&tgzfilename=%s' % (gmlFileName,tgzFileName))
