######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the 
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
#  Boston, MA 02111-1307 USA.
#
######################################################################

# @filename : OWLExport.py
# @author   : Paul Varkey (paul@hbcse.tifr.res.in)
# Module for exporting GNOWSYS data into the OWL format



import os
               

filename = "OWLExportFile"

# The entry-point funtion from the calling DTML script #

def performOWLExport ( self , REQUEST ):

    try:
        filename = REQUEST['filename']
    except:
        filename = "OWLExportFile"
    if filename == '':
        filename = "OWLExportFile"
        
    #Check validity of filename
    if not filename.isalnum() :
        url = self.surl + '/Programs/exportCheckfilename'
        REQUEST.RESPONSE.redirect(url)
        return
                            
    OWLFormatFileName = filename + '.owl'
    OWLFormatFullyQualifiedFileName = '/tmp/' + OWLFormatFileName
    OWLFile = open ( OWLFormatFullyQualifiedFileName , 'w' )
    #OWLFile.writelines ( prettyWriter ( self , "Person" , "Name" , "Paul" ) )
    OWLFile.writelines ( getStart () )
    OWLFile.writelines ( getStandardGNOWSYSEntityAssertions () )
    OWLFile.writelines ( getMetaTypeLayerAssertions ( self ) )
    OWLFile.writelines ( getTypeLayerAssertions ( self ) )
    OWLFile.writelines ( getObjectAssertions ( self ) )
    OWLFile.close ()
    Relations = getRelations ( self,OWLFormatFullyQualifiedFileName )
    OWLFile = open ( OWLFormatFullyQualifiedFileName , 'a' )    
    OWLFile.writelines ( Relations )
    OWLFile.writelines ( getEnd () )
    OWLFile.close ()

    # Obtain complete data from generated OWL file
    OWLFile = open ( OWLFormatFullyQualifiedFileName , 'r' )
    OWLData = OWLFile.read ()
    OWLFile.close ()

    # Add the file to the GNOWSYS instance
    self.OWL_Files.manage_addProduct['OFSP'].manage_addFile ( OWLFormatFileName , OWLData , OWLFormatFileName , '' , '' )
    
    tgzFileName = filename + '.tgz'
    tgzFullFileName = '/tmp/' + tgzFileName
    tgzFilePath = CLIENT_HOME + '/GContent' + self.InstancePath
    os.chdir ( tgzFilePath )
    os.system ( 'tar -cvzf ' + tgzFullFileName + ' Data/' )

    if os.path.exists ( tgzFullFileName ):
        tgzFile = open ( tgzFullFileName , 'r' )
        tgzData = tgzFile.read ()
        tgzFile.close ()
        # Add the file to the GNOWSYS instance
        self.OWL_Files.manage_addProduct['OFSP'].manage_addFile( tgzFileName , tgzData , tgzFileName , '' , '' )
    else:
        pass
    REQUEST.RESPONSE.redirect( self.surl + '/Programs/OWLReplyExport?OWLFileName=%s&TGZFileName=%s' % ( OWLFormatFileName , tgzFileName ) )

    return None


# Function to generate abbreviations, namespace declarations and ontology headers

def getStart ():

    start = []
    # standard header
    start.append ( "<?xml version=\"1.0\"?>\n\n" )
    # abbreviations
    start.append ( "<!DOCTYPE rdf:RDF [\n" )
    start.append ( "<!ENTITY rdf  \"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" >\n" )
    start.append ( "<!ENTITY rdfs \"http://www.w3.org/2000/01/rdf-schema#\" >\n" )
    start.append ( "<!ENTITY xsd  \"http://www.w3.org/2001/XMLSchema#\" >\n" )
    start.append ( "<!ENTITY owl  \"http://www.w3.org/2002/07/owl#\" >\n" )
    start.append ( "\t]>\n\n" )
    # namespace declarations
    start.append ( "<rdf:RDF\n" )
    start.append ( "\txmlns = \"http://www.gnowledge.org/gnowsys-owl#\"\n" )
    start.append ( "\txmlns:gnowsys = \"http://www.gnowledge.org/gnowsys-owl#\"\n" )
    start.append ( "\txmlns:base = \"http://www.gnowledge.org/gnowsys-owl#\"\n" )
    start.append ( "\txmlns:owl = \"http://www.w3.org/2002/07/owl#\"\n" )    
    start.append ( "\txmlns:rdf = \"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n" )
    start.append ( "\txmlns:rdfs = \"http://www.w3.org/2000/01/rdf-schema#\"\n" )    
    start.append ( "\txmlns:xsd = \"http://www.w3.org/2001/XMLSchema#\">\n\n" )
    # ontology header
    start.append ( "\t<owl:Ontology rdf:about=\"\">\n" )
    start.append ( "\t\t<rdfs:label>Exported GNOWSYS Ontology</rdfs:label>\n" )
    start.append ( "\t\t<rdfs:comment>\n" )
    start.append ( "\t\t\tThis file contains exported GNOWSYS data as an OWL Ontology\n" )
    start.append ( "\t\t</rdfs:comment>\n" )
    start.append ( "\t</owl:Ontology>\n\n" )
    return start


 
# Function to generate assertions/definitions for standard GNOWSYS entities

def getStandardGNOWSYSEntityAssertions ():

    standardEntities = []
    # 'Default MetaType' object definition
    standardEntities.append ( "\t<rdfs:Class rdf:ID=\"DMetaType\">\n" )
    standardEntities.append ( "\t\t<rdfs:label>MetaType</rdfs:label>\n" )
    standardEntities.append ( "\t\t<rdfs:subClassOf rdf:resource=\"&rdfs;Class\"/>\n" )
    standardEntities.append ( "\t\t<owl:equivalentClass rdf:resource=\"&owl;Class\"/>\n" )
    standardEntities.append ( "\t</rdfs:Class>\n\n" )
    # 'Default ObjectType' object definition
    standardEntities.append ( "\t<owl:Class rdf:ID=\"DObjectType\">\n" )
    standardEntities.append ( "\t\t<rdfs:label>Object</rdfs:label>\n" )
    standardEntities.append ( "\t\t<owl:equivalentClass rdf:resource=\"&owl;Thing\"/>\n" )
    standardEntities.append ( "\t</owl:Class>\n\n" )
    # Define property to represent RelationType MetaType
    standardEntities.append ( "\t<rdf:Property rdf:ID=\"RelationTypeMetaType\">\n" )
    standardEntities.append ( "\t\t<rdf:label>RelationTypeMetaType</rdf:label>\n" )
    standardEntities.append ( "\t\t<rdfs:domain rdf:resource=\"&owl;ObjectProperty\"/>\n" )
    standardEntities.append ( "\t\t<rdfs:range rdf:resource=\"&rdfs;Class\"/>\n" )
    standardEntities.append ( "\t</rdf:Property>\n\n" )
    # Define property to represent AttributeType MetaType
    standardEntities.append ( "\t<rdf:Property rdf:ID=\"AttributeTypeMetaType\">\n" )
    standardEntities.append ( "\t\t<rdf:label>AttributeTypeMetaType</rdf:label>\n" )
    standardEntities.append ( "\t\t<rdfs:domain rdf:resource=\"&owl;DatatypeProperty\"/>\n" )
    standardEntities.append ( "\t\t<rdfs:range rdf:resource=\"&rdfs;Class\"/>\n" )
    standardEntities.append ( "\t</rdf:Property>\n\n" )    
    return standardEntities



# Function to generate assertions for MetaType and MetaType Relation objects

def getMetaTypeLayerAssertions ( self ):

    MTLayerAssertions = []
    # scan the object pool and process all MetaTypes
    for eachElement in self.Catalog ():
        if eachElement.meta_type == 'GMetaType' and not eachElement.id == 'DMetaType':
            # Caveat Lector : Cryptic code follows; developer apologises profusely; purely unintentional; but subconciously developer feels quite proud ;-) @23:30 p.m. Mar 04, 04
            # ABANDON APPROACH :: MTLayerAssertions.append ( prettyWriter ( "" , "rdfs:Class" , prettyWriter ( "\t" , "rdfs:label" , eachElement.BaseName ) , prettyWriter ( "\t" , "rdfs:subClassOf" ) , attrvalPair1 = "rdfs:ID=\"" + eachElement.id + "\"" ) ) :: pretty writer not useful for all generic scenarios
            # not feeling so proud anymore @23:50 p.m. Mar 04, 04
            MTLayerAssertions.append ( "\t<rdfs:Class rdfs:ID=\"" + eachElement.id + "\">\n" )
            MTLayerAssertions.append ( "\t\t<rdfs:label>" + eachElement.BaseName + "</rdfs:label>\n" )
            for eachPMT in eachElement.PMetaType:
                MTLayerAssertions.append ( "\t\t<rdfs:subClassOf rdf:resource=\"#" + eachPMT + "\"/>\n" )
            MTLayerAssertions.append ( "\t</rdfs:Class>\n\n" )
    return MTLayerAssertions



# Dictionary for storing the GNOWSYS to OWL (xsd datatype) mappings

datatypeMappings = { 'boolean' : '&xsd;boolean' ,
                     'date' : '&xsd;date' ,
                     'int' : '&xsd;int' ,
                     'positiveInteger' : '&xsd;int' ,
                     'nonPositiveInteger' : '&xsd;int' ,
                     'negativeInteger' : '&xsd;int' ,
                     'nonNegativeInteger' : '&xsd;int' ,
                     'long' : '&xsd;long' ,
                     'float' : '&xsd;float' ,
                     'string' : '&xsd;string' ,
                     'ustring' : '&xsd;string' ,
                     'tokens' : '&xsd;tokens' ,
                     'text' : '&xsd;tokens' ,
                     'lines' : '&xsd;tokens' ,
                     'utokens' : '&xsd;tokens' ,
                     'utext' : '&xsd;tokens' ,
                     'ulines' : '&xsd;tokens' }



# Function to generate assertions for ObjectType, AttributeType and RelationType objects

def getTypeLayerAssertions ( self ):

    TypeLayerAssertions = []
    for eachElement in self.Catalog ():
        if eachElement.meta_type == 'GObject Type' and not eachElement.id == 'DObjectType':
            combinedMetaTypeID = owlEnvironmentalizer ( eachElement.PMetaType[0] )
            # check for multiple parent MetaTypes; create combined MetaType to reify virtual supertype
            if len ( eachElement.PMetaType ) > 1:
                TypeLayerAssertions.append ( "\t<rdfs:Class rdf:ID=\"" + eachElement.PMetaType[0] )
                for eachPMT in eachElement.PMetaType[1:]:
                    TypeLayerAssertions.append ( "_" + eachPMT )
                    combinedMetaTypeID = combinedMetaTypeID + "_" + eachPMT
                TypeLayerAssertions.append ( "\">\n" )
                for eachPMT in eachElement.PMetaType:
                    TypeLayerAssertions.append ( "\t\t<rdfs:subClassOf rdf:resource=\"#" + eachPMT + "\">\n" )
                TypeLayerAssertions.append ( "\t</rdfs:Class>\n\n" )
            TypeLayerAssertions.append ( "\t<" + combinedMetaTypeID + " rdf:ID=\"" + eachElement.id + "\">\n" )    
            TypeLayerAssertions.append ( "\t\t<rdfs:label>" + eachElement.BaseName + "</rdfs:label>\n" )
            # for eachSuperType in eachElement.TTList:
            # really crazy nomenclature ...."TTList" ...  nobody knows how it got in here
            for eachSuperType in eachElement.PObjectType:
                TypeLayerAssertions.append ( "\t\t<rdfs:subClassOf rdf:resource=\"#" + eachSuperType + "\"/>\n" )
            TypeLayerAssertions.append ( "\t</" + combinedMetaTypeID + ">\n\n" )
        elif eachElement.meta_type == 'GRelation Type':
            combinedMetaTypeID = eachElement.RelMetaType[0]
            # do the same checking for mutliple paren...blah-blah...here ...DUH!!!!!
            if len ( eachElement.RelMetaType ) > 1:
                TypeLayerAssertions.append ( "\t<rdfs:Class rdf:ID=\"" + eachElement.RelMetaType[0] )
                for eachPMT in eachElement.RelMetaType[1:]:
                    TypeLayerAssertions.append ( "_" + eachPMT )
                    combinedMetaTypeID = combinedMetaTypeID + "_" + eachPMT
                TypeLayerAssertions.append ( "\">\n" )
                for eachPMT in eachElement.RelMetaType:
                    TypeLayerAssertions.append ( "\t\t<rdfs:subClassOf rdf:resource=\"#" + eachPMT + "\"/>\n" )
                TypeLayerAssertions.append ( "\t</rdfs:Class>\n\n" )
            TypeLayerAssertions.append ( "\t<owl:ObjectProperty rdf:ID=\"" + eachElement.id+ "\">\n" )
            TypeLayerAssertions.append ( "\t\t<rdfs:label>" + eachElement.BaseName + "</rdfs:label>\n" )
            TypeLayerAssertions.append ( "\t\t<RelationTypeMetaType rdf:resource=\"#" + combinedMetaTypeID + "\"/>\n" )
            if len ( eachElement.LRoles ) > 0:
                TypeLayerAssertions.append ( "\t\t<rdfs:domain rdf:resource=\"#" + eachElement.LRoles[0] + "\"/>\n" )
            if len ( eachElement.RRoles ) > 0:                
                TypeLayerAssertions.append ( "\t\t<rdfs:range rdf:resource=\"#" + eachElement.RRoles[0] + "\"/>\n" )
            TypeLayerAssertions.append ( "\t</owl:ObjectProperty>\n\n" )
        elif eachElement.meta_type == 'GAttribute Type':
            combinedMetaTypeID = eachElement.AttMetaType[0]
            # do the same checking for mutliple paren...blah-blah...here ...DUH!!!!!
            if len ( eachElement.AttMetaType ) > 1:
                TypeLayerAssertions.append ( "\t<rdfs:Class rdf:ID=\"" + eachElement.AttMetaType[0] )
                for eachPMT in eachElement.AttMetaType[1:]:
                    TypeLayerAssertions.append ( "_" + eachPMT )
                    combinedMetaTypeID = combinedMetaTypeID + "_" + eachPMT
                TypeLayerAssertions.append ( "\">\n" )
                for eachPMT in eachElement.AttMetaType:
                    TypeLayerAssertions.append ( "\t\t<rdfs:subClassOf rdf:resource=\"#" + eachPMT + "\"/>\n" )
                TypeLayerAssertions.append ( "\t</rdfs:Class>\n\n" )
            TypeLayerAssertions.append ( "\t<owl:DatatypeProperty rdf:ID=\"" + eachElement.id+ "\">\n" )
            TypeLayerAssertions.append ( "\t\t<rdfs:label>" + eachElement.BaseName + "</rdfs:label>\n" )
            TypeLayerAssertions.append ( "\t\t<AttributeTypeMetaType rdf:resource=\"#" + combinedMetaTypeID + "\"/>\n" )
            TypeLayerAssertions.append ( "\t\t<rdfs:range rdf:resource=\"" + datatypeMappings[eachElement.datatype] + "\"/>\n" )
            TypeLayerAssertions.append ( "\t</owl:DatatypeProperty>\n\n" )            
    return TypeLayerAssertions
    


def owlEnvironmentalizer ( _GNOWSYS_identifier ):

    """ Method that returns the OWL equivalent nomenclature for GNOWSYS indetifiers """

    if _GNOWSYS_identifier == 'DMetaType':
        _OWL_identifier = 'owl:Class'
    else:
        _OWL_identifier = _GNOWSYS_identifier     # in case no equivalent was found, return unchanged
    return _OWL_identifier



# Function to generate assertions for Objects

def getObjectAssertions ( self ):

    ObjectAssertions = []
    for eachElement in self.Catalog ():
        if eachElement.meta_type == 'GObject':
            combinedObjectTypeID = eachElement.ObjectTypes[0]
            # check for multiple parent ObjectTypes; create combined ObjectType to reify virtual supertype
            if len ( eachElement.ObjectTypes ) > 1:
                ObjectAssertions.append ( "\t<rdfs:Class rdf:ID=\"" + eachElement.ObjectTypes[0] )
                for eachPMT in eachElement.ObjectTypes[1:]:
                    ObjectAssertions.append ( "_" + eachPMT )
                    combinedObjectTypeID = combinedObjectTypeID + "_" + eachPMT
                ObjectAssertions.append ( "\">\n" )
                for eachPMT in eachElement.ObjectTypes:
                    ObjectAssertions.append ( "\t\t<rdfs:subClassOf rdf:resource=\"#" + eachPMT + "\">\n" )
                ObjectAssertions.append ( "\t</rdfs:Class>\n\n" )
            ObjectAssertions.append ( "\t<" + combinedObjectTypeID + " rdf:ID=\"" + eachElement.id + "\">\n" )    
            ObjectAssertions.append ( "\t\t<rdfs:label>" + eachElement.BaseName + "</rdfs:label>\n" )
            ObjectAssertions.append ( "\t</" + combinedObjectTypeID + ">\n\n" )
    return ObjectAssertions



# Function to generate assertions for Relations

def getRelations ( self,OWLFormatFullyQualifiedFileName ):

    # Make a copy of the OWL assertions generated hitherto
    os.system ( 'cp /tmp/OWLFormatFile.owl /tmp/OWLFormatFileCopy.owl' )
    RelationAssertions = []
    for eachElement in self.Catalog ():
        if eachElement.meta_type == 'GRelation':
            #<* rdf:ID="OT1">
            listMatches = getPatternMatches ( "<* rdf:ID=\"" + eachElement.LObjects[0] + "\">",OWLFormatFullyQualifiedFileName )
            #listMatches = getPatternMatches ( "<* rdf:ID=\"O1\">" )
            if len ( listMatches ) > 0:
                RelationAssertions.append ( "\t<" + listMatches[0] + " rdf:about=\"#" + eachElement.LObjects[0] + "\">\n" )
                RelationAssertions.append ( "\t\t<" + eachElement.RelationType[0] + " rdf:resource=\"#" + eachElement.RObjects[0] + "\"/>\n" )
                RelationAssertions.append ( "\t</" + listMatches[0] + ">\n\n" )
    debugOutput = open ( '/tmp/debugOutput' , 'w' )
    debugOutput.writelines ( RelationAssertions )
    debugOutput.close ()
    return RelationAssertions



# Function to generate RDF end-tag

def getEnd ():

    end = []
    end.append ( "</rdf:RDF>" )
    return end



# Function to extract string patterns; used for defintion-extension assertions (esp. Relations)

def getPatternMatches ( patternBase , sourceFile ):

    # Sample Pattern : <* rdf:ID="OT1">
    # sampleSourceLine = "<<<< adadd rdf:ID=\"OT?1\">"
    # @19:10 p.m. Mar 06, 04 : feeling of exhiliration .... generic utility function made ... will always remmeber to close hanging file pointers
    matchedPatterns = []
    sourceFileHandler = open ( sourceFile , 'r' )        
    done = 0
    tokens = patternBase.split ( "*" )
    while not done:
        aLine = sourceFileHandler.readline ()
        if aLine != "":
            for i in range ( len ( tokens ) - 1 ):
                token_start = aLine.find ( tokens [ i ] )
                token_end = aLine.find ( tokens [ i+1 ] )
                if not ( token_start == -1 or token_end == -1 ):
                    matchedPatterns.append ( aLine [ token_start + len ( tokens [ i ] ) : token_end ] )            
        else:
            done = 1
    sourceFileHandler.close ()
    return matchedPatterns



# Evolve the following function, if needed, into a full-functional XML pretty writer

def prettyWriter ( tabSpace , tag , *contents , **attrval ):

    serializedOutput = ""
    #serializedOutput.append( 'Book wants to say you...... eerrrghghh (clearing throat) that ..eh.. the The whole story goes this way...' )
    serializedOutput = serializedOutput + "<" + tag
    for eachAttrValPair in attrval.keys():
        serializedOutput = serializedOutput + " " + str ( attrval[eachAttrValPair] )
    serializedOutput = serializedOutput + ">\n"
    for eachLine in contents:
        serializedOutput = serializedOutput + tabSpace + "\t" + eachLine + "\n"
    serializedOutput = serializedOutput + tabSpace + "</" + tag + ">"
    return serializedOutput



# Debugger workhorse

def debugPrinter ( self ):

    OWLFormatFullyQualifiedFileName = '/tmp/' + OWLFormatFileName
    OWLFile = open ( OWLFormatFullyQualifiedFileName , 'w' )
    #OWLFile.writelines ( prettyWriter ( self , "Person" , "Name" , "Paul" ) )
    OWLFile.writelines ( getStart () )
    OWLFile.writelines ( getStandardGNOWSYSEntityAssertions () )
    OWLFile.writelines ( getMetaTypeLayerAssertions ( self ) )
    OWLFile.writelines ( getTypeLayerAssertions ( self ) )
    OWLFile.writelines ( getObjectAssertions ( self ) )
    OWLFile.close ()
    Relations = getRelations ( self )
    OWLFile = open ( OWLFormatFullyQualifiedFileName , 'a' )    
    OWLFile.writelines ( Relations )
    OWLFile.writelines ( getEnd () )
    OWLFile.close ()
    tgzFileName = '/tmp/' + TGZContentArchive + '.tgz'
    tgzFilePath = CLIENT_HOME + '/GContent' + self.InstancePath
    os.chdir ( tgzFilePath )
    os.system ( 'tar -cvzf ' + tgzFileName + ' Data/' )
    #return "File \"/tmp/OWLFormatFile\" has been written"
    #return performOWLExport ( self )
    #return getPattern ()
    return None



# Prevent erroneous execution as standalone program

if __name__ == '__main__':
    print 'This module cannot be executed as an independent module'
