######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the 
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
#  Boston, MA 02111-1307 USA.
#
######################################################################

# @filename : OWLImport.py
# @author   : Paul Varkey (paul@hbcse.tifr.res.in)
# Module for importing OWL ontologies into GNOWSYS


from xml.sax import make_parser
import xml.sax.handler

#from Products.GNOWSYS.MetaType import *
#from Products.GNOWSYS.MetaTypeRelation import CatRel
from Products.GNOWSYS06.ObjectType import *
from Products.GNOWSYS06.RelationType import AssocT
from Products.GNOWSYS06.AttributeType import attributetype
from Products.GNOWSYS06.Object import *
from Products.GNOWSYS06.Relation import Assoc
from Products.ZCatalog.CatalogAwareness import CatalogAware
from Products.ZCatalog.Catalog import Catalog
#from Products.GNOWSYS.OWLExport import *

import Products.PythonScripts, Globals
from Products.PythonScripts.PythonScript import *
from Globals import InitializeClass, DTMLFile
from Globals import HTMLFile
from Globals import Persistent

import os
import sys
import string
import copy

# ---ABORT@04/12/04--- #
# os.sys.path.append( '/usr/lib/zope/lib/python/Products/GNOWSYS/Extensions' )
# from manageAdd import *
# ---ABORT@04/12/04--- #

# from Products.GNOWSYS.OWLParser import CustomHandler


GNOWSYSObject = None


class _contentHandler ( xml.sax.handler.ContentHandler ):

    messages = []
    PI = []
    prefixes = {}
    contents = []
    skipped = []
    attributes = {}
    keys = []

    stack = []    

    # A list of dictionaries for each OT, RT and AT along with corresponding references to the currently processed entity
    objecttypes = [] 
    objecttype = {} 
    relationtypes = []
    relationtype = {}
    attributetypes = []
    attributetype = {} ### :-) oops...this identifier clashes with another..the imported function....but I had no option...and fortunately, the scope keeps one from danger (someone plz. consider last 5 word for new Chineese proverb)
    objects = []
    _object = {}
    relations = []
    relation = {}
    _attributes = []
    attribute = {}

    def startDocument ( self ):

        self.messages.append ( '<html><body>' )

    def endDocument ( self ):

        self.messages.append ( '</body></html>' )

    def setDocumentLocator ( self , locator ):

        self.locator = locator

    def startElement ( self , name , attrs ):

        self.keys = []
        self.attributes = {}
        # Retrieve the attributes, if any
        if attrs.getLength () > 0:
            self.keys = attrs.keys ()
            for i in range ( attrs.getLength () ):
                self.attributes [ self.keys[i] ] = str ( attrs.getValue ( self.keys[i] ) )
        if name == 'owl:Class':
            # Process both possible cases: Class definition & modification
            # self.stack.append ( 'Class' )            
            # Class Definition
            if self.attributes.has_key ( 'rdf:ID' ):
                #if len ( self.stack ) > 0:
                #if self.stack [ -1 ] == 'Class':                
                self.stack.append ( 'ClassBeingDefined' )            # Stack Marker Entry
                # ---ABORT@04/12/04--- #
                # manageAdd.addObjectType ( GNOWSYSObject , 'wine_' + self.attributes [ 'rdf:ID' ] , self.attributes [ 'rdf:ID' ] , ['DMetaType'] , [] , '' )
                # ---ABORT@04/12/04--- #
                # self.Data.ObjectType._setObject( '_' + self.attributes [ 'rdf:ID' ] , ObjectType ( '_' + self.attributes [ 'rdf:ID' ] , self.attributes [ 'rdf:ID' ] , 'DMetaType' , ''  , [] , [] , [] , [] ) )
                self.objecttype [ 'ID' ] = self.attributes [ 'rdf:ID' ]
                self.objecttype [ 'BaseName' ] = self.attributes [ 'rdf:ID' ]
                self.objecttype [ 'PMetaType' ] = [ 'DMetaType' ]
                self.objecttype [ 'PObjectType' ] = [ 'DObjectType' ]
                self.objecttype [ 'Description' ] = ''
        elif name == 'rdfs:comment':
            self.stack.append ( 'Comment' )            # Stack Marker Entry
        elif name == 'rdfs:subClassOf':
            if  len ( self.stack ) > 0:
                if self.stack [ -1 ] == 'ClassBeingDefined':                
                    self.stack.append ( 'Inheriting' )         # Stack Marker Entry
                    # Process the case where the parent class is specified as an rdf:resource attribute
                    if self.attributes.has_key ( 'rdf:resource' ):
                        # Parse the resource identifier to seperate URI and name components
                        resource_elements = self.parse_split ( self.attributes [ 'rdf:resource' ]  )
                        # Case where resource is from same document
                        if len ( resource_elements ) == 1:
                            self.objecttype [ 'PObjectType' ].append ( resource_elements [0] )
                            # Case where resource is imported from external ontology
                        elif len ( resource_elements ) == 2:
                            # Reify surrogate/substitute for imported object
                            # self.objecttypes.append ( { 'ID':resource_elements[1].replace('/','_slash_').replace(':','_colon_').replace('#','_hash_') + resource_elements [0] , 'BaseName': resource_elements [0] , 'PMetaType':'DMetaType' , 'PObjectType':'DObjectType' , 'Description':'This OT is a reified surrogate for an externally imported object' } )
                            self.safe_append ( self.objecttypes , { 'ID':resource_elements[1].replace('/','_slash_').replace(':','_colon_').replace('#','_hash_') + resource_elements [0] , 'BaseName': resource_elements [0] , 'PMetaType':['DMetaType'] , 'PObjectType':['DObjectType'] , 'Description':'This OT is a reified surrogate for an externally imported object' } )
                            # self.objecttype [ 'PObjectType' ].append ( resource_elements[1].replace('/','_slash_').replace(':','_colon_').replace('#','_hash_') + resource_elements [0] )
        elif name == 'owl:ObjectProperty':
            # ObjectProperty is mapped to RelationType
            self.stack.append ( 'ObjectProperty' )
            if self.attributes.has_key ( 'rdf:ID' ):
                self.relationtype [ 'ID' ] = self.attributes [ 'rdf:ID' ]
                self.relationtype [ 'BaseName' ] = self.attributes [ 'rdf:ID' ]
                self.relationtype [ 'RelMetaType' ] = [ 'DMetaType' ]
                self.relationtype [ 'LRoles' ] = []
                self.relationtype [ 'RRoles' ] = []
                self.relationtype [ 'Reflexive' ] = 'NotDefined'
                self.relationtype [ 'Transitive' ] = 'NotDefined'
                self.relationtype [ 'Symmetric' ] = 'NotDefined'
                self.relationtype [ 'Constraint' ] = 0
                self.relationtype [ 'Necessary' ] = 0
                self.relationtype [ 'RoleType' ] = 'OTOT'
                self.relationtype [ 'AltName' ] = ''
                self.relationtype [ 'InvName' ] = ''
                self.relationtype [ 'OTFlag' ] = 'True'
        elif name == 'owl:DatatypeProperty':
            # DatatypeProperty is mapped to AttributeType
            self.stack.append ( 'DatatypeProperty' )
            if self.attributes.has_key ( 'rdf:ID' ):
                self.attributetype [ 'ID' ] = self.attributes [ 'rdf:ID' ]
                self.attributetype [ 'BaseName' ] = self.attributes [ 'rdf:ID' ]
                self.attributetype [ 'Datatype' ] = ''
                self.attributetype [ 'PMetaType' ] = [ 'DMetaType' ]
                self.attributetype [ 'Description' ] = ''
        elif name == 'rdf:type':
            if len ( self.stack ) > 0:
                if self.stack [ -1 ] == 'ObjectProperty':
                    self.stack.append ( 'ObjectPropertyType' )
                    if self.attributes.has_key ( 'rdf:resource' ):
                        # Parse the resource identifier to seperate URI and name components
                        resource_elements = self.parse_split ( self.attributes [ 'rdf:resource' ]  )
                        # The name component will determine the type of the ObjectProperty
                        if resource_elements [0] == 'TransitiveProperty':
                            self.relationtype [ 'Transitive' ] = 'Yes' # ?????
                        elif resource_elements [0] == 'SymmetricProperty':
                            self.relationtype [ 'Symmetric' ] = 'Yes' # ?????
        elif name == 'rdfs:domain':
            if len ( self.stack ) > 0:
                if self.stack [ -1 ] == 'ObjectProperty':
                    self.stack.append ( 'ObjectPropertyDomain' )
                    if self.attributes.has_key ( 'rdf:resource' ):
                        # Parse the resource identifier to seperate URI and name components
                        resource_elements = self.parse_split ( self.attributes [ 'rdf:resource' ]  )
                        # Case where resource is from same document
                        if len ( resource_elements ) == 1:
                            domain_resource = resource_elements [0]
                        # Case where resource is imported from external ontology
                        elif len ( resource_elements ) == 2:
                            self.safe_append ( self.objecttypes , { 'ID':resource_elements[1].replace('/','_slash_').replace(':','_colon_').replace('#','_hash_') + resource_elements [0] , 'BaseName': resource_elements [0] , 'PMetaType':['DMetaType'] , 'PObjectType':['DObjectType'] , 'Description':'This OT is a reified surrogate for an externally imported object' } )                            
                            domain_resource = resource_elements[1].replace('/','_slash_').replace(':','_colon_').replace('#','_hash_') + resource_elements [0]
                        # Domain is mapped to Left Role of RelationType
                        self.relationtype[ 'LRoles' ].append ( domain_resource )
        elif name == 'rdfs:range':
            if len ( self.stack ) > 0:
                if self.stack [ -1 ] == 'ObjectProperty':
                    self.stack.append ( 'ObjectPropertyRange' )            
                    if self.attributes.has_key ( 'rdf:resource' ):
                        # Parse the resource identifier to seperate URI and name components
                        resource_elements = self.parse_split ( self.attributes [ 'rdf:resource' ]  )
                        # Case where resource is from same document
                        if len ( resource_elements ) == 1:
                            range_resource = resource_elements [0]
                        # Case where resource is imported from external ontology
                        elif len ( resource_elements ) == 2:
                            self.safe_append ( self.objecttypes , { 'ID':resource_elements[1].replace('/','_slash_').replace(':','_colon_').replace('#','_hash_') + resource_elements [0] , 'BaseName': resource_elements [0] , 'PMetaType':['DMetaType'] , 'PObjectType':['DObjectType'] , 'Description':'This OT is a reified surrogate for an externally imported object' } )                            
                            range_resource = resource_elements[1].replace('/','_slash_').replace(':','_colon_').replace('#','_hash_') + resource_elements [0]
                        # Range is mapped to Righte of RelationType
                        self.relationtype[ 'RRoles' ].append ( range_resource )
                elif self.stack [ -1 ] == 'DatatypeProperty':
                    self.stack.append ( 'DatatypePropertyRange' )
                    if self.attributes.has_key ( 'rdf:resource' ):
                        # Parse the resource identifier to seperate URI and name components
                        resource_elements = self.parse_split ( self.attributes [ 'rdf:resource' ]  )
                        # The name portion of the resource string identifies the datatype
                        range_resource = resource_elements [0]
                        # Now update the datatype field of the AttributeType accordingly
                        self.attributetype [ 'Datatype' ] = range_resource
                        # self.attributetype [ 'Datatype' ] = convertDatatype ( range_resource )
        # This case will refer to object, relation and attribute  definitions
        elif name.find ( ':' ) == -1: # This is a very weak condition
            # Object Instantiation
            if self.attributes.has_key ( 'rdf:ID' ):
                self.stack.append ( 'Object' )            # Stack Marker Entry
                self._object [ 'ID' ] = self.attributes [ 'rdf:ID' ]
                self._object [ 'BaseName' ] = self.attributes [ 'rdf:ID' ]
                self._object [ 'ObjectTypes' ] = [ str ( name ) ]
                self._object [ 'Description' ] = ''
                self._object [ 'Mandatory' ] = []
                self._object [ 'Optional' ] = []
            elif len ( self.stack ) > 0:
                # Relation & Attribute reification
                # NOTE : Very weak condition is used here to distinguish between Relation and Attribute
                if self.stack [ -1 ] == 'Object':
                    # Case : Attribute
                    if self.attributes.has_key ( 'rdf:datatype' ):
                        self.stack.append ( 'Attribute' )
                        datatype_identifier = self.parse_split ( self.attributes [ 'rdf:datatype' ] )
                        self.attribute [ 'Object' ] = self._object [ 'ID' ]
                        self.attribute [ 'Datatype' ] = datatype_identifier [0]
                        self.attribute [ 'Name' ] = [ str ( name ) ]
                    # Case : Relation                        
                    else:
                        self.stack.append ( 'Relation' )                       
                        self.relation [ 'RelationType' ] = [ str ( name ) ]
                        self.relation [ 'LObjects' ] = [ self._object [ 'ID' ] ]
                        self.relation [ 'Participant' ] = ''
                        self.relation [ 'ParticipantType' ] = ''
                    if self.attributes.has_key ( 'rdf:resource' ):
                        resource_identifier = self.parse_split ( self.attributes [ 'rdf:resource' ] )
                        self.relation [ 'RObjects' ] = [ resource_identifier [0] ]
            

    def endElement ( self , name ):

        if name == 'owl:Class':
            if len ( self.stack ) > 0:
                # Only if class is being defined
                if self.stack [ -1 ] == 'ClassBeingDefined':
                    # self.objecttypes.append ( { 'ID':self.objecttype [ 'ID' ] , 'BaseName':self.objecttype [ 'BaseName' ] , 'PMetaType':self.objecttype [ 'PMetaType' ] , 'PObjectType':self.objecttype [ 'PObjectType' ] , 'Description':self.objecttype [ 'Description' ]  } )
                    self.objecttypes.append ( copy.deepcopy ( self.objecttype ) )
                    self.stack = self.stack [ : -1 ]             # Stack Marker Pop
                # self.stack = self.stack [ : -1 ] # Pop the 'Class' marker due to 'owl:Class'
        elif name == 'rdfs:comment':
            if len ( self.stack ) > 0:
                self.stack = self.stack [ : -1 ]             # Stack Marker Pop
        elif name == 'rdfs:subClassOf':
            if len ( self.stack ) > 0:
                self.stack = self.stack [ : -1 ]             # Stack Marker Pop
        elif name == 'owl:ObjectProperty':
            if len ( self.stack ) > 0:
                # Redundant checking here (Unnecessary asofnow...WOW a neologism....sibling to 'inasmuch' & 'insofar' )
                if self.stack [ -1 ] == 'ObjectProperty':
                    self.relationtypes.append ( copy.deepcopy ( self.relationtype ) )
                    self.stack = self.stack [ : -1 ]             # Stack Marker Pop
        elif name == 'owl:DatatypeProperty':
            if len ( self.stack ) > 0:
                # Redundant checking here (Unnecessary asofnow...WOW a neologism....sibling to 'inasmuch' & 'insofar' )
                if self.stack [ -1 ] == 'DatatypeProperty':
                    self.attributetypes.append ( copy.deepcopy ( self.attributetype ) )
                    self.stack = self.stack [ : -1 ]             # Stack Marker Pop
        elif name == 'rdf:type':
            if len ( self.stack ) > 0:
                if self.stack [ -1 ] == 'ObjectPropertyType':
                    self.stack = self.stack [ : -1 ]             # Stack Marker Pop
        elif name == 'rdfs:domain':
            if len ( self.stack ) > 0:
                if self.stack [ -1 ] == 'ObjectPropertyDomain':
                    self.stack = self.stack [ : -1 ]             # Stack Marker Pop
        elif name == 'rdfs:range':
            if len ( self.stack ) > 0:
                if self.stack [ -1 ] == 'ObjectPropertyRange' or self.stack [ -1 ] == 'DatatypePropertyRange':
                    self.stack = self.stack [ : -1 ]             # Stack Marker Pop
        elif name.find ( ':' ) == -1:
            if len ( self.stack ) > 0:
                if self.stack [ -1 ] == 'Object':
                    self.objects.append ( copy.deepcopy ( self._object ) )
                    self.stack = self.stack [ : -1 ]             # Stack Marker Pop
                elif self.stack [ -1 ] == 'Relation' and self.stack [ -2 ] == 'Object':
                    self.relation [ 'ID' ] = self.relation [ 'LObjects' ][0] + '_' + self.relation [ 'RelationType' ][0] + '_' + self.relation [ 'RObjects' ][0]
                    self.relation [ 'BaseName' ] = self.relation [ 'LObjects' ][0] + '_' + self.relation [ 'RelationType' ][0] + '_' + self.relation [ 'RObjects' ][0]                    
                    self.relations.append ( copy.deepcopy ( self.relation ) )
                    self.stack = self.stack [ : -1 ]             # Stack Marker Pop
                elif self.stack [ -1 ] == 'Attribute' and self.stack [ -2 ] == 'Object':
                    self._attributes.append ( copy.deepcopy ( self.attribute ) )
                    self.stack = self.stack [ : -1 ]             # Stack Marker Pop

                    

                    
    def characters ( self , content ):

        if len ( self.stack ) > 1 :
            if self.stack [ -1 ] == 'Comment' and self.stack [ -2 ] == 'ClassBeingDefined':
                self.objecttype [ 'Description' ] = str ( content )
            #elif self.stack [ -1 ] == 'Relation':
                #self.relation [ 'RObjects' ] = [ str ( content ) ]
            elif self.stack [ -1 ] == 'Attribute':
                if self.attribute [ 'Datatype' ] == 'positiveInteger':
                    self.attribute [ 'Value' ] = int ( content )
                    self.attribute [ 'Datatype' ] = 'int'
                elif self.attribute [ 'Datatype' ] == 'nonPositiveInteger':
                    self.attribute [ 'Value' ] = int ( content )
                    self.attribute [ 'Datatype' ] = 'int'                    
                elif self.attribute [ 'Datatype' ] == 'negativeInteger':
                    self.attribute [ 'Value' ] = int ( content )
                    self.attribute [ 'Datatype' ] = 'int'                    
                elif self.attribute [ 'Datatype' ] == 'nonNegativeInteger':
                    self.attribute [ 'Value' ] = int ( content )
                    self.attribute [ 'Datatype' ] = 'int'                    
                elif self.attribute [ 'Datatype' ] == 'int':
                    self.attribute [ 'Value' ] = int ( content )
                elif self.attribute [ 'Datatype' ] == 'long':
                    self.attribute [ 'Value' ] = long ( content )
                elif self.attribute [ 'Datatype' ] == 'short':
                    self.attribute [ 'Value' ] = int ( content )
                    self.attribute [ 'Datatype' ] = 'int'                    
                elif self.attribute [ 'Datatype' ] == 'unsignedInt':
                    self.attribute [ 'Value' ] = int ( content )
                    self.attribute [ 'Datatype' ] = 'int'                    
                elif self.attribute [ 'Datatype' ] == 'unsignedLong':
                    self.attribute [ 'Value' ] = long ( content )
                    self.attribute [ 'Datatype' ] = 'long'                   
                elif self.attribute [ 'Datatype' ] == 'unsignedShort':
                    self.attribute [ 'Value' ] = int ( content )
                    self.attribute [ 'Datatype' ] = 'int'                    
                elif self.attribute [ 'Datatype' ] == 'string':
                    self.attribute [ 'Value' ] = str ( content )
                elif self.attribute [ 'Datatype' ] == 'boolean':
                    self.attribute [ 'Value' ] = boolean ( content )
                elif self.attribute [ 'Datatype' ] == 'float':
                    self.attribute [ 'Value' ] = float ( content )
                elif self.attribute [ 'Datatype' ] == 'double':
                    self.attribute [ 'Value' ] = float ( content )
                    self.attribute [ 'Datatype' ] = 'float'

    def convertDatatype ( OWLDatatype ):

        if OWLDatatype == 'positiveInteger':
            return 'int'
        else:
            return OWLDatatype

    def processingInstruction ( self , target , data ):

        self.PI.append ( 'Processing Instruction:' + target + ' ' + data + '<br></br>' )

    def startPrefixMapping(self, prefix, uri):

        self.prefixes[prefix] = uri
        self.messages.append ( 'Entered prefix mapper' )

    def startElementNS(self, name, qname, attrs):

        self.messages.append ( 'startElementNS:' + name + 'NSqName:' + qname + '<br></br>' )


    def skippedEntity ( self , name ):

        self.skipped.append ( name + '<br></br>' )


    def parse_split ( self , resource_identifier ):
        
        resource_elements = []
        # Case I: External resource w/ abbreviated URL (identifier starts with '&' character)
        if resource_identifier [0] == '&':
            # self.messages.append ( 'Abbreviated Processing' + '<br></br>' )
            if ';' in resource_identifier:
                index = resource_identifier.find ( ';' )
                URLAbbrev = resource_identifier [ 1 : index ]
                resource = resource_identifier [ index + 1 : ]
                resource_elements = [ resource , URLAbbrev ]
        elif '#' in resource_identifier:
            # Case II: Resource within the same document
            if resource_identifier [0] == '#':
                # self.messages.append ( 'Resource Literal' + '<br></br>' )                
                resource = resource_identifier [ 1 : ]
                resource_elements = [ resource ]
                # self.messages.append ( 'Full string >>> ' + resource_identifier + '<br></br>' )
                # self.messages.append ( 'resource >>> ' + resource + '<br></br>' )
                # self.messages.append ( 'resource_elements [0] >>> ' + resource_elements [0] + '<br></br>' )                
            # Case III: External resource w/ full URL
            else:
                # self.messages.append ( 'Full URL' + '<br></br>' )
                index = resource_identifier.find ( '#' )
                # self.messages.append ( 'Full string >>> ' + resource_identifier + '<br></br>' )
                URL = resource_identifier [ : index ]
                resource = resource_identifier [ index + 1 : ]
                # self.messages.append ( 'resource >>> ' + resource + '<br></br>' )
                # self.messages.append ( 'URL  >>> ' + URL + '<br></br>' )
                resource_elements = [ resource , URL ]
        return resource_elements


    def safe_append ( self , collection , dictionary , primary_key = 'ID' ):

        """
        This function is used to ensure that no redundant (based on the supplied primary key) dictionary items are appended to the collection.
        """
        
        primary_key_value = dictionary [ primary_key ]
        Present = 0
        for eachElement in collection:
            if eachElement [ primary_key ] == primary_key_value:
                Present = 1
                break
        if Present != 1:
            collection.append ( dictionary )
    
    


class _dtdHandler ( xml.sax.handler.DTDHandler ):

    messages = []
    
    def notationDecl( self , name , publicId , systemId ):

        self.messages.append ( 'DTDNotation:' + name + ' publicID:' + publicID + ' systemID:' + systemID )

    def unparsedEntityDecl( self , name , publicId , systemId , ndata ):

        self.messages.append ( 'DTDUnparsedEntity:' + name + ' publicID:' + publicID + ' systemID:' + systemID )    



class _entityResolver ( xml.sax.handler.EntityResolver ):

    messages = []

    def resolveEntity ( self , publicID , systemID ):

        self.messages.append ( 'publicID=' + publicID + '  systemID=' + systemID )
        return systemID


# Constructor

def __init__ ( self ):

    self.GNOWSYSObject = self


# This method parses the OWL file and populates the GNOWSYS data objects

#def importOWLFile ( self , OWLFileName = '/tmp/wine.rdf' , TGZFileName = 'None' ):
def importOWLFile ( self , REQUEST ):

    dump = []
    try:
        OWLFileName = REQUEST [ 'OWLFileName' ]
        TGZFileName = REQUEST [ 'TGZFileName' ]
    except:
        OWLFileName = '/tmp/wine.rdf'
        TGZFileName = 'None'
    if OWLFileName == '':
        OWLFileName = '/tmp/wine.rdf'
    if TGZFileName == '':
        TGZFileName = 'None'
        
    if TGZFileName is not 'None':
        if os.path.exists(TGZFileName):
            TGZFilePath = CLIENT_HOME + '/GContent' + self.InstancePath		
            os.chdir(TGZFilePath)
            returnCode = os.system('tar -xvzf ' + TGZFileName )
            if returnCode != 0:
                return 'Error while extracting.....aborting import'
        else:
            dump.append ( 'No such file OR Permission denied' )
            
    contentHandler = _contentHandler ()
    dtdHandler = _dtdHandler ()
    entityResolver = _entityResolver ()
    saxParser = make_parser ()
    saxParser.setContentHandler ( contentHandler )
    saxParser.setDTDHandler ( dtdHandler )
    saxParser.setEntityResolver ( entityResolver )
    saxParser.parse ( OWLFileName )
    TMPFile = open ( '/tmp/OWLImportTMPFile' , 'w' )
    TMPFile.writelines ( contentHandler.messages )

    insertObjectTypes ( self , contentHandler )
    insertRelationTypes ( self , contentHandler )
    insertAttributeTypes ( self , contentHandler )
    insertObjects ( self , contentHandler )
    insertAttributes ( self , contentHandler )
    insertRelations ( self , contentHandler )
    # return dtdHandler.messages
    # return entityResolver.messages
    # return '<html><body>' + str ( contentHandler.objecttypes ) + '</html></body>'
    # return '<html><body>' + str ( contentHandler.relationtypes ) + '</html></body>'
    # return '<html><body>' + str ( contentHandler.attributetypes ) + '</html></body>'
    # return '<html><body>' + str ( contentHandler.objects ) + '</html></body>'
    # return '<html><body>' + str ( contentHandler.relations ) + '</html></body>'
    # return contentHandler.messages
    # return contentHandler.PI
    # return contentHandler.prefixes
    # return contentHandler.locator.getLineNumber ()
    # return contentHandler.contents
    # return contentHandler.skipped
    # return contentHandler.attributes
    REQUEST.RESPONSE.redirect( self.surl + '/OWLReplyImport' )


def insertObjectTypes ( self , reference ):
    
    dump = []
    for eachOT in reference.objecttypes:
        # Check for attempt to perform redundant addition on an instance
        if not idPresent ( self , eachOT [ 'ID' ] ):
            self.Data.ObjectType._setObject( eachOT [ 'ID' ] , ObjectType ( eachOT[ 'ID' ] , eachOT [ 'BaseName' ] , eachOT [ 'PMetaType' ] , eachOT [ 'PObjectType' ] , eachOT [ 'Description' ]  , [] , [] , [] , [] ) )
            # dump.append ( type ( eachOT [ 'PObjectType' ] ) )
            objectTypeRef = self.restrictedTraverse ( self.InstancePath + 'Data/ObjectType/' + eachOT [ 'ID' ] )
            objectTypeRef.index_object ()



def insertRelationTypes ( self , reference ):

    for eachRT in reference.relationtypes:
        if not idPresent ( self , eachRT [ 'ID' ] ):        
            # self.Data.RelationTypes._setObject ( eachRT [ 'ID' ] , AssocT (eachRT [ 'ID' ] , eachRT [ 'BaseName' ] , eachRT [ 'PMetaType' ] , eachRT [ 'LRoles' ]  , eachRT [ 'RRoles' ]  , eachRT [ 'Reflexive' ] , eachRT [ 'Transitive' ] , eachRT [ 'Symmetric' ] , eachRT [ 'Constraint' } , eachRT [ 'Necessary' ] , eachRT [ 'RoleType' ] , eachRT [ 'AltName' ] , eachRT [ 'InvName' ] , eachRT [ 'OTFlag' } ) )
            # Spot the difference between the above commented, error-producing line and the the clean one below. The one who does is granted the reward of the right to feel exhilarated since, ironically, the original developer <Paul mailto="paul@hbcse.tifr.res.in" /> could not find it
            self.Data.RelationTypes._setObject ( eachRT [ 'ID' ] , AssocT (eachRT [ 'ID' ] , eachRT [ 'BaseName' ] , eachRT [ 'RelMetaType' ] , eachRT [ 'LRoles' ] , eachRT [ 'RRoles' ] , eachRT [ 'Reflexive' ] , eachRT [ 'Transitive' ] , eachRT [ 'Symmetric' ] , eachRT [ 'Constraint' ] , eachRT [ 'Necessary' ] , eachRT [ 'RoleType' ] , eachRT [ 'AltName' ] , eachRT [ 'InvName' ] , eachRT [ 'OTFlag'] ) )
            relationTypeRef = self.restrictedTraverse ( self.InstancePath + 'Data/RelationTypes/' + eachRT [ 'ID' ] )
            relationTypeRef.index_object ()    



def insertAttributeTypes ( self , reference ):

    for eachAT in reference.attributetypes:
        if not idPresent ( self , eachAT [ 'ID' ] ):                
            self.Data.AttributeTypes._setObject( eachAT [ 'ID' ] , attributetype ( eachAT [ 'ID' ] , eachAT [ 'BaseName' ] , convertDatatype ( eachAT [ 'Datatype' ] ) , eachAT [ 'Description' ] , eachAT [ 'PMetaType' ] ) )
            attributeTypeID = self.restrictedTraverse ( self.InstancePath + 'Data/AttributeTypes/' + eachAT [ 'ID' ] )
            attributeTypeID.index_object ()
            self.Catalog.manage_addIndex ( eachAT [ 'ID' ] , 'TextIndex' )
            self.Catalog.manage_addColumn ( eachAT [ 'ID' ] )

def convertDatatype ( d ):

    if d == 'positiveInteger':
        return 'int'
    else:
        return d



def insertObjects ( self , reference ):

    ''' For inserting objects along with their attributes to GNOWSYS'''

    dump = [ 'Hello' + '<br></br>' ] #Message dump for debugging purposes
    # eachObject = reference.objects[0]
    for eachObject in reference.objects:
        if not idPresent ( self , eachObject [ 'ID' ] ):         
            self.Data.Objects._setObject( eachObject [ 'ID' ] , Object ( eachObject [ 'ID' ] , eachObject [ 'BaseName' ] , eachObject [ 'ObjectTypes' ] , eachObject [ 'Description' ] , eachObject [ 'Mandatory' ] , eachObject [ 'Optional' ] ) )
            objectRef = self.restrictedTraverse ( self.InstancePath + 'Data/Objects/' + eachObject [ 'ID' ] )
            objectRef.index_object ()
    # objectReference = self.Data.Objects._getObject( eachObject [ 'ID' ] )
    # I christen this locale as the 'Vale of Great Learning'
    # for here did I, on the 16th of April, 2004 A.D.,
    # learn a great many things, yea, even things of an
    # arcane nature
    # return dir ( ( dir ( self.Data.Objects ) ) [1] )



def insertAttributes ( self , reference ):

    for eachObject in reference.objects:
        for x in self.Catalog ():
            if x.id == eachObject [ 'ID' ] and x.meta_type == 'GObject':
                for eachAttribute in reference._attributes:
                    # dump.append ( 'Attribute  - Object' + '<br></br>' )
                    # dump.append ( str ( eachAttribute [ 'Name' ] ) + ' - ' + str ( eachAttribute [ 'Object' ] ) + '<br></br>' )
                    if eachAttribute [ 'Object' ] == eachObject [ 'ID' ]:
                        objectRef = self.restrictedTraverse ( self.InstancePath + 'Data/Objects/' + x.id )
                        attributeaddobj ( objectRef , eachAttribute [ 'Name' ] [ 0 ] , 'Mandatory' , eachAttribute [ 'Value' ] )



def insertRelations ( self , reference ):

    for eachRelation in reference.relations:
        if not idPresent ( self , eachRelation [ 'ID' ] ):        
            self.Data.Relations._setObject( eachRelation [ 'ID' ] , Assoc ( eachRelation [ 'ID' ] , eachRelation [ 'LObjects' ] , eachRelation [ 'RelationType' ] , eachRelation [ 'RObjects' ] , eachRelation [ 'BaseName' ] , eachRelation [ 'Participant' ] , eachRelation [ 'ParticipantType' ] ) )
            relationRef = self.restrictedTraverse ( self.InstancePath + 'Data/Relations/' + eachRelation [ 'ID' ] )
            relationRef.index_object ()



def idPresent ( self , id ):

    for eachElement in self.Catalog ():
        if eachElement.id == id:
            return 1
    return 0



# Prevent erroneous execution as standalone program

if __name__ == '__main__':
    print 'This module cannot be executed as an independent module'
