#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the 
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
#  Boston, MA 02111-1307 USA.
#
######################################################################
from Products.ZCatalog.CatalogPathAwareness import CatalogPathAware  #added by pranay
from OFS import SimpleItem
from Globals import DTMLFile,InitializeClass
from Products.ZCatalog import ZCatalog
from GNOWSYS import *
from listing import *
import string
from FunctionType import *
from tempfolder import *

class Function(ObjectManager,
           PropertyManager,
           RoleManager,
           Item,
           FindSupport,
	   CatalogPathAware,	#added by pranay
	   SimpleItem):

	""" Constraints to impose"""
	
	meta_type="GFunction"

	__ac_permissions__=(
        ('Manage Properties',('manage_addProperty',
                              'manage_editProperties',
                              'manage_delProperties',
                              'manage_changeProperties',
                              'Access content information')),
        )
       
	allowedmetatypes = ('DTML Method','DTML Document','Folder','Temporary Folder','User Folder')

    	def all_meta_types(self):
        	if hasattr(self, 'allowedmetatypes'):
            		result = []
            		import Products
            		for metaType in Products.meta_types:
                		if metaType['name'] in self.allowedmetatypes:
                    			result.append(metaType)
            				return result
        	else:
            		return Products.meta_types

	_properties= (
                {'id':'id', 'type':'string', 'mode':'r'},
                {'id':'title', 'type':'string', 'mode':'r'},
                {'id':'module','type':'string','mode':'r'},
                {'id':'Abouttypevar','type':'text','mode':'r'},
		{'id':'typevar','type':'string','mode':'w'},
		{'id':'Result','type':'string','mode':'r'},
		
                )

	manage_options =(
        	{'label': 'Contents', 'action': 'manage_main'},
		{'label':'Execute','action':'execfun'},
        	{'label': 'Simple Problem', 'action':'login'}, #callconstraint
        	{'label': 'Word Problem', 'action':'composition'},
        	{'label': 'EditConstraints', 'action':'manage_propertiesForm'},
		)

	def __init__(self,id,title,module,docu,typvar='',x='',y='',min_x='',max_x='',min_y='',max_y='',ul1='',ul2='',plist2=[]):
                """ Initialising the function type"""
		
                self.id=id                      #id of the object
                self.title=title                #title of the object
		self.module=module
		self.manage_addProperty('documentation',docu,'string')
		self.typevar=typvar
		self.Result=''
	
		for i in plist2:
			self.manage_addProperty(i,'','string') 

		if min_x!='' or ul1!='' :
			self.manage_addProperty('x',x,'string')
			self.manage_addProperty('min_x',min_x,'string')
			self.manage_addProperty('max_x',max_x,'string')
			self.manage_addProperty('userlist_x',ul1,'string')

		if min_y!='' or ul2!='':	
			self.manage_addProperty('y',y,'string')
			self.manage_addProperty('min_y',min_y,'string')
			self.manage_addProperty('max_y',max_y,'string')
                        self.manage_addProperty('userlist_y',ul2,'string')

		str1="Enter 'intg' or 'flot' or 'ulist' in typevar field to generate Integer values or Decimal numbers or user list respectively. If 'ulist' is selected then keep min and max fields empty and enter in the userlist field."
		self.Abouttypevar=str1
		
        def callconstraint(self,REQUEST=None,RESPONSE=None):
                	"To execute functions with constraints"
			a_user=REQUEST['name']		# To check logins and maintain apropriate records for each user.
			# print REQUEST
			wran=count=rtan=0
			if 'rtans' in REQUEST.keys() and 'wans' in REQUEST.keys():
				rtan=REQUEST['rtans']
				wran=REQUEST['wans']
				count=REQUEST['counter']
			a_user=tempfolder(count,rtan,wran)	# Object of tempfolder class in tempfolder.py
			REQUEST.set('name',REQUEST['name'])

                	if 'ans' in REQUEST.keys():
                        	if fpformat.fix(REQUEST['corrans'],2)==fpformat.fix(REQUEST['ans'],2): # to restrict the digits after decimal point
                                	res=REQUEST['name']+", your previous answer is correct"
					rtan=a_user.incrrcount()	# To increment for right answers
                        	else:
                                	res="Sorry "+REQUEST['name']+"!!!!!. Your previous answer is wrong.Correct answer is: "+fpformat.fix(REQUEST['corrans'],2)
					wran=a_user.incrwcount()	# To increment for wrong answers

                        	REQUEST.set('result','res')
				REQUEST.set('rtans',rtan)
				REQUEST.set('wans',wran)		
                	arg=self.propertyIds()
                	print arg	###
			cont={}
			tv=self.getProperty('typevar')		# To generate integer or decimal numbers
			print "tv =" + tv ###
                	for i in arg:
				#To display variable names only				
                        	if i not in ['id','title','module','typevar','documentation','userlist_x','userlist_y','Abouttypevar','Result']:
                                	if re.search('^min_',i)==None  and re.search('^max_',i)== None:
                                        	cont[i]=''
                	if cont=={} : 
				return "Provide min and max values for variables while instantiating function Object"###added by amit@crce
			if tv=='intg':
                        	for i in cont.keys():
                                	minv="min_"+i
					min=int(self.getProperty(minv))
					print "minv = " , min	, type(min)		
					maxv="max_"+i
		                  	max=int(self.getProperty(maxv))
					print "maxv = " , max , type(max)
					#To generate integer numbers in min-max range
                                	cont[i]=random.randint(min,max)
					print cont
                	elif tv=='flot':
                        	for i in cont.keys():
                                	minv="min_"+i
					min=float(self.getProperty(minv))
                                	print "minv = " , min , type(min)
					maxv="max_"+i
					max=float(self.getProperty(maxv))
					print "maxv = " , max , type(max)
					#To generate decimal numbers in min-max range
                                	cont[i]=float(fpformat.fix(random.uniform(min,max),2))
					#temp=random.uniform(min,max)
					#cont[i]=float(int(temp*100))/100
					print cont
			elif tv=='ulist':
                        	for i in cont.keys():
                        		ul1=[]
					str1='userlist_'+i
					ulist1=self.getProperty(str1)   #To obtain values for user created list passed from rangenum.dtml
					for j in string.split(ulist1,',',len(string.split(ulist1,','))):
						if string.find(j,'.')!=-1:
							ul1.append(float(j))
						else:
							ul1.append(int(j))
                                		#To generate numbers in user-list range
                                		cont[i]=random.choice(ul1)
                	REQUEST.set('contarg','cont')
			ans=self.executecustom(cont,REQUEST)		#This function executes the correct answer

			for i in cont.keys():
				if 'continue' in REQUEST.keys() and REQUEST['continue']!='Let this be my last question':
					self._updateProperty(string.replace(i,"'",""),cont[i])
					self._updateProperty('Result',ans)
		        REQUEST.set('corrans',ans)
                	if 'continue' in REQUEST.keys():
                        	#More questions then continue
                        	if REQUEST['continue']=='Check My Answer and Continue':
					no=a_user.incrcount()	#Increase counter for total number of questions
					REQUEST.set('qno',no)
					REQUEST.set('rtans',rtan)
                        		REQUEST.set('wans','wran')

					RESPONSE.redirect('operation?result=%s&contarg=%s&corrans=%s&rtans=%d&wans=%d&qno=%d&name=%s'%(res,cont,ans,rtan,wran,no,REQUEST['name']))
                        	# Stop the generation of questions
                        	else:
					a_user.calculate()	#To display the status (defined in tempfolder.py)
					REQUEST.set('rans',a_user.cans) #Correct answer
					REQUEST.set('wans',a_user.wrans)	#Wrong answer
					REQUEST.set('msg',a_user.msg)				
					REQUEST.set('tot',a_user.tot)
					REQUEST.set('result',res)
					RESPONSE.redirect('functionresult?rans=%s&wans=%s&tot=%s&result=%s&msg=%s&name=%s'%(a_user.cans,a_user.wrans,a_user.tot,res,a_user.msg,REQUEST['name']))
			else:
				no=a_user.incrcount()

				REQUEST.set('qno',no)
				RESPONSE.redirect('operation?contarg=%s&corrans=%s&qno=%d&rtans=%d&wans=%d&name=%s'%(cont,ans,no,rtan,wran,REQUEST['name']))
	
	def __call__(self,*args):
		pass

	def executecustom(self,cont,REQUEST,RESPONSE=None):
		"""To evaluate  the answer"""
		mod=self.getProperty('module')
                if mod=='umaths':
                	mod='umath'
                if mod=='maths':
                        mod='math'   
                if mod=='cmaths':
                        mod='cmath'
                title=self.getProperty('title')
                evalst=compile('import '+mod,'','single') # Importing the module
                exec evalst
                name=mod+'.'+title
                lis=[]
		if 'cont' not in REQUEST.keys():
			for i in cont.values():
                		lis.append(i)
		else:
			lis.append(REQUEST['x'])
			if 'y' in REQUEST.keys():
				lis.append(REQUEST['y'])
			
                args=tuple(lis)     #Appending the values to function into a tuple for "apply"
		print args
		evalfun=compile('ans=apply('+name+','+str(args)+')','','single')  #Calling func with args
                exec evalfun
		if type(ans)==type(3.14):
			ans=fpformat.fix(ans,2)
		else:
			ans=str(ans)
		#return '<html>'+ans+'</html>'
		tp=ans
		return tp

	def compexe(self,REQUEST,RESPONSE):
		"""This is called for execution of word problems"""
		cont=''
		ans=self.executecustom(cont,REQUEST)
		if float(ans)!=float(REQUEST['ans1']):
			msg="Your answer is wrong."
		else:
			msg="Your answer is correct."
		return '<html><body bgcolor="99ccff"><br><b>'+msg+'<br><br>Correct answer is:'+str(ans)+'<br><form action="composition"><input type="submit" value="Continue"></form><form action="manage_main"><input type="submit" value="Done"></form></body></html>'

	def DelFunO(self,REQUEST,RESPONSE=None):
        	"""Delete the custom object"""
               	id=REQUEST['id']
		PATH=self.InstancePath
		for each in self.Catalog():
			if each.meta_type=='GFunction':
				if each.id==id:
					funref=self.restrictedTraverse(PATH+'PBase/Custom/').manage_delObjects(id)
					self.unindex_object() 
		nm="Function" 
		REQUEST.set('newnm',nm)
                REQUEST.set('newid',id)
                REQUEST.RESPONSE.redirect(REQUEST['URL2']+'/Programs/replydelete?newid=%s&newnm=%s' % (id,nm))
	        
        def updateFun(self,REQUEST,RESPONSE=None):
                """Update the properties"""
                for key in REQUEST.form.keys():
                        self._updateProperty(key,REQUEST.form[key])
               		self.reindex_object()	#added by pranay
                REQUEST.set('newid','Function')
                REQUEST.set('newname',self.id)
                RESPONSE.redirect('confirmUpdate?newid=%s&newname=%s'%(self.id,'Function'))

  	composition=DTMLFile('pdtml/composition',globals())
	operation=DTMLFile('pdtml/operation',globals())
	functionresult=DTMLFile('pdtml/functionresult',globals())
	login=DTMLFile('pdtml/login',globals())
        changeFunProp=DTMLFile('pdtml/changeFunProp',globals())
        confirmUpdate=DTMLFile('pdtml/confirmUpdate',globals())
	inputPage=DTMLFile('pdtml/inputPage',globals())
	execfun=DTMLFile('pdtml/execfun',globals())

def manage_Function(dispatcher,id,title,RESPONSE,REQUEST=None):
     "Add a custom object to a folder."
     #it seems that this function is never called also manage_addFunction.dtml file is useless.(by pranay)	
     dest=dispatcher.Destination()
     ul=""
     a=string.replace(REQUEST['allprop'],'[','')
     b=string.replace(a,']','')
     dic={}
     for c in string.split(b,'),',len(string.split(b,'),'))):
	c=string.replace(c,'(','')
	c=string.replace(c,')','')
	d=string.split(c,',',1)
	d[0]=string.replace(d[0],"'",'')
	d[1]=string.replace(d[1],"'",'')
	d[0]=string.replace(d[0],' ','')
	if d[0]!='documentation':	#To remove space from args except documentation
		d[1]=string.replace(d[1],' ','')
	dic[d[0]]=d[1]
     id=REQUEST['id']     #Takes new id from the user,remaining properties remain the same
     REQUEST.set('newname','id')		
     title=dic['title']
     module=dic['module']
     docu=REQUEST['docs']
     typvar=dic['typevar']
     x=y=min_x=min_y=max_x=max_y=userlist_x=userlist_y=''
     if 'x'in dic.keys():	#Creating new properties x,y,min_x,min_y,max_x,max_y
     	x=dic['x']
	if 'min_x' in dic.keys() and dic['min_x']!='':
		min_x=dic['min_x']
		max_x=dic['max_x']
	else:
		userlist_x=dic['userlist_x']
     if 'y' in dic.keys():	
	y=dic['y']
	if 'min_y' in dic.keys() and dic['min_y']!='':
		min_y=dic['min_y']
		max_y=dic['max_y']
	else:
		userlist_y=dic['userlist_y']
     # Creating a new object containing constraint defined by the user, which will be stored in Custom folder		
     dest.PBase.Custom._setObject(id,Function(id,title,module,docu,typvar,x,y,min_x,max_x,min_y,max_y,userlist_x,userlist_y))
     phyurl=dispatcher.InstancePath	#added by pranay
     funref=dispatcher.restrictedTraverse(phyurl+'/PBase/Custom/'+id)#added by pranay
     funref.index_object()		 	#added by pranay
     if REQUEST is not None:
     	try:    url=dispatcher.DestinationURL()
        except: url=REQUEST['URL1']
	vname='Function'
	REQUEST.set('newid',vname)
        REQUEST.RESPONSE.redirect(url+'/Programs/confirm?newname=%s&newid=%s' % (id,vname))
	
manage_addFunction=DTMLFile('pdtml/manage_addFunction',globals())
InitializeClass(Function)
