#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the 
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
#  Boston, MA 02111-1307 USA.
######################################################################

from OFS.SimpleItem import Item
from OFS.PropertyManager import PropertyManager
from OFS.FindSupport import FindSupport

from AccessControl.Role import RoleManager
from AccessControl import ClassSecurityInfo

from Globals import Persistent
from Globals import InitializeClass, DTMLFile

from Products.ZCatalog.CatalogAwareness import CatalogAware

# here the import statement is added by Chitra
from Products.PageTemplates.ZopePageTemplate import ZopePageTemplate

import string

# the ZopePageTemplate is added instead of the ObjectManager, PropertyManager, RoleManager & Item by Chitra

class CatRel(ZopePageTemplate,
                  FindSupport,
                  CatalogAware):
    """
    MetaType Relation  impelementation
    """

    meta_type = "GMetaTypeRelation"
  
    _properties = (
        {'id':'BaseName', 'type': 'string', 'mode': 'rw'},
        {'id':'LRoles', 'type': 'lines', 'mode': 'rw'},
        {'id':'RRoles', 'type': 'lines', 'mode': 'rw'},
	{'id':'Reflexive','type':'string','mode':'rw'},
	{'id':'Transitive','type':'string','mode':'rw'},
	{'id':'Symmetric','type':'string','mode':'rw'},
        {'id':'CFlag','type':'string','mode':'rw'},
      ) 

    def __init__(self,id,BaseName,LRoles,RRoles,Reflexive,Transitive,Symmetric,cflag):
        self.id=id
	self.BaseName=BaseName  
        self.LRoles=LRoles
        self.RRoles=RRoles
	self.Reflexive = Reflexive
	self.Transitive = Transitive
	self.Symmetric = Symmetric
	self.CFlag = cflag
     
    manage_options = (
        ) + ZopePageTemplate.manage_options
    
    def editCategoricalRelation(self,REQUEST,RESPONSE,URL1,URL2):
        """
        Edits the object requested
        """
        BaseName=REQUEST['BaseName']
        self._updateProperty('BaseName',BaseName)

        Reflexive = REQUEST['Reflexive']
        self._updateProperty('Reflexive',Reflexive)
        Symmetric = REQUEST['Symmetric']
        self._updateProperty('Symmetric',Symmetric)
        Transitive = REQUEST['Transitive']
        self._updateProperty('Transitive',Transitive)

	self.reindex_object()

        nm="MetaTypeRelation"
	REQUEST.set('newnm',nm)
	REQUEST.set('newid',BaseName)

	REQUEST.RESPONSE.redirect(self.surl + '/Programs/replyedit?newid=%s&newnm=%s' % (BaseName,nm))

    def DelCatRel(self,REQUEST,RESPONSE,URL1,URL2):
        """
        Deletes the requested categorical relation
        """
        id=REQUEST['id']
        BaseName=REQUEST['BaseName']

	self.Data.MetaTypeRelations.manage_delObjects(id)

	self.unindex_object()

        nm="MetaTypeRelation"
	REQUEST.set('newnm',nm)
	REQUEST.set('newid',BaseName)
	REQUEST.RESPONSE.redirect(self.surl + '/Programs/replydelete?newid=%s&newnm=%s' % (BaseName,nm))
 
    def strconv(self,temp):
        """
        Converts tokens to strings
        """
        a=string.join(temp)
        return a

# Factory methods

manage_addnewCatRelForm = DTMLFile('dtml/addnewcatrelform', globals())

def manage_addnewCatRel(dispatcher, id, REQUEST=None):
    """
    Add New RelationType object
    """

    dest = dispatcher.Destination()
    ur=dest.absolute_url()

    id = string.replace(id,' ','')
    
    Path=ur+'/Data/MetaTypeRelations/'+id

    id = string.replace(str(id),' ','_')

    dummyflag = REQUEST['hcatrelbtw']

    if dummyflag == '1':
	 cflag = 'COT' ##then default one-many##
    elif dummyflag == '2':
	cflag ='OTC' ##then default many-one##
    else :
	cflag ='CC'  	

    BaseName = REQUEST['BaseName']
    if len(BaseName)==0:
       BaseName = REQUEST['id']	

    RRoles = REQUEST['RRoles']
    LRoles = REQUEST['LRoles']

    Reflexive = REQUEST['Reflexive']
    Symmetric = REQUEST['Symmetric']
    Transitive = REQUEST['Transitive']

    dest.Data.MetaTypeRelations._setObject(id,CatRel(id,BaseName,LRoles,RRoles,Reflexive,Transitive,Symmetric,cflag))

    CRPATH = dispatcher.InstancePath + 'Data/MetaTypeRelations/' + id
    catRelRef = dest.restrictedTraverse( CRPATH )
    catRelRef.index_object()

    nm="MetaTypeRelation"    
    REQUEST.set('newnm',nm)
    REQUEST.set('newid',BaseName)
       
    REQUEST.RESPONSE.redirect(dest.surl + '/Programs/replyadd?newid=%s&newnm=%s' % (BaseName,nm))

InitializeClass(CatRel)
