#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 3 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (COPYING); if not, write to the 
#  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, 
#  Boston, MA  02110-1301  USA59 Temple Place, Suite 330, 
#
######################################################################

__author__ = """Nagarjuna <nagarjun@gnowledge.org>"""
__docformat__ = 'plaintext'

import os.path
import sys
from StringIO import StringIO
from sets import Set
from App.Common import package_home
from Products.CMFCore.utils import getToolByName
from Products.CMFCore.utils import manage_addTool
from Products.ExternalMethod.ExternalMethod import ExternalMethod
from zExceptions import NotFound, BadRequest

from Products.Archetypes.Extensions.utils import installTypes
from Products.Archetypes.Extensions.utils import install_subskin
from Products.Archetypes.config import TOOL_NAME as ARCHETYPETOOLNAME
from Products.Archetypes.atapi import listTypes
from Products.gnowsysApp.config import PROJECTNAME
from Products.gnowsysApp.config import product_globals as GLOBALS

def install(self, reinstall=False):
    """ External Method to install gnowsysApp """
    out = StringIO()
    print >> out, "Installation log of %s:" % PROJECTNAME

    # If the config contains a list of dependencies, try to install
    # them.  Add a list called DEPENDENCIES to your custom
    # AppConfig.py (imported by config.py) to use it.
    try:
        from Products.gnowsysApp.config import DEPENDENCIES
    except:
        DEPENDENCIES = []
    portal = getToolByName(self,'portal_url').getPortalObject()
    quickinstaller = portal.portal_quickinstaller
    for dependency in DEPENDENCIES:
        print >> out, "Installing dependency %s:" % dependency
        quickinstaller.installProduct(dependency)
        get_transaction().commit(1)

    classes = listTypes(PROJECTNAME)
    installTypes(self, out,
                 classes,
                 PROJECTNAME)
    install_subskin(self, out, GLOBALS)


    # try to call a workflow install method
    # in 'InstallWorkflows.py' method 'installWorkflows'
    try:
        installWorkflows = ExternalMethod('temp', 'temp',
                                          PROJECTNAME+'.InstallWorkflows',
                                          'installWorkflows').__of__(self)
    except NotFound:
        installWorkflows = None

    if installWorkflows:
        print >>out,'Workflow Install:'
        res = installWorkflows(self,out)
        print >>out,res or 'no output'
    else:
        print >>out,'no workflow install'




    from Products.gnowsysApp.config import STYLESHEETS
    try:
        portal_css = getToolByName(portal, 'portal_css')
        for stylesheet in STYLESHEETS:
            try:
                portal_css.unregisterResource(stylesheet['id'])
            except:
                pass
            defaults = {'id': '',
            'media': 'all',
            'enabled': True}
            defaults.update(stylesheet)
            portal_css.registerStylesheet(**defaults)
    except:
        # No portal_css registry
        pass
    from Products.gnowsysApp.config import JAVASCRIPTS
    try:
        portal_javascripts = getToolByName(portal, 'portal_javascripts')
        for javascript in JAVASCRIPTS:
            try:
                portal_javascripts.unregisterResource(javascript['id'])
            except:
                pass
            defaults = {'id': ''}
            defaults.update(javascript)
            portal_javascripts.registerScript(**defaults)
    except:
        # No portal_javascripts registry
        pass

    # try to call a custom install method
    # in 'AppInstall.py' method 'install'
    try:
        install = ExternalMethod('temp', 'temp',
                                 PROJECTNAME+'.AppInstall', 'install')
    except NotFound:
        install = None

    if install:
        print >>out,'Custom Install:'
        try:
            res = install(self, reinstall)
        except TypeError:
            res = install(self)
        if res:
            print >>out,res
        else:
            print >>out,'no output'
    else:
        print >>out,'no custom install'

    
    inspath = self.portal_url()
    splitpath = inspath.split('/')
    insname = str(splitpath[-1])
    

    Gno_data_path = CLIENT_HOME + "/GContent/" + insname  + "/kb/data/"
    subdirs = ["gbnidinidtable","gbmetatypes","gbobjecttypes","gbobjects","gbrelations","gbrelationtypes","gbattributes","gbattributetypes","gbprocess","gbprocesstypes","gbsystem","gbsystemtypes","gbfunctiontypes","gbclasstypes","gbclass","gbflowtypes","gbflows", "gbusers", "gbusertypes"]
    for each in subdirs:
        if not(os.path.exists(Gno_data_path + each)):
            os.makedirs(Gno_data_path + each)
    


    path = INSTANCE_HOME + '/Products/gnowsysApp/Extensions/DB_connectionString.txt'
    os.system('cp'+' '+path+' '+'/tmp/')
    os.system('cd /tmp/')
    fp = open('/tmp/DB_connectionString.txt')
    conparam = []
    for line in fp.readlines():
        conparam = line.split(':')
    conString = conparam[0]+' '+conparam[1]+' '+conparam[2]+' '+conparam[3]+' '+conparam[4]


    self.manage_addProduct['LocalFS'].manage_addLocalFS('Data', '', Gno_data_path)
    
    self.manage_addProduct['ZPsycopgDA'].manage_addZPsycopgConnection('dbadapter', 'Connection to PG', 'dbname=', zdatetime=None, tilevel=2, check=None, REQUEST=None)
    
    

    self.dbadapter.connection_string = conString
    self.dbadapter.encoding = 'UTF-8'
    self.dbadapter.manage_open_connection()


    self.invokeFactory('gnowQL', 'gnowql')


    dictParameters = {
        'nid':'gnowsysusers',
        'uid':'1',
        'status':'Public',
        'content':"User Type for gnowsys",
        'subtypeof':[],
        'title':['gnowsysusers'],
        'description':'UserType For Gnowsys'
                    }
    self.gnowql.manageAddUserType( dictParameters )


    extMethod = ExternalMethod('displaytree','Tree Structure Logic','gnowsysApp.DisplayTree','drive')
    self._setObject('displaytree',extMethod)

    extMethod = ExternalMethod('testmd5sum','Generating md5sum of user password','gnowsysApp.addData','passenc')
    self._setObject('testmd5sum',extMethod)

    extMethod = ExternalMethod('createFile','Creating Files at FileSystem','gnowsysApp.addData','createFile')
    self._setObject('createFile',extMethod)

    extMethod = ExternalMethod('getFileInfo','Gets information regarding the files','gnowsysApp.addData','getFileInfo')
    self._setObject('getFileInfo',extMethod)


    # Creating the custom portal_tabs

    actionsTool = getToolByName(self, 'portal_actions')
    actionsTool.addAction('objecttypes',
                          name='ObjectTypes',
                          action='string:${globals_view/navigationRootUrl}/objecttypes/',
                          condition='',
                          permission='View',
                          category='portal_tabs',
                          visible=1,
                          )

    return out.getvalue()

def uninstall(self, reinstall=False):
    out = StringIO()



    # try to call a workflow uninstall method
    # in 'InstallWorkflows.py' method 'uninstallWorkflows'
    try:
        uninstallWorkflows = ExternalMethod('temp', 'temp',
                                            PROJECTNAME+'.InstallWorkflows',
                                            'uninstallWorkflows').__of__(self)
    except NotFound:
        uninstallWorkflows = None

    if uninstallWorkflows:
        print >>out, 'Workflow Uninstall:'
        res = uninstallWorkflows(self, out)
        print >>out, res or 'no output'
    else:
        print >>out,'no workflow uninstall'

    # try to call a custom uninstall method
    # in 'AppInstall.py' method 'uninstall'
    try:
        uninstall = ExternalMethod('temp', 'temp',
                                   PROJECTNAME+'.AppInstall', 'uninstall')
    except:
        uninstall = None

    if uninstall:
        print >>out,'Custom Uninstall:'
        try:
            res = uninstall(self, reinstall)
        except TypeError:
            res = uninstall(self)
        if res:
            print >>out,res
        else:
            print >>out,'no output'
    else:
        print >>out,'no custom uninstall'

    return out.getvalue()

def beforeUninstall(self, reinstall, product, cascade):
    """ try to call a custom beforeUninstall method in 'AppInstall.py'
        method 'beforeUninstall'
    """
    out = StringIO()
    try:
        beforeuninstall = ExternalMethod('temp', 'temp',
                                   PROJECTNAME+'.AppInstall', 'beforeUninstall')
    except:
        beforeuninstall = []

    if beforeuninstall:
        print >>out, 'Custom beforeUninstall:'
        res = beforeuninstall(self, reinstall=reinstall
                                  , product=product
                                  , cascade=cascade)
        if res:
            print >>out, res
        else:
            print >>out, 'no output'
    else:
        print >>out, 'no custom beforeUninstall'
    return (out,cascade)

def afterInstall(self, reinstall, product):
    """ try to call a custom afterInstall method in 'AppInstall.py' method
        'afterInstall'
    """
    out = StringIO()
    try:
        afterinstall = ExternalMethod('temp', 'temp',
                                   PROJECTNAME+'.AppInstall', 'afterInstall')
    except:
        afterinstall = None

    if afterinstall:
        print >>out, 'Custom afterInstall:'
        res = afterinstall(self, product=None
                               , reinstall=None)
        if res:
            print >>out, res
        else:
            print >>out, 'no output'
    else:
        print >>out, 'no custom afterInstall'
    return out
