#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 3 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (COPYING); if not, write to the
#  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#  Boston, MA  02110-1301  USA59 Temple Place, Suite 330,
#
######################################################################
__docformat__ = 'plaintext'

import string
import os, sys
import xmlrpclib
import pprint, pickle
import cPickle


def addOT(self):
    
    """
    Creating ObjectTypes For SELF-Platform
    """
    os.system('cp /var/lib/zope2.9/instance/plone-site/Products/selfApp/Extensions/SCORMTables.txt /tmp/')
    file = open('/tmp/SCORMTables.txt')
    for line in file.readlines():
        if line == '\n' or len(line.split(','))==1:
            pass
        else:
            line = line.replace('\n','')
            array = line.split(',')

            # Creating Dict
            
            nid = array[0].replace(' ','')
            title=array[0]
            alttitle=array[1]            
            description=array[2]
            instanceOf=array[4]
            subTypeOf=array[5]

            instanceof = []
            
            if nid == 'SCO' or nid == 'Bookshelf':
                dictParameters = {
                    'nid':nid,
                    'uid':'1',
                    'status':'Public',
                    'content':'',
                    'subtypes':[],
                    'noofcommits':'0',
                    'subtypeof':[],
                    'title':[title,alttitle],
                    'instanceof':[],
                    'relations':[],
                    'noofchangesaftercommit':'0',
                    'instances':[],
                    'description':description,
                    'attributes':[],
                    'relationtypes':[],
                    'history':[0],
                    'attributetypes':[]
                    
                    }

            else:
                dictParameters = {
                    'nid':nid,
                    'uid':'1',
                    'status':'Public',
                    'content':'',
                    'subtypes':[],
                    'noofcommits':'0',
                    'subtypeof':[subTypeOf],
                    'title':[title,alttitle],
                    'instanceof':instanceof,
                    'relations':[],
                    'noofchangesaftercommit':'0',
                    'instances':[],
                    'description':description,
                    'attributes':[],
                    'relationtypes':[],
                    'history':[0],
                    'attributetypes':[]
                    
                    }
            
            self.gnowql.manageAddObjectType( dictParameters )
            print "Added ---", nid
            
    return "Success"

def addAT(self):
    
    """
    Creating AttributeTypes For SELF-Platform
    """
    os.system('cp /var/lib/zope2.9/instance/plone-site/Products/selfApp/Extensions/SCORMAttributeTypes.txt /tmp/')
    file = open('/tmp/SCORMAttributeTypes.txt')
    for line in file.readlines():
        if line == '\n' or len(line.split(','))==1:
            pass
        else:
            line = line.replace('\n','')
            array = line.split(',')
            print array
            
            # Creating Dict
            
            nid = array[0].replace(' ','')
            title=array[0]
            description=array[1]
            status = array[2]
            datatype=array[3]
            subjecttypes=array[4]
            print "RECORD ::: ",nid, "--", title, "---", description, "---", datatype, "---", subjecttypes
            
            print subjecttypes
            
            subTypeOf=[]
            
            dictParameters = {
                'nid':nid,
                'uid':'1',
                'status':status,
                'content':'',
                'subtypeof':[],
                'title':[title],
                'description':description,
                'datatype':datatype,
                'subjecttypes':[subjecttypes]
                }

            print dictParameters
            self.gnowql.manageAddAttributeType( dictParameters )
            print "Added ---", nid
            
    return "Success"


def addLOMAT(self):
    
    """
    Creating AttributeTypes For SELF-Platform
    """
    os.system('cp /var/lib/zope2.9/instance/plone-site/Products/selfApp/Extensions/SCORMLOMMetadata.txt /tmp/')
    file = open('/tmp/SCORMLOMMetadata.txt')
    for line in file.readlines():
        if line == '\n' or len(line.split(','))==1:
            pass
        else:
            line = line.replace('\n','')
            array = line.split(',')
            print array
            
            # Creating Dict
            
            nid = array[0]
            title=array[1]
            alttitle=array[2]
            description=array[3]
            status = array[4]
            datatype=array[5]
            subjecttypes=array[6]
            print "RECORD ::: ",nid, "--", title, "---", description, "---", datatype, "---", subjecttypes
            
            print subjecttypes
            
            subTypeOf=[]
            
            dictParameters = {
                'nid':nid,
                'uid':'1',
                'status':status,
                'content':'',
                'subtypeof':[],
                'title':[title,alttitle],
                'description':description,
                'datatype':datatype,
                'subjecttypes':[subjecttypes]
                }

            print dictParameters
            self.gnowql.manageAddAttributeType( dictParameters )
            print "Added ---", nid
            
    return "Success"


def addSEQAT(self):
    
    """
    Creating AttributeTypes For SELF-Platform
    """
    os.system('cp /var/lib/zope2.9/instance/plone-site/Products/selfApp/Extensions/SCORMSEQMetadata.txt /tmp/')
    file = open('/tmp/SCORMSEQMetadata.txt')
    for line in file.readlines():
        if line == '\n' or len(line.split(','))==1:
            pass
        else:
            line = line.replace('\n','')
            array = line.split(',')
            print array
            
            # Creating Dict
            
            nid = array[0]
            title=array[1]
            alttitle=array[2]
            description=array[3]
            status = array[4]
            datatype=array[5]
            subjecttypes=array[6]
            print "RECORD ::: ",nid, "--", title, "---", description, "---", datatype, "---", subjecttypes
            
            print subjecttypes
            
            subTypeOf=[]
            
            dictParameters = {
                'nid':nid,
                'uid':'1',
                'status':status,
                'content':'',
                'subtypeof':[],
                'title':[title,alttitle],
                'description':description,
                'datatype':datatype,
                'subjecttypes':[subjecttypes]
                }

            print dictParameters
            self.gnowql.manageAddAttributeType( dictParameters )
            print "Added ---", nid
            
    return "Success"

def addMANIFESTAT(self):
    
    """
    Creating AttributeTypes For SELF-Platform
    """
    os.system('cp /var/lib/zope2.9/instance/plone-site/Products/selfApp/Extensions/SCORMManifest.txt /tmp/')
    file = open('/tmp/SCORMManifest.txt')
    for line in file.readlines():
        if line == '\n' or len(line.split(','))==1:
            pass
        else:
            line = line.replace('\n','')
            array = line.split(',')
            print array
            
            # Creating Dict
            
            nid = array[0]
            title=array[1]
            alttitle = array[2]
            description=array[3]
            status = array[4]
            datatype=array[5]
            subjecttypes=array[6]
            print "RECORD ::: ",nid, "--", title, "---", description, "---", datatype, "---", subjecttypes
            
            print subjecttypes
            
            subTypeOf=[]
            
            dictParameters = {
                'nid':nid,
                'uid':'1',
                'status':status,
                'content':'',
                'subtypeof':[],
                'title':[title,alttitle],
                'description':description,
                'datatype':datatype,
                'subjecttypes':[subjecttypes]
                }

            print dictParameters
            self.gnowql.manageAddAttributeType( dictParameters )
            print "Added ---", nid
            
    return "Success"


def addRT(self):
    
    """
    Creating AttributeTypes For SELF-Platform
    """
    os.system('cp /var/lib/zope2.9/instance/plone-site/Products/selfApp/Extensions/SCORMRelationTypes.txt /tmp/')
    file = open('/tmp/SCORMRelationTypes.txt')
    for line in file.readlines():
        if line == '\n' or len(line.split(','))==1:
            pass
        else:
            line = line.replace('\n','')
            array = line.split(',')

            # Creating Dict
            
            nid = array[0]
            uid = '1'         
            title=array[1]
            inversename=array[2]
            description=array[3]
            status = array[4]
            role1=array[5]
            role2=array[6]
            
            dictParameters = {
                'nid':nid,
                'uid':'1',
                'status':status,
                'content':'',
                'title':[title],
                'inversename':[inversename],
                'description':description,
                'role1':[role1],
                'role2':[role2]
                }

            print dictParameters
            self.gnowql.manageAddRelationType( dictParameters )
            print "Added ---", nid
            
    return "Success"

def addUserType(self):
    """
    importing all usertypes from beta version of SELF-Platform
    """
    listofUT = []
    con = xmlrpclib.Server('http://beta.selfplatform.eu/selfbeta/kb')
    listofUT = con.getAll('userType')

    for x in listofUT:

        dictParameters = {
            'nid':x,
            'uid':'1',
            'status':'Public',
            'content':"<p align=justify><b>User Types </b></p>",
            'subtypeof':[],
            'title':[x],
            'description':'<b>UserType For SELF</b>'
            }
        
        self.gnowql.manageAddUserType( dictParameters )
        print "Added ---:", x

    return "success"

def addLanguage(self):
    """
    Adding Languages to SELF-Platform
    """

    os.system('cp /var/lib/zope2.9/instance/plone-site/Products/selfApp/Extensions/Languages.txt /tmp/')
    file = open('/tmp/Languages.txt')
    for line in file.readlines():
        if len(line.split(' '))>2:
            id = line.split(' ')[0].lower() + line.split(' ')[1].lower()
            title = line.split(' ')[0] + ' ' + line.split(' ')[1]
            shortname = line.split(' ')[2]
        else:
            id = line.split(' ')[0].lower()
            title = line.split(' ')[0]
            shortname = line.split(' ')[1]

        dictParameters = {
            'nid':id,
            'uid':'1',
            'status':'Public',
            'content':"",
            'title':[title,shortname],
            'description':'',
            'instanceof':['Languages']
            }
        self.gnowql.manageAddObject( dictParameters )
        print "Added Language is -->  ", title

    return "Done !"
            
def passenc(password):
    try:
        fp = open('/tmp/pass.txt','w')
        fp.write(password)
    except:
        print "cant write"

    fp.close()
    
    os.system('md5sum -t /tmp/pass.txt > /tmp/new.txt')
    try:
        fp1 = open('/tmp/new.txt','r')
        encpass = fp1.readline()
    except:
        print "cant read"

    
    fp1.close()

    return encpass.split(" ")[0]

def addUser(self):
    """
    importing all users from beta version of SELF-Platform
    """
    listofU = []
    con = xmlrpclib.Server('http://beta.selfplatform.eu/selfbeta/kb')
    listofU = con.getAll('users')
    
    print listofU
    
    for x in listofU:
        title = con.getNeighbourhood(x,'users',['title'])[0]
        email = con.getNeighbourhood(x+'.email','attribute',['value'])[0]
        password = con.getUserPassword(x)
        passw = passenc(password)
        dictParameters = {
            'username':x,
            'fullname':title,
            'password':passw,
            'email':email,
            'content':"Members of SELF-Platform",
            'title':[title],
            'description':'Authenticated User of SELF-Platform',
            'instanceof':['selfusers']
            }
        
        self.gnowql.manageAddUser( dictParameters )
        print "Added USER   ---: ", x, passw

    return "success"



def addUserInPlone(self):

    listofU = []
    con = xmlrpclib.Server('http://beta.selfplatform.eu/selfbeta/kb')
    listofU = con.getAll('users')
    
    print listofU
    listofUINFO = ""
    fps = open('/tmp/userrec.txt','w')
    for x in listofU:
        username = x
        fullname = con.getNeighbourhood(x,'users',['title'])[0]
        email = con.getNeighbourhood(x+'.email','attribute',['value'])[0]
        pass1 = con.getUserPassword(x)
        listofUINFO = username+','+pass1+','+fullname+','+email+'\n'
        fps.write(listofUINFO)
        print listofUINFO
        
    fps.close()      
    return "Successfully created"

    


def passenc1(self,password):
    try:
        fp = open('/tmp/pass.txt','w')
        fp.write(password)
    except:
        print "cant write"

    fp.close()
    
    os.system('md5sum -t /tmp/pass.txt > /tmp/new.txt')
    try:
        fp1 = open('/tmp/new.txt','r')
        encpass = fp1.readline()
    except:
        print "cant read"

    
    fp1.close()

    return encpass.split(" ")[0]

def addCourseCategory(self):

    con = xmlrpclib.Server('http://beta.selfplatform.eu/selfbeta/kb')
    lstofcat = con.getCourseCategoryStruct()

    print lstofcat
    
    for x in lstofcat[1:]:

        print "this is value of X ==   ",x
        title = con.getNeighbourhood(x[0],'objectType',['title'])[0]
        title = self.gnowql.strValidate( title )
        
        description = con.getNeighbourhood(x[0],'objectType',['description'])[0]
        description = self.gnowql.strValidate( description )
        
        subtpof = x[1]

        username = con.getNeighbourhood(x[0],'objectType',['relations'],[['owns', '1']])[0][0][1][0]
        uid = self.gnowql.getUserIdfromUsername(username)

        print "************"
        print title
        print subtpof
        print uid
        print "************"
        
        
        dictParameters = {
            'nid':x[0],
            'uid':uid,
            'status':'Public',
            'content':"",
            'subtypeof':[subtpof],
            'title':[title],
            'description':description
            }
        
        self.gnowql.manageAddObjectType( dictParameters )
        print "Added --", x[0],title


def picklecoursecat(self):
    """
    pickling entire course structure and storing it at file system
    """
    
    lstdata = self.getCourseCategoryStruct()
    
    ssid = self.gnowql.getlatestVersion('CourseCategory')

    print "ssid of coursecategory", ssid
    
    preuri = self.gnowql.geturifromssid(ssid,'gbobjecttypes')

    print "preuri of coursecategory", preuri
    
    finaluri=preuri+'/coursecategorystruct'

    print "final uri --- >", finaluri
    
    FILE=open(finaluri,'w')
    
    cPickle.dump(lstdata,FILE)
    FILE.close()

    print "CourseStructure Pickled"

    return "Successfully Pickled"

def pickleCatStruct(self, lstdata ):
    """
    pickling entire course structure and storing it at file system
    """
        
    ssid = self.gnowql.getlatestVersion('CourseCategory')

    print "ssid of coursecategory", ssid
    
    preuri = self.gnowql.geturifromssid(ssid,'gbobjecttypes')

    print "preuri of coursecategory", preuri
    
    finaluri=preuri+'/coursecategorystruct'

    print "final uri --- >", finaluri
    
    FILE=open(finaluri,'w')
    
    cPickle.dump(lstdata,FILE)
    FILE.close()

    print "CourseStructure Pickled"

    return "Successfully Pickled"


def unpkl(self,uri, ssid):

    pkl_file = open(uri+'/'+ssid, 'rb')

    data = pickle.load(pkl_file)

    pkl_file.close()
    return data

def unpklcat(self,uri):

    pkl_file = open(uri, 'rb')

    data = pickle.load(pkl_file)

    pkl_file.close()
    return data
    
def pickleCourse(self, course_ssid , data):
    """
    This method pickles a course
    """
    print '----------------------Entered pickle Course Function -------------------------------',data
    preuri = self.gnowql.geturifromssid( course_ssid , 'gbobjects' )
    finaluri = preuri + '/' + str( course_ssid ) + '_' + 'CourseStructure'
    FILE=open(finaluri,'w')
    cPickle.dump(data,FILE)
    FILE.close()
    print '----------------------Exiting pickle Course Function -------------------------------',data
    
     
def unpickleCourse(self , course_ssid ):
    """
    This method unpickles a course
    """
    print '----------------------Entered unpickleCourse Function -------------------------------'
    preuri = self.gnowql.geturifromssid( course_ssid , 'gbobjects' )
    finaluri = preuri + '/' + str( course_ssid ) + '_' + 'CourseStructure'
    pkl_file = open(finaluri, 'rb')
    data = pickle.load(pkl_file)
    pkl_file.close() 
    print '----------------------Exited unpickleCourse Function -------------------------------',data
    return data

def chkExistence(self , course_ssid , component):
    """
    This method checks the existence of the pickle for course components 
    """
    
    preuri = self.gnowql.geturifromssid( course_ssid , 'gbobjects' )
    finaluri = preuri + '/' + str( course_ssid ) + '_' + component +'Structure'
    return os.path.exists( finaluri )

def pickleComponent(self, course_ssid , component , data):
    """
    This method unpickles a course Component
    """
    preuri = self.gnowql.geturifromssid( course_ssid , 'gbobjects' )
    finaluri = preuri + '/' + str( course_ssid ) +'_' + component  + 'Structure'
    if not os.path.exists(finaluri):
        os.mknod(finaluri)
    FILE=open(finaluri,'w')
    cPickle.dump(data,FILE)
    FILE.close()

def unpickleComponent(self, course_ssid , component):
    """
    This method unpickles a Component
    """
    preuri = self.gnowql.geturifromssid( course_ssid , 'gbobjects' )
    finaluri = preuri + '/' + str( course_ssid ) +'_'+ component  + 'Structure'
    pkl_file = open(finaluri, 'rb')
    data = pickle.load(pkl_file)
    pkl_file.close() 
    return data
    

def getFileInfo(self, fp):
    """
    This method is used to get FileSize
    """

    res = []
    fname = fp.filename
    print fname
    fcont = fp.read()

    destPath = '/tmp/'+fname
    
    fp1 = open(destPath,'w')
    fp1.write(fcont)
    fp1.close()

    try:
        os.system('ls -l '+destPath+' > /tmp/size.txt')
        fp2 = open('/tmp/size.txt','r')
        t = fp2.readline()
        
        k = t.split(' ')
    
        lsize = str(string.atoi(k[4]) / 1024) + "kb"
    except:
        print "Invalid Operation"
        lsize = "0kb"
    res.append(lsize)

    
    filet = ''
    
    os.system('file -bi '+destPath+' > /tmp/res.txt')
    
    fp3 = open('/tmp/res.txt')
    t = fp3.readline()
    print t
    t = t.replace("\n",'')
    filet = t.split('/')[1]
    res.append(filet)
    fp3.close()

    os.system('md5sum -t '+destPath+' > /tmp/new.txt')
    
    try:
        fp4 = open('/tmp/new.txt','r')
        nid = fp4.readline()
        
    except:
        print "cant read"
        
    nid1 = nid.split(" ")[0]
    res.append(nid1)
    fp4.close()
  
    #os.system('rm -fr '+destPath)


    return res

def createFile(self, fp, filepath):
    """
    This method is used to get FileSize
    """

    fname = fp.filename
    
    sourcePath = '/tmp/'+fname

    createthumb(sourcePath)

    thumbpath = sourcePath + '.thumb.png'

    try:
        os.system('cp '+sourcePath+' '+filepath)
    except:
        print "cant copy File"

    try:
        os.system('cp '+thumbpath+' '+filepath)
    except:
        print "cant copy File"


    os.system('rm -fr '+sourcePath)
    os.system('rm -fr '+thumbpath)

    return


import PIL.Image as PIL

def createthumb(sourcePath):

    """
    create Thumb
    """
    
    print "This is the Source Path", sourcePath

    try:
        image = PIL.open(sourcePath)

        image.thumbnail ((100,100), PIL.ANTIALIAS)

        image.save (sourcePath +'.thumb.png')

        print "Done !!!"

    except:
        
        print "this is not an Image file"

    return


def addBookshelftoUser(self):

    """
    creating bookshelf for all user
    """

    lstofusers = self.gnowql.getAll('gbusers')

    for x in lstofusers:

        nid = str(x['nid']) + '_shelf'
        title = str(x['nid']) + "'s Shelf"
        uid = x['uid']

        dictParameters = {
            'nid': nid,
            'uid':uid,
            'status':'Public',
            'title':[title],
            'description':'',
            'instanceof':['Bookshelf']
            }

        self.gnowql.manageAddObject( dictParameters )

        shelf_ssid = self.gnowql.getlatestVersion( nid )

        dictParameters = {
            'uid':uid,
            'status':'Public',
            'subject1':shelf_ssid,
            'subject2':x['ssid'],
            'relationtypes':'hasshelf'
            }

        self.gnowql.manageAddRelation( dictParameters )

        print "Shelf for user === > ", nid, "created"
