#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 3 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (COPYING); if not, write to the
#  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#  Boston, MA  02110-1301  USA59 Temple Place, Suite 330,
#
######################################################################

__docformat__ = 'plaintext'

from genericTable import *
from datatypes import *
from set_checks import *
from gbroletypes import *
from gbcontent import *

class gbattributes:
	def __init__( self, conString ):
		self.conn = psycopg2.connect( conString )
		self.cur = self.conn.cursor()
		self.nodetype = 'gbattributes'
		self.conString = conString


	def set( self, lstofDic, insname ):
		lstofssidofattr = []

		for x in lstofDic:
			p = self.set1(x, insname)
			lstofssidofattr.append(p)

		dictT = {}
		dictT= lstofDic[0]
		subject = dictT['subject']

		print "Subject passed",subject
		oldsubject = subject
		newsubject = self.updateSubject(lstofssidofattr, subject, insname)

		for elem in lstofssidofattr:
		        ssid = str(elem)
			
			query = "SELECT nodename FROM view_nidinidssid WHERE ssid=%s;" % ssid
			print query
			self.cur.execute( query )
			res = self.cur.fetchall()
			nodename = res[0][0]

			s = storageSpec()
            
			flddef = s.dictTNamesFDefs[ nodename ]['subject']

			obj = tbl_nodetype( self.cur )
			ntid = obj.getntid( nodename )
			
			dtobj = tbl_datatypes( self.cur )
			dtid = dtobj.getdtid( 'int8' )

			ft = tbl_field( self.cur, flddef )
			fid = ft.insert( { 'ntid':ntid, 'datatypeid':dtid, 'value':int(newsubject) } )

			updatequery = "UPDATE %s SET subject=%s WHERE ssid=%s" % ( nodename, fid, ssid )
			print updatequery
            
			self.cur.execute( updatequery )
			
		# from commonMethods import *
# 	        obj1 = gbMethods(self.conString)
# 		instanceof = obj1.getinfoFromSSID(str(oldsubject), 'gbobjects')[0]['instanceof']

# 		if instanceof <> None:
# 			for elem in instanceof:
# 				val = []
# 				instances = obj1.getinfoFromSSID(str(elem), 'gbobjecttypes')[0]['instances']
# 				if instances <> None:
# 					val = instances
# 					val.append(long(newsubject))
# 				else:
# 					val = [long(newsubject)]
# 				ssid = str(elem)
# 				query = "SELECT nodename FROM view_nidinidssid WHERE ssid=%s;" % ssid
# 				print query
# 				self.cur.execute( query )
# 				res = self.cur.fetchall()
# 				nodename = res[0][0]

# 				s = storageSpec()
            
# 				flddef = s.dictTNamesFDefs[ nodename ]['instances']

# 				obj = tbl_nodetype( self.cur )
# 				ntid = obj.getntid( nodename )
			
# 				dtobj = tbl_datatypes( self.cur )
# 				dtid = dtobj.getdtid( 'int8[]' )

# 				ft = tbl_field( self.cur, flddef )
# 				fid = ft.insert( { 'ntid':ntid, 'datatypeid':dtid, 'value':val } )

# 				updatequery = "UPDATE %s SET instances=%s WHERE ssid=%s" % ( nodename, fid, ssid )
# 				print updatequery
            
# 				self.cur.execute( updatequery )
				
		self.conn.commit()
		self.conn.close()
		print "Attributes are successfully added into DB"

		return
		
	def set1( self, dictParameters, insname ):
		cur = self.cur
		nt=self.nodetype

		uid = dictParameters['uid']
		# mandatory and cannot be empty
		instanceof = dictParameters['instanceof']

		try:
			status = dictParameters['status']
		except:
			status = 'Public'

		try:
			relations = dictParameters['relations']
		except:
			relations = []

		try:
			instances = dictParameters['instances']
		except:
			instances = []


		try:
			attributes = dictParameters['attributes']
		except:
			attributes = []

		try:
			attributetypes = dictParameters['attributetypes']
		except:
			attributetypes = []

		try:
			relationtypes = dictParameters['relationtypes']
		except:
			relationtypes = []

		try:
			history = dictParameters['history']
		except:
			history = [0]
			
		value =  dictParameters['value']
		print "value is", value
		subject = dictParameters['subject']
		
		""" uid and uri field is mandatory for objecttypes """
		mandatory_fields = ({'uid':uid, 'instanceof':instanceof, 'subject':subject, 'value':value})
		
		chk_ssid = ({'instanceof':instanceof})
	
		obj = def_set_checks()
		obj.manflds_chk(mandatory_fields);
		status = obj.status(status)

		# calculating sentense

		#reqDict.update({'subject':subject})
		#        def mysentence( self, dict, attributetypes_nid, attribute_value, cur ):

		for li in instanceof:
			print li
			attributetypes_nid = obj.get_nid_from_ssid(li, cur)
		mysentence = ""
		
		
		tpofval = str(type(value))
		if tpofval == "<type 'list'>":
			mysentence = str(subject) + str(attributetypes_nid) + " has " + str(value[0])
		else:
			mysentence = str(subject) + str(attributetypes_nid) + " has " + str(value)

		wordlist = mysentence.split()
		nid = '_'.join(wordlist)
               
                print "type of value is :", isinstance(value,list)

		nidtbl = tbl_nidinid( cur )
		inid = nidtbl.setval( nid, nt )
		if inid == 0:
			inid = nidtbl.getinid( nid, nt )
                   
		inidtbl = tbl_inidssid( cur )
		ssid = inidtbl.setval_using_nid( nid, nt )
                
		       #		attributetypes_nid = obj.get_nid_from_ssid(ssid, cur)
		       #		mysentence = subject + attributetypes_nid + " is " + value

		       # Calculating URI

		preuri = makeURI(nid, inid, nt, insname)
		print preuri

		dtid = 0
		datatype = ''
		for x in instanceof:
			datatypeid = self.get_dtid_attributetype(x, cur)
			dtid = datatypeid
			print dtid
			qryrslt = cur.execute("select a.datatypename from gbdatatypes a, gbvaluerestrictions b where a.datatypeid = b.datatypeid and b.datatypeid = " + str(dtid) + ";")
			qryrslt = cur.fetchall()
			print qryrslt
			farg = qryrslt[0]
			datatype = farg[0]
			print datatype
		attribute_value = value
		print attribute_value
		valueid = self.value_id(attribute_value,datatype,cur)
		print "valueid is ---", valueid

		noofchangesaftercommit = '0'
		noofcommits = '1'


		# subject is a list

		givensubject = []
		givensubject.append(subject)

                # creating list of networkfield

                listofnbhfield = []

		if relations <> []:
			listofnbhfield.append('relations')
                if attributes <> []:
			listofnbhfield.append('attributes')
                if relationtypes <> []:
			listofnbhfield.append('relationtypes')
                if attributetypes <> []:
                        listofnbhfield.append('attributetypes')
                if instanceof <> []:
                      listofnbhfield.append('instanceof')
                if instances <> []:
                        listofnbhfield.append('instances')
		
                  
		insertionDict = {
			'status':status,
			'inid': inid, 
			'ssid': ssid, 
			'uri':preuri,
			'relations':relations,
			'instances':instances,
			'attributes':attributes,
			'relationtypes':relationtypes,
			'attributetypes':attributetypes,
			'uid':uid,
			'instanceof':instanceof,
			'subject':subject,
			'sentence':mysentence,
			'valueid': valueid,
			'history':history,
			'noofchangesaftercommit':noofchangesaftercommit,
			'noofcommits':noofcommits
			}
                   
		insertionDict = obj.insertionDict(insertionDict)

                fieldschanged = obj.fldschd(insertionDict, nt, nid, cur)
                modifications = obj.mod(fieldschanged)
                changetypes = obj.chgtyp(modifications)
		insertionDict.update({'fieldschanged':fieldschanged, 'noofchanges':modifications, 'changetype':changetypes})
						
                   
                   
		# do checking here of ssid, inid, nid, uid...
                   
	        print insertionDict
                   
		s = storageSpec()
                   
		gt = genericTable( cur, self.nodetype, s.dictTableNamesAndDefs[ self.nodetype ], s.dictTNamesFDefs[ self.nodetype ], 1 )
		gt.insert( insertionDict )

                # Setting NBH Props in respective nodes

		obj.set_nbh(ssid, listofnbhfield, cur)
	

		# creating snapshot at filesystem
                createURI(preuri, inid, ssid)

		# creating a pickle using the ssid
		dict=self.getNeighbourhood(nid,ssid)
		finaldict=dict[0]
		pickleobject(preuri,ssid,finaldict)
                   
		print "Attributes Created"
		

		return ssid


	def updateSubject(self, lstofssidofattr, subject, insname):

		from commonMethods import *
		obj1 = gbMethods(self.conString)
		
		dictP = obj1.getinfoFromSSID(subject, 'gbobjects')[0]

		print dictP
		
		instanceof = dictP['instanceof']

		cur = self.cur
		
		qryrslt = cur.execute("select nid, uid, status, uri, title, description, attributes, attributetypes, relations, relationtypes, instanceof, structure, content from djview_o where ssid = " + str(subject) + "; ")
		qryrslt = cur.fetchall()
		farg = qryrslt[0]
		#values_objects = farg[0]
		print "values from the gbobject view is --- ", farg

		dict_object = {}
		keys_objects = [ 'nid', 'uid', 'status', 'uri', 'title',  'description', 'attributes', 'attributetypes', 'relations', 'relationtypes', 'instanceof', 'structure', 'content' ]

		i = 0
		for li in keys_objects:
			dict_object.update({li:farg[i]})
			i = i + 1

		#print dict_object
		
		att_ssid = []
		for ssidx in lstofssidofattr:
			att_ssid.append(ssidx)
		
		attributes_obj = dict_object['attributes']
		gt = genericTable( cur, self.nodetype )
		
		ntattr = []
		print "Before Checking value of attributes_obj"
		if attributes_obj <> [] and attributes_obj <> None:
			attributes = gt.getAllBySSIDCols( 'djview_a', [ 'instanceof' ] , attributes_obj, 'gbattributes' )
			print "instance of property of old attr: %s" % attributes
		
			lstofattr1 = gt.getAllBySSIDCols( 'djview_a', [ 'instanceof' ] , lstofssidofattr, 'gbattributes' )
			print "instance of property of new attr:",lstofattr1
		
			
		
			if attributes <> {}:
				for xt, vt in lstofattr1.iteritems():
					for pt, ct in attributes.iteritems():
						if vt['instanceof'] == ct['instanceof']:
							ntattr.append(ct['ssid'])

			print "unwanted attr ssid ===========", ntattr

		if str(attributes_obj) <> 'None':
			for ssidx in lstofssidofattr:
				print "New attributes ssids-------", ssidx
                                # cheking which attributes ssids have to be substituted
				
				attributes_obj.append(ssidx)
                                print "pass --------",attributes_obj
		else:
			dict_object.update({'attributes':att_ssid})

		if ntattr <> []:
			for ft in ntattr:
				if ft in attributes_obj:
					attributes_obj.remove(ft)
					

		print "Fianl list of attributes ssid", attributes_obj

		print "dict_object for attributes ========================", dict_object
	
		dict_object.update({'ssid':subject})

		obj_instanceof = dict_object['instanceof']
		obj_instanceof_list = []
		for li in instanceof:
			obj_instanceof_list.append(int(li))
		dict_object.update({'instanceof':obj_instanceof_list})

		obj_uid = dict_object['uid']
		dict_object.update({'uid':int(obj_uid)})
		
		obj_attributes = dict_object['attributes']
		obj_attributes_list = []
		for li in obj_attributes:
			obj_attributes_list.append(int(li))
		dict_object.update({'attributes':obj_attributes_list})

		print dict_object

		keys_list = []
		for li in dict_object:
			if str(dict_object[li]) == 'None':
				keys_list.append(li)
		for li in keys_list:		
			del dict_object[li]
		
		print "dictionary for object snapshot is ---", dict_object


		from gbobjects import *
		from genericTable import *
		from gbcontent import *
		
		obj = gbobjects(self.conString)
		newid = obj.update(dict_object, insname, 0)
		
		return newid
		
	def getNeighbourhood( self, nid, ssid=0 ):
		"""
		"""
		
		sid = []
		queryResult = []
		cur = self.cur
		listofver = []
		dictofsnaps = {}
		listoffields=['ssid','inid','uid','noofchanges','fieldschanged','changetype','noofcommits','noofchangesaftercommit','history','gbtimestamp','sentence','status','attributetypes','attributes','relationtypes','relations','instanceof','uri','subject','valueid']
		
		obj = def_set_checks()

		if ssid == 0:
		   sid = obj.get_ssid_from_nid(nid, cur)
		else:
		   sid=[ssid]
		
		for x in sid:
			i = 0
			dictofsnaps = {}
			queryResult = cur.execute("select * from view_a where ssid = " + str(x) + ";")
			queryResult = cur.fetchall()
			for y in listoffields:
			    dictofsnaps.update({y:queryResult[0][i]})
			    i=i+1

			print dictofsnaps
			listofver.append(dictofsnaps)

		return listofver
		
	def value_id( self, attribute_value, datatype, cur ):
		datatype_field_table = "datatypes_" + datatype
		vt = tbl_values( cur, '', datatype )
		vid = vt.insert( attribute_value )
            
#		qryrslt = cur.execute("insert into " + datatype_field_table + " (value) values ('" + attribute_value + "')")
# #vid = get_pkey(qryrslt)
# 		qryrslt = cur.execute("select vid from " + datatype_field_table + " where value = '" + attribute_value + "';")
# 		qryrslt = cur.fetchall()
# 		farg = qryrslt[0]
# 		vid = farg[0]

		#print vid
		print "function[value_id]: vid is %s" % vid
		return vid
            
	def value_fid( self, vid, datatype, cur):
		qryrslt = cur.execute("select dtid from  gbdatatypes where datatype = " + datatype + ";")
		qryrslt = cur.fetchall()
		farg = qryrslt[0]
		dtid = farg[0]
            
		ntid = 3
            
		cur.execute("insert into field_valueid (ntid, vid, datatypeid) values (" + ntid + ", " + vid + ", " + dtid + ")")
            
		qryrslt = cur.execute("select vid from field_valueid where ntid = " + ntid + " and vid + " + vid + " and dtid = " + dtid + ";")
		qryrslt = cur.fetchall()
		farg = qryrslt[0]
		fid = farg[0]
		print fid
		return fid
 
    
	def get_dtid_attributetype( self, ssid, cur ):
		"""
		select ssid row from gbattributestypes
		get restrictionid
		select datatypeid from gbvaluerestrictions
		return datatypeid
		"""
		print ssid
		#qryrslt = cur.execute("select a.datatypeid from gbvaluerestrictions a, gbattributetypes b where a.restrictionid = b.restrictionref and b.ssid = " + str(ssid) + ";")
		qryrslt = cur.execute("select gbvaluerestrictions.datatypeid AS dtid FROM gbvaluerestrictions, djview_at WHERE djview_at.restrictionref = gbvaluerestrictions.restrictionid AND djview_at.ssid = " + str(ssid) + ";")
		qryrslt = cur.fetchall()
		print qryrslt
		farg = qryrslt[0]
		dtid = farg[0]
		return dtid

	def getAllAttributeValuesOld( self, lstSSIDs ):
		cur = self.cur
		"""
		Assumption:
		-----------
		An attribute is an instance of 1 and only 1 attributeType
		
		Logic:
		1. retreive all SSIDs
		2. collect instanceOf and valueId
		3. search and retrieve all instanceOf SSIDs in gbattributeType table
		4. retrieve restrictionRef of all the above ATs
		5. goto gbValueRestrictions and collect all restrictionRefs
		6. check the datatypeid from the gbDataTypes table
		7. get all values from the datatype tables
		"""

		gt = genericTable( cur, self.nodetype )

		# get all attributes
		attributes = gt.getAllBySSIDCols( 'djview_a', [ 'nid', 'instanceof', 'valueid' ] , lstSSIDs, 'gbattributes' )
		print "attributes: %s" % attributes

		lstInstanceOf = []
		lstValueId = []

		ssid2rr = {}
		rr2dtid = {}
		dtid2dtn = {}
		vid2ssid = {}

		for k, a in attributes.items():
			io = a[ 'instanceof' ][0]
			vid = a[ 'valueid' ]

			ssid2rr[ k ] = 0
			vid2ssid[ vid ] = k

 			lstInstanceOf.append( io ) # Because of the above assumption
 			lstValueId.append( vid )

 		print "lstInstanceOf: %s" % lstInstanceOf
 		print "lstValueId: %s" % lstValueId
		
		# get all attribute types
		attributeTypes = gt.getAllBySSIDCols( 'djview_at', [ 'restrictionref', 'nid' ] , lstInstanceOf, 'gbattributetypes' )

		print "attributeTypes: %s" % attributeTypes

		lstRestrictionRef = []

		for k, at in attributeTypes.items():
			rr = at[ 'restrictionref' ]
			lstRestrictionRef.append( rr )
		i=0
		for io in lstInstanceOf:
			ssid2rr[ lstSSIDs[i] ] = attributeTypes[ io ]['restrictionref']
			i = i + 1
		print "ssid2rr: %s" % ssid2rr

		print "lstRestrictionRef: %s" % lstRestrictionRef

		# get all datatypeids
		datatypeids = gt.getAllIdsFromTableCols( 'restrictionid', 'gbvaluerestrictions', [ 'datatypeid' ], lstRestrictionRef )

		lstDatatypeIds = []
		i=0
		for at in datatypeids.values():
			dtid = at[ 'datatypeid' ]
			print lstRestrictionRef[i], dtid
			rr2dtid[ lstRestrictionRef[ i ] ] = dtid
			lstDatatypeIds.append( dtid )
			i=i+1

		print "rr2dtid: %s" % rr2dtid

		print "lstDatatypeIds: %s" % lstDatatypeIds


		# get all datatype names
		datatypeNames = gt.getAllIdsFromTableCols( 'datatypeid', 'gbdatatypes', [ 'datatypename' ], lstDatatypeIds )

		print "datatypenames: %s" % datatypeNames

		# construct the value tablename list
		lstVTNames = []
		dictCommonValues = {}
		dtc = gnowsysDatatypes( 'gbdatatypes', 1 )

		for l in lstDatatypeIds:
			dt = datatypeNames[ l ]
			vtname = dtc.getDataTypeTableName( dt[ 'datatypename' ] )
			lstVTNames.append( vtname )
			dtid2dtn[ l ] = vtname
			if vtname not in dictCommonValues:
				dictCommonValues[ vtname ] = []
		# group all valueids together
		print "lstVTNames: %s" % lstVTNames		
		i=0
#		for vtn in lstVTNames:
		for s in lstSSIDs:
			vtn = dtid2dtn[ rr2dtid[ ssid2rr[ s ] ] ]
			dictCommonValues[ vtn ].append( lstValueId[i] )
			i = i + 1
		print "dictCommonValues: %s" % dictCommonValues		

		res = []
		# k = datatype
		# v = list of vids associated with the datatype
		for k, v in dictCommonValues.items():
			tmp = gt.getAllIdsFromTableCols( 'vid', k, [ 'value' ], v )
			print tmp
			#for valueid, info in tmp.items():
			for valueid in v:
				info = tmp[ valueid ]
				# for ssid to value mapping, uncomment this line and
				# comment the next line
				#res[ vid2ssid[ valueid ] ] = info['value']

				# for nid to value mapping, uncomment this line and
				# comment the previous line
				#res[ attributes[ vid2ssid[ valueid ] ]['nid'] ] = info['value']

				# enable this portion for handling multiple attributes which are the
				# instance of the same attribute types 
# 				aSSID = attributes[ vid2ssid[ valueid ] ]['ssid']
# 				aNid  = attributes[ vid2ssid[ valueid ] ]['nid']
# 				atNid = attributeTypes[ attributes[ aSSID ]['instanceof'][0] ]['nid']
# 				print atNid
# 				if atNid not in res.keys():
# 					res[ atNid ] = {}

# 				res[ atNid ][ aNid ] = info['value']

				# disable this portion if you enable the above portion
   				aSSID = attributes[ vid2ssid[ valueid ] ]['ssid']
				atNid = attributeTypes[ attributes[ aSSID ]['instanceof'][0] ]['nid']
				print atNid
#				res[ atNid ] = info['value']
				res.append( [ atNid, info['value'] ] )

		return res

	def getAllAttributeValues( self, lstSSIDs ):
		cur = self.cur
		"""
		Assumption:
		-----------
		An attribute is an instance of 1 and only 1 attributeType
		
		Logic:
		1. retreive all SSIDs
		2. collect instanceOf and valueId
		3. search and retrieve all instanceOf SSIDs in gbattributeType table
		4. retrieve restrictionRef of all the above ATs
		5. goto gbValueRestrictions and collect all restrictionRefs
		6. check the datatypeid from the gbDataTypes table
		7. get all values from the datatype tables
		"""

		gt = genericTable( cur, self.nodetype )

		# get all attributes
		attributes = gt.getAllBySSIDCols( 'djview_a', [ 'nid', 'instanceof', 'valueid' ] , lstSSIDs, 'gbattributes' )
		print "attributes: %s" % attributes

		"""
		result format:
		[ col0 | col1       | col2    | col3           | col4 | ... ]
		[ ssid | instanceof | valueid | restrictionref | dtid | 
		"""

		res = []
		lstInstanceOf = []
		lstValueId = []

		for ssid in lstSSIDs:
			io = attributes[ ssid ]['instanceof'][0]
			vid = attributes[ ssid ]['valueid']

			lstInstanceOf.append( io )
			lstValueId.append( vid )
			res.append( [ ssid, io, vid ] )

		print "res: %s" % res

		# get all attribute types
		attributeTypes = gt.getAllBySSIDCols( 'djview_at', [ 'restrictionref', 'nid' ] , lstInstanceOf, 'gbattributetypes' )
		print "attributeTypes: %s" % attributeTypes

		lstRestrictionRef = []
		cnt=0
		for cnt in range( 0, len( lstSSIDs ) ):
			aIO = res[cnt][1]
			rr = attributeTypes[ aIO ][ 'restrictionref' ]
			lstRestrictionRef.append( rr )
			res[cnt].append( rr )

		print res

		# get all datatypeids
		datatypeids = gt.getAllIdsFromTableCols( 'restrictionid', 'gbvaluerestrictions', [ 'datatypeid' ], lstRestrictionRef )

		lstDatatypeIds = []
		cnt=0
		for cnt in range( 0, len( lstSSIDs ) ):
			aRR = res[cnt][3]
			dtid = datatypeids[ aRR ][ 'datatypeid' ]
			if dtid not in lstDatatypeIds:
				lstDatatypeIds.append( dtid )

			res[cnt].append( dtid )

		print "lstDatatypeIds: %s" % lstDatatypeIds
		print res

		# get all datatype names
		datatypeNames = gt.getAllIdsFromTableCols( 'datatypeid', 'gbdatatypes', [ 'datatypename' ], lstDatatypeIds )

		print "datatypenames: %s" % datatypeNames
		
		# construct the value tablename list
		dtid2vtname = {}
		dtc = gnowsysDatatypes( 'gbdatatypes', 1 )
		for l in lstDatatypeIds:
			dt = datatypeNames[ l ]
			vtname = dtc.getDataTypeTableName( dt[ 'datatypename' ] )
			dtid2vtname[l] = vtname

		print "dtid2vtname: %s" % dtid2vtname

		cnt=0
		dictCommonValues = {}
		for cnt in range( 0, len( lstSSIDs ) ):
			dtid = res[cnt][4]
			vid = res[cnt][2]
			vtname = dtid2vtname[ dtid ]

			if vtname not in dictCommonValues.keys():
				dictCommonValues[vtname] = []

			dictCommonValues[vtname].append( vid )

		vtname = ""
		lstVids = []
		dictResults = {}
		for vtname, lstVids in dictCommonValues.items():
			tmp = gt.getAllIdsFromTableCols( 'vid', vtname, [ 'value' ], lstVids )

			if vtname not in dictResults.keys():
				dictResults[ vtname ] = tmp

		print dictResults

		# uncomment the following line to return a list
		#finalResult = []

		# uncomment the following line to return a dict
		finalResult = {}

		cnt=0
		for cnt in range( 0, len( lstSSIDs ) ):
			resultSetName = dtid2vtname[ res[cnt][4] ]
			vid = res[cnt][2]
			value = dictResults[ resultSetName ][ vid ]['value']
			atname = attributeTypes[ res[cnt][1] ]['nid']
			# uncomment the following line to return a list
			#finalResult.append( [ atname, value ] )

			# uncomment the following line to return a dict
			finalResult[ atname ] = value

		return finalResult

if __name__ == '__main__':
	dictConn = { 
		'dbname':'self', 
		'username':'username', 
		'password':'username', 
		'host':'127.0.0.1'
		}

	connstr = "dbname=%(dbname)s user=%(username)s password=%(password)s host=%(host)s" % dictConn

# 	conn = psycopg2.connect( "dbname=%(dbname)s user=%(username)s password=%(password)s host=%(host)s" % dictConn )
# 	cur = conn.cursor()
	
	ga = gbattributes( connstr )
#	print ga.getAllAttributeValues( [ 382, 383, 412, 413 ] )
#	print ga.getAllAttributeValues( [ 382, 383 ] )
	print ga.getAllAttributeValues( [ 1675, 1676, 1677, 1678, 1679 ] )

