#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 3 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (COPYING); if not, write to the
#  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#  Boston, MA  02110-1301  USA59 Temple Place, Suite 330,
#
######################################################################

__docformat__ = 'plaintext'

import os
import cPickle

def makeURI(nid, inid, nodetype, instanceID):

    """
    function to create gnowledge base repository in the filesystem at
    CLIENT_HOME within the Zope instance's 'var' directory, create a
    folder for each node within the respective nodetype folders and
    return uri.
    """

    # if middle spaces exist, substitue with '_' character
    # for testing prune these lines after testing
    # CLIENT_HOME = "/tmp"
    # calculate gbpath, create folder by the name nid, create if does
    # not exist, and return uri.

    nid = nid.replace(' ','_')
    gbpath =  CLIENT_HOME + '/GB' + '/' + instanceID + '/' + nodetype + '/' + nid[0] + '/' + nid[1] + '/' + nid
    preuri =  gbpath 
    return preuri

def createURI(preuri, inid, ssid):

    if not os.path.exists(preuri):
        os.makedirs(preuri)

    inid = str(inid)
    print inid
    
    os.chdir(preuri)
    if not os.path.exists(preuri):
        os.mknod(inid)

    if not os.path.exists(preuri+'/'+str(ssid)):
        os.mknod(str(ssid))

def makeFSSSID(preuri, ssid):

    if not os.path.exists(preuri):
        os.makedirs(preuri)

    
    if not os.path.exists(preuri+'/'+str(ssid)):
        os.chdir(preuri)
        os.mknod(str(ssid))

def pickleobject(preuri,ssid,dict_view):
    """
    """
    finaluri=preuri+'/'+str(ssid)
    FILE=open(finaluri,'w')
    cPickle.dump(dict_view,FILE)
    FILE.close()

                        
