#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 3 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (COPYING); if not, write to the
#  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#  Boston, MA  02110-1301  USA59 Temple Place, Suite 330,
#
######################################################################

__docformat__ = 'plaintext'

from genericTable import *
from set_checks import *
from gbcontent import *

class gbusers:
        def __init__( self, conString ):

                self.conn = psycopg2.connect(conString)
                self.cur = self.conn.cursor()
                self.nodetype = 'gbusers'

        def set( self, dictParameters, insname ):
                """
                """

                cur = self.cur
                nt=self.nodetype
                
                try:
                   nid = dictParameters['username']
                except:
                   return "Please enter nid"

	        try:
	           password=dictParameters['password']
		except:
		   return "Please enter password"
		   
                
                try:
                   title =dictParameters['title']
                except:
                   title=nid

                try:
                   description =dictParameters['description']
                except:
                   description=''

                try:
                   firstname =dictParameters['fullname']
                except:
                   firstname=nid

		try:
                   middlename =dictParameters['middlename']
                except:
                   middlename=''

		try:
                   lastname =dictParameters['lastname']
                except:
                   lastname=''   

                try:
	           email=dictParameters['email']
		except:
	           return "Please enter email id"

		   
                try:
                   instanceof =dictParameters['instanceof']
                except:
                   instanceof=[]

                try:
                   content =dictParameters['content']
                except:
                   content=''

                
		status= 'Private'
                domain= 0
  		loginstatus= 0

                relations = []
                instances = []
                attributes = []
                relationtypes = []
		attributetypes = []

		noofcommits = '0'
                history = [0]
                noofchangesaftercommit = '0'


                #checks for insertion
	
		nidtbl = tbl_nidinid( cur )
		inid = nidtbl.setval( nid, nt )
		if inid == 0:
			inid = nidtbl.getinid( nid, nt )
	
		inidtbl = tbl_inidssid( cur )
		ssid = inidtbl.setval_using_nid( nid, nt )


			
                
                # Calculating URI

                preuri = makeURI(nid, inid, nt, insname)
                print preuri
		


		# uid,uri and instanceof fields are mandatory for users 
   		
		mandatory_fields = ({'uid':inid, 'uri':preuri, 'instanceof':instanceof})
	
		obj = def_set_checks()
		obj.manflds_chk(mandatory_fields)
		status = obj.status(status)
		title = obj.title(title, nid)


		# get ssid from usertype-nid provided by user
		
		instof = []
		if instanceof <> []:
			for z in instanceof:
				insid = int(str(obj.get_ssid_from_nid(z, cur)[-1]))
				instof.append(insid)
		instanceof = instof
		print "Reinitialized instanceof :", instanceof
		
		
	      		
                # Final Dictionary
		insertionDict={
                    'inid':inid,
		    'ssid':ssid,
		    'uri':preuri,
		    'title':title,
		    'description':description,
		    'status':status,
		    'content':content,
	            'attributetypes':attributetypes,
		    'attributes':attributes,
 		    'relationtypes':relationtypes,
                    'relations':relations,
		    'instanceof':instanceof,
                    'firstname':firstname,
		    'middlename':middlename,
 		    'lastname':lastname,
		    'email':email,
                    'domain':domain,
                    'loginstatus':loginstatus,
		    'password':password,
                    'uid':inid,
		    'history':history,
		    'noofchangesaftercommit':noofchangesaftercommit,
  		    'noofcommits':noofcommits
               
                 }


              	insertionDict = obj.insertionDict(insertionDict)

		# To calculate fieldschanged, noofchangesaftercommit, changetype """

		fieldschanged = obj.fldschd(insertionDict,nt,nid,cur)
		
		"""
		fieldschanged=['status','content','title','description']
		"""
		modifications = obj.mod(fieldschanged)
		changetypes = obj.chgtyp(modifications)
	
		insertionDict.update({'fieldschanged':fieldschanged, 'noofchanges':modifications, 'changetype':changetypes})


                # do checking here of ssid, inid, nid, uid...

                s = storageSpec()
                gt = genericTable( cur, self.nodetype, s.dictTableNamesAndDefs[ self.nodetype ], s.dictTNamesFDefs[ self.nodetype ], 1 )
                gt.insert( insertionDict )

                # creating snapshot at filesystem
                createURI(preuri, inid, ssid)

                self.conn.commit()
                self.conn.close()
