#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 3 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (COPYING); if not, write to the
#  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#  Boston, MA  02110-1301  USA59 Temple Place, Suite 330,
#
######################################################################

__docformat__ = 'plaintext'

from genericTable import *
from storageSpec import *
from set_checks import *

class gbvaluerestrictions:

    """
    holds a functions to insert the special fields for gbattributetype
    """
   
    def __init__(self, cur):
        self.cur = cur
        #self.storageInfo = storageSpec
        self.nodetype = 'gbvaluerestrictions'
        # define the names of mandatory fields
        self.mandatoryFields = []
        #self.loggerObj = logger( self.nodetype )

    def insert( self, dictParams ):

        """
        dictParams format:
        {
        'datatype':'',
        'description':'',
        'range':'',
        'precision':'',
        'regexid':'',
        'length':''
        }
        """
        print "Old Dict", dictParams
        cur = self.cur
        
        insertDict = {}

        obj = tbl_datatypes( cur )
        dtid = obj.getdtid( dictParams['datatype'] )
        
        if dtid == 0:
            return 0
        
        # we have a valid datatype

        insertDict['datatypeid'] = dtid

        try:
            description = dictParams['description']
            insertDict['description'] = description
        except:
            description = ''

        try:
            range = dictParams['range']
            insertDict['range'] = range
        except:
            range = ''

        try:
            precision = dictParams['precision']
            insertDict['precision'] = precision
        except:
            precision = '0'



        # TODO
        # regular expression table should be inserted and returned
        # value of this function should be taken as regular
        # expression.

        try:
            regexid = dictParams['regexid']
            insertDict['regexid'] = regexid    
        except:
            regexid = ''
        
        
        try:
            length = dictParams['length']
            insertDict['length'] = length
        except:
            length = ''


        # TODO: check the uniqueness of the constraint being inserted

        s = storageSpec()
        gt = genericTable( cur, self.nodetype, s.dictTableNamesAndDefs[ self.nodetype ], s.dictTNamesFDefs[ self.nodetype ], 1 )
        print "Final Dict", insertDict
        gt.insert( insertDict )
        
        return gt.get_pkey( 'restrictionid' )
    
