#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 3 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (COPYING); if not, write to the
#  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#  Boston, MA  02110-1301  USA59 Temple Place, Suite 330,
#
######################################################################

__docformat__ = 'plaintext'# Contributor: "Dinesh Joshi" <dinesh.joshi@yahoo.com>


from datatypes import *
from gnowsysTable import *
from storageSpec import *

debug=0
dictFldsTblSQL = {}

def debug_print( var ):
    if debug==1:
        print "[debug] %s" % var


class pgtable:
    def __init__( self, tableName ):
        # { 'fieldname' : [ 'fieldname', 'fieldtype', 'immediate constraint' ] }
        self.fields = {}

        #     FLDNAME              CNSTRDEF
        # { 'fieldname' : [ 'constraint type', [ fields, ... ] ] }

        # { 'fieldname' : [ 'candidatekey',    [ fields, ... ] ] }
        # { 'fieldname' : [ 'reference',       [ tblname, list flds, ... ] ] }
        # { 'fieldname' : [ 'ckeyref',         [ tblname, list flds, ... ] ] }
        self.constraints = {}

        # table name
        self.tableName = tableName

        # constraint types:
        #    1. primary key
        #    2. unique key
        #    3. candidate key
        #    4. reference
        #    5. candidate key reference

    def addField( self, fldDef ):
        self.fields[ fldDef[0] ] = fldDef

    def addConstraint( self, fldName, cnstrDef ):
        debug_print( "addConstraint: %s, %s" % ( fldName, cnstrDef ) )
        self.constraints[ fldName ] = cnstrDef

    def processConstraint( self, fldName, cnstrDef ):
        cnstrType = cnstrDef[0]
        definition = cnstrDef[1]
        strSQL = ""

#         print "Processing constraint of type: %s" % cnstrType
#         print "Constraint Def: %s" % cnstrDef
        if cnstrType == 'candidatekey':
            tmpSQL = ", " . join( [ "%s" % ( c ) for c in cnstrDef[1] ] )
            strSQL = "PRIMARY KEY( %s )" % tmpSQL
        elif cnstrType == 'uniqueflds':
            tmpSQL = ", " . join( [ "%s" % ( c ) for c in cnstrDef[1] ] )
            strSQL = "UNIQUE( %s )" % tmpSQL
        elif cnstrType == 'reference':
            strSQL = "FOREIGN KEY( %s ) REFERENCES %s ( %s )" % ( fldName, definition[0], definition[1][0] )
        elif cnstrType == 'ckeyref':
            strFlds = ", " . join( [ "%s" % ( c ) for c in cnstrDef[1][1] ] )
            strSQL = "FOREIGN KEY( %s ) REFERENCES %s ( %s )" % ( strFlds, definition[0], strFlds )
            
        return strSQL


    def genSQL( self ):
        tableBody = "CREATE TABLE %(tableName)s ( %(fieldDefs)s \n);"

        strSQL = ""
        strSQL = ",". join( [ "\n\t%s %s %s" % ( v[0], v[1], v[2] ) for v in self.fields.values() ] )

        strTmp = ""
        strTmp = "," . join( [ "\n\t%s" % ( self.processConstraint( k, v ) ) for k, v in self.constraints.items() ] )


        fieldsSQL = strSQL
        if len( self.constraints ) > 0:
            fieldsSQL = fieldsSQL + ",\n\t" + strTmp
        tableBody = tableBody % { "tableName": self.tableName, "fieldDefs":fieldsSQL }

        return tableBody

    def dumpInfo( self ):
        print "INFO FOR: %s" % self.tableName
        print "Field Name\t\tFieldDef"
        for k, v in self.fields.items():
            print k, v

        print self.constraints

        print "Field Name\t\tConstraint Def"
        for k, v in self.constraints.items():
            print k, v


class baseTable:
    def __init__( self, dictTableNames ):
        self.dictTableNames = dictTableNames
        self.s = storageSpec()
        self.datatypeTable = s.dtTables
        self.pgTbl = pgtable( self.tableName )

    def getValueTableName( self, datatype ):
        return self.datatypeTable.getDataTypeTableName( datatype )

    def genSQL( self ):
        tmpTbl = self.pgTbl

        if debug==1:
            print "Original Table Def:"
            for f in self.dictFlds:
                print f
            print

        dictFldSQL = {}
        for v in self.dictFlds:
            # check if it is a field table?
            if v[3] != "":
                # yes, its a field table
                tmpFldTblName = "field_%s" % v[0]
                tmpFldTbl = pgtable( tmpFldTblName )

                fidFieldName = 'fid'
                vidFieldName = 'vid'
                dtidFieldName = 'datatypeid'
                ntidFieldName = 'ntid'

                tmpFldTbl.addField( [ fidFieldName , 'serial8', 'PRIMARY KEY' ] )
                tmpFldTbl.addField( [ vidFieldName , 'int8'   , '' ] )
                tmpFldTbl.addField( [ dtidFieldName, 'int8'   , '' ] )
                tmpFldTbl.addField( [ ntidFieldName, 'int8'   , '' ] )                
                
                # find datatype table 
                dtTableName = self.s.gbDataTypeTableName
                tmpFldTbl.addConstraint( dtidFieldName, [ 'reference', [ dtTableName, [ 'datatypeid', 'int8' ] ] ] )

                # find the nodetype table, set the reference
                ntTableName = self.s.gbNodeTypeTableName
                tmpFldTbl.addConstraint( ntidFieldName, [ 'reference', [ ntTableName, self.s.ntidField ] ] )

                # find the value table, set the reference
                vtTableName = self.getValueTableName( v[1] )
                debug_print( "Value: %s, Table name: %s" % ( v[1], vtTableName ) )

                tmpFldTbl.addConstraint( vidFieldName, [ 'reference', [ vtTableName, [ 'vid', 'int8' ] ] ] )

                # add the pointer to the node table
                tmpTbl.addField( [ v[0], 'int8', v[2] ] )
                tmpTbl.addConstraint( v[0], [ 'reference', [ tmpFldTblName, [ fidFieldName ] ] ] )

                #print tmpFldTbl.genSQL()
                #print tmpFldTblName
                dictFldSQL[ tmpFldTblName ] = tmpFldTbl.genSQL()
                #print tmpFldTbl.dumpInfo()
                
            elif isinstance( v[2], list ):
                #print "Field is: %s" % v

                
                # do we have a field constraint of the form:

                if isinstance( v[2][0], list ):
                    #if isinstance( v[2][1], list ) and len( v[2][0] ) == 1:
                    # the field constraint is of the form:
                    # [ [ list: regular constraints ], [ list: references ] ]
                    tmpTbl.addField( [ v[0], v[1], v[2][0][0] ] )
                    tmpTbl.addConstraint( v[0], [ 'reference', [ v[2][1][0], v[2][1][1] ] ] )
                else:
                    # the field constraint is of the form:
                    # [ [ list: references ] ]
                    tmpTbl.addField( [ v[0], v[1], '' ] )
                    tmpTbl.addConstraint( v[0], [ 'reference', [ v[2][0], v[2][1] ] ] )
                        
                #else:
                #    tmpTbl.addConstraint( v[0], [ 'reference', 
                    
                #tmpTbl.addConstraint( v[0], v[2][1] )
            else:
                tmpTbl.addField( [ v[0], v[1], v[2] ] )

#        tmpTbl.dumpInfo()
        return [ tmpTbl.genSQL(), dictFldSQL ]


class nidinidTable( baseTable ):
    def __init__( self, dictTableNames, dictFlds ):
        self.tableName = dictTableNames[ 'nidinid' ]
        self.dictFlds = dictFlds
        baseTable.__init__( self, dictTableNames )

        self.pgTbl.addConstraint( 'nid', [ 'reference', [ 'datatypes_varchar', [ 'vid', 'int8' ] ] ] )

        # add candidate key ( nid, nodetype )
        self.pgTbl.addConstraint( 'inid', [ 'uniqueflds', [ 'nid', 'ntid' ] ] )

    def genSQL( self ):
        return( baseTable.genSQL( self ) )


class inidssidTable( baseTable  ):
    def __init__( self, dictTableNames, dictFlds ):
        self.tableName = dictTableNames[ 'inidssid' ]
        self.dictFlds = dictFlds
        baseTable.__init__( self, dictTableNames )

    def genSQL( self ):
        return( baseTable.genSQL( self ) )

class datatypesTable( baseTable  ):
    def __init__( self, dictTableNames, dictFlds ):
        self.tableName = dictTableNames[ 'datatypes' ]
        self.dictFlds = dictFlds
        baseTable.__init__( self, dictTableNames )

    def genSQL( self ):
        return( baseTable.genSQL( self ) )

class nodetypesTable( baseTable ):
    def __init__( self, dictTableNames, dictFlds ):
        self.tableName = dictTableNames[ 'nodetypes' ]
        self.dictFlds = dictFlds
        baseTable.__init__( self, dictTableNames )

    def genSQL( self ):
        return( baseTable.genSQL( self ) )
    

class metatypesTable( baseTable  ):
    def __init__( self, dictTableNames, dictFlds ):
        self.tableName = dictTableNames[ 'metatypes' ]
        self.dictFlds = dictFlds
        baseTable.__init__( self, dictTableNames )

    def genSQL( self ):
        return( baseTable.genSQL( self ) )

class attributeTypes( baseTable  ):
    def __init__( self, dictTableNames, dictFlds ):
        self.tableName = dictTableNames[ 'attributetypes' ]
        self.dictFlds = dictFlds
        baseTable.__init__( self, dictTableNames )

    def genSQL( self ):
        return( baseTable.genSQL( self ) )


class genericTable( baseTable  ):
    def __init__( self, dictTableNames, dictFlds, tblname ):
        self.tableName = dictTableNames[ tblname ]
        self.dictFlds = dictFlds
        baseTable.__init__( self, dictTableNames )

    def genSQL( self ):
        return( baseTable.genSQL( self ) )



if __name__ == '__main__':
    s = storageSpec()
    dictTableNames = {}

    dictTableNames[ 'nodetypes' ]           = 'gbnodetypes'
    dictTableNames[ 'datatypes' ]           = 'gbdatatypes'
    dictTableNames[ 'nidinid' ]             = 'gbnidinid'
    dictTableNames[ 'inidssid' ]            = 'gbinidssid'
    dictTableNames[ 'metatypes' ]           = 'gbmetatypes'
    dictTableNames[ 'attributetypes' ]      = 'gbattributetypes'
    dictTableNames[ 'attributes' ]          = 'gbattributes'
    dictTableNames[ 'relationtypes' ]       = 'gbrelationtypes'
    dictTableNames[ 'relations' ]           = 'gbrelations'
    dictTableNames[ 'objecttypes' ]         = 'gbobjecttypes'
    dictTableNames[ 'objects' ]             = 'gbobjects'
    dictTableNames[ 'usertypes' ]           = 'gbusertypes'
    dictTableNames[ 'users' ]               = 'gbusers'
    dictTableNames[ 'valuerestrictions' ]   = 'gbvaluerestrictions'
    dictTableNames[ 'regularexpressions' ]  = 'gbregularexpressions'
    dictTableNames[ 'datatypes' ]           = 'gbdatatypes'
    dictTableNames[ 'roletypes' ]           = 'gbroletypes'
    dictTableNames[ 'selectionlist' ]       = 'gbselectionlist'
    dictTableNames[ 'vocabulary' ]          = 'gbvocabulary'

    listGenOrder = [ 
        'nodetypes',
        'datatypes',
#        'nidinid',
        'inidssid',
        'metatypes',
        'attributetypes',
        'attributes',
        'relationtypes',
        'relations',
        'objecttypes',
        'objects',
        'usertypes',
        'users',
        'regularexpressions',
        'valuerestrictions',
        'datatypes',
        'roletypes',
        'selectionlist',
        'vocabulary'
        ]

    n = datatypesTable( dictTableNames, s.dictTableNamesAndDefs[ 'gbdatatypes' ] )
    retList = n.genSQL()
    print retList[0]

    # Populate the datatypes table
    s.dtTables = gnowsysDatatypes( s.gbDataTypeTableName, 0 )		# turn on value column prefixes TODO: what are prefixes?
    s.dtTables.createTables()

    print s.dtTables.genSQL()

    n = nodetypesTable( dictTableNames, s.dictTableNamesAndDefs[ 'gbnodetypes' ] )
    retList = n.genSQL()
    print retList[0]

    n = nidinidTable( dictTableNames, s.dictTableNamesAndDefs[ 'gbnidinid' ] )
    retList = n.genSQL()
    print retList[0]

    tblSQL = []
    for k in listGenOrder:
        tblSQL.append( [ k, genericTable( dictTableNames, s.dictTableNamesAndDefs[ dictTableNames[ k ] ], k ) ] )

    retList = []
    for v in tblSQL:
        k = v[0]
        if k == 'datatypes' or k == 'nodetypes':
            continue
        retList.append( v[1].genSQL() )
    
    fldSQL = {}
    for r in retList:
        for k, v in r[1].items():
            fldSQL[k] = v

    for k, v in fldSQL.items():
        print v
 
    for r in retList:
        print r[0]
        
    schemaName = {'schema':'auth_schema'}

    authenSQL = """create schema %(schema)s;

    create table %(schema)s.users (
            name varchar(64) primary key,
            password text
    );

    create table %(schema)s.userroles (
            name varchar(64) not null references %(schema)s.users(name)
            on delete cascade
            on update cascade,
            role varchar(64) not null,
            constraint %(schema)s_userroles_pkey primary key (name, role)
    );

    create table %(schema)s.groups (
            name varchar(64) primary key,
            password text
    );

    create table %(schema)s.grouproles (
            name varchar(64) not null references %(schema)s.groups(name)
            on delete cascade
            on update cascade,
            role varchar(64) not null,
            constraint %(schema)s_grouproles_pkey primary key (name, role)
    );""" % schemaName

    print authenSQL

    
    nodes = [ "gbobjects",
              "gbrelations",
              "gbattributes",
              "gbmetatypes",
              "gbobjecttypes",
              "gbrelationtypes",
              "gbattributetypes",
              "gbusertypes",
              "gbusers"
              ]

    for n in nodes:
        print "INSERT INTO gbnodetypes( ntid, nodename) VALUES ( DEFAULT,  '%s' );" % n

